/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.TokenInfo;

public class Token {
    private final Slot slot;
    private final boolean useUtf8Encoding;

    protected Token(Slot slot) {
        this.slot = Functions.requireNonNull("slot", slot);
        this.useUtf8Encoding = slot.isUseUtf8Encoding();
    }

    public Slot getSlot() {
        return this.slot;
    }

    public boolean isUseUtf8Encoding() {
        return this.useUtf8Encoding;
    }

    public long getTokenID() {
        return this.slot.getSlotID();
    }

    public TokenInfo getTokenInfo() throws PKCS11Exception {
        try {
            return new TokenInfo(this.slot.getModule().getPKCS11Module().C_GetTokenInfo(this.slot.getSlotID()));
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.slot.getModule().convertException(e);
        }
    }

    public long[] getMechanismList() throws PKCS11Exception {
        long[] mechanisms;
        PKCS11Module module = this.slot.getModule();
        try {
            mechanisms = module.getPKCS11Module().C_GetMechanismList(this.slot.getSlotID());
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw this.slot.getModule().convertException(e);
        }
        for (int i = 0; i < mechanisms.length; ++i) {
            long code = mechanisms[i];
            mechanisms[i] = module.vendorToGenericCode(PKCS11Constants.Category.CKM, code);
        }
        return mechanisms;
    }

    public MechanismInfo getMechanismInfo(long mechanism) throws PKCS11Exception {
        PKCS11Module module = this.slot.getModule();
        mechanism = module.genericToVendorCode(PKCS11Constants.Category.CKM, mechanism);
        try {
            return new MechanismInfo(module.getPKCS11Module().C_GetMechanismInfo(this.slot.getSlotID(), mechanism));
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw module.convertException(e);
        }
    }

    public Session openSession(boolean rwSession) throws PKCS11Exception {
        return this.openSession(rwSession, null);
    }

    public Session openSession(boolean rwSession, Object application) throws PKCS11Exception {
        long sessionHandle;
        long flags = rwSession ? 6L : 4L;
        PKCS11Module module = this.slot.getModule();
        try {
            sessionHandle = module.getPKCS11Module().C_OpenSession(this.slot.getSlotID(), flags, application, null);
        }
        catch (iaik.pkcs.pkcs11.wrapper.PKCS11Exception e) {
            throw module.convertException(e);
        }
        StaticLogger.info("C_OpenSession: slotID={}, flags=0x{}, sessionHandle={}", this.slot.getSlotID(), Functions.toFullHex(flags), sessionHandle);
        return new Session(this, sessionHandle);
    }

    public String toString() {
        return "Token in Slot: " + this.slot;
    }
}

