/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import iaik.pkcs.pkcs11.wrapper.CK_PKCS5_PBKD2_PARAMS;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class PKCS5_PBKD2_PARAMS
extends CkParams {
    private final CK_PKCS5_PBKD2_PARAMS params = new CK_PKCS5_PBKD2_PARAMS();

    public PKCS5_PBKD2_PARAMS(long saltSource, byte[] saltSourceData, int iterations, long prf, byte[] prfData) {
        this.params.saltSource = Functions.requireAmong("saltSource", saltSource, 1L);
        this.params.pSaltSourceData = PKCS5_PBKD2_PARAMS.requireNonNull("saltSourceData", saltSourceData);
        this.params.iterations = iterations;
        this.params.prf = Functions.requireAmong("prf", prf, 1L);
        this.params.pPrfData = PKCS5_PBKD2_PARAMS.requireNonNull("prfData", prfData);
    }

    @Override
    public CK_PKCS5_PBKD2_PARAMS getParams() {
        if (this.module == null || (this.params.prf & 0x80000000L) == 0L) {
            return this.params;
        }
        long newPrf = this.module.genericToVendorCode(PKCS11Constants.Category.CKP_PRF, this.params.prf);
        if (newPrf == this.params.prf) {
            return this.params;
        }
        CK_PKCS5_PBKD2_PARAMS params0 = new CK_PKCS5_PBKD2_PARAMS();
        params0.saltSource = this.params.saltSource;
        params0.pSaltSourceData = this.params.pSaltSourceData;
        params0.iterations = this.params.iterations;
        params0.prf = newPrf;
        params0.pPrfData = this.params.pPrfData;
        return params0;
    }

    @Override
    protected int getMaxFieldLen() {
        return 16;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_PKCS5_PBKD2_PARAMS:" + this.val2Str(indent, "saltSource", PKCS11Constants.codeToName(PKCS11Constants.Category.CKZ, this.params.saltSource)) + this.ptr2str(indent, "pSaltSourceData", this.params.pSaltSourceData) + this.val2Str(indent, "iterations", this.params.iterations) + this.val2Str(indent, "prf", PKCS11Constants.codeToName(PKCS11Constants.Category.CKP_PRF, this.params.prf)) + this.ptr2str(indent, "pPrfData", this.params.pPrfData);
    }
}

