/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.concurrent;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.concurrent.ClockSource;
import org.xipki.pkcs11.wrapper.concurrent.ConcurrentBagEntry;
import org.xipki.pkcs11.wrapper.concurrent.FastList;

public class ConcurrentBag<T extends ConcurrentBagEntry>
implements AutoCloseable {
    private final CopyOnWriteArrayList<T> sharedList;
    private final boolean weakThreadLocals = this.useWeakThreadLocals();
    private final ThreadLocal<List<Object>> threadList;
    private final AtomicInteger waiters;
    private volatile boolean closed;
    private final SynchronousQueue<T> handoffQueue = new SynchronousQueue(true);
    static final int STATE_NOT_IN_USE = 0;
    static final int STATE_IN_USE = 1;
    static final int STATE_REMOVED = -1;
    static final int STATE_RESERVED = -2;

    public ConcurrentBag() {
        this.waiters = new AtomicInteger();
        this.sharedList = new CopyOnWriteArrayList();
        this.threadList = this.weakThreadLocals ? ThreadLocal.withInitial(() -> new ArrayList(16)) : ThreadLocal.withInitial(() -> new FastList(ConcurrentBagEntry.class, 16));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        ConcurrentBagEntry bagEntry;
        List<Object> list = this.threadList.get();
        for (int i = list.size() - 1; i >= 0; --i) {
            Object entry = list.remove(i);
            ConcurrentBagEntry concurrentBagEntry = bagEntry = this.weakThreadLocals ? (ConcurrentBagEntry)((WeakReference)entry).get() : (ConcurrentBagEntry)entry;
            if (bagEntry == null || !bagEntry.compareAndSet(0, 1)) continue;
            return (T)bagEntry;
        }
        try {
            long start;
            for (ConcurrentBagEntry bagEntry2 : this.sharedList) {
                if (!bagEntry2.compareAndSet(0, 1)) continue;
                bagEntry = bagEntry2;
                return (T)bagEntry;
            }
            timeout = timeUnit.toNanos(timeout);
            do {
                start = ClockSource.currentTime();
                bagEntry = (ConcurrentBagEntry)this.handoffQueue.poll(timeout, TimeUnit.NANOSECONDS);
                if (bagEntry != null && !bagEntry.compareAndSet(0, 1)) continue;
                ConcurrentBagEntry concurrentBagEntry = bagEntry;
                return (T)concurrentBagEntry;
            } while ((timeout -= ClockSource.elapsedNanos(start)) > 10000L);
            T t = null;
            return t;
        }
        finally {
            this.waiters.decrementAndGet();
        }
    }

    public void requite(T bagEntry) {
        ((ConcurrentBagEntry)bagEntry).setState(0);
        int i = 0;
        while (this.waiters.get() > 0) {
            if (((ConcurrentBagEntry)bagEntry).getState() != 0 || this.handoffQueue.offer(bagEntry)) {
                return;
            }
            if ((i & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++i;
        }
        List<Object> threadLocalList = this.threadList.get();
        if (threadLocalList.size() < 50) {
            threadLocalList.add(this.weakThreadLocals ? new WeakReference<T>(bagEntry) : bagEntry);
        }
    }

    public void add(T bagEntry) {
        if (this.closed) {
            StaticLogger.info("ConcurrentBag has been closed, ignoring add()", new Object[0]);
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(bagEntry);
        while (this.waiters.get() > 0 && ((ConcurrentBagEntry)bagEntry).getState() == 0 && !this.handoffQueue.offer(bagEntry)) {
            Thread.yield();
        }
    }

    public boolean remove(T bagEntry) {
        if (!(((ConcurrentBagEntry)bagEntry).compareAndSet(1, -1) || ((ConcurrentBagEntry)bagEntry).compareAndSet(-2, -1) || this.closed)) {
            StaticLogger.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", bagEntry);
            return false;
        }
        boolean removed = this.sharedList.remove(bagEntry);
        if (!removed && !this.closed) {
            StaticLogger.warn("Attempt to remove an object from the bag that does not exist: {}", bagEntry);
        }
        this.threadList.get().remove(bagEntry);
        return removed;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List<T> values(int state) {
        List list = this.sharedList.stream().filter(e -> e.getState() == state).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List<T> values() {
        return (List)this.sharedList.clone();
    }

    public boolean reserve(T bagEntry) {
        return ((ConcurrentBagEntry)bagEntry).compareAndSet(0, -2);
    }

    public void unreserve(T bagEntry) {
        if (((ConcurrentBagEntry)bagEntry).compareAndSet(-2, 0)) {
            while (this.waiters.get() > 0 && !this.handoffQueue.offer(bagEntry)) {
                Thread.yield();
            }
        } else {
            StaticLogger.warn("Attempt to relinquish an object to the bag that was not reserved: {}", bagEntry);
        }
    }

    public int getWaitingThreadCount() {
        return this.waiters.get();
    }

    public int getCount(int state) {
        int count = 0;
        for (ConcurrentBagEntry e : this.sharedList) {
            if (e.getState() != state) continue;
            ++count;
        }
        return count;
    }

    public int[] getStateCounts() {
        int[] states = new int[6];
        for (ConcurrentBagEntry e : this.sharedList) {
            int n = e.getState();
            states[n] = states[n] + 1;
        }
        states[4] = this.sharedList.size();
        states[5] = this.waiters.get();
        return states;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        this.sharedList.forEach(entry -> StaticLogger.info(entry.toString(), new Object[0]));
    }

    private boolean useWeakThreadLocals() {
        try {
            if (System.getProperty("org.xipki.useWeakReferences") != null) {
                return Boolean.getBoolean("org.xipki.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException se) {
            return true;
        }
    }
}

