/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import iaik.pkcs.pkcs11.wrapper.CK_RSA_PKCS_OAEP_PARAMS;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class RSA_PKCS_OAEP_PARAMS
extends CkParams {
    private final CK_RSA_PKCS_OAEP_PARAMS params = new CK_RSA_PKCS_OAEP_PARAMS();

    public RSA_PKCS_OAEP_PARAMS(long hashAlg, long mgf) {
        this(hashAlg, mgf, 1L, null);
    }

    public RSA_PKCS_OAEP_PARAMS(long hashAlg, long mgf, long source, byte[] sourceData) {
        this.params.hashAlg = hashAlg;
        this.params.mgf = mgf;
        this.params.source = source;
        this.params.pSourceData = sourceData;
    }

    @Override
    public CK_RSA_PKCS_OAEP_PARAMS getParams() {
        if (this.module == null || (this.params.hashAlg & 0x80000000L) == 0L && (this.params.mgf & 0x80000000L) == 0L) {
            return this.params;
        }
        long newHashAlg = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.params.hashAlg);
        long newMgf = this.module.genericToVendorCode(PKCS11Constants.Category.CKG_MGF, this.params.mgf);
        if (newHashAlg == this.params.hashAlg && newMgf == this.params.mgf) {
            return this.params;
        }
        CK_RSA_PKCS_OAEP_PARAMS params0 = new CK_RSA_PKCS_OAEP_PARAMS();
        params0.hashAlg = newHashAlg;
        params0.mgf = newMgf;
        params0.source = this.params.source;
        params0.pSourceData = this.params.pSourceData;
        return params0;
    }

    @Override
    protected int getMaxFieldLen() {
        return 11;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_RSA_PKCS_OAEP_PARAMS:" + this.val2Str(indent, "hashAlg", this.module == null ? PKCS11Constants.ckmCodeToName(this.params.hashAlg) : this.module.codeToName(PKCS11Constants.Category.CKM, this.params.hashAlg)) + this.val2Str(indent, "mgf", this.module == null ? PKCS11Constants.codeToName(PKCS11Constants.Category.CKG_MGF, this.params.mgf) : this.module.codeToName(PKCS11Constants.Category.CKG_MGF, this.params.mgf)) + this.val2Str(indent, "source", PKCS11Constants.codeToName(PKCS11Constants.Category.CKZ, this.params.source)) + this.ptr2str(indent, "pSourceData", this.params.pSourceData);
    }
}

