/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.Version;

public class ModuleInfo {
    private final Version cryptokiVersion;
    private final String manufacturerID;
    private final String libraryDescription;
    private final Version libraryVersion;

    public ModuleInfo(CK_INFO ckInfo) {
        Functions.requireNonNull("ckInfo", ckInfo);
        this.cryptokiVersion = new Version(ckInfo.cryptokiVersion);
        this.manufacturerID = new String(ckInfo.manufacturerID).trim();
        this.libraryDescription = new String(ckInfo.libraryDescription).trim();
        this.libraryVersion = new Version(ckInfo.libraryVersion);
    }

    public Version getCryptokiVersion() {
        return this.cryptokiVersion;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getLibraryDescription() {
        return this.libraryDescription;
    }

    public Version getLibraryVersion() {
        return this.libraryVersion;
    }

    public String toString() {
        return "Cryptoki Version:    " + this.cryptokiVersion + "\nManufacturerID:      " + this.manufacturerID + "\nLibrary Description: " + this.libraryDescription + "\nLibrary Version:     " + this.libraryVersion;
    }
}

