/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;

public class SessionInfo {
    private final long slotID;
    private final long state;
    private final long deviceError;
    private final long flags;

    protected SessionInfo(CK_SESSION_INFO ckSessionInfo) {
        Functions.requireNonNull("ckSessionInfo", ckSessionInfo);
        this.slotID = ckSessionInfo.slotID;
        this.state = ckSessionInfo.state;
        this.deviceError = ckSessionInfo.ulDeviceError;
        this.flags = ckSessionInfo.flags;
    }

    public long getState() {
        return this.state;
    }

    public long getDeviceError() {
        return this.deviceError;
    }

    public boolean isRwSession() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isSerialSession() {
        return (this.flags & 4L) != 0L;
    }

    public String toString() {
        String text = "State: " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKS, this.state) + "\nSlot ID: " + this.slotID + "\nDevice Error: 0x" + Long.toHexString(this.deviceError) + "\n";
        return text + Functions.toStringFlags(PKCS11Constants.Category.CKF_SESSION, "Flags: ", this.flags, 2L, 4L);
    }
}

