/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.Logger;

public class StaticLogger {
    private static Logger logger;

    public static void setLogger(Logger logger_) {
        logger = logger_;
    }

    public static void error(String format, Object ... arguments) {
        if (logger != null) {
            logger.error(format, arguments);
        } else {
            StaticLogger.print("ERROR", format, arguments);
        }
    }

    public static void warn(String format, Object ... arguments) {
        if (logger != null) {
            logger.warn(format, arguments);
        } else {
            StaticLogger.print("WARN", format, arguments);
        }
    }

    public static void info(String format, Object ... arguments) {
        if (logger != null) {
            logger.info(format, arguments);
        } else {
            StaticLogger.print("INFO", format, arguments);
        }
    }

    public static void debug(String format, Object ... arguments) {
        if (logger != null) {
            logger.debug(format, arguments);
        }
    }

    public static void trace(String format, Object ... arguments) {
        if (logger != null) {
            logger.trace(format, arguments);
        }
    }

    public static boolean isWarnEnabled() {
        return logger == null || logger.isWarnEnabled();
    }

    public static boolean isInfoEnabled() {
        return logger == null || logger.isInfoEnabled();
    }

    public static boolean isDebugEnabled() {
        return logger != null && logger.isDebugEnabled();
    }

    public static boolean isTraceEnabled() {
        return logger != null && logger.isTraceEnabled();
    }

    private static void print(String level, String format, Object ... arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(level).append("] ");
        if (arguments == null || arguments.length == 0) {
            System.out.println(sb.append(format));
            return;
        }
        int fromIdx = 0;
        for (Object argument : arguments) {
            int idx = format.indexOf("{}", fromIdx);
            if (idx == -1) {
                sb.append(format, fromIdx, format.length());
                fromIdx = format.length();
                break;
            }
            sb.append(format, fromIdx, idx);
            sb.append(argument);
            fromIdx = idx + 2;
        }
        if (fromIdx < format.length()) {
            sb.append(format, fromIdx, format.length());
        }
        System.out.println(sb);
    }
}

