/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Key;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.TokenInfo;
import org.xipki.pkcs11.wrapper.multipart.DecryptMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.DecryptMessageStreamEntry;
import org.xipki.pkcs11.wrapper.multipart.EncryptMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.EncryptMessageStreamEntry;
import org.xipki.pkcs11.wrapper.multipart.SignMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.SignMessageStreamEntry;
import org.xipki.pkcs11.wrapper.multipart.VerifyMessageBytesEntry;
import org.xipki.pkcs11.wrapper.multipart.VerifyMessageStreamEntry;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class PKCS11Token {
    private static final Clock clock = Clock.systemUTC();
    private int maxMessageSize = 2048;
    private final Token token;
    private final Map<Long, MechanismInfo> mechanisms = new HashMap<Long, MechanismInfo>();
    private final long userType;
    private final char[] userName;
    private final List<char[]> pins;
    private final int maxSessionCount;
    private final boolean readOnly;
    private long timeOutWaitNewSessionMs = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final LinkedBlockingQueue<Session> sessions;
    private final Object loginSync = new Object();

    public PKCS11Token(Token token, boolean readOnly, char[] pin) throws TokenException {
        this(token, readOnly, 1L, null, pin == null ? null : Collections.singletonList(pin), null);
    }

    public PKCS11Token(Token token, boolean readOnly, char[] pin, Integer numSessions) throws TokenException {
        this(token, readOnly, 1L, null, pin == null ? null : Collections.singletonList(pin), numSessions);
    }

    public PKCS11Token(Token token, boolean readOnly, long userType, char[] userName, List<char[]> pins, Integer numSessions) throws TokenException {
        int tokenMaxSessionCount;
        this.token = Objects.requireNonNull(token, "token shall not be null");
        this.readOnly = readOnly;
        this.userType = userType;
        this.userName = userName;
        this.pins = pins;
        TokenInfo tokenInfo = token.getTokenInfo();
        long lc = tokenInfo.getMaxSessionCount();
        int n = tokenMaxSessionCount = lc > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lc;
        this.maxSessionCount = numSessions == null ? (tokenMaxSessionCount < 1 ? 32 : Math.min(32, tokenMaxSessionCount)) : (tokenMaxSessionCount < 1 ? numSessions : Math.min(numSessions, tokenMaxSessionCount));
        StaticLogger.info("tokenMaxSessionCount={}, maxSessionCount={}", tokenMaxSessionCount, this.maxSessionCount);
        this.sessions = new LinkedBlockingQueue();
        for (long mech : token.getMechanismList()) {
            try {
                MechanismInfo mechInfo = token.getMechanismInfo(mech);
                this.mechanisms.put(mech, mechInfo);
            }
            catch (Exception e) {
                StaticLogger.warn("error getMechanism for {} (0x{}): {}", token.getSlot().getModule().codeToName(PKCS11Constants.Category.CKM, mech), Functions.toFullHex(mech), e.getMessage());
            }
        }
        Session session = this.openSession();
        this.login(session);
        this.sessions.add(session);
    }

    public PKCS11Module getModule() {
        return this.token.getSlot().getModule();
    }

    public void setTimeOutWaitNewSession(int timeOutWaitNewSessionMs) {
        if (timeOutWaitNewSessionMs < 1000) {
            throw new IllegalArgumentException("timeOutWaitNewSessionMs is not greater than 999");
        }
        this.timeOutWaitNewSessionMs = timeOutWaitNewSessionMs;
        StaticLogger.info("timeOutWaitNewSession = {} milli-seconds", timeOutWaitNewSessionMs);
    }

    public void setMaxMessageSize(int maxMessageSize) {
        if (maxMessageSize < 256) {
            throw new IllegalArgumentException("maxMessageSize too small, at least 256 is required: " + maxMessageSize);
        }
        this.maxMessageSize = maxMessageSize;
    }

    public Set<Long> getMechanisms() {
        return Collections.unmodifiableSet(this.mechanisms.keySet());
    }

    public MechanismInfo getMechanismInfo(long mechanism) {
        return this.mechanisms.get(mechanism);
    }

    public boolean supportsMechanism(long mechanism, long flagBit) {
        MechanismInfo info = this.mechanisms.get(mechanism);
        return info != null && info.hasFlagBit(flagBit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPIN(char[] oldPin, char[] newPin) throws TokenException {
        Session session = this.borrowSession();
        try {
            long sessionState = session.getSessionInfo().getState();
            if (sessionState == 0L) {
                return;
            }
            if (sessionState != 4L) {
                throw new TokenException("Session is not logged in as CKU_SO");
            }
            session.setPIN(oldPin, newPin);
            StaticLogger.info("setPIN", new Object[0]);
        }
        finally {
            this.sessions.offer(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPIN(char[] pin) throws TokenException {
        Session session = this.borrowSession();
        try {
            long sessionState = session.getSessionInfo().getState();
            if (sessionState == 0L) {
                return;
            }
            if (sessionState != 4L) {
                throw new TokenException("Session is not logged in as CKU_SO");
            }
            session.initPIN(pin);
            StaticLogger.info("initPIN", new Object[0]);
        }
        finally {
            this.sessions.add(session);
        }
    }

    public void closeAllSessions() {
        if (this.token != null) {
            try {
                StaticLogger.info("close all sessions on token: {}", this.token.getTokenInfo());
                for (Session session : this.sessions) {
                    session.closeSession();
                }
            }
            catch (Throwable th) {
                StaticLogger.error("error closing sessions, {}", th.getMessage());
            }
        }
        this.sessions.clear();
        this.countSessions.lazySet(0L);
    }

    public long getTokenId() {
        return this.token.getTokenID();
    }

    public Token getToken() {
        return this.token;
    }

    public String getModuleInfo() throws TokenException {
        return this.token.getSlot().getModule().getInfo().toString();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInSecurityOfficer(char[] userName, char[] pin) throws TokenException {
        Session session = this.borrowNoLoginSession();
        try {
            this.login(session, 0L, userName, pin == null ? null : Collections.singletonList(pin));
            StaticLogger.info("logIn CKU_SO", new Object[0]);
        }
        finally {
            this.sessions.add(session);
        }
    }

    public void logout() throws TokenException {
        Session session = this.borrowSession();
        try {
            session.logout();
            StaticLogger.info("logout", new Object[0]);
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createObject(AttributeVector template) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.createObject(template);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.createPrivateKeyObject(template, publicKey);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.createECPrivateKeyObject(template, ecPoint);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyObject(long sourceObjectHandle, AttributeVector template) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.copyObject(sourceObjectHandle, template);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws TokenException {
        Session session = this.borrowSession();
        try {
            session.setAttributeValues(objectToUpdateHandle, template);
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(long objectHandle) throws TokenException {
        Session session = this.borrowSession();
        try {
            session.destroyObject(objectHandle);
        }
        finally {
            this.sessions.add(session);
        }
    }

    public long[] destroyObjects(long ... objectHandles) throws TokenException {
        ArrayList<Long> list = new ArrayList<Long>(objectHandles.length);
        for (long handle : objectHandles) {
            list.add(handle);
        }
        List<Long> destroyedHandles = this.destroyObjects(list);
        long[] ret = new long[destroyedHandles.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = destroyedHandles.get(i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> destroyObjects(List<Long> objectHandles) throws TokenException {
        Session session = this.borrowSession();
        try {
            ArrayList<Long> destroyedHandles = new ArrayList<Long>(objectHandles.size());
            Object object = objectHandles.iterator();
            while (object.hasNext()) {
                long objectHandle = object.next();
                try {
                    session.destroyObject(objectHandle);
                    destroyedHandles.add(objectHandle);
                }
                catch (PKCS11Exception e) {
                    StaticLogger.warn("error destroying object {}: {}", objectHandle, e.getMessage());
                }
            }
            object = destroyedHandles;
            return object;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectSize(long objectHandle) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.getObjectSize(objectHandle);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateUniqueId(AttributeVector template, int idLength, Random random) throws TokenException {
        if (template != null && template.id() != null) {
            throw new IllegalArgumentException("template shall not have CKA_ID");
        }
        if (template == null) {
            template = new AttributeVector();
        }
        byte[] keyId = new byte[idLength];
        template.id(keyId);
        Session session = this.borrowSession();
        try {
            do {
                random.nextBytes(keyId);
            } while (session.findObjectsSingle(template, 1).length != 0);
            byte[] byArray = keyId;
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11Key getKey(PKCS11KeyId keyId) throws TokenException {
        if (keyId == null) {
            return null;
        }
        Session session = this.borrowSession();
        try {
            PKCS11Key pKCS11Key = this.getKey(session, keyId);
            return pKCS11Key;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11Key getKey(AttributeVector criteria) throws TokenException {
        Session session = this.borrowSession();
        try {
            PKCS11KeyId keyId = this.getKeyId(session, criteria);
            PKCS11Key pKCS11Key = keyId == null ? null : this.getKey(session, keyId);
            return pKCS11Key;
        }
        finally {
            this.sessions.add(session);
        }
    }

    private PKCS11Key getKey(Session session, PKCS11KeyId keyId) throws TokenException {
        long objClass = keyId.getObjectCLass();
        long keyType = keyId.getKeyType();
        LinkedList<Long> ckaTypes = new LinkedList<Long>();
        if (objClass == 4L || objClass == 3L) {
            PKCS11Token.addCkaTypes(ckaTypes, 354L, 356L, 2L, 261L, 264L, 263L, 528L, 259L, 357L);
            if (objClass == 4L) {
                PKCS11Token.addCkaTypes(ckaTypes, 260L, 134L, 266L, 262L);
                if (keyType != 19L && keyType != 20L && keyType != 21L) {
                    ckaTypes.add(353L);
                }
            } else {
                PKCS11Token.addCkaTypes(ckaTypes, 514L, 265L);
                if (keyType == 0L) {
                    PKCS11Token.addCkaTypes(ckaTypes, 288L, 290L);
                } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                    ckaTypes.add(384L);
                } else if (keyType == 1L) {
                    PKCS11Token.addCkaTypes(ckaTypes, 304L, 305L, 306L);
                }
            }
        } else {
            PKCS11Token.addCkaTypes(ckaTypes, 260L, 134L, 266L, 267L, 262L);
            if (keyType == 0L) {
                PKCS11Token.addCkaTypes(ckaTypes, 288L, 290L);
            } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                PKCS11Token.addCkaTypes(ckaTypes, 384L, 385L);
            } else if (keyType == 1L) {
                PKCS11Token.addCkaTypes(ckaTypes, 304L, 305L, 306L);
            }
        }
        AttributeVector attrs = session.getAttrValues(keyId.getHandle(), ckaTypes);
        return new PKCS11Key(keyId, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11KeyId getKeyId(AttributeVector criteria) throws TokenException {
        Session session = this.borrowSession();
        try {
            PKCS11KeyId pKCS11KeyId = this.getKeyId(session, criteria);
            return pKCS11KeyId;
        }
        finally {
            this.sessions.add(session);
        }
    }

    private PKCS11KeyId getKeyId(Session session, AttributeVector criteria) throws TokenException {
        byte[] id = criteria.id();
        String label = criteria.label();
        if (!(id != null && id.length != 0 || label != null && !label.isEmpty())) {
            return null;
        }
        Long oClass = criteria.class_();
        if (oClass != null) {
            if (3L != oClass && 2L != oClass && 4L != oClass) {
                return null;
            }
            long[] handles = session.findObjectsSingle(criteria, 2);
            if (handles.length == 0) {
                return null;
            }
            if (handles.length > 1) {
                throw new TokenException("found more than 1 key for the criteria " + criteria);
            }
            return this.getKeyIdByHandle(session, handles[0]);
        }
        oClass = 3L;
        long[] handles = session.findObjectsSingle(criteria.class_(oClass), 2);
        if (handles.length == 0 && (handles = session.findObjectsSingle(criteria.class_(oClass = Long.valueOf(4L)), 2)).length == 0) {
            oClass = 2L;
            handles = session.findObjectsSingle(criteria.class_(oClass), 2);
        }
        if (handles.length == 0) {
            return null;
        }
        if (handles.length > 1) {
            throw new TokenException("found more than 1 key of " + PKCS11Constants.ckoCodeToName(oClass) + " for the criteria " + criteria.class_(null));
        }
        return this.getKeyIdByHandle(session, handles[0]);
    }

    private PKCS11KeyId getKeyIdByHandle(Session session, long hKey) throws TokenException {
        AttributeVector attrs = session.getAttrValues(hKey, 0L, 256L, 258L, 3L);
        Long oClass = attrs.class_();
        Long keyType = attrs.keyType();
        if (oClass == null || keyType == null) {
            return null;
        }
        byte[] id = attrs.id();
        PKCS11KeyId ret = new PKCS11KeyId(hKey, oClass, keyType, id, attrs.label());
        if (oClass == 3L) {
            long[] pubKeyHandles = session.findObjectsSingle(AttributeVector.newPublicKey(keyType).id(id), 2);
            if (pubKeyHandles.length == 1) {
                ret.setPublicKeyHandle(pubKeyHandles[0]);
            } else if (pubKeyHandles.length > 1) {
                StaticLogger.warn("found more than 1 public key for the private key {}, ignore them.", hKey);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findAllObjects(AttributeVector template) throws TokenException {
        Session session = this.borrowSession();
        try {
            long[] lArray = session.findAllObjectsSingle(template);
            return lArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findObjects(AttributeVector template, int maxObjectCount) throws TokenException {
        Session session = this.borrowSession();
        try {
            long[] lArray = session.findObjectsSingle(template, maxObjectCount);
            return lArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(Mechanism mechanism, long keyHandle, byte[] plaintext) throws TokenException {
        Session session = this.borrowSession();
        try {
            this.opInit(OP.ENCRYPT, session, mechanism, keyHandle);
            int len = plaintext.length;
            if (len <= this.maxMessageSize) {
                byte[] byArray = session.encrypt(plaintext);
                return byArray;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(plaintext.length + 16);
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    byte[] ciphertextPart = session.encryptUpdate(PKCS11Token.copyOfLen(plaintext, ofs, Math.min(this.maxMessageSize, len - ofs)));
                    bout.write(ciphertextPart, 0, ciphertextPart.length);
                }
            }
            finally {
                byte[] ciphertextPart = session.encryptFinal();
                bout.write(ciphertextPart, 0, ciphertextPart.length);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encrypt(OutputStream out, Mechanism mechanism, long keyHandle, InputStream plaintext) throws TokenException, IOException {
        Session session = this.borrowSession();
        try {
            byte[] res;
            byte[] buffer = new byte[this.maxMessageSize];
            int resSum = 0;
            this.opInit(OP.ENCRYPT, session, mechanism, keyHandle);
            try {
                int read;
                while ((read = plaintext.read(buffer)) != -1) {
                    if (read <= 0 || (res = session.encryptUpdate(PKCS11Token.copyOfLen(buffer, read))) == null || res.length <= 0) continue;
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            finally {
                res = session.encryptFinal();
                if (res != null && res.length > 0) {
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            int n = resSum;
            return n;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(Mechanism mechanism, long keyHandle, byte[] ciphertext) throws TokenException {
        Session session = this.borrowSession();
        try {
            this.opInit(OP.DECRYPT, session, mechanism, keyHandle);
            int len = ciphertext.length;
            if (len <= this.maxMessageSize) {
                byte[] byArray = session.decrypt(ciphertext);
                return byArray;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(ciphertext.length);
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    byte[] plaintextPart = session.decryptUpdate(PKCS11Token.copyOfLen(ciphertext, ofs, Math.min(this.maxMessageSize, len - ofs)));
                    bout.write(plaintextPart, 0, plaintextPart.length);
                }
            }
            finally {
                byte[] plaintextPart = session.decryptFinal();
                bout.write(plaintextPart, 0, plaintextPart.length);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrypt(OutputStream out, Mechanism mechanism, long keyHandle, InputStream ciphertext) throws TokenException, IOException {
        Session session = this.borrowSession();
        try {
            byte[] res;
            byte[] buffer = new byte[this.maxMessageSize];
            int resSum = 0;
            this.opInit(OP.DECRYPT, session, mechanism, keyHandle);
            try {
                int read;
                while ((read = ciphertext.read(buffer)) != -1) {
                    if (read <= 0 || (res = session.decryptUpdate(PKCS11Token.copyOfLen(buffer, read))) == null || res.length <= 0) continue;
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            finally {
                res = session.decryptFinal();
                if (res != null && res.length > 0) {
                    resSum += res.length;
                    out.write(res, 0, res.length);
                }
            }
            int n = resSum;
            return n;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(Mechanism mechanism, byte[] data) throws TokenException {
        Session session = this.borrowSession();
        int len = data.length;
        try {
            byte[] digest;
            this.opInit(OP.DIGEST, session, mechanism, 0L);
            if (len < this.maxMessageSize) {
                byte[] byArray = session.digest(data);
                return byArray;
            }
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    session.signUpdate(data, ofs, Math.min(this.maxMessageSize, len - ofs));
                }
            }
            finally {
                digest = session.digestFinal();
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digestKey(Mechanism mechanism, long keyHandle) throws TokenException {
        Session session = this.borrowSession();
        try {
            byte[] digest;
            this.opInit(OP.DIGEST, session, mechanism, 0L);
            try {
                session.digestKey(keyHandle);
            }
            finally {
                digest = session.digestFinal();
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(Mechanism mechanism, InputStream data) throws TokenException, IOException {
        Session session = this.borrowSession();
        try {
            byte[] digest;
            byte[] buffer = new byte[this.maxMessageSize];
            this.opInit(OP.DIGEST, session, mechanism, 0L);
            try {
                int read;
                while ((read = data.read(buffer)) != -1) {
                    if (read <= 0) continue;
                    session.digestUpdate(PKCS11Token.copyOfLen(buffer, read));
                }
            }
            finally {
                digest = session.digestFinal();
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(Mechanism mechanism, long keyHandle, byte[] data) throws TokenException {
        Session session = this.borrowSession();
        try {
            byte[] signature;
            this.opInit(OP.SIGN, session, mechanism, keyHandle);
            int len = data.length;
            if (len < this.maxMessageSize) {
                byte[] byArray = session.sign(data);
                return byArray;
            }
            try {
                for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    session.signUpdate(data, ofs, Math.min(this.maxMessageSize, len - ofs));
                }
            }
            finally {
                signature = session.signFinal();
            }
            byte[] byArray = signature;
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(Mechanism mechanism, long keyHandle, InputStream data) throws TokenException, IOException {
        Session session = this.borrowSession();
        try {
            byte[] signature;
            byte[] buffer;
            block13: {
                buffer = new byte[this.maxMessageSize];
                int firstBlockLen = PKCS11Token.readBytes(data, buffer, this.maxMessageSize);
                byte[] firstBlock = PKCS11Token.copyOfLen(buffer, firstBlockLen);
                this.opInit(OP.SIGN, session, mechanism, keyHandle);
                if (firstBlockLen < this.maxMessageSize) {
                    byte[] byArray = session.sign(firstBlock);
                    return byArray;
                }
                try {
                    session.signUpdate(firstBlock);
                }
                catch (PKCS11Exception e) {
                    int read;
                    if (e.getErrorCode() != 145L) break block13;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(this.maxMessageSize + data.available());
                    bout.write(firstBlock);
                    while ((read = data.read(buffer)) != -1) {
                        bout.write(buffer, 0, read);
                    }
                    this.opInit(OP.SIGN, session, mechanism, keyHandle);
                    byte[] byArray = session.sign(bout.toByteArray());
                    this.sessions.add(session);
                    return byArray;
                }
            }
            try {
                int read;
                while ((read = data.read(buffer)) != -1) {
                    if (read <= 0) continue;
                    session.signUpdate(PKCS11Token.copyOfLen(buffer, read));
                }
            }
            finally {
                signature = session.signFinal();
            }
            byte[] byArray = signature;
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] signRecover(Mechanism mechanism, long keyHandle, byte[] data) throws TokenException {
        Session session = this.borrowSession();
        try {
            this.opInit(OP.SIGN_RECOVER, session, mechanism, keyHandle);
            byte[] byArray = session.signRecover(data);
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean verify(Mechanism mechanism, long keyHandle, byte[] data, byte[] signature) throws TokenException {
        block23: {
            session = this.borrowSession();
            len = data.length;
            code = mechanism.getMechanismCode();
            if (!this.supportsMechanism(code, 8192L)) break block23;
            try {
                this.opInit(OP.VERIFY, session, mechanism, keyHandle);
                if (len <= this.maxMessageSize) {
                    session.verify(data, signature);
                } else {
                    try {
                        try {
                            for (ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                                session.verifyUpdate(PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)));
                            }
                        }
                        finally {
                            session.verifyFinal(signature);
                        }
                    }
                    catch (PKCS11Exception e) {
                        if (e.getErrorCode() == 145L) {
                            session.verifySingle(mechanism, keyHandle, data, signature);
                        }
                        throw e;
                    }
                }
                e = true;
                return e;
            }
            catch (PKCS11Exception e) {
                block25: {
                    ckr = e.getErrorCode();
                    if (ckr != 192L && ckr != 193L) break block25;
                    var13_16 = false;
                    this.sessions.add(session);
                    return var13_16;
                }
                throw e;
            }
        }
        if (!this.supportsMechanism(code, 2048L) || !PKCS11Token.isMacMechanism(code)) ** GOTO lbl-1000
        this.opInit(OP.VERIFY, session, mechanism, keyHandle);
        if (len <= this.maxMessageSize) {
            sig2 = session.sign(data);
        } else {
            try {
                for (ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    session.signUpdate(PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)));
                }
            }
            finally {
                sig2 = session.signFinal();
            }
        }
        var11_15 = Arrays.equals(signature, sig2);
        return var11_15;
lbl-1000:
        // 1 sources

        {
            throw new PKCS11Exception(112L);
            {
                catch (Throwable var15_18) {
                    throw var15_18;
                }
            }
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(Mechanism mechanism, long keyHandle, InputStream data, byte[] signature) throws TokenException, IOException {
        Session session = this.borrowSession();
        try {
            byte[] buffer = new byte[this.maxMessageSize];
            int firstBlockLen = PKCS11Token.readBytes(data, buffer, this.maxMessageSize);
            byte[] firstBlock = PKCS11Token.copyOfLen(buffer, firstBlockLen);
            long code = mechanism.getMechanismCode();
            this.opInit(OP.VERIFY, session, mechanism, keyHandle);
            if (this.supportsMechanism(code, 8192L)) {
                int read;
                if (firstBlockLen < this.maxMessageSize) {
                    session.verify(firstBlock, signature);
                } else {
                    block27: {
                        try {
                            session.verifyUpdate(firstBlock);
                        }
                        catch (PKCS11Exception e) {
                            int read2;
                            if (e.getErrorCode() != 145L) break block27;
                            ByteArrayOutputStream bout = new ByteArrayOutputStream(this.maxMessageSize + data.available());
                            bout.write(firstBlock);
                            while ((read2 = data.read(buffer)) != -1) {
                                bout.write(buffer, 0, read2);
                            }
                            session.verifySingle(mechanism, keyHandle, bout.toByteArray(), signature);
                            boolean bl = true;
                            this.sessions.add(session);
                            return bl;
                        }
                    }
                    try {
                        while ((read = data.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            session.verifyUpdate(PKCS11Token.copyOfLen(buffer, read));
                        }
                    }
                    finally {
                        session.verifyFinal(signature);
                    }
                }
                read = 1;
                return read != 0;
            }
            if (this.supportsMechanism(code, 2048L) && PKCS11Token.isMacMechanism(code)) {
                byte[] sig2;
                this.opInit(OP.SIGN, session, mechanism, keyHandle);
                if (firstBlockLen < this.maxMessageSize) {
                    sig2 = session.sign(firstBlock);
                } else {
                    try {
                        int read;
                        session.signUpdate(firstBlock);
                        while ((read = data.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            session.signUpdate(buffer, 0, read);
                        }
                    }
                    finally {
                        sig2 = session.signFinal();
                    }
                }
                boolean bl = Arrays.equals(signature, sig2);
                return bl;
            }
            try {
                throw new PKCS11Exception(112L);
            }
            catch (PKCS11Exception e) {
                long ckr = e.getErrorCode();
                if (ckr == 192L || ckr == 193L) {
                    boolean bl = false;
                    return bl;
                }
                throw e;
            }
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] verifyRecover(Mechanism mechanism, long keyHandle, byte[] data) throws TokenException {
        Session session = this.borrowSession();
        try {
            this.opInit(OP.VERIFY_RECOVER, session, mechanism, keyHandle);
            byte[] byArray = session.verifyRecover(data);
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateKey(Mechanism mechanism, AttributeVector template) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.generateKey(mechanism, template);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws TokenException {
        Session session = this.borrowSession();
        try {
            PKCS11KeyPair pKCS11KeyPair = session.generateKeyPair(mechanism, template);
            return pKCS11KeyPair;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws TokenException {
        Session session = this.borrowSession();
        try {
            byte[] byArray = session.wrapKey(mechanism, wrappingKeyHandle, keyHandle);
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.unwrapKey(mechanism, unwrappingKeyHandle, wrappedKey, keyTemplate);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws TokenException {
        Session session = this.borrowSession();
        try {
            long l = session.deriveKey(mechanism, baseKeyHandle, template);
            return l;
        }
        finally {
            this.sessions.add(session);
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws TokenException {
        return this.generateRandom(numberOfBytesToGenerate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateRandom(int numberOfBytesToGenerate, byte[] extraSeed) throws TokenException {
        Session session = this.borrowSession();
        try {
            if (extraSeed != null && extraSeed.length > 0) {
                session.seedRandom(extraSeed);
            }
            byte[] byArray = session.generateRandom(numberOfBytesToGenerate);
            return byArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] encryptMessages(Mechanism mechanism, long keyHandle, EncryptMessageBytesEntry[] entries) throws TokenException {
        byte[][] ciphertexts = new byte[entries.length][];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_ENCRYPT, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    EncryptMessageBytesEntry entry = entries[i];
                    byte[] plaintext = entry.plaintext();
                    int len = plaintext.length;
                    if (len <= this.maxMessageSize) {
                        ciphertexts[i] = session.encryptMessage(entry.params(), entry.associatedData(), entry.plaintext());
                        continue;
                    }
                    session.encryptMessageBegin(entry.params(), entry.associatedData());
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(plaintext.length + 16);
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        boolean lastBlock = ofs + this.maxMessageSize >= len;
                        byte[] ciphertextPart = session.encryptMessageNext(entry.params(), PKCS11Token.copyOfLen(plaintext, ofs, Math.min(len - ofs, this.maxMessageSize)), lastBlock);
                        bout.write(ciphertextPart, 0, ciphertextPart.length);
                    }
                    ciphertexts[i] = bout.toByteArray();
                }
            }
            finally {
                session.messageEncryptFinal();
            }
            byte[][] byArrayArray = ciphertexts;
            return byArrayArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] encryptMessages(Mechanism mechanism, long keyHandle, EncryptMessageStreamEntry[] entries) throws TokenException, IOException {
        int[] ciphertextLens = new int[entries.length];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_ENCRYPT, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    EncryptMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream inPlaintext = entry.inPlaintext();
                    OutputStream outCiphertext = entry.outCiphertext();
                    CkParams params = entry.params();
                    try {
                        byte[] ciphertextPart;
                        int read;
                        session.encryptMessageBegin(params, entry.associatedData());
                        int ciphertextLen = 0;
                        while ((read = inPlaintext.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            ciphertextPart = session.encryptMessageNext(params, PKCS11Token.copyOfLen(buffer, read), false);
                            ciphertextLen += ciphertextPart.length;
                            outCiphertext.write(ciphertextPart);
                        }
                        ciphertextPart = session.encryptMessageNext(params, new byte[0], true);
                        outCiphertext.write(ciphertextPart);
                        ciphertextLens[i] = ciphertextLen += ciphertextPart.length;
                        continue;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                session.messageEncryptFinal();
            }
            int[] nArray = ciphertextLens;
            return nArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] decryptMessages(Mechanism mechanism, long keyHandle, DecryptMessageBytesEntry[] entries) throws TokenException {
        byte[][] plaintexts = new byte[entries.length][];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_DECRYPT, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    DecryptMessageBytesEntry entry = entries[i];
                    byte[] ciphertext = entry.ciphertext();
                    int len = ciphertext.length;
                    if (len <= this.maxMessageSize) {
                        plaintexts[i] = session.decryptMessage(entry.params(), entry.associatedData(), ciphertext);
                        continue;
                    }
                    session.decryptMessageBegin(entry.params(), entry.associatedData());
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(ciphertext.length);
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        boolean lastBlock = ofs + this.maxMessageSize >= len;
                        byte[] plaintextPart = session.decryptMessageNext(entry.params(), PKCS11Token.copyOfLen(ciphertext, ofs, Math.min(len - ofs, this.maxMessageSize)), lastBlock);
                        bout.write(plaintextPart, 0, plaintextPart.length);
                    }
                    plaintexts[i] = bout.toByteArray();
                }
            }
            finally {
                session.messageDecryptFinal();
            }
            byte[][] byArrayArray = plaintexts;
            return byArrayArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] decryptMessages(Mechanism mechanism, long keyHandle, DecryptMessageStreamEntry[] entries) throws TokenException, IOException {
        int[] plaintextLens = new int[entries.length];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_DECRYPT, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    DecryptMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream inCiphertext = entry.inCiphertext();
                    OutputStream outPlaintext = entry.outPlaintext();
                    CkParams params = entry.params();
                    try {
                        byte[] plaintextPart;
                        int read;
                        session.decryptMessageBegin(params, entry.associatedData());
                        int plaintextLen = 0;
                        while ((read = inCiphertext.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            plaintextPart = session.decryptMessageNext(params, PKCS11Token.copyOfLen(buffer, read), false);
                            plaintextLen += plaintextPart.length;
                            outPlaintext.write(plaintextPart);
                        }
                        plaintextPart = session.decryptMessageNext(params, new byte[0], true);
                        outPlaintext.write(plaintextPart);
                        plaintextLens[i] = plaintextLen += plaintextPart.length;
                        continue;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                session.messageDecryptFinal();
            }
            int[] nArray = plaintextLens;
            return nArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] signMessages(Mechanism mechanism, long keyHandle, SignMessageBytesEntry[] entries) throws TokenException {
        byte[][] signatures = new byte[entries.length][];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_SIGN, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    SignMessageBytesEntry entry = entries[i];
                    byte[] data = entry.data();
                    int len = data.length;
                    if (len <= this.maxMessageSize) {
                        signatures[i] = session.signMessage(entry.params(), entry.data());
                        continue;
                    }
                    session.signMessageBegin(entry.params());
                    for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                        boolean lastBlock = ofs + this.maxMessageSize >= len;
                        signatures[i] = session.signMessageNext(entry.params(), PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)), lastBlock);
                    }
                }
            }
            finally {
                session.messageSignFinal();
            }
            byte[][] byArrayArray = signatures;
            return byArrayArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] signMessages(Mechanism mechanism, long keyHandle, SignMessageStreamEntry[] entries) throws TokenException, IOException {
        byte[][] signatures = new byte[entries.length][];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_SIGN, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    SignMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream data = entry.data();
                    CkParams params = entry.params();
                    try {
                        int read;
                        session.signMessageBegin(params);
                        while ((read = data.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            session.signMessageNext(params, PKCS11Token.copyOfLen(buffer, read), false);
                        }
                        signatures[i] = session.signMessageNext(params, new byte[0], true);
                        continue;
                    }
                    catch (PKCS11Exception e) {
                        break;
                    }
                }
            }
            finally {
                session.messageSignFinal();
            }
            byte[][] byArrayArray = signatures;
            return byArrayArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] verifyMessages(Mechanism mechanism, long keyHandle, VerifyMessageBytesEntry[] entries) throws TokenException {
        boolean[] verifyResults = new boolean[entries.length];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_VERIFY, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    VerifyMessageBytesEntry entry = entries[i];
                    byte[] data = entry.data();
                    int len = data.length;
                    try {
                        if (len <= this.maxMessageSize) {
                            session.verifyMessage(entry.params(), entry.data(), entry.signature());
                        } else {
                            session.verifyMessageBegin(entry.params());
                            for (int ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                                boolean lastBlock = ofs + this.maxMessageSize >= len;
                                session.verifyMessageNext(entry.params(), PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)), lastBlock ? entry.signature() : null);
                            }
                        }
                        verifyResults[i] = true;
                        continue;
                    }
                    catch (PKCS11Exception e) {
                        verifyResults[i] = false;
                    }
                }
            }
            finally {
                session.messageVerifyFinal();
            }
            boolean[] blArray = verifyResults;
            return blArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] verifyMessages(Mechanism mechanism, long keyHandle, VerifyMessageStreamEntry[] entries) throws TokenException, IOException {
        boolean[] verifyResults = new boolean[entries.length];
        Session session = this.borrowSession();
        try {
            this.opInit(OP.MESSAGE_VERIFY, session, mechanism, keyHandle);
            try {
                for (int i = 0; i < entries.length; ++i) {
                    VerifyMessageStreamEntry entry = entries[i];
                    byte[] buffer = new byte[this.maxMessageSize];
                    InputStream data = entry.data();
                    CkParams params = entry.params();
                    try {
                        int read;
                        session.verifyMessageBegin(params);
                        while ((read = data.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            session.verifyMessageNext(params, PKCS11Token.copyOfLen(buffer, read), null);
                        }
                        session.verifyMessageNext(params, new byte[0], entry.signature());
                        verifyResults[i] = true;
                        continue;
                    }
                    catch (PKCS11Exception e) {
                        verifyResults[i] = false;
                    }
                }
            }
            finally {
                session.messageVerifyFinal();
            }
            boolean[] blArray = verifyResults;
            return blArray;
        }
        finally {
            this.sessions.add(session);
        }
    }

    public String toString() {
        return "User type: " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, this.userType) + "\nUser name: " + (this.userName == null ? "null" : new String(this.userName)) + "\nMaximal session count: " + this.maxSessionCount + "\nNew session timeout: " + this.timeOutWaitNewSessionMs + " ms\nRead only: " + this.readOnly + "\nToken: " + this.token;
    }

    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws TokenException {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        return this.getAttrValues(objectHandle, typeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getAttrValues(long objectHandle, List<Long> attributeTypes) throws TokenException {
        Session session = this.borrowSession();
        try {
            AttributeVector attributeVector = session.getAttrValues(objectHandle, attributeTypes);
            return attributeVector;
        }
        finally {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getDefaultAttrValues(long objectHandle) throws TokenException {
        Session session = this.borrowSession();
        try {
            AttributeVector attributeVector = session.getDefaultAttrValues(objectHandle);
            return attributeVector;
        }
        finally {
            this.sessions.add(session);
        }
    }

    private Session openSession() throws PKCS11Exception {
        Session session = this.token.openSession(!this.readOnly);
        this.countSessions.incrementAndGet();
        return session;
    }

    private Session borrowSession() throws TokenException {
        return this.borrowSession(true);
    }

    private Session borrowNoLoginSession() throws TokenException {
        return this.borrowSession(false);
    }

    private Session borrowSession(boolean login) throws TokenException {
        long maxTimeMs = clock.millis() + this.timeOutWaitNewSessionMs;
        int maxTries = this.maxSessionCount + 1;
        for (int retries = 0; retries < maxTries; ++retries) {
            Session session = this.borrowSession(login, maxTimeMs);
            if (session == null) continue;
            if (retries != 0) {
                StaticLogger.info("Borrowed session after " + (retries + 1) + " tries.", new Object[0]);
            }
            return session;
        }
        throw new TokenException("could not borrow session after " + maxTries + " tries.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session borrowSession(boolean login, long maxTimeMs) throws TokenException {
        if (maxTimeMs == 0L) {
            maxTimeMs = clock.millis() + this.timeOutWaitNewSessionMs;
        }
        Session session = null;
        LinkedBlockingQueue<Session> linkedBlockingQueue = this.sessions;
        synchronized (linkedBlockingQueue) {
            if (this.countSessions.get() < (long)this.maxSessionCount && (session = this.sessions.poll()) == null) {
                this.sessions.add(this.openSession());
            }
        }
        if (session == null) {
            long timeOutMs = maxTimeMs - clock.millis();
            try {
                session = this.sessions.poll(Math.max(1L, timeOutMs), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new TokenException("no idle session");
        }
        boolean requiteSession = true;
        try {
            long deviceError2;
            boolean sessionActive = true;
            SessionInfo sessionInfo = null;
            try {
                sessionInfo = session.getSessionInfo();
            }
            catch (PKCS11Exception ex) {
                long ckr = ex.getErrorCode();
                if (ckr == 176L || ckr == 179L) {
                    sessionActive = false;
                }
                StaticLogger.warn("error getSessionInfo: {}", PKCS11Constants.ckrCodeToName(ckr));
            }
            if (sessionActive && sessionInfo != null && (deviceError2 = sessionInfo.getDeviceError()) != 0L) {
                if (this.getModule().hasVendorBehaviour(5)) {
                    StaticLogger.warn("ignore device error {}", deviceError2);
                } else {
                    sessionActive = false;
                    StaticLogger.error("device has error {}", deviceError2);
                }
            }
            if (!sessionActive) {
                requiteSession = false;
                this.sessions.remove(session);
                this.countSessions.decrementAndGet();
                Session deviceError2 = null;
                return deviceError2;
            }
            if (login) {
                boolean loggedIn = false;
                if (sessionInfo != null) {
                    loggedIn = PKCS11Token.isSessionLoggedIn(sessionInfo);
                }
                if (!loggedIn) {
                    Object object = this.loginSync;
                    synchronized (object) {
                        try {
                            sessionInfo = session.getSessionInfo();
                            loggedIn = PKCS11Token.isSessionLoggedIn(sessionInfo);
                        }
                        catch (Exception e) {
                            StaticLogger.debug("Error while getSessionInfo()", e);
                        }
                        if (!loggedIn) {
                            this.login(session);
                        }
                    }
                }
            }
            requiteSession = false;
            Session session2 = session;
            return session2;
        }
        finally {
            if (requiteSession) {
                this.sessions.add(session);
            }
        }
    }

    private static boolean isSessionLoggedIn(SessionInfo sessionInfo) {
        long state = sessionInfo.getState();
        return state == 4L || state == 3L || state == 1L;
    }

    private void login(Session session) throws TokenException {
        this.login(session, this.userType, this.userName, this.pins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(Session session, long userType, char[] userName, List<char[]> pins) throws TokenException {
        Object object = this.loginSync;
        synchronized (object) {
            Object pin;
            StaticLogger.info("verify on PKCS11Module with " + (pins == null || pins.isEmpty() ? "NULL pin" : "pin"), new Object[0]);
            String userText = "user ";
            if (userName != null) {
                userText = userText + new String(userName) + " ";
            }
            userText = userText + "of type " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, userType);
            boolean nullPins = pins == null || pins.isEmpty() ? true : (pins.size() == 1 ? (pin = (Object)pins.get(0)) == null || ((Object)pin).length == 0 : false);
            try {
                if (userName == null) {
                    if (nullPins) {
                        session.login(userType, new char[0]);
                        StaticLogger.info("login successful as " + userText + " with NULL PIN", new Object[0]);
                    } else {
                        for (char[] pin2 : pins) {
                            session.login(userType, pin2 == null ? new char[]{} : pin2);
                        }
                        StaticLogger.info("login successful as " + userText + " with PIN", new Object[0]);
                    }
                } else if (nullPins) {
                    session.loginUser(userType, userName, new char[0]);
                    StaticLogger.info("loginUser successful as " + userText + " with NULL PIN", new Object[0]);
                } else {
                    for (char[] pin3 : pins) {
                        session.loginUser(userType, userName, pin3 == null ? new char[]{} : pin3);
                    }
                    StaticLogger.info("loginUser successful as " + userText + " with PIN", new Object[0]);
                }
            }
            catch (PKCS11Exception ex) {
                long ckr = ex.getErrorCode();
                if (ckr == 256L) {
                    StaticLogger.info("user already logged in", new Object[0]);
                }
                StaticLogger.warn("login failed as {}: {}", userText, PKCS11Constants.ckrCodeToName(ckr));
                throw ex;
            }
        }
    }

    private void opInit(OP op, Session session, Mechanism mechanism, long keyHandle) throws TokenException {
        block2: {
            try {
                this.opInit0(op, session, mechanism, keyHandle);
            }
            catch (PKCS11Exception ex) {
                if (ex.getErrorCode() != 257L) break block2;
                this.login(session);
                this.opInit0(op, session, mechanism, keyHandle);
            }
        }
    }

    private void opInit0(OP op, Session session, Mechanism mechanism, long keyHandle) throws TokenException {
        switch (op) {
            case SIGN: {
                session.signInit(mechanism, keyHandle);
                break;
            }
            case VERIFY: {
                session.verifyInit(mechanism, keyHandle);
                break;
            }
            case DECRYPT: {
                session.decryptInit(mechanism, keyHandle);
                break;
            }
            case ENCRYPT: {
                session.encryptInit(mechanism, keyHandle);
                break;
            }
            case MESSAGE_DECRYPT: {
                session.messageDecryptInit(mechanism, keyHandle);
                break;
            }
            case MESSAGE_ENCRYPT: {
                session.messageEncryptInit(mechanism, keyHandle);
                break;
            }
            case MESSAGE_SIGN: {
                session.messageSignInit(mechanism, keyHandle);
                break;
            }
            case MESSAGE_VERIFY: {
                session.messageVerifyInit(mechanism, keyHandle);
                break;
            }
            case DIGEST: {
                session.digestInit(mechanism);
                break;
            }
            case SIGN_RECOVER: {
                session.signRecoverInit(mechanism, keyHandle);
                break;
            }
            case VERIFY_RECOVER: {
                session.verifyRecoverInit(mechanism, keyHandle);
                break;
            }
            default: {
                throw new IllegalStateException("unknown OP " + (Object)((Object)op));
            }
        }
    }

    private static byte[] copyOfLen(byte[] bytes, int len) {
        return bytes.length == len ? bytes : Arrays.copyOf(bytes, len);
    }

    private static byte[] copyOfLen(byte[] bytes, int offset, int len) {
        return offset == 0 && bytes.length == len ? bytes : Arrays.copyOfRange(bytes, offset, offset + len);
    }

    private static int readBytes(InputStream stream, byte[] buffer, int numBytes) throws IOException {
        int read;
        int ofs = 0;
        while ((read = stream.read(buffer, ofs, numBytes - ofs)) != -1 && (ofs += read) < numBytes) {
        }
        return ofs;
    }

    private static boolean isMacMechanism(long mechanism) {
        return mechanism == 4234L || mechanism == 4238L || mechanism == 545L || mechanism == 598L || mechanism == 593L || mechanism == 609L || mechanism == 625L || mechanism == 694L || mechanism == 689L || mechanism == 705L || mechanism == 721L || mechanism == 599L || mechanism == 594L || mechanism == 610L || mechanism == 626L || mechanism == 695L || mechanism == 690L || mechanism == 706L || mechanism == 722L;
    }

    private static void addCkaTypes(List<Long> list, long ... types) {
        for (long type : types) {
            list.add(type);
        }
    }

    private static enum OP {
        DIGEST,
        SIGN,
        VERIFY,
        ENCRYPT,
        DECRYPT,
        MESSAGE_ENCRYPT,
        MESSAGE_DECRYPT,
        MESSAGE_SIGN,
        MESSAGE_VERIFY,
        SIGN_RECOVER,
        VERIFY_RECOVER;

    }
}

