/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.Version;

public class SlotInfo {
    private final String slotDescription;
    private final String manufacturerID;
    private final Version hardwareVersion;
    private final Version firmwareVersion;
    private final long flags;

    protected SlotInfo(CK_SLOT_INFO ckSlotInfo) {
        Functions.requireNonNull("ckSlotInfo", ckSlotInfo);
        this.slotDescription = new String(ckSlotInfo.slotDescription).trim();
        this.manufacturerID = new String(ckSlotInfo.manufacturerID).trim();
        this.hardwareVersion = new Version(ckSlotInfo.hardwareVersion);
        this.firmwareVersion = new Version(ckSlotInfo.firmwareVersion);
        this.flags = ckSlotInfo.flags;
    }

    public String getSlotDescription() {
        return this.slotDescription;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isTokenPresent() {
        return (this.flags & 1L) != 0L;
    }

    public boolean isRemovableDevice() {
        return (this.flags & 2L) != 0L;
    }

    public boolean isHwSlot() {
        return (this.flags & 4L) != 0L;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String ni = "\n" + indent;
        String text = indent + "Description:     " + this.slotDescription + ni + "Manufacturer ID: " + this.manufacturerID + ni + "Versions:        [Hardware: " + this.hardwareVersion + ", Firmware: " + this.firmwareVersion + "]";
        return text + "\n" + Functions.toStringFlags(PKCS11Constants.Category.CKF_TOKEN, indent + "Flags: ", this.flags, 1L, 2L, 4L);
    }
}

