/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.attrs;

import java.math.BigInteger;
import java.util.Arrays;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.attrs.Attribute;

public class ByteArrayAttribute
extends Attribute {
    public ByteArrayAttribute(long type) {
        super(type);
    }

    public ByteArrayAttribute byteArrayValue(byte[] value) {
        this.ckAttribute.pValue = value;
        this.present = true;
        return this;
    }

    public ByteArrayAttribute bigIntValue(BigInteger value) {
        return this.byteArrayValue(value == null ? null : Functions.asUnsignedByteArray(value));
    }

    public byte[] getValue() {
        return (byte[])this.ckAttribute.pValue;
    }

    public BigInteger getBigIntValue() {
        return this.isNullValue() ? null : new BigInteger(1, (byte[])this.ckAttribute.pValue);
    }

    public BigInteger getSignedBigIntValue() {
        return this.isNullValue() ? null : new BigInteger((byte[])this.ckAttribute.pValue);
    }

    @Override
    protected String getValueString() {
        if (this.isNullValue()) {
            return "<NULL_PTR>";
        }
        byte[] value = (byte[])this.ckAttribute.pValue;
        String text = "byte[" + value.length + "]\n" + Functions.toString("    ", value);
        if (this.type() != 384L) {
            return text;
        }
        try {
            Object[] curveNames = Functions.getCurveNames(value);
            String curveOid = Functions.decodeOid(value);
            return text + "(" + curveOid + ", " + Arrays.toString(curveNames) + ")";
        }
        catch (Exception e) {
            return text;
        }
    }
}

