/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.attrs;

import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.attrs.Attribute;

public class MechanismArrayAttribute
extends Attribute {
    public MechanismArrayAttribute(long type) {
        super(type);
    }

    public MechanismArrayAttribute mechanismAttributeArrayValue(long[] value) {
        this.ckAttribute.pValue = value.clone();
        this.present = true;
        return this;
    }

    public long[] getValue() {
        return this.isNullValue() ? null : (long[])((long[])this.ckAttribute.pValue).clone();
    }

    @Override
    protected String getValueString() {
        long[] allowedMechanisms = this.getValue();
        if (allowedMechanisms != null && allowedMechanisms.length > 0) {
            StringBuilder sb = new StringBuilder(200);
            for (long mech : allowedMechanisms) {
                sb.append("\n      ").append(PKCS11Constants.ckmCodeToName(mech));
            }
            return sb.toString();
        }
        return "<NULL_PTR>";
    }
}

