/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import java.util.Arrays;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Module;

public abstract class CkParams {
    protected PKCS11Module module;

    public abstract Object getParams();

    protected abstract int getMaxFieldLen();

    public abstract String toString(String var1);

    public void setModule(PKCS11Module module) {
        this.module = module;
    }

    public final String toString() {
        return this.toString("");
    }

    protected String ptr2str(String indent, String name, Object value) {
        String prefix = "\n" + indent + "  ";
        if (!name.isEmpty()) {
            prefix = prefix + this.formatFieldName(name) + ": ";
        }
        if (value == null) {
            return prefix + "<NULL_PTR>";
        }
        if (value instanceof byte[]) {
            char[] spaceIndent = new char[prefix.length() - 1];
            Arrays.fill(spaceIndent, ' ');
            byte[] bytes = (byte[])value;
            return prefix + "byte[" + bytes.length + "]\n" + Functions.toString(new String(spaceIndent), bytes);
        }
        if (value instanceof char[]) {
            return prefix + new String((char[])value);
        }
        return prefix + value;
    }

    protected String val2Str(String indent, String name, Object value) {
        String prefix = "\n" + indent + "  ";
        if (!name.isEmpty()) {
            prefix = prefix + this.formatFieldName(name) + ": ";
        }
        return prefix + value;
    }

    private String formatFieldName(String name) {
        int maxFieldNameLen = this.getMaxFieldLen();
        if (name.length() >= maxFieldNameLen) {
            return name;
        }
        char[] prefix = new char[maxFieldNameLen - name.length()];
        Arrays.fill(prefix, ' ');
        return new String(prefix) + name;
    }

    protected String codeToName(PKCS11Constants.Category category, long code) {
        long code2;
        String name = PKCS11Constants.codeToName(category, code);
        if (this.module != null && code != (code2 = this.module.genericToVendorCode(category, code))) {
            name = name + " (native: " + this.module.codeToName(category, code2) + ")";
        }
        return name;
    }

    protected static <T> T requireNonNull(String paramName, T param) {
        return Functions.requireNonNull(paramName, param);
    }
}

