/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import iaik.pkcs.pkcs11.wrapper.CK_ECDSA_ECIES_PARAMS;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;

public class Utimaco_ECDSA_ECIES_PARAMS
extends CkParams {
    private final CK_ECDSA_ECIES_PARAMS params = new CK_ECDSA_ECIES_PARAMS();

    public Utimaco_ECDSA_ECIES_PARAMS(long hashAlg, long cryptAlg, long cryptOpt, long macAlg, long macOpt) {
        this(hashAlg, cryptAlg, cryptOpt, macAlg, macOpt, null, null);
    }

    public Utimaco_ECDSA_ECIES_PARAMS(long hashAlg, long cryptAlg, long cryptOpt, long macAlg, long macOpt, byte[] sharedSecret1, byte[] sharedSecret2) {
        this.params.hashAlg = hashAlg;
        this.params.cryptAlg = cryptAlg;
        this.params.cryptOpt = cryptOpt;
        this.params.macAlg = macAlg;
        this.params.macOpt = macOpt;
        this.params.pSharedSecret1 = sharedSecret1;
        this.params.pSharedSecret2 = sharedSecret2;
    }

    @Override
    public CK_ECDSA_ECIES_PARAMS getParams() {
        if (this.module == null) {
            return this.params;
        }
        long newHashAlg = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.params.hashAlg);
        long newCryptAlg = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.params.cryptAlg);
        long newMacAlg = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.params.macAlg);
        if (newHashAlg == this.params.hashAlg && newCryptAlg == this.params.cryptAlg && newMacAlg == this.params.macAlg) {
            return this.params;
        }
        CK_ECDSA_ECIES_PARAMS params0 = new CK_ECDSA_ECIES_PARAMS();
        params0.hashAlg = newHashAlg;
        params0.cryptAlg = newCryptAlg;
        params0.cryptOpt = this.params.cryptOpt;
        params0.macAlg = newMacAlg;
        params0.macOpt = this.params.macOpt;
        params0.pSharedSecret1 = this.params.pSharedSecret1;
        params0.pSharedSecret2 = this.params.pSharedSecret2;
        return params0;
    }

    @Override
    protected int getMaxFieldLen() {
        return 13;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_ECDSA_ECIES_PARAMS:" + this.val2Str(indent, "hashAlg", this.codeToName(PKCS11Constants.Category.CKM, this.params.hashAlg)) + this.val2Str(indent, "cryptAlg", this.codeToName(PKCS11Constants.Category.CKM, this.params.cryptAlg)) + this.val2Str(indent, "cryptOpt", this.params.cryptOpt) + this.val2Str(indent, "macAlg", this.codeToName(PKCS11Constants.Category.CKM, this.params.macAlg)) + this.val2Str(indent, "mac options", this.params.macOpt) + this.ptr2str(indent, "sharedSecret1", this.params.pSharedSecret1) + this.ptr2str(indent, "sharedSecret2", this.params.pSharedSecret2);
    }
}

