/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.xipki.pkcs11.wrapper.PKCS11Constants;

public class Functions {
    private static final Map<Long, String> hashMechCodeToHashNames = new HashMap<Long, String>();
    private static final Map<String, ECInfo> ecParamsInfoMap;
    private static final Set<String> edwardsMontgomeryEcParams;

    public static String getHashAlgName(long hashMechanism) {
        return hashMechCodeToHashNames.get(hashMechanism);
    }

    public static byte[] asUnsignedByteArray(BigInteger bn) {
        byte[] bytes = bn.toByteArray();
        return bytes[0] != 0 ? bytes : Arrays.copyOfRange(bytes, 1, bytes.length);
    }

    public static String toFullHex(long value) {
        long currentValue = value;
        StringBuilder stringBuffer = new StringBuilder(16);
        int size = value > 0xFFFFFFFFL ? 16 : 8;
        for (int j = 0; j < size; ++j) {
            int currentDigit = (int)currentValue & 0xF;
            stringBuffer.append(Hex.DIGITS[currentDigit]);
            currentValue >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHex(byte[] value) {
        return Hex.encode(value, 0, value.length);
    }

    public static String toHex(byte[] value, int ofs, int len) {
        return Hex.encode(value, ofs, len);
    }

    public static byte[] decodeHex(String encoded) {
        return Hex.decode(encoded);
    }

    public static <T> T requireNonNull(String paramName, T param) {
        if (param == null) {
            throw new NullPointerException("Argument '" + paramName + "' must not be null.");
        }
        return param;
    }

    public static int requireRange(String name, int argument, int min, int max) {
        if (argument < min || argument > max) {
            throw new IllegalArgumentException(String.format("%s may not be out of the range [%d, %d]: %d", name, min, max, argument));
        }
        return argument;
    }

    public static int requireAmong(String name, int argument, int ... candidates) {
        for (int candidate : candidates) {
            if (argument != candidate) continue;
            return argument;
        }
        throw new IllegalArgumentException(name + " is not among " + Arrays.toString(candidates) + ": " + argument);
    }

    public static long requireAmong(String name, long argument, long ... candidates) {
        for (long candidate : candidates) {
            if (argument != candidate) continue;
            return argument;
        }
        throw new IllegalArgumentException(name + " is not among " + Arrays.toString(candidates) + ": " + argument);
    }

    public static String toStringFlags(PKCS11Constants.Category category, String prefix, long flags, long ... flagMasks) {
        char[] indentChars = new char[prefix.length() + 1];
        Arrays.fill(indentChars, ' ');
        String indent = new String(indentChars);
        ArrayList<Long> sortedMasks = new ArrayList<Long>(flagMasks.length);
        for (long flagMask : flagMasks) {
            sortedMasks.add(flagMask);
        }
        Collections.sort(sortedMasks);
        boolean first = true;
        LinkedList<String> lines = new LinkedList<String>();
        String line = prefix + "0x" + Functions.toFullHex(flags) + " (";
        Iterator flagMask = sortedMasks.iterator();
        while (flagMask.hasNext()) {
            String thisEntry;
            long flagMask2 = (Long)flagMask.next();
            if ((flags & flagMask2) == 0L) continue;
            String string = thisEntry = first ? "" : " | ";
            if (first) {
                first = false;
            }
            thisEntry = thisEntry + PKCS11Constants.codeToName(category, flagMask2).substring(4);
            if (line.length() + thisEntry.length() > 100) {
                lines.add(line);
                line = indent;
            }
            line = line + thisEntry;
        }
        if (line.length() > indentChars.length) {
            lines.add(line);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append((String)lines.get(i));
        }
        return sb.append(")").toString();
    }

    static byte[] fixECDSASignature(byte[] sig, byte[] ecParams) {
        ECInfo ecInfo = ecParamsInfoMap.get(Hex.encode(ecParams, 0, ecParams.length));
        return ecInfo == null ? sig : Functions.fixECDSASignature(sig, ecInfo.orderSize);
    }

    static byte[] fixECParams(byte[] ecParams) {
        int tag = 0xFF & ecParams[0];
        if (tag == 12 || tag == 19) {
            int len = 0xFF & ecParams[1];
            if (len < 128 && 2 + len == ecParams.length) {
                String curveName = new String(ecParams, 2, len, StandardCharsets.UTF_8).trim().toUpperCase(Locale.ROOT);
                for (Map.Entry<String, ECInfo> m : ecParamsInfoMap.entrySet()) {
                    for (String name : m.getValue().names) {
                        if (!name.equals(curveName)) continue;
                        return Functions.decodeHex(m.getKey());
                    }
                }
            }
            return ecParams;
        }
        if (tag == 48) {
            int len;
            int lenb;
            int offset = 1;
            int n = (lenb = 0xFF & ecParams[offset++]) <= 127 ? lenb : (lenb == 129 ? 0xFF & ecParams[offset++] : (len = lenb == 130 ? (0xFF & ecParams[offset++]) << 8 | 0xFF & ecParams[offset++] : -1));
            if (len == -1 || offset + len != ecParams.length) {
                return ecParams;
            }
            SipHash24 hash = new SipHash24();
            hash.update(ecParams, 0, ecParams.length);
            long hashValue = hash.doFinal();
            for (Map.Entry<String, ECInfo> m : ecParamsInfoMap.entrySet()) {
                if (hashValue != m.getValue().ecParamsHash) continue;
                return Functions.decodeHex(m.getKey());
            }
        }
        return ecParams;
    }

    static byte[] fixECDSASignature(byte[] sig, int rOrSLen) {
        int len;
        if (sig.length == 2 * rOrSLen || sig[0] != 48) {
            return sig;
        }
        byte b = sig[1];
        int ofs = 2;
        int n = (b & 0x80) == 0 ? 0xFF & b : (len = b == -127 ? 0xFF & sig[ofs++] : 0);
        if (len == 0 || ofs + len != sig.length) {
            return sig;
        }
        if (sig[ofs++] != 2) {
            return sig;
        }
        if (((b = sig[ofs++]) & 0x80) != 0) {
            return sig;
        }
        int rLen = 0xFF & b;
        byte[] r = Arrays.copyOfRange(sig, ofs, ofs + rLen);
        ofs += rLen;
        if (sig[ofs++] != 2) {
            return sig;
        }
        if (((b = sig[ofs++]) & 0x80) != 0) {
            return sig;
        }
        int sLen = 0xFF & b;
        if (ofs + sLen != sig.length) {
            return sig;
        }
        byte[] s = Arrays.copyOfRange(sig, ofs, sig.length);
        if (r[0] == 0) {
            r = Arrays.copyOfRange(r, 1, r.length);
        }
        if (s[0] == 0) {
            s = Arrays.copyOfRange(s, 1, s.length);
        }
        if (r.length > rOrSLen || s.length > rOrSLen) {
            return sig;
        }
        byte[] rs = new byte[2 * rOrSLen];
        System.arraycopy(r, 0, rs, rOrSLen - r.length, r.length);
        System.arraycopy(s, 0, rs, rs.length - s.length, s.length);
        return rs;
    }

    public static String toString(String prefix, byte[] bytes) {
        int numPerLine = 40;
        int len = bytes.length;
        int indentLen = prefix.length();
        if (indentLen > 0 && prefix.charAt(0) == '\n') {
            --indentLen;
        }
        char[] indentChars = new char[indentLen];
        Arrays.fill(indentChars, ' ');
        String indent = "\n" + new String(indentChars);
        StringBuilder sb = new StringBuilder(5 * (len + 40 - 1) / 40 + 4 * bytes.length);
        for (int ofs = 0; ofs < len; ofs += 40) {
            int num = Math.min(40, len - ofs);
            sb.append(ofs == 0 ? prefix : indent).append(Functions.toHex(bytes, ofs, num));
        }
        return sb.toString();
    }

    static byte[] fixECPoint(byte[] ecPoint, byte[] ecParams) {
        if (ecParams == null) {
            return ecPoint;
        }
        int len = ecPoint.length;
        if (len > 65520) {
            return ecPoint;
        }
        String hexEcParams = Hex.encode(ecParams, 0, ecParams.length);
        ECInfo ecInfo = ecParamsInfoMap.get(hexEcParams);
        if (ecInfo == null) {
            return ecPoint;
        }
        int fieldSize = ecInfo.fieldSize;
        if (edwardsMontgomeryEcParams.contains(hexEcParams)) {
            return len == fieldSize ? Functions.toOctetString(ecPoint) : ecPoint;
        }
        if (ecPoint.length == 2 * fieldSize) {
            byte[] ecPoint2 = new byte[1 + ecPoint.length];
            ecPoint2[0] = 4;
            System.arraycopy(ecPoint, 0, ecPoint2, 1, ecPoint.length);
            return Functions.toOctetString(ecPoint2);
        }
        byte encodingByte = ecPoint[0];
        if (encodingByte == 4 ? len == 1 + 2 * fieldSize : (encodingByte == 2 || encodingByte == 3) && len == 1 + fieldSize) {
            return Functions.toOctetString(ecPoint);
        }
        return ecPoint;
    }

    private static byte[] toOctetString(byte[] bytes) {
        int len = bytes.length;
        int numLenBytes = len <= 127 ? 1 : (len <= 255 ? 2 : (len <= 65535 ? 3 : 4));
        byte[] ret = new byte[1 + numLenBytes + len];
        ret[0] = 4;
        if (numLenBytes == 2) {
            ret[1] = -127;
        } else if (numLenBytes == 3) {
            ret[1] = -126;
            ret[2] = (byte)(len >> 8);
        } else if (numLenBytes == 4) {
            ret[1] = -125;
            ret[2] = (byte)(len >> 16);
            ret[3] = (byte)(len >> 8);
        }
        ret[numLenBytes] = (byte)len;
        System.arraycopy(bytes, 0, ret, 1 + numLenBytes, bytes.length);
        return ret;
    }

    static {
        hashMechCodeToHashNames.put(544L, "SHA1");
        hashMechCodeToHashNames.put(597L, "SHA224");
        hashMechCodeToHashNames.put(592L, "SHA256");
        hashMechCodeToHashNames.put(608L, "SHA384");
        hashMechCodeToHashNames.put(624L, "SHA512");
        hashMechCodeToHashNames.put(72L, "SHA512/224");
        hashMechCodeToHashNames.put(76L, "SHA512/256");
        hashMechCodeToHashNames.put(693L, "SHA3-224");
        hashMechCodeToHashNames.put(688L, "SHA3-256");
        hashMechCodeToHashNames.put(704L, "SHA3-384");
        hashMechCodeToHashNames.put(720L, "SHA3-512");
        edwardsMontgomeryEcParams = new HashSet<String>(6);
        edwardsMontgomeryEcParams.add("06032b656e");
        edwardsMontgomeryEcParams.add("06032b656f");
        edwardsMontgomeryEcParams.add("06032b6570");
        edwardsMontgomeryEcParams.add("06032b6571");
        ecParamsInfoMap = new HashMap<String, ECInfo>(120);
        String propFile = "org/xipki/pkcs11/wrapper/EC.properties";
        Properties props = new Properties();
        try {
            props.load(Functions.class.getClassLoader().getResourceAsStream(propFile));
            for (String name : props.stringPropertyNames()) {
                if (ecParamsInfoMap.containsKey(name = name.trim())) {
                    throw new IllegalStateException("duplicated definition of " + name);
                }
                byte[] ecParams = Hex.decode(name);
                ECInfo ecInfo = new ECInfo();
                String[] values = props.getProperty(name).split(",");
                ecInfo.names = values[0].toUpperCase(Locale.ROOT).split(":");
                ecInfo.ecParamsHash = "-".equals(values[1]) ? 0L : SipHash24.littleEndianToLong(Hex.decode(values[1]), 0);
                ecInfo.fieldSize = (Integer.parseInt(values[2]) + 7) / 8;
                ecInfo.orderSize = values.length > 3 ? (Integer.parseInt(values[3]) + 7) / 8 : ecInfo.fieldSize;
                String hexEcParams = Hex.encode(ecParams, 0, ecParams.length);
                ecParamsInfoMap.put(hexEcParams, ecInfo);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("error reading properties file " + propFile + ": " + t.getMessage());
        }
    }

    private static class SipHash24 {
        private final int c = 2;
        private final int d = 4;
        private final long k0 = 506097522914230528L;
        private final long k1 = 1084818905618843912L;
        private long v0;
        private long v1;
        private long v2;
        private long v3;
        private long m = 0L;
        private int wordPos = 0;
        private int wordCount = 0;

        public SipHash24() {
            this.reset();
        }

        public void update(byte[] input, int offset, int length) {
            int i;
            int fullWords = length & 0xFFFFFFF8;
            if (this.wordPos == 0) {
                for (i = 0; i < fullWords; i += 8) {
                    this.m = SipHash24.littleEndianToLong(input, offset + i);
                    this.processMessageWord();
                }
                while (i < length) {
                    this.m >>>= 8;
                    this.m |= ((long)input[offset + i] & 0xFFL) << 56;
                    ++i;
                }
                this.wordPos = length - fullWords;
            } else {
                int bits = this.wordPos << 3;
                while (i < fullWords) {
                    long n = SipHash24.littleEndianToLong(input, offset + i);
                    this.m = n << bits | this.m >>> -bits;
                    this.processMessageWord();
                    this.m = n;
                    i += 8;
                }
                while (i < length) {
                    this.m >>>= 8;
                    this.m |= ((long)input[offset + i] & 0xFFL) << 56;
                    if (++this.wordPos == 8) {
                        this.processMessageWord();
                        this.wordPos = 0;
                    }
                    ++i;
                }
            }
        }

        public long doFinal() {
            this.m >>>= 7 - this.wordPos << 3;
            this.m >>>= 8;
            this.m |= ((long)((this.wordCount << 3) + this.wordPos) & 0xFFL) << 56;
            this.processMessageWord();
            this.v2 ^= 0xFFL;
            this.applySipRounds(4);
            long result = this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
            this.reset();
            return result;
        }

        public void reset() {
            this.v0 = 8388350548712186997L;
            this.v1 = 7737605742629119589L;
            this.v2 = 7746018054687388513L;
            this.v3 = 8893317812261383291L;
            this.m = 0L;
            this.wordPos = 0;
            this.wordCount = 0;
        }

        private void processMessageWord() {
            ++this.wordCount;
            this.v3 ^= this.m;
            this.applySipRounds(2);
            this.v0 ^= this.m;
        }

        private void applySipRounds(int n) {
            long r0 = this.v0;
            long r1 = this.v1;
            long r2 = this.v2;
            long r3 = this.v3;
            for (int r = 0; r < n; ++r) {
                r0 += r1;
                r2 += r3;
                r1 = r1 << 13 | r1 >>> 51;
                r3 = r3 << 16 | r3 >>> 48;
                r1 ^= r0;
                r3 ^= r2;
                r0 = r0 << 32 | r0 >>> 32;
                r2 += r1;
                r0 += r3;
                r1 = r1 << 17 | r1 >>> 47;
                r3 = r3 << 21 | r3 >>> 43;
                r1 ^= r2;
                r3 ^= r0;
                r2 = r2 << 32 | r2 >>> 32;
            }
            this.v0 = r0;
            this.v1 = r1;
            this.v2 = r2;
            this.v3 = r3;
        }

        private static long littleEndianToLong(byte[] bs, int off) {
            return (long)bs[off++] & 0xFFL | ((long)bs[off++] & 0xFFL) << 8 | ((long)bs[off++] & 0xFFL) << 16 | ((long)bs[off++] & 0xFFL) << 24 | ((long)bs[off++] & 0xFFL) << 32 | ((long)bs[off++] & 0xFFL) << 40 | ((long)bs[off++] & 0xFFL) << 48 | ((long)bs[off] & 0xFFL) << 56;
        }
    }

    private static class ECInfo {
        int fieldSize;
        int orderSize;
        long ecParamsHash;
        String[] names;

        private ECInfo() {
        }
    }

    private static class Hex {
        private static final char[] DIGITS;
        private static final char[] UPPER_DIGITS;
        private static final int[] LINTS;
        private static final int[] HINTS;

        private Hex() {
        }

        public static String encode(byte[] data, int ofs, int len) {
            char[] out = new char[len << 1];
            int endOfs = ofs + len;
            int j = 0;
            for (int i = ofs; i < endOfs; ++i) {
                out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
                out[j++] = DIGITS[0xF & data[i]];
            }
            return new String(out);
        }

        public static byte[] decode(String hex) {
            char[] data = hex.toCharArray();
            int len = data.length;
            if ((len & 1) != 0) {
                throw new IllegalArgumentException("Odd number of characters.");
            }
            byte[] out = new byte[len >> 1];
            int i = 0;
            int j = 0;
            while (j < len) {
                out[i] = (byte)(HINTS[data[j++]] | LINTS[data[j++]]);
                ++i;
            }
            return out;
        }

        static {
            int i;
            DIGITS = "0123456789abcdef".toCharArray();
            UPPER_DIGITS = "0123456789ABCDEF".toCharArray();
            LINTS = new int[103];
            HINTS = new int[LINTS.length];
            for (i = 0; i < DIGITS.length; ++i) {
                Hex.LINTS[Hex.DIGITS[i]] = i;
            }
            for (i = 10; i < UPPER_DIGITS.length; ++i) {
                Hex.LINTS[Hex.UPPER_DIGITS[i]] = i;
            }
            for (i = 0; i < LINTS.length; ++i) {
                Hex.HINTS[i] = LINTS[i] << 4;
            }
        }
    }
}

