/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.util.Date;
import java.util.Objects;
import org.xipki.pkcs11.wrapper.AttributeVector;

public class KeyPairTemplate {
    private final AttributeVector privateKey;
    private final AttributeVector publicKey;

    public KeyPairTemplate(long keyType) {
        this.privateKey = AttributeVector.newPrivateKey(keyType);
        this.publicKey = AttributeVector.newPublicKey(keyType);
    }

    public KeyPairTemplate(AttributeVector privateKey, AttributeVector publicKey) {
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey must not be null");
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey must not be null");
        if (!Objects.equals(privateKey.keyType(), publicKey.keyType())) {
            throw new IllegalArgumentException("privateKey and publicKey do not have the same key type.");
        }
        if (privateKey.class_() == null) {
            privateKey.class_(3L);
        } else if (privateKey.class_() != 3L) {
            throw new IllegalArgumentException("privateKey must have the class CKO_PRIVATE_KEY");
        }
        if (publicKey.class_() == null) {
            publicKey.class_(2L);
        } else if (publicKey.class_() != 2L) {
            throw new IllegalArgumentException("publicKey must have the class CKO_PUBLIC_KEY");
        }
    }

    public AttributeVector privateKey() {
        return this.privateKey;
    }

    public AttributeVector publicKey() {
        return this.publicKey;
    }

    public KeyPairTemplate derive(Boolean derive) {
        this.privateKey.derive(derive);
        this.publicKey.derive(derive);
        return this;
    }

    public KeyPairTemplate decryptEncrypt(Boolean decryptEncrypt) {
        this.privateKey.decrypt(decryptEncrypt);
        this.publicKey.encrypt(decryptEncrypt);
        return this;
    }

    public KeyPairTemplate endDate(Date endDate) {
        this.privateKey.endDate(endDate);
        this.publicKey.endDate(endDate);
        return this;
    }

    public KeyPairTemplate id(byte[] id) {
        this.privateKey.id(id);
        this.publicKey.id(id);
        return this;
    }

    public KeyPairTemplate keyType(long keyType) {
        this.privateKey.keyType(keyType);
        this.publicKey.keyType(keyType);
        return this;
    }

    public KeyPairTemplate label(String label) {
        return this.label(label, label);
    }

    public KeyPairTemplate label(String privateKeyLabel, String publicKeyLabel) {
        if (privateKeyLabel != null) {
            this.privateKey.label(privateKeyLabel);
        }
        if (publicKeyLabel != null) {
            this.publicKey.label(publicKeyLabel);
        }
        return this;
    }

    public KeyPairTemplate local(Boolean local) {
        this.privateKey.local(local);
        this.publicKey.local(local);
        return this;
    }

    public KeyPairTemplate modifiable(Boolean modifiable) {
        this.privateKey.modifiable(modifiable);
        this.publicKey.modifiable(modifiable);
        return this;
    }

    public KeyPairTemplate private_(Boolean private_) {
        return this.private_(private_, private_);
    }

    public KeyPairTemplate private_(Boolean privateKeyPrivate, Boolean publicKeyPrivate) {
        if (privateKeyPrivate != null) {
            this.privateKey.private_(privateKeyPrivate);
        }
        if (publicKeyPrivate != null) {
            this.publicKey.private_(publicKeyPrivate);
        }
        return this;
    }

    public KeyPairTemplate signVerify(Boolean signVerify) {
        this.privateKey.sign(signVerify);
        this.publicKey.verify(signVerify);
        return this;
    }

    public KeyPairTemplate signVerifyRecover(Boolean signVerifyRecover) {
        this.privateKey.signRecover(signVerifyRecover);
        this.publicKey.verifyRecover(signVerifyRecover);
        return this;
    }

    public KeyPairTemplate startDate(Date startDate) {
        this.privateKey.startDate(startDate);
        this.publicKey.startDate(startDate);
        return this;
    }

    public KeyPairTemplate subject(byte[] subject) {
        this.privateKey.subject(subject);
        this.publicKey.subject(subject);
        return this;
    }

    public KeyPairTemplate token(Boolean token) {
        this.privateKey.token(token);
        this.publicKey.token(token);
        return this;
    }

    public KeyPairTemplate unwrapWrap(Boolean unwrapWrap) {
        this.privateKey.unwrap(unwrapWrap);
        this.publicKey.wrap(unwrapWrap);
        return this;
    }
}

