/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;

public class MechanismInfo {
    private final long minKeySize;
    private final long maxKeySize;
    private long flags;

    public MechanismInfo(CK_MECHANISM_INFO ckMechanismInfo) {
        this(Functions.requireNonNull((String)"ckMechanismInfo", ckMechanismInfo).ulMinKeySize, ckMechanismInfo.ulMaxKeySize, ckMechanismInfo.flags);
    }

    public MechanismInfo(long minKeySize, long maxKeySize, long flags) {
        this.minKeySize = minKeySize;
        this.maxKeySize = maxKeySize;
        this.flags = flags;
    }

    public long getMinKeySize() {
        return this.minKeySize;
    }

    public long getMaxKeySize() {
        return this.maxKeySize;
    }

    public boolean hasFlagBit(long flagMask) {
        return (this.flags & flagMask) != 0L;
    }

    public void setFlagBit(long flagMask) {
        this.flags |= flagMask;
    }

    public void clearFlagBit(long flagMask) {
        this.flags &= flagMask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean supports(MechanismInfo requiredFeatures) {
        Functions.requireNonNull("requiredFeatures", requiredFeatures);
        long requiredMaxKeySize = requiredFeatures.getMaxKeySize();
        long requiredMinKeySize = requiredFeatures.getMinKeySize();
        return requiredMaxKeySize != 0L && requiredMaxKeySize > this.maxKeySize ? false : (requiredMinKeySize != 0L && requiredMinKeySize < this.minKeySize ? false : (requiredFeatures.flags & this.flags) == requiredFeatures.flags);
    }

    public String toString() {
        String text = "  Key-Size: [" + this.minKeySize + ", " + this.maxKeySize + "]\n";
        return text + Functions.toStringFlags(PKCS11Constants.Category.CKF_MECHANISM, "  Flags: ", this.flags, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L);
    }
}

