/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.Version;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.PKCS11;

public class PKCS11Module {
    private PKCS11 pkcs11;
    private final String pkcs11ModulePath;
    private Boolean ecPointFixNeeded;
    private Boolean ecdsaSignatureFixNeeded;
    private Boolean sm2SignatureFixNeeded;
    private boolean withVendorCodeMap;
    private final Map<Long, Long> ckkGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckkVendorToGenericMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmVendorToGenericMap = new HashMap<Long, Long>();

    protected PKCS11Module(String pkcs11ModulePath) {
        this.pkcs11ModulePath = Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath);
    }

    public static PKCS11Module getInstance(String pkcs11ModulePath) throws IOException {
        Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath);
        File file = new File(pkcs11ModulePath);
        if (!file.exists()) {
            throw new IOException("File " + pkcs11ModulePath + " does not exist");
        }
        if (!file.isFile()) {
            throw new IOException(pkcs11ModulePath + " is not a file");
        }
        if (!file.canRead()) {
            throw new IOException("Can not read file " + pkcs11ModulePath + "");
        }
        return new PKCS11Module(pkcs11ModulePath);
    }

    Boolean getEcPointFixNeeded() {
        return this.ecPointFixNeeded;
    }

    void setEcPointFixNeeded(Boolean ecPointFixNeeded) {
        this.ecPointFixNeeded = ecPointFixNeeded;
    }

    Boolean getEcdsaSignatureFixNeeded() {
        return this.ecdsaSignatureFixNeeded;
    }

    void setEcdsaSignatureFixNeeded(Boolean ecdsaSignatureFixNeeded) {
        this.ecdsaSignatureFixNeeded = ecdsaSignatureFixNeeded;
    }

    Boolean getSm2SignatureFixNeeded() {
        return this.sm2SignatureFixNeeded;
    }

    void setSm2SignatureFixNeeded(Boolean sm2SignatureFixNeeded) {
        this.sm2SignatureFixNeeded = sm2SignatureFixNeeded;
    }

    public ModuleInfo getInfo() throws PKCS11Exception {
        this.assertInitialized();
        try {
            return new ModuleInfo(this.pkcs11.C_GetInfo());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void initialize() throws TokenException {
        CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
        wrapperInitArgs.flags |= 2L;
        String functionList = "C_GetFunctionList";
        boolean omitInitialize = false;
        try {
            this.pkcs11 = PKCS11.getInstance(this.pkcs11ModulePath, "C_GetFunctionList", wrapperInitArgs, false);
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        catch (NoSuchMethodError ex) {
            try {
                Method getInstanceMethod = PKCS11.class.getMethod("getInstance", String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE, MethodHandle.class);
                this.pkcs11 = (PKCS11)getInstanceMethod.invoke(null, this.pkcs11ModulePath, "C_GetFunctionList", wrapperInitArgs, false, null);
            }
            catch (Exception ex1) {
                throw new TokenException(ex1.getMessage(), ex1);
            }
        }
        this.initVendorCode();
    }

    public Slot[] getSlotList(boolean tokenPresent) throws PKCS11Exception {
        long[] slotIDs;
        this.assertInitialized();
        try {
            slotIDs = this.pkcs11.C_GetSlotList(tokenPresent);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        Slot[] slots = new Slot[slotIDs.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = new Slot(this, slotIDs[i]);
        }
        return slots;
    }

    public PKCS11 getPKCS11() {
        this.assertInitialized();
        return this.pkcs11;
    }

    long ckkGenericToVendor(long genericCode) {
        return this.withVendorCodeMap ? this.ckkGenericToVendorMap.getOrDefault(genericCode, genericCode) : genericCode;
    }

    long ckkVendorToGeneric(long vendorCode) {
        return this.withVendorCodeMap ? this.ckkVendorToGenericMap.getOrDefault(vendorCode, vendorCode) : vendorCode;
    }

    long ckmGenericToVendor(long genericCode) {
        return this.withVendorCodeMap ? this.ckmGenericToVendorMap.getOrDefault(genericCode, genericCode) : genericCode;
    }

    long ckmVendorToGeneric(long vendorCode) {
        return this.withVendorCodeMap ? this.ckmVendorToGenericMap.getOrDefault(vendorCode, vendorCode) : vendorCode;
    }

    public String toString() {
        return this.pkcs11 != null ? this.pkcs11.toString() : "null";
    }

    public void finalize(Object args) throws PKCS11Exception {
        try {
            this.pkcs11.C_Finalize(args);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    private void assertInitialized() {
        if (this.pkcs11 == null) {
            throw new IllegalStateException("Module not initialized yet, please call initialize() first");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initVendorCode() {
        block23: {
            try {
                moduleInfo = this.getInfo();
                manufacturerID = moduleInfo.getManufacturerID();
                libraryDescription = moduleInfo.getLibraryDescription();
                libraryVersion = moduleInfo.getLibraryVersion();
                confPath = System.getProperty("org.xipki.pkcs11.vendorcode.conf");
                in = confPath != null ? Files.newInputStream(Paths.get(this.pkcs11ModulePath, new String[0]), new OpenOption[0]) : PKCS11Module.class.getClassLoader().getResourceAsStream("org/xipki/pkcs11/wrapper/vendorcode.conf");
                br = new BufferedReader(new InputStreamReader(in));
                var8_9 = null;
                ** try [egrp 1[TRYBLOCK] [1, 2 : 87->535)] { 
lbl11:
                // 1 sources

                break block23;
lbl12:
                // 1 sources

                catch (Throwable var9_12) {
                    var8_9 = var9_12;
                    throw var9_12;
                }
            }
            catch (Exception e) {
                System.err.println("error reading VENDOR code mapping, ignore it.");
                ** GOTO lbl-1000
            }
        }
        block11: while (true) {
            if ((block = PKCS11Module.readVendorCodeBlock(br)) == null) ** GOTO lbl-1000
            if (!block.matches(this.pkcs11ModulePath, manufacturerID, libraryDescription, libraryVersion)) continue;
            var10_13 = VendorCodeConfBlock.access$000(block).entrySet().iterator();
            ** GOTO lbl26
lbl-1000:
            // 2 sources

            {
                this.withVendorCodeMap = this.ckmGenericToVendorMap.isEmpty() == false || this.ckkGenericToVendorMap.isEmpty() == false;
                return;
lbl26:
                // 1 sources

                block12: while (true) {
                    if (var10_13.hasNext()) ** break;
                    continue block11;
                    entry = var10_13.next();
                    name = ((String)entry.getKey()).toUpperCase(Locale.ROOT);
                    valueStr = ((String)entry.getValue()).toUpperCase(Locale.ROOT);
                    hex = valueStr.startsWith("0X");
                    v0 = vendorCode = hex != false ? Long.parseLong(valueStr.substring(2), 16) : Long.parseLong(valueStr);
                    if (name.startsWith("CKK_VENDOR_")) {
                        genericCode = PKCS11Constants.ckkNameToCode(name);
                        if (genericCode == null) {
                            throw new IllegalStateException("unknown name in vendorcode block: " + name);
                        }
                        this.ckkGenericToVendorMap.put(genericCode, vendorCode);
                    } else {
                        if (!name.startsWith("CKM_VENDOR_")) {
                            throw new IllegalStateException("Unknown name in vendorcode block: " + name);
                        }
                        genericCode = PKCS11Constants.ckmNameToCode(name);
                        if (genericCode == null) {
                            throw new IllegalStateException("unknown name in vendorcode block: " + name);
                        }
                        this.ckmGenericToVendorMap.put(genericCode, vendorCode);
                    }
                    for (Map.Entry<Long, Long> m : this.ckkGenericToVendorMap.entrySet()) {
                        this.ckkVendorToGenericMap.put(m.getValue(), m.getKey());
                    }
                    var17_19 = this.ckmGenericToVendorMap.entrySet().iterator();
                    while (true) {
                        if (!var17_19.hasNext()) continue block12;
                        m = var17_19.next();
                        this.ckmVendorToGenericMap.put(m.getValue(), m.getKey());
                    }
                    break;
                }
lbl59:
                // 1 sources

                ** finally { 
lbl60:
                // 1 sources

                if (br != null) {
                    if (var8_9 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable var9_11) {
                            var8_9.addSuppressed(var9_11);
                        }
                    } else {
                        br.close();
                    }
                }
            }
            break;
        }
    }

    private static VendorCodeConfBlock readVendorCodeBlock(BufferedReader reader) throws IOException {
        String line;
        boolean inBlock = false;
        VendorCodeConfBlock block = null;
        while ((line = reader.readLine()) != null) {
            int idx;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            if (line.startsWith("<vendorcode>")) {
                block = new VendorCodeConfBlock();
                inBlock = true;
                continue;
            }
            if (line.startsWith("</vendorcode>")) {
                block.validate();
                return block;
            }
            if (!inBlock) continue;
            if (line.startsWith("module.")) {
                String value;
                idx = line.indexOf(32);
                if (idx == -1 || (value = line.substring(idx + 1).trim()).isEmpty()) continue;
                String name = line.substring(0, idx).trim();
                List<String> textList = Arrays.asList(value.toLowerCase(Locale.ROOT).split(":"));
                if (name.equalsIgnoreCase("module.path")) {
                    block.modulePaths = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.mid")) {
                    block.manufacturerIDs = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.description")) {
                    block.descriptions = textList;
                    continue;
                }
                if (!name.equalsIgnoreCase("module.version")) continue;
                block.versions = textList;
                continue;
            }
            if (!line.startsWith("CKK_") && !line.startsWith("CKM_") || (idx = line.indexOf(32)) == -1) continue;
            block.nameToCodeMap.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
        }
        return block;
    }

    private static final class VendorCodeConfBlock {
        private List<String> modulePaths;
        private List<String> manufacturerIDs;
        private List<String> descriptions;
        private List<String> versions;
        private final Map<String, String> nameToCodeMap = new HashMap<String, String>();

        private VendorCodeConfBlock() {
        }

        void validate() throws IOException {
            if (VendorCodeConfBlock.isEmpty(this.modulePaths) && VendorCodeConfBlock.isEmpty(this.manufacturerIDs) && VendorCodeConfBlock.isEmpty(this.descriptions)) {
                throw new IOException("invalid <vendorcode>-block");
            }
        }

        boolean matches(String modulePath, String manufacturerID, String libraryDescription, Version libraryVersion) {
            if (!VendorCodeConfBlock.isEmpty(this.modulePaths) && !VendorCodeConfBlock.contains(this.modulePaths, Paths.get(modulePath, new String[0]).getFileName().toString()) || !VendorCodeConfBlock.isEmpty(this.manufacturerIDs) && !VendorCodeConfBlock.contains(this.manufacturerIDs, manufacturerID) || !VendorCodeConfBlock.isEmpty(this.descriptions) && !VendorCodeConfBlock.contains(this.descriptions, libraryDescription)) {
                return false;
            }
            if (VendorCodeConfBlock.isEmpty(this.versions)) {
                return true;
            }
            int iVersion = ((0xFF & libraryVersion.getMajor()) << 8) + (0xFF & libraryVersion.getMinor());
            boolean match = false;
            for (String t : this.versions) {
                int to;
                int idx = t.indexOf("-");
                int from = idx == -1 ? VendorCodeConfBlock.toIntVersion(t) : VendorCodeConfBlock.toIntVersion(t.substring(0, idx));
                int n = to = idx == -1 ? from : VendorCodeConfBlock.toIntVersion(t.substring(idx + 1));
                if (iVersion < from || iVersion > to) continue;
                match = true;
                break;
            }
            return match;
        }

        private static int toIntVersion(String version) {
            StringTokenizer st = new StringTokenizer(version, ".");
            return (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        }

        private static boolean isEmpty(Collection<?> c) {
            return c == null || c.isEmpty();
        }

        private static boolean contains(List<String> list, String str) {
            str = str.toLowerCase(Locale.ROOT);
            for (String s : list) {
                if (!str.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

