/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.attrs;

import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.attrs.AttributeArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.BooleanAttribute;
import org.xipki.pkcs11.wrapper.attrs.ByteArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.CharArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.DateAttribute;
import org.xipki.pkcs11.wrapper.attrs.LongAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismAttribute;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public abstract class Attribute {
    private static final Map<Long, AttrType> attributeTypes = new HashMap<Long, AttrType>(130);
    protected boolean present = false;
    protected boolean sensitive = false;
    protected CK_ATTRIBUTE ckAttribute = new CK_ATTRIBUTE();

    public abstract Object getValue();

    protected Attribute(long type) {
        this.ckAttribute.type = type;
    }

    public static Attribute getInstance(long type) {
        Attribute attr = Attribute.getInstance0(type);
        if (attr == null) {
            throw new IllegalArgumentException("Unknown attribute type " + PKCS11Constants.ckaCodeToName(type));
        }
        return attr;
    }

    static Attribute getInstance0(long type) {
        AttrType attrType = attributeTypes.get(type);
        return attrType == AttrType.BOOLEAN ? new BooleanAttribute(type) : (attrType == AttrType.BYTEARRAY ? new ByteArrayAttribute(type) : (attrType == AttrType.CHARARRAY ? new CharArrayAttribute(type) : (attrType == AttrType.DATE ? new DateAttribute(type) : (attrType == AttrType.LONG ? new LongAttribute(type) : (attrType == AttrType.MECHANISM ? new MechanismAttribute(type) : (attrType == AttrType.MECHANISMARRAY ? new MechanismArrayAttribute(type) : (attrType == AttrType.ATTRIBUTEARRAY ? new AttributeArrayAttribute(type) : null)))))));
    }

    public static Attribute getInstance(long type, Object value) {
        AttrType attrType = attributeTypes.get(type);
        if (attrType == AttrType.BOOLEAN) {
            return new BooleanAttribute(type).booleanValue((Boolean)value);
        }
        if (attrType == AttrType.BYTEARRAY) {
            return value == null || value instanceof byte[] ? new ByteArrayAttribute(type).byteArrayValue((byte[])value) : new ByteArrayAttribute(type).bigIntValue((BigInteger)value);
        }
        if (attrType == AttrType.CHARARRAY) {
            return value == null || value instanceof char[] ? new CharArrayAttribute(type).charArrayValue((char[])value) : new CharArrayAttribute(type).stringValue((String)value);
        }
        if (attrType == AttrType.DATE) {
            return new DateAttribute(type).dateValue((Date)value);
        }
        if (attrType == AttrType.LONG || attrType == AttrType.MECHANISM) {
            LongAttribute attr = attrType == AttrType.LONG ? new LongAttribute(type) : new MechanismAttribute(type);
            return value == null || value instanceof Long ? attr.longValue((Long)value) : attr.longValue((long)((Integer)value));
        }
        if (attrType == AttrType.MECHANISMARRAY) {
            return new MechanismArrayAttribute(type).mechanismAttributeArrayValue((long[])value);
        }
        if (attrType == AttrType.ATTRIBUTEARRAY) {
            return new AttributeArrayAttribute(type).attributeArrayValue((AttributeVector)value);
        }
        throw new IllegalStateException("unknown attribute type " + PKCS11Constants.ckaCodeToName(type));
    }

    public Attribute present(boolean present) {
        this.present = present;
        return this;
    }

    public Attribute sensitive(boolean sensitive) {
        this.sensitive = sensitive;
        return this;
    }

    public Attribute ckAttribute(CK_ATTRIBUTE ckAttribute) {
        this.ckAttribute = Functions.requireNonNull("ckAttribute", ckAttribute);
        return this;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public CK_ATTRIBUTE getCkAttribute() {
        return this.ckAttribute;
    }

    public long type() {
        return this.ckAttribute.type;
    }

    protected String getValueString() {
        if (this.ckAttribute == null || this.ckAttribute.pValue == null) {
            return "<NULL_PTR>";
        }
        long type = this.ckAttribute.type;
        Object value = this.ckAttribute.pValue;
        return type == 0L ? PKCS11Constants.ckoCodeToName((Long)value) : (type == 256L ? PKCS11Constants.ckkCodeToName((Long)value) : (type == 128L ? PKCS11Constants.codeToName(PKCS11Constants.Category.CKC, (Long)value) : (type == 768L ? PKCS11Constants.codeToName(PKCS11Constants.Category.CKH, (Long)value) : value.toString())));
    }

    public String toString() {
        return this.toString(true, "");
    }

    public String toString(boolean withName, String indent) {
        StringBuilder sb = new StringBuilder(32).append(indent);
        if (withName) {
            sb.append(PKCS11Constants.ckaCodeToName(this.ckAttribute.type)).append(": ");
        }
        String valueString = this.present ? (this.sensitive ? "<Value is sensitive>" : this.getValueString()) : "<Attribute not present>";
        return sb.append(valueString).toString();
    }

    public long getType() {
        return this.ckAttribute.type;
    }

    protected boolean isNullValue() {
        return this.ckAttribute == null || this.ckAttribute.pValue == null;
    }

    static {
        String propFile = "org/xipki/pkcs11/wrapper/type-CKA.properties";
        Properties props = new Properties();
        try {
            props.load(Functions.class.getClassLoader().getResourceAsStream(propFile));
            for (String name : props.stringPropertyNames()) {
                name = name.trim();
                String type = props.getProperty(name).trim();
                Long code = PKCS11Constants.ckaNameToCode(name);
                if (code == null) {
                    throw new IllegalStateException("unknown CKA: " + name);
                }
                if (attributeTypes.containsKey(code)) {
                    throw new IllegalStateException("duplicated definition of CKA: " + name);
                }
                AttrType attrType = AttrType.valueOf(type.toUpperCase(Locale.ROOT));
                attributeTypes.put(code, attrType);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("error reading properties file " + propFile + ": " + t.getMessage());
        }
        if (attributeTypes.isEmpty()) {
            throw new IllegalStateException("no code to name map is defined properties file " + propFile);
        }
    }

    private static enum AttrType {
        ATTRIBUTEARRAY,
        BOOLEAN,
        BYTEARRAY,
        CHARARRAY,
        DATE,
        LONG,
        MECHANISM,
        MECHANISMARRAY;

    }
}

