/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.attrs;

import java.util.Date;
import java.util.GregorianCalendar;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import sun.security.pkcs11.wrapper.CK_DATE;

public class DateAttribute
extends Attribute {
    public DateAttribute(long type) {
        super(type);
    }

    public DateAttribute dateValue(Date value) {
        if (value == null) {
            this.ckAttribute.pValue = null;
        } else {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(value);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            this.ckAttribute.pValue = new CK_DATE(Integer.toString(year).toCharArray(), (month < 10 ? "0" + month : Integer.toString(month)).toCharArray(), (day < 10 ? "0" + day : Integer.toString(day)).toCharArray());
        }
        this.present = true;
        return this;
    }

    @Override
    public Date getValue() {
        if (this.isNullValue()) {
            return null;
        }
        CK_DATE ckDate = (CK_DATE)this.ckAttribute.pValue;
        int year = Integer.parseInt(new String(ckDate.year));
        int month = Integer.parseInt(new String(ckDate.month));
        int day = Integer.parseInt(new String(ckDate.day));
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }
}

