/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class ECDH1_DERIVE_PARAMS
extends CkParams {
    private final CK_ECDH1_DERIVE_PARAMS params;

    public ECDH1_DERIVE_PARAMS(long kdf, byte[] sharedData, byte[] publicData) {
        ECDH1_DERIVE_PARAMS.requireNonNull("publicData", publicData);
        Functions.requireAmong("kdf", kdf, 1L, 2L, 3L, 4L);
        this.params = new CK_ECDH1_DERIVE_PARAMS(kdf, sharedData, publicData);
    }

    @Override
    public CK_ECDH1_DERIVE_PARAMS getParams() {
        return this.params;
    }

    @Override
    public CK_MECHANISM toCkMechanism(long mechanism) {
        return new CK_MECHANISM(mechanism, this.params);
    }

    public String toString() {
        return "CK_ECDH1_DERIVE_PARAMS:\n  KDF:         " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKD, this.params.kdf) + ECDH1_DERIVE_PARAMS.ptrToString("\n  Public Data: ", this.params.pPublicData) + ECDH1_DERIVE_PARAMS.ptrToString("\n  Shared Data: ", this.params.pSharedData);
    }
}

