/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import java.lang.reflect.Constructor;
import org.xipki.pkcs11.wrapper.Util;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class GCM_PARAMS
extends CkParams {
    private static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_GCM_PARAMS";
    private static final Constructor<?> constructor = Util.getConstructor("sun.security.pkcs11.wrapper.CK_GCM_PARAMS", Integer.TYPE, byte[].class, byte[].class);
    private static final Constructor<?> constructor_CK_MECHANISM = Util.getConstructorOfCK_MECHANISM("sun.security.pkcs11.wrapper.CK_GCM_PARAMS");
    private final Object params;
    private final byte[] iv;
    private final byte[] aad;
    private final int tagBits;

    public GCM_PARAMS(byte[] iv, byte[] aad, int tagBits) {
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_GCM_PARAMS is not available in the JDK");
        }
        this.iv = iv;
        this.aad = aad;
        this.tagBits = tagBits;
        try {
            this.params = constructor.newInstance(tagBits, iv, aad);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_GCM_PARAMS", ex);
        }
    }

    @Override
    public Object getParams() {
        return this.params;
    }

    @Override
    public CK_MECHANISM toCkMechanism(long mechanism) {
        return this.buildCkMechanism(constructor_CK_MECHANISM, mechanism);
    }

    public String toString() {
        return "CK_GCM_PARAMS:" + GCM_PARAMS.ptrToString("\n  pIv:       ", this.iv) + GCM_PARAMS.ptrToString("\n  pAAD:      ", this.aad) + "\n  ulTagBits: " + this.tagBits;
    }
}

