/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.Version;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.PKCS11;

public class PKCS11Module {
    static final int BEHAVIOUR_ECDSA_SIGNATURE_X962 = 1;
    static final int BEHAVIOUR_SM2_SIGNATURE_X962 = 2;
    static final int BEHAVIOUR_EC_PRIVATEKEY_ECPOINT = 3;
    static final int BEHAVIOUR_SM2_PRIVATEKEY_ECPOINT = 4;
    private PKCS11 pkcs11;
    private final String pkcs11ModulePath;
    private Boolean ecPointFixNeeded;
    private Boolean ecdsaSignatureFixNeeded;
    private Boolean sm2SignatureFixNeeded;
    private boolean withVendorCodeMap;
    private final Map<Long, Long> ckkGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckkVendorToGenericMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmGenericToVendorMap = new HashMap<Long, Long>();
    private final Map<Long, Long> ckmVendorToGenericMap = new HashMap<Long, Long>();
    private final Set<Integer> vendorBehaviours = new HashSet<Integer>();

    protected PKCS11Module(String pkcs11ModulePath) {
        this.pkcs11ModulePath = Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath);
    }

    public static PKCS11Module getInstance(String pkcs11ModulePath) throws IOException {
        Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath);
        File file = new File(pkcs11ModulePath);
        if (!file.exists()) {
            throw new IOException("File " + pkcs11ModulePath + " does not exist");
        }
        if (!file.isFile()) {
            throw new IOException(pkcs11ModulePath + " is not a file");
        }
        if (!file.canRead()) {
            throw new IOException("Can not read file " + pkcs11ModulePath + "");
        }
        return new PKCS11Module(pkcs11ModulePath);
    }

    Boolean getEcPointFixNeeded() {
        return this.ecPointFixNeeded;
    }

    void setEcPointFixNeeded(Boolean ecPointFixNeeded) {
        this.ecPointFixNeeded = ecPointFixNeeded;
    }

    Boolean getEcdsaSignatureFixNeeded() {
        return this.ecdsaSignatureFixNeeded;
    }

    void setEcdsaSignatureFixNeeded(Boolean ecdsaSignatureFixNeeded) {
        this.ecdsaSignatureFixNeeded = ecdsaSignatureFixNeeded;
    }

    Boolean getSm2SignatureFixNeeded() {
        return this.sm2SignatureFixNeeded;
    }

    void setSm2SignatureFixNeeded(Boolean sm2SignatureFixNeeded) {
        this.sm2SignatureFixNeeded = sm2SignatureFixNeeded;
    }

    public ModuleInfo getInfo() throws PKCS11Exception {
        this.assertInitialized();
        try {
            return new ModuleInfo(this.pkcs11.C_GetInfo());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void initialize() throws TokenException {
        CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
        wrapperInitArgs.flags |= 2L;
        String functionList = "C_GetFunctionList";
        boolean omitInitialize = false;
        try {
            this.pkcs11 = PKCS11.getInstance(this.pkcs11ModulePath, "C_GetFunctionList", wrapperInitArgs, false);
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        catch (NoSuchMethodError ex) {
            try {
                Method getInstanceMethod = PKCS11.class.getMethod("getInstance", String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE, MethodHandle.class);
                this.pkcs11 = (PKCS11)getInstanceMethod.invoke(null, this.pkcs11ModulePath, "C_GetFunctionList", wrapperInitArgs, false, null);
            }
            catch (Exception ex1) {
                throw new TokenException(ex1.getMessage(), ex1);
            }
        }
        this.initVendor();
    }

    public Slot[] getSlotList(boolean tokenPresent) throws PKCS11Exception {
        long[] slotIDs;
        this.assertInitialized();
        try {
            slotIDs = this.pkcs11.C_GetSlotList(tokenPresent);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        Slot[] slots = new Slot[slotIDs.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = new Slot(this, slotIDs[i]);
        }
        return slots;
    }

    public PKCS11 getPKCS11() {
        this.assertInitialized();
        return this.pkcs11;
    }

    boolean hasVendorBehaviour(int vendorBehavior) {
        return this.vendorBehaviours.contains(vendorBehavior);
    }

    long ckkGenericToVendor(long genericCode) {
        return this.withVendorCodeMap ? this.ckkGenericToVendorMap.getOrDefault(genericCode, genericCode) : genericCode;
    }

    long ckkVendorToGeneric(long vendorCode) {
        return this.withVendorCodeMap ? this.ckkVendorToGenericMap.getOrDefault(vendorCode, vendorCode) : vendorCode;
    }

    long ckmGenericToVendor(long genericCode) {
        return this.withVendorCodeMap ? this.ckmGenericToVendorMap.getOrDefault(genericCode, genericCode) : genericCode;
    }

    long ckmVendorToGeneric(long vendorCode) {
        return this.withVendorCodeMap ? this.ckmVendorToGenericMap.getOrDefault(vendorCode, vendorCode) : vendorCode;
    }

    public String toString() {
        return this.pkcs11 != null ? this.pkcs11.toString() : "null";
    }

    public void finalize(Object args) throws PKCS11Exception {
        try {
            this.pkcs11.C_Finalize(args);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    private void assertInitialized() {
        if (this.pkcs11 == null) {
            throw new IllegalStateException("Module not initialized yet, please call initialize() first");
        }
    }

    /*
     * Exception decompiling
     */
    private void initVendor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static VendorBlock readVendorBlock(BufferedReader reader) throws IOException {
        String line;
        boolean inBlock = false;
        VendorBlock block = null;
        while ((line = reader.readLine()) != null) {
            String value;
            int idx;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            if (line.startsWith("<vendor>")) {
                block = new VendorBlock();
                inBlock = true;
                continue;
            }
            if (line.startsWith("</vendor>")) {
                block.validate();
                return block;
            }
            if (!inBlock) continue;
            if (line.startsWith("module.")) {
                idx = line.indexOf(32);
                if (idx == -1 || (value = line.substring(idx + 1).trim()).isEmpty()) continue;
                String name = line.substring(0, idx).trim();
                List<String> textList = Arrays.asList(value.toLowerCase(Locale.ROOT).split(":"));
                if (name.equalsIgnoreCase("module.path")) {
                    block.modulePaths = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.mid")) {
                    block.manufacturerIDs = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.description")) {
                    block.descriptions = textList;
                    continue;
                }
                if (!name.equalsIgnoreCase("module.version")) continue;
                block.versions = textList;
                continue;
            }
            if (line.startsWith("CKK_") || line.startsWith("CKM_")) {
                idx = line.indexOf(32);
                if (idx == -1) continue;
                block.nameToCodeMap.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
                continue;
            }
            if (!line.startsWith("VENDOR_BEHAVIORS ") || (value = line.substring((idx = line.indexOf(32)) + 1).trim()).isEmpty()) continue;
            block.vendoBehaviours = value;
        }
        return block;
    }

    private static final class VendorBlock {
        private List<String> modulePaths;
        private List<String> manufacturerIDs;
        private List<String> descriptions;
        private List<String> versions;
        private String vendoBehaviours;
        private final Map<String, String> nameToCodeMap = new HashMap<String, String>();

        private VendorBlock() {
        }

        void validate() throws IOException {
            if (VendorBlock.isEmpty(this.modulePaths) && VendorBlock.isEmpty(this.manufacturerIDs) && VendorBlock.isEmpty(this.descriptions)) {
                throw new IOException("invalid <vendor>-block");
            }
        }

        boolean matches(String modulePath, String manufacturerID, String libraryDescription, Version libraryVersion) {
            if (!VendorBlock.isEmpty(this.modulePaths) && !VendorBlock.contains(this.modulePaths, Paths.get(modulePath, new String[0]).getFileName().toString()) || !VendorBlock.isEmpty(this.manufacturerIDs) && !VendorBlock.contains(this.manufacturerIDs, manufacturerID) || !VendorBlock.isEmpty(this.descriptions) && !VendorBlock.contains(this.descriptions, libraryDescription)) {
                return false;
            }
            if (VendorBlock.isEmpty(this.versions)) {
                return true;
            }
            int iVersion = ((0xFF & libraryVersion.getMajor()) << 8) + (0xFF & libraryVersion.getMinor());
            boolean match = false;
            for (String t : this.versions) {
                int to;
                int idx = t.indexOf("-");
                int from = idx == -1 ? VendorBlock.toIntVersion(t) : VendorBlock.toIntVersion(t.substring(0, idx));
                int n = to = idx == -1 ? from : VendorBlock.toIntVersion(t.substring(idx + 1));
                if (iVersion < from || iVersion > to) continue;
                match = true;
                break;
            }
            return match;
        }

        private static int toIntVersion(String version) {
            StringTokenizer st = new StringTokenizer(version, ".");
            return (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        }

        private static boolean isEmpty(Collection<?> c) {
            return c == null || c.isEmpty();
        }

        private static boolean contains(List<String> list, String str) {
            str = str.toLowerCase(Locale.ROOT);
            for (String s : list) {
                if (!str.contains(s)) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ String access$000(VendorBlock x0) {
            return x0.vendoBehaviours;
        }
    }
}

