/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.Util;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import org.xipki.pkcs11.wrapper.attrs.BooleanAttribute;
import org.xipki.pkcs11.wrapper.attrs.ByteArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.CharArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.LongAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismArrayAttribute;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11;

public class Session {
    private static final int SIGN_TYPE_ECDSA = 1;
    private static final int SIGN_TYPE_SM2 = 2;
    private static final Method encrypt0;
    private static final Method encrypt1;
    private static final Method decrypt0;
    private static final Method decrypt1;
    private final PKCS11Module module;
    private final PKCS11 pkcs11;
    private long sessionHandle;
    private final Token token;
    private int signatureType;
    private long signKeyHandle;
    private final LruCache<Long, byte[]> handleEcParamsMap = new LruCache(1000);

    protected Session(Token token, long sessionHandle) {
        this.token = Functions.requireNonNull("token", token);
        this.module = token.getSlot().getModule();
        this.pkcs11 = this.module.getPKCS11();
        this.sessionHandle = sessionHandle;
    }

    public void closeSession() throws PKCS11Exception {
        this.handleEcParamsMap.evictAll();
        try {
            this.pkcs11.C_CloseSession(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public SessionInfo getSessionInfo() throws PKCS11Exception {
        try {
            return new SessionInfo(this.pkcs11.C_GetSessionInfo(this.sessionHandle));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public PKCS11Module getModule() {
        return this.module;
    }

    public Token getToken() {
        return this.token;
    }

    public byte[] getOperationState() throws PKCS11Exception {
        try {
            return this.pkcs11.C_GetOperationState(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void setOperationState(byte[] operationState, long encryptionKeyHandle, long authenticationKeyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_SetOperationState(this.sessionHandle, operationState, encryptionKeyHandle, authenticationKeyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void setSessionHandle(long sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public void login(long userType, char[] pin) throws PKCS11Exception {
        try {
            this.pkcs11.C_Login(this.sessionHandle, userType, pin);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void logout() throws PKCS11Exception {
        try {
            this.pkcs11.C_Logout(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long createObject(AttributeVector template) throws PKCS11Exception {
        try {
            return this.pkcs11.C_CreateObject(this.sessionHandle, this.toOutCKAttributes(template));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws PKCS11Exception {
        if (publicKey instanceof ECPublicKey && this.privateKeyWithEcPoint(template.keyType())) {
            byte[] ecParams = template.ecParams();
            Integer fieldSize = Functions.getECFieldSize(ecParams);
            ECPoint w = ((ECPublicKey)publicKey).getW();
            byte[] wx = Functions.asUnsignedByteArray(w.getAffineX());
            byte[] wy = Functions.asUnsignedByteArray(w.getAffineY());
            if (fieldSize == null) {
                fieldSize = Math.max(wx.length, wy.length);
            } else if (wx.length > fieldSize || wy.length > fieldSize) {
                throw new IllegalStateException("should not happen, public key and ecParams do not match");
            }
            byte[] ecPoint = new byte[1 + 2 * fieldSize];
            ecPoint[0] = 4;
            System.arraycopy(wx, 0, ecPoint, 1 + fieldSize - wx.length, wx.length);
            System.arraycopy(wy, 0, ecPoint, ecPoint.length - wy.length, wy.length);
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws PKCS11Exception {
        if (ecPoint != null && this.privateKeyWithEcPoint(template.keyType())) {
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    private boolean privateKeyWithEcPoint(Long keyType) {
        if (keyType == null) {
            return false;
        }
        if (3L == keyType) {
            return this.module.hasVendorBehaviour(3);
        }
        if (0xFFFFF001L == keyType) {
            return this.module.hasVendorBehaviour(4);
        }
        return false;
    }

    public long copyObject(long sourceObjectHandle, AttributeVector template) throws PKCS11Exception {
        try {
            return this.pkcs11.C_CopyObject(this.sessionHandle, sourceObjectHandle, this.toOutCKAttributes(template));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws PKCS11Exception {
        try {
            this.pkcs11.C_SetAttributeValue(this.sessionHandle, objectToUpdateHandle, this.toOutCKAttributes(template));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void destroyObject(long objectHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_DestroyObject(this.sessionHandle, objectHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void findObjectsInit(AttributeVector template) throws PKCS11Exception {
        try {
            this.pkcs11.C_FindObjectsInit(this.sessionHandle, template == null ? null : this.toOutCKAttributes(template, true));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long[] findObjects(int maxObjectCount) throws PKCS11Exception {
        try {
            long[] handles = this.pkcs11.C_FindObjects(this.sessionHandle, maxObjectCount);
            return handles == null ? new long[]{} : handles;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void findObjectsFinal() throws PKCS11Exception {
        try {
            this.pkcs11.C_FindObjectsFinal(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void encryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_EncryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int encrypt(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.encrypt(in, 0, in.length, out, outOfs, outLen);
    }

    public int encrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            if (encrypt0 != null) {
                return (Integer)encrypt0.invoke((Object)this.pkcs11, this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
            }
            if (encrypt1 != null) {
                return (Integer)encrypt1.invoke((Object)this.pkcs11, this.sessionHandle, 0, in, inOfs, inLen, 0, out, outOfs, outLen);
            }
            throw new IllegalStateException("could not find C_ENCRYPT method");
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof sun.security.pkcs11.wrapper.PKCS11Exception) {
                throw new PKCS11Exception(((sun.security.pkcs11.wrapper.PKCS11Exception)cause).getErrorCode());
            }
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public int encryptUpdate(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.encryptUpdate(in, 0, in.length, out, outOfs, outLen);
    }

    public int encryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            return this.pkcs11.C_EncryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int encryptFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkOutParams(out, outOfs, outLen);
        try {
            return this.pkcs11.C_EncryptFinal(this.sessionHandle, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void decryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_DecryptInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int decrypt(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.decrypt(in, 0, in.length, out, outOfs, outLen);
    }

    public int decrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            if (decrypt0 != null) {
                return (Integer)decrypt0.invoke((Object)this.pkcs11, this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
            }
            if (decrypt1 != null) {
                return (Integer)decrypt1.invoke((Object)this.pkcs11, this.sessionHandle, 0, in, inOfs, inLen, 0, out, outOfs, outLen);
            }
            throw new IllegalStateException("could not find C_DECRYPT method");
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof sun.security.pkcs11.wrapper.PKCS11Exception) {
                throw new PKCS11Exception(((sun.security.pkcs11.wrapper.PKCS11Exception)cause).getErrorCode());
            }
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public int decryptUpdate(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.decryptUpdate(in, 0, in.length, out, outOfs, outLen);
    }

    public int decryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            return this.pkcs11.C_DecryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int decryptFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkOutParams(out, outOfs, outLen);
        try {
            return this.pkcs11.C_DecryptFinal(this.sessionHandle, 0L, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void digestInit(Mechanism mechanism) throws PKCS11Exception {
        try {
            this.pkcs11.C_DigestInit(this.sessionHandle, this.toCkMechanism(mechanism));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int digestFinal(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.digestFinal(in, 0, in.length, out, outOfs, outLen);
    }

    public int digestFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        this.digestUpdate(in, inOfs, inLen);
        return this.digestFinal(out, outOfs, outLen);
    }

    public int digest(Mechanism mechanism, byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.digest(mechanism, in, 0, in.length, out, outOfs, outLen);
    }

    public int digest(Mechanism mechanism, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            return this.pkcs11.C_DigestSingle(this.sessionHandle, this.toCkMechanism(mechanism), in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void digestUpdate(byte[] in) throws PKCS11Exception {
        this.digestUpdate(in, 0, in.length);
    }

    public void digestUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        Session.checkInParams(in, inOfs, inLen);
        try {
            this.pkcs11.C_DigestUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void digestKey(long keyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_DigestKey(this.sessionHandle, keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int digestFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkOutParams(out, outOfs, outLen);
        try {
            return this.pkcs11.C_DigestFinal(this.sessionHandle, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    private void initSignVerify(Mechanism mechanism, long keyHandle) {
        this.signKeyHandle = keyHandle;
        long code = mechanism.getMechanismCode();
        this.signatureType = code == 4161L || code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L ? 1 : (code == 0xFFFFF002L || code == 0xFFFFF003L ? 2 : 0);
    }

    public void signInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        try {
            this.initSignVerify(mechanism, keyHandle);
            this.pkcs11.C_SignInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public byte[] sign(byte[] data) throws PKCS11Exception {
        Functions.requireNonNull("data", data);
        try {
            byte[] sigValue = this.pkcs11.C_Sign(this.sessionHandle, data);
            return this.fixSignOutput(sigValue);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void signUpdate(byte[] in) throws PKCS11Exception {
        this.signUpdate(in, 0, in.length);
    }

    public void signUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        Session.checkInParams(in, inOfs, inLen);
        try {
            this.pkcs11.C_SignUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public byte[] signFinal() throws PKCS11Exception {
        try {
            byte[] sigValue = this.pkcs11.C_SignFinal(this.sessionHandle, 0);
            return this.fixSignOutput(sigValue);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fixSignOutput(byte[] signatureValue) {
        if (this.signatureType == 0) {
            return signatureValue;
        }
        PKCS11Module pKCS11Module = this.module;
        synchronized (pKCS11Module) {
            Boolean b;
            if (this.signatureType == 1) {
                Boolean b2 = this.module.getEcdsaSignatureFixNeeded();
                if (b2 == null || b2.booleanValue()) {
                    byte[] ecParams = this.handleEcParamsMap.get(this.signKeyHandle);
                    if (ecParams == null) {
                        try {
                            ecParams = this.getByteArrayAttrValue(this.signKeyHandle, 384L);
                        }
                        catch (PKCS11Exception e) {
                            return signatureValue;
                        }
                        if (ecParams != null) {
                            this.handleEcParamsMap.put(this.signKeyHandle, ecParams);
                        }
                    }
                    if (ecParams != null) {
                        boolean fixed;
                        byte[] fixedSigValue = Functions.fixECDSASignature(signatureValue, ecParams);
                        boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                        if (b2 == null) {
                            this.module.setEcdsaSignatureFixNeeded(fixed);
                        }
                        return fixedSigValue;
                    }
                }
            } else if (this.signatureType == 2 && ((b = this.module.getSm2SignatureFixNeeded()) == null || b.booleanValue())) {
                boolean fixed;
                byte[] fixedSigValue = Functions.fixECDSASignature(signatureValue, 32);
                boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                if (b == null) {
                    this.module.setSm2SignatureFixNeeded(fixed);
                }
                return fixedSigValue;
            }
            return signatureValue;
        }
    }

    private byte[] fixSignatureToVerify(byte[] signatureValue) {
        if (this.signatureType == 1 ? this.module.hasVendorBehaviour(1) : this.signatureType == 2 && this.module.hasVendorBehaviour(2)) {
            return Functions.toX962DSASignature(signatureValue);
        }
        return signatureValue;
    }

    public void signRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_SignRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int signRecover(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.signRecover(in, 0, in.length, out, outOfs, outLen);
    }

    public int signRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            return this.pkcs11.C_SignRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void verifyInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        try {
            this.initSignVerify(mechanism, keyHandle);
            this.pkcs11.C_VerifyInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void verify(byte[] data, byte[] signature) throws PKCS11Exception {
        Functions.requireNonNull("signature", signature);
        try {
            this.pkcs11.C_Verify(this.sessionHandle, data, this.fixSignatureToVerify(signature));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void verifyUpdate(byte[] in) throws PKCS11Exception {
        this.verifyUpdate(in, 0, in.length);
    }

    public void verifyUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        Session.checkInParams(in, inOfs, inLen);
        try {
            this.pkcs11.C_VerifyUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void verifyFinal(byte[] signature) throws PKCS11Exception {
        Functions.requireNonNull("signature", signature);
        try {
            this.pkcs11.C_VerifyFinal(this.sessionHandle, this.fixSignatureToVerify(signature));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void verifyRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_VerifyRecoverInit(this.sessionHandle, this.toCkMechanism(mechanism), keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public int verifyRecover(byte[] in, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.verifyRecover(in, 0, in.length, out, outOfs, outLen);
    }

    public int verifyRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        try {
            return this.pkcs11.C_VerifyRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long generateKey(Mechanism mechanism, AttributeVector template) throws PKCS11Exception {
        try {
            return this.pkcs11.C_GenerateKey(this.sessionHandle, this.toCkMechanism(mechanism), this.toOutCKAttributes(template));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws PKCS11Exception {
        long[] objectHandles;
        try {
            template.id();
            objectHandles = this.pkcs11.C_GenerateKeyPair(this.sessionHandle, this.toCkMechanism(mechanism), this.toOutCKAttributes(template.publicKey()), this.toOutCKAttributes(template.privateKey()));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        return new PKCS11KeyPair(objectHandles[0], objectHandles[1]);
    }

    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws PKCS11Exception {
        try {
            return this.pkcs11.C_WrapKey(this.sessionHandle, this.toCkMechanism(mechanism), wrappingKeyHandle, keyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws PKCS11Exception {
        Functions.requireNonNull("wrappedKey", wrappedKey);
        try {
            return this.pkcs11.C_UnwrapKey(this.sessionHandle, this.toCkMechanism(mechanism), unwrappingKeyHandle, wrappedKey, this.toOutCKAttributes(keyTemplate));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws PKCS11Exception {
        CK_MECHANISM ckMechanism = this.toCkMechanism(mechanism);
        try {
            return this.pkcs11.C_DeriveKey(this.sessionHandle, ckMechanism, baseKeyHandle, this.toOutCKAttributes(template));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public void seedRandom(byte[] seed) throws PKCS11Exception {
        try {
            this.pkcs11.C_SeedRandom(this.sessionHandle, seed);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws PKCS11Exception {
        byte[] randomBytesBuffer = new byte[numberOfBytesToGenerate];
        try {
            this.pkcs11.C_GenerateRandom(this.sessionHandle, randomBytesBuffer);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        return randomBytesBuffer;
    }

    public String toString() {
        return "Session Handle: 0x" + Long.toHexString(this.sessionHandle) + "\nToken: " + this.token;
    }

    private CK_MECHANISM toCkMechanism(Mechanism mechanism) {
        CK_MECHANISM ckMechanism = mechanism.toCkMechanism();
        long code = mechanism.getMechanismCode();
        if ((code & 0x80000000L) != 0L) {
            ckMechanism.mechanism = this.module.ckmGenericToVendor(code);
        }
        return ckMechanism;
    }

    public Integer getIntAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        Long value = this.getLongAttrValue(objectHandle, attributeType);
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    public Long getLongAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        LongAttribute attr = new LongAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public String getStringAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        CharArrayAttribute attr = new CharArrayAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public BigInteger getBigIntAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        byte[] value = this.getByteArrayAttrValue(objectHandle, attributeType);
        return value == null ? null : new BigInteger(1, value);
    }

    public byte[] getByteArrayAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        ByteArrayAttribute attr = new ByteArrayAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public Boolean getBooleanAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        BooleanAttribute attr = new BooleanAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public String getCkaLabel(long objectHandle) throws PKCS11Exception {
        return this.getStringAttrValue(objectHandle, 3L);
    }

    public byte[] getCkaId(long objectHandle) throws PKCS11Exception {
        return this.getByteArrayAttrValue(objectHandle, 258L);
    }

    public Long getCkaClass(long objectHandle) throws PKCS11Exception {
        return this.getLongAttrValue(objectHandle, 0L);
    }

    public Long getCkaKeyType(long objectHandle) throws PKCS11Exception {
        return this.getLongAttrValue(objectHandle, 256L);
    }

    public Long getCkaCertificateType(long objectHandle) throws PKCS11Exception {
        return this.getLongAttrValue(objectHandle, 128L);
    }

    public Object getAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        Attribute attr = Attribute.getInstance(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws PKCS11Exception {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        if (typeList.contains(385L) && !typeList.contains(384L)) {
            typeList.add(384L);
        }
        Attribute[] attrs = new Attribute[typeList.size()];
        int index = 0;
        long[] firstTypes = new long[]{0L, 256L, 384L, 385L};
        for (long type : firstTypes) {
            if (!typeList.remove(type)) continue;
            attrs[index++] = Attribute.getInstance(type);
        }
        Object object = typeList.iterator();
        while (object.hasNext()) {
            long type = (Long)object.next();
            attrs[index++] = Attribute.getInstance(type);
        }
        this.doGetAttrValues(objectHandle, attrs);
        return new AttributeVector(attrs);
    }

    private void doGetAttrValues(long objectHandle, Attribute ... attributes) throws PKCS11Exception {
        Functions.requireNonNull("attributes", attributes);
        if (attributes.length == 1) {
            this.doGetAttrValue(objectHandle, attributes[0]);
            return;
        }
        CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributeTemplateList[i] = new CK_ATTRIBUTE();
            attributeTemplateList[i].type = attributes[i].getType();
        }
        PKCS11Exception delayedEx = null;
        try {
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            delayedEx = new PKCS11Exception(ex.getErrorCode());
        }
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            CK_ATTRIBUTE template = attributeTemplateList[i];
            if (template == null) continue;
            attribute.present(true).sensitive(false).ckAttribute(template);
        }
        if (delayedEx != null) {
            delayedEx = null;
            for (Attribute attr : attributes) {
                if (attr.getCkAttribute() != null && attr.getCkAttribute().pValue != null) continue;
                try {
                    this.doGetAttrValue0(objectHandle, attr, false);
                }
                catch (PKCS11Exception ex) {
                    if (delayedEx != null) continue;
                    delayedEx = ex;
                }
            }
        }
        for (Attribute attr : attributes) {
            this.postProcessGetAttribute(attr, objectHandle, attributes);
        }
        if (delayedEx != null) {
            throw delayedEx;
        }
    }

    private void doGetAttrValue(long objectHandle, Attribute attribute) throws PKCS11Exception {
        if (attribute.getType() == 385L) {
            this.doGetAttrValues(objectHandle, new ByteArrayAttribute(384L), attribute);
        } else {
            this.doGetAttrValue0(objectHandle, attribute, true);
        }
    }

    private void doGetAttrValue0(long objectHandle, Attribute attribute, boolean postProcess) throws PKCS11Exception {
        attribute.present(false);
        try {
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            attributeTemplateList[0].type = attribute.getType();
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList);
            attribute.ckAttribute(attributeTemplateList[0]).present(true).sensitive(false);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            long ec = ex.getErrorCode();
            if (ec == 18L) {
                if (attribute.getType() == 384L) {
                    attribute.present((boolean)false).getCkAttribute().pValue = null;
                }
            }
            if (ec == 17L) {
                attribute.getCkAttribute().pValue = null;
                attribute.present((boolean)true).sensitive((boolean)true).getCkAttribute().pValue = null;
            }
            if (ec == 7L || ec == 6L || ec == 512L) {
                attribute.present((boolean)false).sensitive((boolean)false).getCkAttribute().pValue = null;
            }
            throw new PKCS11Exception(ec);
        }
        if (postProcess) {
            this.postProcessGetAttribute(attribute, objectHandle, new Attribute[0]);
        }
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template) {
        return this.toOutCKAttributes(template, false);
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template, boolean withoutNullValueAttr) {
        if (template == null) {
            return null;
        }
        CK_ATTRIBUTE[] ckAttrs = template.toCkAttributes();
        ArrayList<CK_ATTRIBUTE> nonNullCkAttrs = null;
        if (withoutNullValueAttr) {
            nonNullCkAttrs = new ArrayList<CK_ATTRIBUTE>(ckAttrs.length);
        }
        for (CK_ATTRIBUTE ckAttr : ckAttrs) {
            if (ckAttr.pValue == null) continue;
            if (withoutNullValueAttr) {
                nonNullCkAttrs.add(ckAttr);
            }
            if (ckAttr.type == 256L) {
                long value = (Long)ckAttr.pValue;
                if ((value & 0x80000000L) == 0L) continue;
                ckAttr.pValue = this.module.ckkGenericToVendor(value);
                continue;
            }
            if (ckAttr.type != 385L) continue;
            ckAttr.pValue = Functions.toOctetString((byte[])ckAttr.pValue);
        }
        return nonNullCkAttrs != null && nonNullCkAttrs.size() != ckAttrs.length ? nonNullCkAttrs.toArray(new CK_ATTRIBUTE[0]) : ckAttrs;
    }

    private void postProcessGetAttribute(Attribute attr, long objectHandle, Attribute ... otherAttrs) {
        long type = attr.getType();
        CK_ATTRIBUTE ckAttr = attr.getCkAttribute();
        if (type == 384L) {
            if (ckAttr.pValue == null) {
                Long keyType = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.type() != 256L) continue;
                        keyType = ((LongAttribute)otherAttr).getValue();
                    }
                }
                if (keyType == null) {
                    try {
                        keyType = this.getCkaKeyType(objectHandle);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
                if (keyType != null && keyType == 0xFFFFF001L) {
                    attr.present((boolean)false).getCkAttribute().pValue = Functions.decodeHex("06082a811ccf5501822d");
                }
            } else {
                byte[] ecParams = (byte[])ckAttr.pValue;
                if (ecParams[0] != 6) {
                    ckAttr.pValue = Functions.fixECParams((byte[])ckAttr.pValue);
                }
            }
            return;
        }
        if (ckAttr == null || ckAttr.pValue == null) {
            return;
        }
        if (type == 256L) {
            long value = (Long)ckAttr.pValue;
            if ((value & 0x80000000L) != 0L && !PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.ckkVendorToGeneric(value);
            }
        } else if (type == 358L) {
            long value = (Long)ckAttr.pValue;
            if ((value & 0x80000000L) != 0L && !PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.ckmVendorToGeneric(value);
            }
        } else if (type == 0x40000600L) {
            long[] mechs;
            for (long mech : mechs = ((MechanismArrayAttribute)attr).getValue()) {
                if ((mech & 0x80000000L) == 0L) continue;
                ckAttr.pValue = this.module.ckmVendorToGeneric(mech);
            }
        } else if (type == 385L) {
            Boolean b = this.module.getEcPointFixNeeded();
            byte[] pValue = (byte[])ckAttr.pValue;
            if (b == null || b.booleanValue()) {
                byte[] ecParams = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.getType() != 384L) continue;
                        ecParams = ((ByteArrayAttribute)otherAttr).getValue();
                        break;
                    }
                }
                byte[] fixedCoreEcPoint = Functions.getCoreECPoint(pValue, ecParams);
                if (b == null) {
                    byte[] coreEcPoint = Functions.getCoreECPoint(pValue);
                    this.module.setEcPointFixNeeded(!Arrays.equals(coreEcPoint, fixedCoreEcPoint));
                }
                ckAttr.pValue = fixedCoreEcPoint;
            } else {
                ckAttr.pValue = Functions.getCoreECPoint(pValue);
            }
        } else if (attr instanceof BooleanAttribute && ckAttr.pValue instanceof byte[]) {
            byte[] value = (byte[])ckAttr.pValue;
            boolean allZeros = true;
            for (byte b : value) {
                if (b == 0) continue;
                allZeros = false;
                break;
            }
            ckAttr.pValue = !allZeros;
        }
    }

    private static void checkParams(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) {
        Session.checkInParams(in, inOfs, inLen);
        Session.checkOutParams(out, outOfs, outLen);
    }

    private static void checkInParams(byte[] in, int inOfs, int inLen) {
        Functions.requireNonNull("in", in);
        if (inOfs < 0 || inLen <= 0) {
            throw new IllegalArgumentException("inOfs or inLen is invalid");
        }
        if (in.length < inOfs + inLen) {
            throw new IllegalArgumentException("inOfs + inLen > in.length");
        }
    }

    private static void checkOutParams(byte[] out, int outOfs, int outLen) {
        Functions.requireNonNull("out", out);
        if (outOfs < 0 || outLen <= 0) {
            throw new IllegalArgumentException("outOfs or outLen is invalid");
        }
        if (out.length < outOfs + outLen) {
            throw new IllegalArgumentException("outOfs + outLen > out.length");
        }
    }

    static {
        Class<PKCS11> clazz = PKCS11.class;
        decrypt0 = Util.getMethod(clazz, "C_Decrypt", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        encrypt0 = Util.getMethod(clazz, "C_Encrypt", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        decrypt1 = decrypt0 != null ? null : Util.getMethod(clazz, "C_Decrypt", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        encrypt1 = encrypt0 != null ? null : Util.getMethod(clazz, "C_Encrypt", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
    }

    private static class LruCache<K, V> {
        private final LinkedHashMap<K, V> map;
        private int size;
        private final int maxSize;

        public LruCache(int maxSize) {
            if (maxSize < 0) {
                throw new IllegalArgumentException("maxSize is not positive: " + maxSize);
            }
            this.maxSize = maxSize;
            this.map = new LinkedHashMap(0, 0.75f, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final V get(K key) {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            LruCache lruCache = this;
            synchronized (lruCache) {
                V mapValue = this.map.get(key);
                if (mapValue != null) {
                    return mapValue;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final V put(K key, V value) {
            V previous;
            if (key == null || value == null) {
                throw new NullPointerException("key == null || value == null");
            }
            LruCache lruCache = this;
            synchronized (lruCache) {
                ++this.size;
                previous = this.map.put(key, value);
                if (previous != null) {
                    --this.size;
                }
            }
            this.trimToSize(this.maxSize);
            return previous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trimToSize(int maxSize) {
            while (true) {
                LruCache lruCache = this;
                synchronized (lruCache) {
                    if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                        throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                    }
                    if (this.size <= maxSize || this.map.isEmpty()) {
                        break;
                    }
                    Map.Entry<K, V> toEvict = this.map.entrySet().iterator().next();
                    K key = toEvict.getKey();
                    this.map.remove(key);
                    --this.size;
                }
            }
        }

        public final void evictAll() {
            this.trimToSize(-1);
        }
    }
}

