/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.TokenInfo;

public class Token {
    private final Slot slot;
    private final boolean useUtf8Encoding;

    protected Token(Slot slot) {
        this.slot = Functions.requireNonNull("slot", slot);
        this.useUtf8Encoding = slot.isUseUtf8Encoding();
    }

    public Slot getSlot() {
        return this.slot;
    }

    public boolean isUseUtf8Encoding() {
        return this.useUtf8Encoding;
    }

    public long getTokenID() {
        return this.slot.getSlotID();
    }

    public TokenInfo getTokenInfo() throws PKCS11Exception {
        try {
            return new TokenInfo(this.slot.getPKCS11().C_GetTokenInfo(this.slot.getSlotID()));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public long[] getMechanismList() throws PKCS11Exception {
        long[] mechanisms;
        try {
            mechanisms = this.slot.getPKCS11().C_GetMechanismList(this.slot.getSlotID());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        for (int i = 0; i < mechanisms.length; ++i) {
            long code = mechanisms[i];
            if ((code & 0x80000000L) == 0L) continue;
            mechanisms[i] = this.slot.getModule().ckmVendorToGeneric(code);
        }
        return mechanisms;
    }

    public MechanismInfo getMechanismInfo(long mechanism) throws PKCS11Exception {
        if ((mechanism & 0x80000000L) != 0L) {
            mechanism = this.slot.getModule().ckmGenericToVendor(mechanism);
        }
        try {
            return new MechanismInfo(this.slot.getPKCS11().C_GetMechanismInfo(this.slot.getSlotID(), mechanism));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
    }

    public Session openSession(boolean rwSession) throws PKCS11Exception {
        return this.openSession(rwSession, null);
    }

    public Session openSession(boolean rwSession, Object application) throws PKCS11Exception {
        long sessionHandle;
        long flags = rwSession ? 6L : 4L;
        try {
            sessionHandle = this.slot.getPKCS11().C_OpenSession(this.slot.getSlotID(), flags, application, null);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw new PKCS11Exception(ex.getErrorCode());
        }
        return new Session(this, sessionHandle);
    }

    public String toString() {
        return "Token in Slot: " + this.slot;
    }
}

