/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import java.lang.reflect.Constructor;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.Util;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class CCM_PARAMS
extends CkParams {
    private static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_CCM_PARAMS";
    private static final Constructor<?> constructor_CK_MECHANISM;
    private static final Constructor<?> constructor;
    private final Object params;
    private int dataLen;
    private final byte[] nonce;
    private final byte[] aad;
    private final int macLen;

    public CCM_PARAMS(int dataLen, byte[] nonce, byte[] aad, int macLen) {
        if (constructor == null) {
            throw new IllegalStateException("sun.security.pkcs11.wrapper.CK_CCM_PARAMS is not available in the JDK");
        }
        this.nonce = Functions.requireNonNull("nonce", nonce);
        Functions.requireRange("nonce.length", nonce.length, 7, 13);
        this.macLen = Functions.requireAmong("macLen", macLen, 4, 6, 8, 10, 12, 14, 16);
        this.dataLen = dataLen;
        this.aad = aad;
        try {
            this.params = constructor.newInstance(macLen, nonce, aad, dataLen);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_CCM_PARAMS", ex);
        }
    }

    public void setDataLen(int dataLen) {
        this.dataLen = dataLen;
    }

    @Override
    public CK_MECHANISM toCkMechanism(long mechanism) {
        return this.buildCkMechanism(constructor_CK_MECHANISM, mechanism);
    }

    @Override
    public Object getParams() {
        return this.params;
    }

    @Override
    protected int getMaxFieldLen() {
        return 9;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_CCM_PARAMS:" + this.val2Str(indent, "ulDataLen", this.dataLen) + this.ptr2str(indent, "pNonce", this.nonce) + this.ptr2str(indent, "pAAD", this.aad) + this.val2Str(indent, "ulMacLen", this.macLen);
    }

    static {
        constructor = Util.getConstructor(CLASS_CK_PARAMS, Integer.TYPE, byte[].class, byte[].class, Integer.TYPE);
        constructor_CK_MECHANISM = Util.getConstructorOfCK_MECHANISM(CLASS_CK_PARAMS);
    }
}

