/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import org.xipki.pkcs11.wrapper.attrs.AttributeArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.BooleanAttribute;
import org.xipki.pkcs11.wrapper.attrs.ByteArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.CharArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.DateAttribute;
import org.xipki.pkcs11.wrapper.attrs.LongAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismArrayAttribute;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public class AttributeVector {
    private final List<Attribute> attributes = new LinkedList<Attribute>();

    public AttributeVector() {
    }

    public AttributeVector(Attribute ... attributes) {
        if (attributes != null) {
            for (Attribute attr : attributes) {
                if (attr == null) continue;
                this.attr(attr);
            }
        }
    }

    public static AttributeVector newSecretKey() {
        return new AttributeVector().class_(4L);
    }

    public static AttributeVector newSecretKey(long keyType) {
        return AttributeVector.newSecretKey().keyType(keyType);
    }

    public static AttributeVector newAESSecretKey() {
        return AttributeVector.newSecretKey(31L);
    }

    public static AttributeVector newPrivateKey() {
        return new AttributeVector().class_(3L);
    }

    public static AttributeVector newPrivateKey(long keyType) {
        return AttributeVector.newPrivateKey().keyType(keyType);
    }

    public static AttributeVector newRSAPrivateKey() {
        return AttributeVector.newPrivateKey(0L);
    }

    public static AttributeVector newECPrivateKey() {
        return AttributeVector.newPrivateKey(3L);
    }

    public static AttributeVector newDSAPrivateKey() {
        return AttributeVector.newPrivateKey(1L);
    }

    public static AttributeVector newPublicKey() {
        return new AttributeVector().class_(2L);
    }

    public static AttributeVector newPublicKey(long keyType) {
        return AttributeVector.newPublicKey().keyType(keyType);
    }

    public static AttributeVector newRSAPublicKey() {
        return AttributeVector.newPublicKey(0L);
    }

    public static AttributeVector newECPublicKey() {
        return AttributeVector.newPublicKey(3L);
    }

    public static AttributeVector newDSAPublicKey() {
        return AttributeVector.newPublicKey(1L);
    }

    public static AttributeVector newCertificate(long certificateType) {
        return new AttributeVector().class_(1L).certificateType(certificateType);
    }

    public static AttributeVector newX509Certificate() {
        return AttributeVector.newCertificate(0L);
    }

    public AttributeVector attr(long attrType, Object attrValue) {
        return this.attr(Attribute.getInstance(attrType, attrValue));
    }

    public AttributeVector attr(Attribute attr) {
        if (!this.attributes.isEmpty()) {
            long type = attr.getType();
            int oldAttrIdx = -1;
            for (int i = 0; i < this.attributes.size(); ++i) {
                if (this.attributes.get(i).getType() != type) continue;
                oldAttrIdx = i;
                break;
            }
            if (oldAttrIdx != -1) {
                this.attributes.remove(oldAttrIdx);
            }
        }
        this.attributes.add(attr);
        return this;
    }

    public List<Attribute> snapshot() {
        return Collections.unmodifiableList(this.attributes);
    }

    public CK_ATTRIBUTE[] toCkAttributes() {
        ArrayList<CK_ATTRIBUTE> attributeList = new ArrayList<CK_ATTRIBUTE>();
        for (Attribute attribute : this.attributes) {
            if (!attribute.isPresent()) continue;
            attributeList.add(attribute.getCkAttribute());
        }
        return attributeList.toArray(new CK_ATTRIBUTE[0]);
    }

    public Attribute getAttribute(long type) {
        for (Attribute attr : this.attributes) {
            if (attr.getType() != type) continue;
            return attr;
        }
        return null;
    }

    public Boolean getBooleanAttrValue(long type) {
        Attribute attr = this.getAttribute(type);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public Long getLongAttrValue(long type) {
        Attribute attr = this.getAttribute(type);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public Integer getIntAttrValue(long type) {
        Long value = this.getLongAttrValue(type);
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    public String getStringAttrValue(long type) {
        Attribute attr = this.getAttribute(type);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public byte[] getByteArrayAttrValue(long type) {
        Attribute attr = this.getAttribute(type);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public String toString() {
        return this.toString(true, "");
    }

    public String toString(boolean withName, String indent) {
        StringBuilder sb = new StringBuilder(200);
        String indent2 = indent;
        if (withName) {
            sb.append(indent).append("Attribute Vector:");
            indent2 = indent2 + "  ";
        }
        ArrayList<Attribute> copy = new ArrayList<Attribute>(this.attributes);
        Collections.sort(copy, Comparator.comparingLong(Attribute::getType));
        int nameLen = 0;
        for (Attribute attribute : copy) {
            if (attribute.isNullValue()) continue;
            nameLen = Math.max(nameLen, PKCS11Constants.ckaCodeToName(attribute.getType()).length());
        }
        nameLen = Math.min(nameLen, 30);
        for (Attribute attribute : copy) {
            if (attribute.isNullValue()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(attribute.toString(true, nameLen, indent2));
        }
        return sb.toString();
    }

    public byte[] acIssuer() {
        Attribute attr = this.getAttribute(131L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector acIssuer(byte[] acIssuer) {
        return this.attr(131L, acIssuer);
    }

    public long[] allowedMechanisms() {
        Attribute attr = this.getAttribute(0x40000600L);
        return attr == null ? null : ((MechanismArrayAttribute)attr).getValue();
    }

    public AttributeVector allowedMechanisms(long[] allowedMechanisms) {
        return this.attr(0x40000600L, allowedMechanisms);
    }

    public Boolean alwaysAuthenticate() {
        Attribute attr = this.getAttribute(514L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector alwaysAuthenticate(Boolean alwaysAuthenticate) {
        return this.attr(514L, alwaysAuthenticate);
    }

    public Boolean alwaysSensitive() {
        Attribute attr = this.getAttribute(357L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector alwaysSensitive(Boolean alwaysSensitive) {
        return this.attr(357L, alwaysSensitive);
    }

    public String application() {
        Attribute attr = this.getAttribute(16L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector application(String application) {
        return this.attr(16L, application);
    }

    public byte[] attrTypes() {
        Attribute attr = this.getAttribute(133L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector attrTypes(byte[] attrTypes) {
        return this.attr(133L, attrTypes);
    }

    public BigInteger base() {
        Attribute attr = this.getAttribute(306L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector base(BigInteger base) {
        return this.attr(306L, base);
    }

    public Integer bitsPerPixel() {
        Attribute attr = this.getAttribute(1030L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector bitsPerPixel(Integer bitsPerPixel) {
        return this.attr(1030L, bitsPerPixel);
    }

    public Long certificateCategory() {
        Attribute attr = this.getAttribute(135L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector certificateCategory(Long certificateCategory) {
        return this.attr(135L, certificateCategory);
    }

    public Long certificateType() {
        Attribute attr = this.getAttribute(128L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector certificateType(Long certificateType) {
        return this.attr(128L, certificateType);
    }

    public Integer charColumns() {
        Attribute attr = this.getAttribute(1028L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector charColumns(Integer charColumns) {
        return this.attr(1028L, charColumns);
    }

    public Integer charRows() {
        Attribute attr = this.getAttribute(1027L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector charRows(Integer charRows) {
        return this.attr(1027L, charRows);
    }

    public String charSets() {
        Attribute attr = this.getAttribute(1152L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector charSets(String charSets) {
        return this.attr(1152L, charSets);
    }

    public byte[] checkValue() {
        Attribute attr = this.getAttribute(144L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector checkValue(byte[] checkValue) {
        return this.attr(144L, checkValue);
    }

    public Long class_() {
        Attribute attr = this.getAttribute(0L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector class_(Long class_) {
        return this.attr(0L, class_);
    }

    public BigInteger coefficient() {
        Attribute attr = this.getAttribute(296L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector coefficient(BigInteger coefficient) {
        return this.attr(296L, coefficient);
    }

    public Boolean color() {
        Attribute attr = this.getAttribute(1029L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector color(Boolean color) {
        return this.attr(1029L, color);
    }

    public Boolean copyable() {
        Attribute attr = this.getAttribute(369L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector copyable(Boolean copyable) {
        return this.attr(369L, copyable);
    }

    public Boolean decrypt() {
        Attribute attr = this.getAttribute(261L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector decrypt(Boolean decrypt) {
        return this.attr(261L, decrypt);
    }

    public byte[] defaultCmsAttributes() {
        Attribute attr = this.getAttribute(1282L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector defaultCmsAttributes(byte[] defaultCmsAttributes) {
        return this.attr(1282L, defaultCmsAttributes);
    }

    public Boolean derive() {
        Attribute attr = this.getAttribute(268L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector derive(Boolean derive) {
        return this.attr(268L, derive);
    }

    public AttributeVector deriveTemplate() {
        Attribute attr = this.getAttribute(1073742355L);
        return attr == null ? null : ((AttributeArrayAttribute)attr).getValue();
    }

    public AttributeVector deriveTemplate(AttributeVector deriveTemplate) {
        return this.attr(1073742355L, deriveTemplate);
    }

    public Boolean destroyable() {
        Attribute attr = this.getAttribute(370L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector destroyable(Boolean destroyable) {
        return this.attr(370L, destroyable);
    }

    public byte[] ecParams() {
        Attribute attr = this.getAttribute(384L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector ecParams(byte[] ecParams) {
        return this.attr(384L, ecParams);
    }

    public byte[] ecPoint() {
        Attribute attr = this.getAttribute(385L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector ecPoint(byte[] ecPoint) {
        return this.attr(385L, ecPoint);
    }

    public String encodingMethods() {
        Attribute attr = this.getAttribute(1153L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector encodingMethods(String encodingMethods) {
        return this.attr(1153L, encodingMethods);
    }

    public Boolean encrypt() {
        Attribute attr = this.getAttribute(260L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector encrypt(Boolean encrypt) {
        return this.attr(260L, encrypt);
    }

    public Date endDate() {
        Attribute attr = this.getAttribute(273L);
        return attr == null ? null : ((DateAttribute)attr).getValue();
    }

    public AttributeVector endDate(Date endDate) {
        return this.attr(273L, endDate);
    }

    public BigInteger exponent1() {
        Attribute attr = this.getAttribute(294L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector exponent1(BigInteger exponent1) {
        return this.attr(294L, exponent1);
    }

    public BigInteger exponent2() {
        Attribute attr = this.getAttribute(295L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector exponent2(BigInteger exponent2) {
        return this.attr(295L, exponent2);
    }

    public Boolean extractable() {
        Attribute attr = this.getAttribute(354L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector extractable(Boolean extractable) {
        return this.attr(354L, extractable);
    }

    public byte[] gost28147Params() {
        Attribute attr = this.getAttribute(594L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector gost28147Params(byte[] gost28147Params) {
        return this.attr(594L, gost28147Params);
    }

    public byte[] gostr3410Params() {
        Attribute attr = this.getAttribute(592L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector gostr3410Params(byte[] gostr3410Params) {
        return this.attr(592L, gostr3410Params);
    }

    public byte[] gostr3411Params() {
        Attribute attr = this.getAttribute(593L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector gostr3411Params(byte[] gostr3411Params) {
        return this.attr(593L, gostr3411Params);
    }

    public byte[] hashOfIssuerPublicKey() {
        Attribute attr = this.getAttribute(139L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector hashOfIssuerPublicKey(byte[] hashOfIssuerPublicKey) {
        return this.attr(139L, hashOfIssuerPublicKey);
    }

    public byte[] hashOfSubjectPublicKey() {
        Attribute attr = this.getAttribute(138L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector hashOfSubjectPublicKey(byte[] hashOfSubjectPublicKey) {
        return this.attr(138L, hashOfSubjectPublicKey);
    }

    public Boolean hasReset() {
        Attribute attr = this.getAttribute(770L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector hasReset(Boolean hasReset) {
        return this.attr(770L, hasReset);
    }

    public Long hwFeatureType() {
        Attribute attr = this.getAttribute(768L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector hwFeatureType(Long hwFeatureType) {
        return this.attr(768L, hwFeatureType);
    }

    public byte[] id() {
        Attribute attr = this.getAttribute(258L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector id(byte[] id) {
        return this.attr(258L, id);
    }

    public byte[] issuer() {
        Attribute attr = this.getAttribute(129L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector issuer(byte[] issuer) {
        return this.attr(129L, issuer);
    }

    public Long javaMidpSecurityDomain() {
        Attribute attr = this.getAttribute(136L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector javaMidpSecurityDomain(Long javaMidpSecurityDomain) {
        return this.attr(136L, javaMidpSecurityDomain);
    }

    public Long keyGenMechanism() {
        Attribute attr = this.getAttribute(358L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector keyGenMechanism(Long keyGenMechanism) {
        return this.attr(358L, keyGenMechanism);
    }

    public Long keyType() {
        Attribute attr = this.getAttribute(256L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector keyType(Long keyType) {
        return this.attr(256L, keyType);
    }

    public String label() {
        Attribute attr = this.getAttribute(3L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector label(String label) {
        return this.attr(3L, label);
    }

    public Boolean local() {
        Attribute attr = this.getAttribute(355L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector local(Boolean local) {
        return this.attr(355L, local);
    }

    public Long mechanismType() {
        Attribute attr = this.getAttribute(1280L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector mechanismType(Long mechanismType) {
        return this.attr(1280L, mechanismType);
    }

    public String mimeTypes() {
        Attribute attr = this.getAttribute(1154L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector mimeTypes(String mimeTypes) {
        return this.attr(1154L, mimeTypes);
    }

    public Boolean modifiable() {
        Attribute attr = this.getAttribute(368L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector modifiable(Boolean modifiable) {
        return this.attr(368L, modifiable);
    }

    public BigInteger modulus() {
        Attribute attr = this.getAttribute(288L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector modulus(BigInteger modulus) {
        return this.attr(288L, modulus);
    }

    public Integer modulusBits() {
        Attribute attr = this.getAttribute(289L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector modulusBits(Integer modulusBits) {
        return this.attr(289L, modulusBits);
    }

    public Long nameHashAlgorithm() {
        Attribute attr = this.getAttribute(140L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector nameHashAlgorithm(Long nameHashAlgorithm) {
        return this.attr(140L, nameHashAlgorithm);
    }

    public Boolean neverExtractable() {
        Attribute attr = this.getAttribute(356L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector neverExtractable(Boolean neverExtractable) {
        return this.attr(356L, neverExtractable);
    }

    public byte[] objectId() {
        Attribute attr = this.getAttribute(18L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector objectId(byte[] objectId) {
        return this.attr(18L, objectId);
    }

    public Long otpChallengeRequirement() {
        Attribute attr = this.getAttribute(548L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector otpChallengeRequirement(Long otpChallengeRequirement) {
        return this.attr(548L, otpChallengeRequirement);
    }

    public byte[] otpCounter() {
        Attribute attr = this.getAttribute(558L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector otpCounter(byte[] otpCounter) {
        return this.attr(558L, otpCounter);
    }

    public Long otpCounterRequirement() {
        Attribute attr = this.getAttribute(550L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector otpCounterRequirement(Long otpCounterRequirement) {
        return this.attr(550L, otpCounterRequirement);
    }

    public Long otpFormat() {
        Attribute attr = this.getAttribute(544L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector otpFormat(Long otpFormat) {
        return this.attr(544L, otpFormat);
    }

    public Integer otpLength() {
        Attribute attr = this.getAttribute(545L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector otpLength(Integer otpLength) {
        return this.attr(545L, otpLength);
    }

    public Long otpPinRequirement() {
        Attribute attr = this.getAttribute(551L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector otpPinRequirement(Long otpPinRequirement) {
        return this.attr(551L, otpPinRequirement);
    }

    public String otpServiceIdentifier() {
        Attribute attr = this.getAttribute(555L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector otpServiceIdentifier(String otpServiceIdentifier) {
        return this.attr(555L, otpServiceIdentifier);
    }

    public byte[] otpServiceLogo() {
        Attribute attr = this.getAttribute(556L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector otpServiceLogo(byte[] otpServiceLogo) {
        return this.attr(556L, otpServiceLogo);
    }

    public String otpServiceLogoType() {
        Attribute attr = this.getAttribute(557L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector otpServiceLogoType(String otpServiceLogoType) {
        return this.attr(557L, otpServiceLogoType);
    }

    public String otpTime() {
        Attribute attr = this.getAttribute(559L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector otpTime(String otpTime) {
        return this.attr(559L, otpTime);
    }

    public Long otpTimeInterval() {
        Attribute attr = this.getAttribute(546L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector otpTimeInterval(Long otpTimeInterval) {
        return this.attr(546L, otpTimeInterval);
    }

    public Long otpTimeRequirement() {
        Attribute attr = this.getAttribute(549L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector otpTimeRequirement(Long otpTimeRequirement) {
        return this.attr(549L, otpTimeRequirement);
    }

    public Boolean otpUserFriendlyMode() {
        Attribute attr = this.getAttribute(547L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector otpUserFriendlyMode(Boolean otpUserFriendlyMode) {
        return this.attr(547L, otpUserFriendlyMode);
    }

    public String otpUserIdentifier() {
        Attribute attr = this.getAttribute(554L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector otpUserIdentifier(String otpUserIdentifier) {
        return this.attr(554L, otpUserIdentifier);
    }

    public byte[] owner() {
        Attribute attr = this.getAttribute(132L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector owner(byte[] owner) {
        return this.attr(132L, owner);
    }

    public Integer pixelX() {
        Attribute attr = this.getAttribute(1024L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector pixelX(Integer pixelX) {
        return this.attr(1024L, pixelX);
    }

    public Integer pixelY() {
        Attribute attr = this.getAttribute(1025L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector pixelY(Integer pixelY) {
        return this.attr(1025L, pixelY);
    }

    public BigInteger prime() {
        Attribute attr = this.getAttribute(304L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector prime(BigInteger prime) {
        return this.attr(304L, prime);
    }

    public BigInteger prime1() {
        Attribute attr = this.getAttribute(292L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector prime1(BigInteger prime1) {
        return this.attr(292L, prime1);
    }

    public BigInteger prime2() {
        Attribute attr = this.getAttribute(293L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector prime2(BigInteger prime2) {
        return this.attr(293L, prime2);
    }

    public Integer primeBits() {
        Attribute attr = this.getAttribute(307L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector primeBits(Integer primeBits) {
        return this.attr(307L, primeBits);
    }

    public Boolean private_() {
        Attribute attr = this.getAttribute(2L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector private_(Boolean private_) {
        return this.attr(2L, private_);
    }

    public BigInteger privateExponent() {
        Attribute attr = this.getAttribute(291L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector privateExponent(BigInteger privateExponent) {
        return this.attr(291L, privateExponent);
    }

    public Long profileId() {
        Attribute attr = this.getAttribute(1537L);
        return attr == null ? null : ((LongAttribute)attr).getValue();
    }

    public AttributeVector profileId(Long profileId) {
        return this.attr(1537L, profileId);
    }

    public BigInteger publicExponent() {
        Attribute attr = this.getAttribute(290L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector publicExponent(BigInteger publicExponent) {
        return this.attr(290L, publicExponent);
    }

    public byte[] publicKeyInfo() {
        Attribute attr = this.getAttribute(297L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector publicKeyInfo(byte[] publicKeyInfo) {
        return this.attr(297L, publicKeyInfo);
    }

    public byte[] requiredCmsAttributes() {
        Attribute attr = this.getAttribute(1281L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector requiredCmsAttributes(byte[] requiredCmsAttributes) {
        return this.attr(1281L, requiredCmsAttributes);
    }

    public Boolean resetOnInit() {
        Attribute attr = this.getAttribute(769L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector resetOnInit(Boolean resetOnInit) {
        return this.attr(769L, resetOnInit);
    }

    public Integer resolution() {
        Attribute attr = this.getAttribute(1026L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector resolution(Integer resolution) {
        return this.attr(1026L, resolution);
    }

    public Boolean sensitive() {
        Attribute attr = this.getAttribute(259L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector sensitive(Boolean sensitive) {
        return this.attr(259L, sensitive);
    }

    public byte[] serialNumber() {
        Attribute attr = this.getAttribute(130L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector serialNumber(byte[] serialNumber) {
        return this.attr(130L, serialNumber);
    }

    public Boolean sign() {
        Attribute attr = this.getAttribute(264L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector sign(Boolean sign) {
        return this.attr(264L, sign);
    }

    public Boolean signRecover() {
        Attribute attr = this.getAttribute(265L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector signRecover(Boolean signRecover) {
        return this.attr(265L, signRecover);
    }

    public Date startDate() {
        Attribute attr = this.getAttribute(272L);
        return attr == null ? null : ((DateAttribute)attr).getValue();
    }

    public AttributeVector startDate(Date startDate) {
        return this.attr(272L, startDate);
    }

    public byte[] subject() {
        Attribute attr = this.getAttribute(257L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector subject(byte[] subject) {
        return this.attr(257L, subject);
    }

    public BigInteger subprime() {
        Attribute attr = this.getAttribute(305L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getBigIntValue();
    }

    public AttributeVector subprime(BigInteger subprime) {
        return this.attr(305L, subprime);
    }

    public Integer subprimeBits() {
        Attribute attr = this.getAttribute(308L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector subprimeBits(Integer subprimeBits) {
        return this.attr(308L, subprimeBits);
    }

    public byte[] supportedCmsAttributes() {
        Attribute attr = this.getAttribute(1283L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector supportedCmsAttributes(byte[] supportedCmsAttributes) {
        return this.attr(1283L, supportedCmsAttributes);
    }

    public Boolean token() {
        Attribute attr = this.getAttribute(1L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector token(Boolean token) {
        return this.attr(1L, token);
    }

    public Boolean trusted() {
        Attribute attr = this.getAttribute(134L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector trusted(Boolean trusted) {
        return this.attr(134L, trusted);
    }

    public String uniqueId() {
        Attribute attr = this.getAttribute(4L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector uniqueId(String uniqueId) {
        return this.attr(4L, uniqueId);
    }

    public Boolean unwrap() {
        Attribute attr = this.getAttribute(263L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector unwrap(Boolean unwrap) {
        return this.attr(263L, unwrap);
    }

    public AttributeVector unwrapTemplate() {
        Attribute attr = this.getAttribute(1073742354L);
        return attr == null ? null : ((AttributeArrayAttribute)attr).getValue();
    }

    public AttributeVector unwrapTemplate(AttributeVector unwrapTemplate) {
        return this.attr(1073742354L, unwrapTemplate);
    }

    public String url() {
        Attribute attr = this.getAttribute(137L);
        return attr == null ? null : ((CharArrayAttribute)attr).getValue();
    }

    public AttributeVector url(String url) {
        return this.attr(137L, url);
    }

    public byte[] value() {
        Attribute attr = this.getAttribute(17L);
        return attr == null ? null : ((ByteArrayAttribute)attr).getValue();
    }

    public AttributeVector value(byte[] value) {
        return this.attr(17L, value);
    }

    public Integer valueBits() {
        Attribute attr = this.getAttribute(352L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector valueBits(Integer valueBits) {
        return this.attr(352L, valueBits);
    }

    public Integer valueLen() {
        Attribute attr = this.getAttribute(353L);
        return attr == null ? null : ((LongAttribute)attr).getIntValue();
    }

    public AttributeVector valueLen(Integer valueLen) {
        return this.attr(353L, valueLen);
    }

    public Boolean verify() {
        Attribute attr = this.getAttribute(266L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector verify(Boolean verify) {
        return this.attr(266L, verify);
    }

    public Boolean verifyRecover() {
        Attribute attr = this.getAttribute(267L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector verifyRecover(Boolean verifyRecover) {
        return this.attr(267L, verifyRecover);
    }

    public Boolean wrap() {
        Attribute attr = this.getAttribute(262L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector wrap(Boolean wrap) {
        return this.attr(262L, wrap);
    }

    public AttributeVector wrapTemplate() {
        Attribute attr = this.getAttribute(1073742353L);
        return attr == null ? null : ((AttributeArrayAttribute)attr).getValue();
    }

    public AttributeVector wrapTemplate(AttributeVector wrapTemplate) {
        return this.attr(1073742353L, wrapTemplate);
    }

    public Boolean wrapWithTrusted() {
        Attribute attr = this.getAttribute(528L);
        return attr == null ? null : ((BooleanAttribute)attr).getValue();
    }

    public AttributeVector wrapWithTrusted(Boolean wrapWithTrusted) {
        return this.attr(528L, wrapWithTrusted);
    }
}

