/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class Mechanism {
    private final long mechanismCode;
    private final CkParams parameters;

    public Mechanism(long mechanismCode) {
        this(mechanismCode, null);
    }

    public Mechanism(long mechanismCode, CkParams parameters) {
        this.mechanismCode = mechanismCode;
        this.parameters = parameters;
    }

    public CkParams getParameters() {
        return this.parameters;
    }

    public long getMechanismCode() {
        return this.mechanismCode;
    }

    public String getName() {
        return PKCS11Constants.ckmCodeToName(this.mechanismCode);
    }

    public CK_MECHANISM toCkMechanism() {
        return this.parameters == null ? new CK_MECHANISM(this.mechanismCode) : this.parameters.toCkMechanism(this.mechanismCode);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return indent + "Mechanism: " + this.getName() + "\n" + indent + "Parameters:" + (this.parameters == null ? " null" : "\n" + this.parameters.toString(indent + "  "));
    }
}

