/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.attrs;

import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;

public class AttributeArrayAttribute
extends Attribute {
    private AttributeVector template;

    public AttributeArrayAttribute(long type) {
        super(type);
    }

    public AttributeArrayAttribute attributeArrayValue(AttributeVector value) {
        this.template = value;
        this.ckAttribute.pValue = value == null ? null : value.toCkAttributes();
        this.present = true;
        return this;
    }

    @Override
    public AttributeVector getValue() {
        if (this.template != null) {
            return this.template;
        }
        if (this.isNullValue() || ((CK_ATTRIBUTE[])this.ckAttribute.pValue).length == 0) {
            return null;
        }
        CK_ATTRIBUTE[] attributesArray = (CK_ATTRIBUTE[])this.ckAttribute.pValue;
        AttributeVector template = new AttributeVector();
        for (CK_ATTRIBUTE ck_attribute : attributesArray) {
            long type = ck_attribute.type;
            Attribute attr = AttributeArrayAttribute.getInstance0(type);
            if (attr == null) {
                StaticLogger.warn("Could not create attribute for the attribute type 0x" + Functions.toFullHex(type));
                continue;
            }
            template.attr(attr.ckAttribute(ck_attribute).present(true));
        }
        return template;
    }

    @Override
    protected String getValueString() {
        if (this.template == null) {
            this.template = this.getValue();
        }
        return this.template == null ? "<NULL_PTR>" : "\n" + this.template.toString(false, "    ");
    }
}

