/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.TokenException;

public class Functions {
    private static final Map<Long, String> hashMechCodeToHashNames = new HashMap<Long, String>();
    private static final Map<String, ECInfo> ecParamsInfoMap;
    private static final Set<String> edwardsMontgomeryEcParams;

    public static byte[] encodeOid(String oid) {
        return Functions.encodeOid(new ByteArrayOutputStream(10), oid);
    }

    private static byte[] encodeOid(ByteArrayOutputStream out, String oid) {
        out.reset();
        String[] nodes = oid.split("\\.");
        out.write(6);
        out.write(0);
        out.write(Integer.parseInt(nodes[0]) * 40 + Integer.parseInt(nodes[1]));
        for (int i = 2; i < nodes.length; ++i) {
            int v = Integer.parseInt(nodes[i]);
            if (v < 128) {
                out.write(v);
                continue;
            }
            int bitLen = BigInteger.valueOf(v).bitLength();
            int numBytes = (bitLen + 6) / 7;
            int shiftBits = bitLen - (numBytes - 1) * 7;
            for (int j = 0; j < numBytes; ++j) {
                int k = 0x7F & v >> bitLen - shiftBits - 7 * j;
                if (j != numBytes - 1) {
                    k |= 0x80;
                }
                out.write(k);
            }
        }
        byte[] is = out.toByteArray();
        if (is.length - 2 > 127) {
            throw new IllegalStateException("should not reach here, OID too long");
        }
        is[1] = (byte)(is.length - 2);
        return is;
    }

    public static String getHashAlgName(long hashMechanism) {
        return hashMechCodeToHashNames.get(hashMechanism);
    }

    public static byte[] asUnsignedByteArray(BigInteger bn) {
        byte[] bytes = bn.toByteArray();
        return bytes[0] != 0 ? bytes : Arrays.copyOfRange(bytes, 1, bytes.length);
    }

    public static String toFullHex(long value) {
        return Functions.toFullHex(value, false);
    }

    public static String toFullHexUpper(long value) {
        return Functions.toFullHex(value, true);
    }

    private static String toFullHex(long value, boolean upperCase) {
        long currentValue = value;
        StringBuilder stringBuffer = new StringBuilder(16);
        int size = value > 0xFFFFFFFFL ? 16 : 8;
        for (int j = 0; j < size; ++j) {
            int currentDigit = (int)currentValue & 0xF;
            stringBuffer.append((upperCase ? Hex.UPPER_DIGITS : Hex.DIGITS)[currentDigit]);
            currentValue >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHex(byte[] value) {
        return Hex.encode(value, 0, value.length);
    }

    public static String toHex(byte[] value, int ofs, int len) {
        return Hex.encode(value, ofs, len);
    }

    public static byte[] decodeHex(String encoded) {
        return Hex.decode(encoded);
    }

    public static Long parseLong(String text) {
        int i;
        if (text.startsWith("0x") || text.startsWith("0X")) {
            return Long.parseLong(text.substring(2), 16);
        }
        boolean isNumber = true;
        boolean withSign = text.startsWith("-");
        int n = i = withSign ? 1 : 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c > '9' || c < '0') {
                isNumber = false;
                break;
            }
            ++i;
        }
        if (isNumber) {
            return Long.parseLong(text);
        }
        return null;
    }

    public static <T> T requireNonNull(String paramName, T param) {
        if (param == null) {
            throw new NullPointerException("Argument '" + paramName + "' must not be null.");
        }
        return param;
    }

    public static int requireRange(String name, int argument, int min, int max) {
        if (argument < min || argument > max) {
            throw new IllegalArgumentException(String.format("%s may not be out of the range [%d, %d]: %d", name, min, max, argument));
        }
        return argument;
    }

    public static int requireAmong(String name, int argument, int ... candidates) {
        for (int candidate : candidates) {
            if (argument != candidate) continue;
            return argument;
        }
        throw new IllegalArgumentException(name + " is not among " + Arrays.toString(candidates) + ": " + argument);
    }

    public static String toStringFlags(PKCS11Constants.Category category, String prefix, long flags, long ... flagMasks) {
        char[] indentChars = new char[prefix.length() + 1];
        Arrays.fill(indentChars, ' ');
        String indent = new String(indentChars);
        ArrayList<Long> sortedMasks = new ArrayList<Long>(flagMasks.length);
        for (long flagMask : flagMasks) {
            sortedMasks.add(flagMask);
        }
        Collections.sort(sortedMasks);
        boolean first = true;
        LinkedList<String> lines = new LinkedList<String>();
        String line = prefix + "0x" + Functions.toFullHex(flags) + " (";
        Iterator flagMask = sortedMasks.iterator();
        while (flagMask.hasNext()) {
            String thisEntry;
            long flagMask2 = (Long)flagMask.next();
            if ((flags & flagMask2) == 0L) continue;
            String string = thisEntry = first ? "" : " | ";
            if (first) {
                first = false;
            }
            thisEntry = thisEntry + PKCS11Constants.codeToName(category, flagMask2).substring(4);
            if (line.length() + thisEntry.length() > 100) {
                lines.add(line);
                line = indent;
            }
            line = line + thisEntry;
        }
        if (line.length() > indentChars.length) {
            lines.add(line);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append((String)lines.get(i));
        }
        return sb.append(")").toString();
    }

    public static byte[] getEcParams(BigInteger order, BigInteger baseX) {
        byte[] orderBytes = order.toByteArray();
        byte[] baseXBytes = baseX.toByteArray();
        for (Map.Entry<String, ECInfo> m : ecParamsInfoMap.entrySet()) {
            ECInfo ei = m.getValue();
            if (!Arrays.equals(ei.order, orderBytes) || !Arrays.equals(ei.baseX, baseXBytes)) continue;
            return Hex.decode(m.getKey());
        }
        return null;
    }

    public static Integer getCurveOrderBitLength(byte[] ecParams) {
        ECInfo ecInfo = ecParamsInfoMap.get(Hex.encode(ecParams, 0, ecParams.length));
        return ecInfo == null ? null : Integer.valueOf(ecInfo.orderBitLength);
    }

    public static String getCurveName(byte[] ecParams) {
        ECInfo ecInfo = ecParamsInfoMap.get(Hex.encode(ecParams, 0, ecParams.length));
        return ecInfo == null ? null : ecInfo.names[0];
    }

    public static String[] getCurveNames(byte[] ecParams) {
        ECInfo ecInfo = ecParamsInfoMap.get(Hex.encode(ecParams, 0, ecParams.length));
        return ecInfo == null ? null : (String[])ecInfo.names.clone();
    }

    public static String decodeOid(byte[] encoded) {
        int len = encoded.length;
        if (encoded[0] != 6 || (0xFF & encoded[1]) != len - 2 || (encoded[len - 1] & 0x80) != 0) {
            throw new IllegalArgumentException("invalid ecParams");
        }
        StringBuilder sb = new StringBuilder(len + 5);
        int ofs = 2;
        int b = encoded[ofs++] & 0xFF;
        sb.append(b / 40).append('.');
        sb.append(b % 40).append('.');
        while (ofs < len) {
            int bi;
            if ((b = encoded[ofs++] & 0xFF) < 128) {
                sb.append(b).append('.');
                continue;
            }
            int ni = b & 0x7F;
            do {
                b = encoded[ofs++] & 0xFF;
                bi = b & 0x7F;
                ni <<= 7;
                ni += bi;
            } while (b != bi);
            sb.append(ni).append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    static Integer getECFieldSize(byte[] ecParams) {
        ECInfo ecInfo = ecParamsInfoMap.get(Hex.encode(ecParams, 0, ecParams.length));
        return ecInfo == null ? null : Integer.valueOf(ecInfo.fieldSize);
    }

    static byte[] fixECDSASignature(byte[] sig, byte[] ecParams) {
        ECInfo ecInfo = ecParamsInfoMap.get(Hex.encode(ecParams, 0, ecParams.length));
        return ecInfo == null ? sig : Functions.fixECDSASignature(sig, ecInfo.orderSize);
    }

    static byte[] fixECParams(byte[] ecParams) {
        try {
            AtomicInteger numLenBytes = new AtomicInteger();
            int tag = 0xFF & ecParams[0];
            if (tag == 12 || tag == 19) {
                int offset = 1;
                int len = Functions.getDerLen(ecParams, offset, numLenBytes);
                if ((offset += numLenBytes.get()) + len == ecParams.length) {
                    String curveName = new String(ecParams, offset, len, StandardCharsets.UTF_8).trim().toUpperCase(Locale.ROOT);
                    for (Map.Entry<String, ECInfo> m : ecParamsInfoMap.entrySet()) {
                        for (String name : m.getValue().names) {
                            if (!name.equals(curveName)) continue;
                            return Functions.decodeHex(m.getKey());
                        }
                    }
                }
                return ecParams;
            }
            if (tag == 48) {
                byte[] baseX;
                byte pointEncoding;
                int offset = 1;
                int len = Functions.getDerLen(ecParams, offset, numLenBytes);
                if ((offset += numLenBytes.get()) + len != ecParams.length) {
                    return ecParams;
                }
                offset = Functions.getOffsetOfNextField(ecParams, offset);
                offset = Functions.getOffsetOfNextField(ecParams, offset);
                offset = Functions.getOffsetOfNextField(ecParams, offset);
                if (ecParams[offset++] != 4) {
                    return ecParams;
                }
                len = Functions.getDerLen(ecParams, offset, numLenBytes);
                int nextOffset = (offset += numLenBytes.get()) + len;
                if ((pointEncoding = ecParams[offset++]) == 4) {
                    baseX = Arrays.copyOfRange(ecParams, offset, offset + (len - 1) / 2);
                } else if (pointEncoding == 2 || pointEncoding == 3) {
                    baseX = Arrays.copyOfRange(ecParams, offset, offset + len - 1);
                } else {
                    return ecParams;
                }
                if ((baseX[0] & 0x80) != 0) {
                    byte[] newBaseX = new byte[1 + baseX.length];
                    System.arraycopy(baseX, 0, newBaseX, 1, baseX.length);
                    baseX = newBaseX;
                } else if (baseX[0] == 0 && (baseX[1] & 0x80) == 0) {
                    baseX = new BigInteger(1, baseX).toByteArray();
                }
                offset = nextOffset;
                if (ecParams[offset++] != 2) {
                    return ecParams;
                }
                len = Functions.getDerLen(ecParams, offset, numLenBytes);
                byte[] order = Arrays.copyOfRange(ecParams, offset += numLenBytes.get(), offset + len);
                for (Map.Entry<String, ECInfo> m : ecParamsInfoMap.entrySet()) {
                    ECInfo ei = m.getValue();
                    if (ei.order == null || !Arrays.equals(ei.order, order) || !Arrays.equals(ei.baseX, baseX)) continue;
                    return Functions.decodeHex(m.getKey());
                }
            }
            return ecParams;
        }
        catch (Exception e) {
            return ecParams;
        }
    }

    public static byte[] dsaSigPlainToX962(byte[] sig) {
        int rOrSLen;
        if (sig.length % 2 != 0) {
            return sig;
        }
        int derRLen = rOrSLen = sig.length / 2;
        for (int i = 0; i < rOrSLen && sig[i] == 0; ++i) {
            --derRLen;
        }
        if ((sig[rOrSLen - derRLen] & 0x80) != 0) {
            ++derRLen;
        }
        int derSLen = rOrSLen;
        for (int i = 0; i < rOrSLen && sig[rOrSLen + i] == 0; ++i) {
            --derSLen;
        }
        if ((sig[sig.length - derSLen] & 0x80) != 0) {
            ++derSLen;
        }
        int contentLen = 2 + derRLen + 2 + derSLen;
        int numBytesForContentLen = 1;
        if (contentLen > 127) {
            ++numBytesForContentLen;
        }
        byte[] res = new byte[1 + numBytesForContentLen + contentLen];
        res[0] = 48;
        int offset = 1;
        if (numBytesForContentLen > 1) {
            res[offset++] = -127;
        }
        res[offset++] = (byte)contentLen;
        res[offset++] = 2;
        res[offset++] = (byte)derRLen;
        if (derRLen >= rOrSLen) {
            System.arraycopy(sig, 0, res, offset + derRLen - rOrSLen, rOrSLen);
        } else {
            System.arraycopy(sig, rOrSLen - derRLen, res, offset, derRLen);
        }
        offset += derRLen;
        res[offset++] = 2;
        res[offset++] = (byte)derSLen;
        if (derSLen >= rOrSLen) {
            System.arraycopy(sig, rOrSLen, res, offset + derSLen - rOrSLen, rOrSLen);
        } else {
            System.arraycopy(sig, sig.length - derSLen, res, offset, derSLen);
        }
        return res;
    }

    static byte[] fixECDSASignature(byte[] sig, int rOrSLen) {
        if (sig.length == 2 * rOrSLen || sig[0] != 48) {
            return sig;
        }
        return Functions.dsaSigX962ToPlain(sig, rOrSLen);
    }

    public static byte[] dsaSigX962ToPlain(byte[] sig, int rOrSLen) {
        try {
            AtomicInteger numLenBytes = new AtomicInteger();
            int ofs = 1;
            int len = Functions.getDerLen(sig, ofs, numLenBytes);
            if (len == 0 || (ofs += numLenBytes.get()) + len != sig.length) {
                return sig;
            }
            if (sig[ofs++] != 2) {
                return sig;
            }
            int rLen = Functions.getDerLen(sig, ofs, numLenBytes);
            byte[] r = Arrays.copyOfRange(sig, ofs += numLenBytes.get(), ofs + rLen);
            ofs += rLen;
            if (sig[ofs++] != 2) {
                return sig;
            }
            int sLen = Functions.getDerLen(sig, ofs, numLenBytes);
            if ((ofs += numLenBytes.get()) + sLen != sig.length) {
                return sig;
            }
            byte[] s = Arrays.copyOfRange(sig, ofs, sig.length);
            if (r[0] == 0) {
                r = Arrays.copyOfRange(r, 1, r.length);
            }
            if (s[0] == 0) {
                s = Arrays.copyOfRange(s, 1, s.length);
            }
            if (r.length > rOrSLen || s.length > rOrSLen) {
                return sig;
            }
            byte[] rs = new byte[2 * rOrSLen];
            System.arraycopy(r, 0, rs, rOrSLen - r.length, r.length);
            System.arraycopy(s, 0, rs, rs.length - s.length, s.length);
            return rs;
        }
        catch (Exception e) {
            return sig;
        }
    }

    public static String toString(String prefix, byte[] bytes) {
        int numPerLine = 40;
        int len = bytes.length;
        int indentLen = prefix.length();
        if (indentLen > 0 && prefix.charAt(0) == '\n') {
            --indentLen;
        }
        char[] indentChars = new char[indentLen];
        Arrays.fill(indentChars, ' ');
        String indent = "\n" + new String(indentChars);
        StringBuilder sb = new StringBuilder(5 * (len + 40 - 1) / 40 + 4 * bytes.length);
        for (int ofs = 0; ofs < len; ofs += 40) {
            int num = Math.min(40, len - ofs);
            sb.append(ofs == 0 ? prefix : indent).append(Functions.toHex(bytes, ofs, num));
        }
        return sb.toString();
    }

    static byte[] getCoreECPoint(byte[] ecPoint) {
        try {
            if (ecPoint[0] == 4) {
                return Functions.getOctetsFromASN1OctetString(ecPoint);
            }
            if (ecPoint[0] == 3) {
                return Functions.getOctetsFromASN1BitString(ecPoint);
            }
            return ecPoint;
        }
        catch (TokenException e) {
            return ecPoint;
        }
    }

    static byte[] getCoreECPoint(byte[] ecPoint, byte[] ecParams) {
        if (ecParams == null) {
            return Functions.getCoreECPoint(ecPoint);
        }
        int len = ecPoint.length;
        if (len > 65520) {
            return Functions.getCoreECPoint(ecPoint);
        }
        String hexEcParams = Hex.encode(ecParams, 0, ecParams.length);
        ECInfo ecInfo = ecParamsInfoMap.get(hexEcParams);
        if (ecInfo == null) {
            return Functions.getCoreECPoint(ecPoint);
        }
        int fieldSize = ecInfo.fieldSize;
        if (edwardsMontgomeryEcParams.contains(hexEcParams)) {
            return len == fieldSize ? ecPoint : Functions.getCoreECPoint(ecPoint);
        }
        if (ecPoint.length == 2 * fieldSize) {
            byte[] ecPoint2 = new byte[1 + ecPoint.length];
            ecPoint2[0] = 4;
            System.arraycopy(ecPoint, 0, ecPoint2, 1, ecPoint.length);
            return ecPoint2;
        }
        byte encodingByte = ecPoint[0];
        if (encodingByte == 4 ? len == 1 + 2 * fieldSize : (encodingByte == 2 || encodingByte == 3) && len == 1 + fieldSize) {
            return ecPoint;
        }
        return Functions.getCoreECPoint(ecPoint);
    }

    public static byte[] getOctetsFromASN1OctetString(byte[] encoded) throws TokenException {
        if (encoded[0] != 4) {
            throw new TokenException("encoded is not a valid ASN.1 octet string");
        }
        AtomicInteger numLenBytes = new AtomicInteger();
        int len = Functions.getDerLen(encoded, 1, numLenBytes);
        if (1 + numLenBytes.get() + len != encoded.length) {
            throw new TokenException("encoded is not a valid ASN.1 octet string");
        }
        return Arrays.copyOfRange(encoded, 1 + numLenBytes.get(), encoded.length);
    }

    public static byte[] getOctetsFromASN1BitString(byte[] encoded) throws TokenException {
        if (encoded[0] != 3) {
            throw new TokenException("encoded is not a valid ASN.1 bit string");
        }
        AtomicInteger numLenBytes = new AtomicInteger();
        int len = Functions.getDerLen(encoded, 1, numLenBytes);
        if (1 + numLenBytes.get() + len != encoded.length) {
            throw new TokenException("encoded is not a valid ASN.1 octet string");
        }
        return Arrays.copyOfRange(encoded, 1 + numLenBytes.get() + 1, encoded.length);
    }

    public static byte[] toOctetOrBitString(byte[] bytes, boolean isBitString) {
        int len = bytes.length;
        int numLenBytes = len <= 127 ? 1 : (len <= 255 ? 2 : (len <= 65535 ? 3 : 4));
        int size = 1 + numLenBytes + len;
        if (isBitString) {
            ++size;
        }
        byte[] ret = new byte[size];
        int off = 0;
        int n = ret[off++] = isBitString ? 3 : 4;
        if (numLenBytes == 2) {
            ret[off++] = -127;
        } else if (numLenBytes == 3) {
            ret[off++] = -126;
            ret[off++] = (byte)(len >> 8);
        } else if (numLenBytes == 4) {
            ret[off++] = -125;
            ret[off++] = (byte)(len >> 16);
            ret[off++] = (byte)(len >> 8);
        }
        ret[off++] = (byte)len;
        if (isBitString) {
            ret[off++] = 0;
        }
        System.arraycopy(bytes, 0, ret, off, bytes.length);
        return ret;
    }

    private static int getOffsetOfNextField(byte[] bytes, int offset) throws TokenException {
        AtomicInteger numLenBytes = new AtomicInteger();
        int len = Functions.getDerLen(bytes, ++offset, numLenBytes);
        return offset + numLenBytes.get() + len;
    }

    private static int getDerLen(byte[] bytes, int ofs, AtomicInteger numLenBytes) throws TokenException {
        int len;
        int b;
        int origOfs = ofs;
        int n = ((b = 0xFF & bytes[ofs++]) & 0x80) == 0 ? b : (b == 129 ? 0xFF & bytes[ofs++] : (b == 130 ? (0xFF & bytes[ofs++]) << 8 | 0xFF & bytes[ofs++] : (b == 131 ? (0xFF & bytes[ofs++]) << 16 | 0xFF & (0xFF & bytes[ofs++]) << 8 | 0xFF & bytes[ofs++] : (len = b == 132 ? (0xFF & bytes[ofs++]) << 24 | (0xFF & bytes[ofs++]) << 16 | 0xFF & (0xFF & bytes[ofs++]) << 8 | 0xFF & bytes[ofs++] : -1))));
        if (len == -1) {
            throw new TokenException("invalid DER encoded bytes");
        }
        numLenBytes.set(ofs - origOfs);
        return len;
    }

    static {
        hashMechCodeToHashNames.put(544L, "SHA1");
        hashMechCodeToHashNames.put(597L, "SHA224");
        hashMechCodeToHashNames.put(592L, "SHA256");
        hashMechCodeToHashNames.put(608L, "SHA384");
        hashMechCodeToHashNames.put(624L, "SHA512");
        hashMechCodeToHashNames.put(72L, "SHA512/224");
        hashMechCodeToHashNames.put(76L, "SHA512/256");
        hashMechCodeToHashNames.put(693L, "SHA3-224");
        hashMechCodeToHashNames.put(688L, "SHA3-256");
        hashMechCodeToHashNames.put(704L, "SHA3-384");
        hashMechCodeToHashNames.put(720L, "SHA3-512");
        edwardsMontgomeryEcParams = new HashSet<String>(6);
        edwardsMontgomeryEcParams.add("06032b656e");
        edwardsMontgomeryEcParams.add("06032b656f");
        edwardsMontgomeryEcParams.add("06032b6570");
        edwardsMontgomeryEcParams.add("06032b6571");
        ecParamsInfoMap = new HashMap<String, ECInfo>(120);
        String propFile = "org/xipki/pkcs11/wrapper/EC.properties";
        Properties props = new Properties();
        try {
            props.load(Functions.class.getClassLoader().getResourceAsStream(propFile));
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
            for (String name : props.stringPropertyNames()) {
                ECInfo ecInfo = new ECInfo();
                ecInfo.oid = name.trim();
                if (ecParamsInfoMap.containsKey(name)) {
                    throw new IllegalStateException("duplicated definition of " + name);
                }
                byte[] ecParams = Functions.encodeOid(buffer, ecInfo.oid);
                String[] values = props.getProperty(name).split(",");
                ecInfo.names = values[0].toUpperCase(Locale.ROOT).split(":");
                ecInfo.fieldSize = (Integer.parseInt(values[1]) + 7) / 8;
                ecInfo.orderBitLength = Integer.parseInt(values[2]);
                ecInfo.orderSize = (ecInfo.orderBitLength + 7) / 8;
                String str = values[3];
                if (!str.isEmpty() && !"-".equals(str)) {
                    ecInfo.order = new BigInteger(str, 16).toByteArray();
                }
                if (!(str = values[4]).isEmpty() && !"-".equals(str)) {
                    ecInfo.baseX = new BigInteger(str, 16).toByteArray();
                }
                String hexEcParams = Hex.encode(ecParams, 0, ecParams.length);
                ecParamsInfoMap.put(hexEcParams, ecInfo);
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("error reading properties file " + propFile + ": " + t.getMessage());
        }
    }

    private static class ECInfo {
        int fieldSize;
        int orderSize;
        int orderBitLength;
        String oid;
        String[] names;
        byte[] order;
        byte[] baseX;

        private ECInfo() {
        }
    }

    private static class Hex {
        private static final char[] DIGITS;
        private static final char[] UPPER_DIGITS;
        private static final int[] LINTS;
        private static final int[] HINTS;

        private Hex() {
        }

        public static String encode(byte[] data, int ofs, int len) {
            char[] out = new char[len << 1];
            int endOfs = ofs + len;
            int j = 0;
            for (int i = ofs; i < endOfs; ++i) {
                out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
                out[j++] = DIGITS[0xF & data[i]];
            }
            return new String(out);
        }

        public static byte[] decode(String hex) {
            char[] data = hex.toCharArray();
            int len = data.length;
            if ((len & 1) != 0) {
                throw new IllegalArgumentException("Odd number of characters.");
            }
            byte[] out = new byte[len >> 1];
            int i = 0;
            int j = 0;
            while (j < len) {
                out[i] = (byte)(HINTS[data[j++]] | LINTS[data[j++]]);
                ++i;
            }
            return out;
        }

        static {
            int i;
            DIGITS = "0123456789abcdef".toCharArray();
            UPPER_DIGITS = "0123456789ABCDEF".toCharArray();
            LINTS = new int[103];
            HINTS = new int[LINTS.length];
            for (i = 0; i < DIGITS.length; ++i) {
                Hex.LINTS[Hex.DIGITS[i]] = i;
            }
            for (i = 10; i < UPPER_DIGITS.length; ++i) {
                Hex.LINTS[Hex.UPPER_DIGITS[i]] = i;
            }
            for (i = 0; i < LINTS.length; ++i) {
                Hex.HINTS[i] = LINTS[i] << 4;
            }
        }
    }
}

