/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class Mechanism {
    private PKCS11Module module;
    private final long mechanismCode;
    private final CkParams parameters;

    public Mechanism(long mechanismCode) {
        this(mechanismCode, null);
    }

    public Mechanism(long mechanismCode, CkParams parameters) {
        this.mechanismCode = mechanismCode;
        this.parameters = parameters;
    }

    public void setModule(PKCS11Module module) {
        this.module = module;
        if (this.parameters != null) {
            this.parameters.setModule(module);
        }
    }

    public CkParams getParameters() {
        return this.parameters;
    }

    public long getMechanismCode() {
        return this.mechanismCode;
    }

    public String getName() {
        if (this.module == null) {
            return PKCS11Constants.ckmCodeToName(this.mechanismCode);
        }
        String name = this.module.codeToName(PKCS11Constants.Category.CKM, this.mechanismCode);
        long code2 = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.mechanismCode);
        if (this.mechanismCode == code2) {
            return name;
        }
        String name2 = this.module.codeToName(PKCS11Constants.Category.CKM, code2);
        return name + " (native: " + name2 + ")";
    }

    public CK_MECHANISM toCkMechanism() {
        if (this.module == null) {
            throw new IllegalStateException("module is not set");
        }
        long realCode = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.mechanismCode);
        if (this.parameters == null) {
            return new CK_MECHANISM(realCode);
        }
        return this.parameters.toCkMechanism(realCode);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return indent + "Mechanism: " + this.getName() + "\n" + indent + "Parameters:" + (this.parameters == null ? " null" : "\n" + this.parameters.toString(indent + "  "));
    }
}

