/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.Version;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.PKCS11;

public class PKCS11Module {
    static final int BEHAVIOUR_ECDSA_SIGNATURE_X962 = 1;
    static final int BEHAVIOUR_SM2_SIGNATURE_X962 = 2;
    static final int BEHAVIOUR_EC_PRIVATEKEY_ECPOINT = 3;
    static final int BEHAVIOUR_SM2_PRIVATEKEY_ECPOINT = 4;
    static final int BEHAVIOUR_IGNORE_DEVICE_ERROR = 5;
    static final int BEHAVIOUR_EC_PARAMS_NAME_ONLY_EDWARDS = 6;
    static final int BEHAVIOUR_EC_PARAMS_NAME_ONLY_MONTGOMERY = 7;
    private PKCS11 pkcs11;
    private final String modulePath;
    private Boolean ecPointFixNeeded;
    private Boolean ecdsaSignatureFixNeeded;
    private Boolean sm2SignatureFixNeeded;
    private final Map<PKCS11Constants.Category, VendorMap> vendorMaps = new HashMap<PKCS11Constants.Category, VendorMap>();
    private final Set<Integer> vendorBehaviours = new HashSet<Integer>();
    private static final AtomicBoolean licensePrinted = new AtomicBoolean(false);

    protected PKCS11Module(String modulePath) {
        this.modulePath = Functions.requireNonNull("modulePath", modulePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKCS11Module getInstance(String pkcs11ModulePath) throws IOException {
        AtomicBoolean atomicBoolean = licensePrinted;
        synchronized (atomicBoolean) {
            if (!licensePrinted.get()) {
                StaticLogger.info("This product (ipkcs11wrapper) includes software (IAIK PKCS#11 wrapper version 1.6.8)\ndeveloped by Stiftung SIC which is licensed under \"IAIK PKCS#11 Wrapper License\"- \nA copy of this license is downloadable under \nhttps://jce.iaik.tugraz.at/products/core-crypto-toolkits/pkcs11-wrapper/#License.\nAll other parts are licensed under Apache License, version 2.", new Object[0]);
                licensePrinted.set(true);
            }
        }
        Functions.requireNonNull("pkcs11ModulePath", pkcs11ModulePath);
        File file = new File(pkcs11ModulePath);
        if (!file.exists()) {
            throw new IOException("File " + pkcs11ModulePath + " does not exist");
        }
        if (!file.isFile()) {
            throw new IOException(pkcs11ModulePath + " is not a file");
        }
        if (!file.canRead()) {
            throw new IOException("Can not read file " + pkcs11ModulePath + "");
        }
        return new PKCS11Module(pkcs11ModulePath);
    }

    Boolean getEcPointFixNeeded() {
        return this.ecPointFixNeeded;
    }

    void setEcPointFixNeeded(Boolean ecPointFixNeeded) {
        this.ecPointFixNeeded = ecPointFixNeeded;
    }

    Boolean getEcdsaSignatureFixNeeded() {
        return this.ecdsaSignatureFixNeeded;
    }

    void setEcdsaSignatureFixNeeded(Boolean ecdsaSignatureFixNeeded) {
        this.ecdsaSignatureFixNeeded = ecdsaSignatureFixNeeded;
    }

    Boolean getSm2SignatureFixNeeded() {
        return this.sm2SignatureFixNeeded;
    }

    void setSm2SignatureFixNeeded(Boolean sm2SignatureFixNeeded) {
        this.sm2SignatureFixNeeded = sm2SignatureFixNeeded;
    }

    public ModuleInfo getInfo() throws PKCS11Exception {
        this.assertInitialized();
        try {
            return new ModuleInfo(this.pkcs11.C_GetInfo());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.convertException(ex);
        }
    }

    public void initialize() throws TokenException {
        CK_C_INITIALIZE_ARGS wrapperInitArgs = new CK_C_INITIALIZE_ARGS();
        wrapperInitArgs.flags |= 2L;
        String functionList = "C_GetFunctionList";
        boolean omitInitialize = false;
        StaticLogger.info("C_Initialize: modulePath={}, flags=0x{}", this.modulePath, Functions.toFullHex(wrapperInitArgs.flags));
        try {
            this.pkcs11 = PKCS11.getInstance(this.modulePath, "C_GetFunctionList", wrapperInitArgs, false);
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), ex);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.convertException(ex);
        }
        catch (NoSuchMethodError ex) {
            try {
                Method getInstanceMethod = PKCS11.class.getMethod("getInstance", String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE, MethodHandle.class);
                this.pkcs11 = (PKCS11)getInstanceMethod.invoke(null, this.modulePath, "C_GetFunctionList", wrapperInitArgs, false, null);
            }
            catch (Exception ex1) {
                throw new TokenException(ex1.getMessage(), ex1);
            }
        }
        this.initVendor();
    }

    public Slot[] getSlotList(boolean tokenPresent) throws PKCS11Exception {
        long[] slotIDs;
        this.assertInitialized();
        try {
            slotIDs = this.pkcs11.C_GetSlotList(tokenPresent);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.convertException(ex);
        }
        Slot[] slots = new Slot[slotIDs.length];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = new Slot(this, slotIDs[i]);
        }
        return slots;
    }

    public PKCS11 getPKCS11() {
        this.assertInitialized();
        return this.pkcs11;
    }

    boolean hasVendorBehaviour(int vendorBehavior) {
        return this.vendorBehaviours.contains(vendorBehavior);
    }

    public long genericToVendorCode(PKCS11Constants.Category category, long genericCode) {
        VendorMap map = this.vendorMaps.get((Object)category);
        return map != null ? map.genericToVendor(genericCode) : genericCode;
    }

    public long vendorToGenericCode(PKCS11Constants.Category category, long vendorCode) {
        VendorMap map = this.vendorMaps.get((Object)category);
        return map != null ? map.vendorToGeneric(vendorCode) : vendorCode;
    }

    public String codeToName(PKCS11Constants.Category category, long code) {
        VendorMap map = this.vendorMaps.get((Object)category);
        return map != null ? map.codeToName(code) : PKCS11Constants.codeToName(category, code);
    }

    public Long nameToCode(PKCS11Constants.Category category, String name) {
        VendorMap map = this.vendorMaps.get((Object)category);
        return map != null ? map.nameToCode(name) : PKCS11Constants.nameToCode(category, name);
    }

    public String toString() {
        return this.pkcs11 != null ? this.pkcs11.toString() : "null";
    }

    public PKCS11Exception convertException(sun.security.pkcs11.wrapper.PKCS11Exception e) {
        return new PKCS11Exception(e.getErrorCode());
    }

    public void finalize(Object args) throws PKCS11Exception {
        try {
            this.pkcs11.C_Finalize(args);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.convertException(ex);
        }
    }

    private void assertInitialized() {
        if (this.pkcs11 == null) {
            throw new IllegalStateException("Module not initialized yet, please call initialize() first");
        }
    }

    private void initVendor() {
        block30: {
            try {
                InputStream in;
                ModuleInfo moduleInfo = this.getInfo();
                String manufacturerID = moduleInfo.getManufacturerID();
                String libraryDescription = moduleInfo.getLibraryDescription();
                Version libraryVersion = moduleInfo.getLibraryVersion();
                String confPath = System.getProperty("org.xipki.pkcs11.vendor.conf");
                if (confPath != null) {
                    in = Files.newInputStream(Paths.get(confPath, new String[0]), new OpenOption[0]);
                } else {
                    String path = "org/xipki/pkcs11/wrapper/vendor.conf";
                    in = PKCS11Module.class.getClassLoader().getResourceAsStream(path);
                    if (in == null) {
                        throw new IOException("found no resource " + path);
                    }
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                    VendorConfBlock block;
                    do {
                        if ((block = PKCS11Module.readVendorBlock(br)) != null) continue;
                        break block30;
                    } while (!block.matches(this.modulePath, manufacturerID, libraryDescription, libraryVersion));
                    StaticLogger.info("found <vendor> configuration: {}", block);
                    if (block.vendorBehaviours != null) {
                        StringTokenizer tokenizer = new StringTokenizer(block.vendorBehaviours, ":, \t");
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if ("SM2_SIGNATURE_X962".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(2);
                                continue;
                            }
                            if ("ECDSA_SIGNATURE_X962".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(1);
                                continue;
                            }
                            if ("SM2_PRIVATEKEY_ECPOINT".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(4);
                                continue;
                            }
                            if ("EC_PRIVATEKEY_ECPOINT".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(3);
                                continue;
                            }
                            if ("IGNORE_DEVICE_ERROR".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(5);
                                continue;
                            }
                            if ("EC_PARAMS_NAME_ONLY_EDWARDS".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(6);
                                continue;
                            }
                            if ("EC_PARAMS_NAME_ONLY_MONTGOMERY".equalsIgnoreCase(token)) {
                                this.vendorBehaviours.add(7);
                                continue;
                            }
                            StaticLogger.warn("Ignored unknown vendor behaviour '" + token + "'.", new Object[0]);
                        }
                    }
                    PKCS11Constants.Category[] categories = new PKCS11Constants.Category[]{PKCS11Constants.Category.CKD, PKCS11Constants.Category.CKG_MGF, PKCS11Constants.Category.CKK, PKCS11Constants.Category.CKM, PKCS11Constants.Category.CKP_PRF, PKCS11Constants.Category.CKR, PKCS11Constants.Category.CKU};
                    for (PKCS11Constants.Category category : categories) {
                        this.vendorMaps.put(category, new VendorMap(category));
                    }
                    for (Map.Entry entry : block.nameToCodeMap.entrySet()) {
                        PKCS11Constants.Category category;
                        String name = ((String)entry.getKey()).toUpperCase(Locale.ROOT);
                        PKCS11Constants.Category category2 = name.startsWith("CKD_") ? PKCS11Constants.Category.CKD : (name.startsWith("CKG_") ? PKCS11Constants.Category.CKG_MGF : (name.startsWith("CKK_") ? PKCS11Constants.Category.CKK : (name.startsWith("CKM_") ? PKCS11Constants.Category.CKM : (name.startsWith("CKP_") ? PKCS11Constants.Category.CKP_PRF : (name.startsWith("CKR_") ? PKCS11Constants.Category.CKR : (category = name.startsWith("CKU_") ? PKCS11Constants.Category.CKU : null))))));
                        if (category == null) {
                            throw new IllegalStateException("Unknown name in vendor block: " + name);
                        }
                        this.vendorMaps.get((Object)category).addNameCode(name, ((String)entry.getValue()).toUpperCase(Locale.ROOT));
                    }
                }
            }
            catch (Exception e) {
                StaticLogger.warn("error reading VENDOR code mapping, ignore it.", new Object[0]);
            }
        }
    }

    private static VendorConfBlock readVendorBlock(BufferedReader reader) throws IOException {
        String line;
        boolean inBlock = false;
        VendorConfBlock block = null;
        while ((line = reader.readLine()) != null) {
            String value;
            int idx;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            if (line.startsWith("<vendor>")) {
                block = new VendorConfBlock();
                inBlock = true;
                continue;
            }
            if (line.startsWith("</vendor>")) {
                if (block == null) {
                    throw new IOException("Ending </vendor> does not having the starting <vendor>.");
                }
                block.validate();
                return block;
            }
            if (!inBlock) continue;
            if (line.startsWith("module.")) {
                idx = line.indexOf(32);
                if (idx == -1 || (value = line.substring(idx + 1).trim()).isEmpty()) continue;
                String name = line.substring(0, idx).trim();
                List<String> textList = Arrays.asList(value.toLowerCase(Locale.ROOT).split(":"));
                if (name.equalsIgnoreCase("module.path")) {
                    block.modulePaths = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.mid")) {
                    block.manufacturerIDs = textList;
                    continue;
                }
                if (name.equalsIgnoreCase("module.description")) {
                    block.descriptions = textList;
                    continue;
                }
                if (!name.equalsIgnoreCase("module.version")) continue;
                block.versions = textList;
                continue;
            }
            if (line.startsWith("CKD_") || line.startsWith("CKG_") || line.startsWith("CKU_") || line.startsWith("CKK_") || line.startsWith("CKM_") || line.startsWith("CKR_")) {
                idx = line.indexOf(32);
                if (idx == -1) continue;
                block.nameToCodeMap.put(line.substring(0, idx).trim(), line.substring(idx + 1).trim());
                continue;
            }
            if (!line.startsWith("VENDOR_BEHAVIORS ") || (value = line.substring((idx = line.indexOf(32)) + 1).trim()).isEmpty()) continue;
            block.vendorBehaviours = value;
        }
        return block;
    }

    private static long parseCode(String str) {
        boolean hex = str.startsWith("0X");
        return hex ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
    }

    static {
        String version = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(PKCS11Module.class.getResourceAsStream("version"))));){
            version = reader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        version = version == null ? "UNKNOWN" : version.trim();
        StaticLogger.info("ipkcs11wrapper " + version, new Object[0]);
    }

    private static final class VendorConfBlock {
        private List<String> modulePaths;
        private List<String> manufacturerIDs;
        private List<String> descriptions;
        private List<String> versions;
        private String vendorBehaviours;
        private final Map<String, String> nameToCodeMap = new HashMap<String, String>();

        private VendorConfBlock() {
        }

        void validate() throws IOException {
            if (VendorConfBlock.isEmpty(this.modulePaths) && VendorConfBlock.isEmpty(this.manufacturerIDs) && VendorConfBlock.isEmpty(this.descriptions)) {
                throw new IOException("invalid <vendor>-block");
            }
        }

        boolean matches(String modulePath, String manufacturerID, String libraryDescription, Version libraryVersion) {
            if (!VendorConfBlock.isEmpty(this.modulePaths) && VendorConfBlock.notContains(this.modulePaths, Paths.get(modulePath, new String[0]).getFileName().toString()) || !VendorConfBlock.isEmpty(this.manufacturerIDs) && VendorConfBlock.notContains(this.manufacturerIDs, manufacturerID) || !VendorConfBlock.isEmpty(this.descriptions) && VendorConfBlock.notContains(this.descriptions, libraryDescription)) {
                return false;
            }
            if (VendorConfBlock.isEmpty(this.versions)) {
                return true;
            }
            int iVersion = ((0xFF & libraryVersion.getMajor()) << 8) + (0xFF & libraryVersion.getMinor());
            boolean match = false;
            for (String t : this.versions) {
                int to;
                int idx = t.indexOf("-");
                int from = idx == -1 ? VendorConfBlock.toIntVersion(t) : VendorConfBlock.toIntVersion(t.substring(0, idx));
                int n = to = idx == -1 ? from : VendorConfBlock.toIntVersion(t.substring(idx + 1));
                if (iVersion < from || iVersion > to) continue;
                match = true;
                break;
            }
            return match;
        }

        private static int toIntVersion(String version) {
            StringTokenizer st = new StringTokenizer(version, ".");
            return (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        }

        private static boolean isEmpty(Collection<?> c) {
            return c == null || c.isEmpty();
        }

        private static boolean notContains(List<String> list, String str) {
            str = str.toLowerCase(Locale.ROOT);
            for (String s : list) {
                if (!str.contains(s)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "VendorConfBlock\n  modulePaths:      " + this.modulePaths + "\n  manufacturerIDs:  " + this.manufacturerIDs + "\n  descriptions:     " + this.descriptions + "\n  versions:         " + this.versions + "\n  vendorBehaviours: " + this.vendorBehaviours + "\n  nameToCodeMap:    " + this.nameToCodeMap;
        }
    }

    private static final class VendorMap {
        private final Map<Long, Long> genericToVendorMap = new HashMap<Long, Long>();
        private final Map<Long, Long> vendorToGenericMap = new HashMap<Long, Long>();
        private final Map<Long, String> codeNameMap = new HashMap<Long, String>();
        private final Map<String, Long> nameCodeMap = new HashMap<String, Long>();
        private final PKCS11Constants.Category category;
        private final boolean overwriteAllowed;

        VendorMap(PKCS11Constants.Category category) {
            this.category = category;
            this.overwriteAllowed = category != PKCS11Constants.Category.CKR && category != PKCS11Constants.Category.CKU;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void addNameCode(String name, String code) {
            long lCode = PKCS11Module.parseCode(code);
            Long genericCode = PKCS11Constants.nameToCode(this.category, name);
            if (genericCode != null) {
                if (genericCode == lCode) return;
                if (!this.overwriteAllowed) throw new IllegalArgumentException("Redefinition of " + name + " is not permitted");
                this.genericToVendorMap.put(genericCode, lCode);
                this.vendorToGenericMap.put(lCode, genericCode);
                return;
            } else {
                this.codeNameMap.put(lCode, name);
                this.nameCodeMap.put(name, lCode);
            }
        }

        boolean isEmpty() {
            return this.genericToVendorMap.isEmpty() && this.codeNameMap.isEmpty();
        }

        long genericToVendor(long genericCode) {
            return this.genericToVendorMap.getOrDefault(genericCode, genericCode);
        }

        long vendorToGeneric(long vendorCode) {
            return this.vendorToGenericMap.getOrDefault(vendorCode, vendorCode);
        }

        public String codeToName(long code) {
            return this.codeNameMap.get(code);
        }

        public Long nameToCode(String name) {
            return this.nameCodeMap.get(name);
        }
    }
}

