/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.ConcurrentBag;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Key;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.TokenInfo;

public class PKCS11Token {
    private static final Clock clock = Clock.systemUTC();
    private int maxMessageSize = 2048;
    private final Token token;
    private final Map<Long, MechanismInfo> mechanisms = new HashMap<Long, MechanismInfo>();
    private final long userType;
    private final List<char[]> pins;
    private final int maxSessionCount;
    private final boolean readOnly;
    private long timeOutWaitNewSessionMs = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final ConcurrentBag<Session> sessions = new ConcurrentBag();
    private final Object loginSync = new Object();

    public PKCS11Token(Token token, boolean readOnly, char[] pin) throws TokenException {
        this(token, readOnly, 1L, null, pin == null ? null : Collections.singletonList(pin), null);
    }

    public PKCS11Token(Token token, boolean readOnly, long userType, char[] userName, List<char[]> pins, Integer numSessions) throws TokenException {
        int tokenMaxSessionCount;
        if (userName != null && userName.length != 0) {
            throw new IllegalArgumentException("userName is not null or empty");
        }
        if (numSessions != null && numSessions < 1) {
            throw new IllegalArgumentException("numSession is not valid: " + numSessions);
        }
        this.token = Objects.requireNonNull(token, "token shall not be null");
        this.readOnly = readOnly;
        this.userType = userType;
        this.pins = pins;
        TokenInfo tokenInfo = token.getTokenInfo();
        long lc = tokenInfo.getMaxSessionCount();
        int n = tokenMaxSessionCount = lc > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)lc;
        this.maxSessionCount = numSessions == null ? (tokenMaxSessionCount < 1 ? 32 : Math.min(32, tokenMaxSessionCount)) : (tokenMaxSessionCount < 1 ? numSessions : Math.min(numSessions, tokenMaxSessionCount));
        StaticLogger.info("tokenMaxSessionCount={}, maxSessionCount={}", tokenMaxSessionCount, this.maxSessionCount);
        for (long mech : token.getMechanismList()) {
            try {
                MechanismInfo mechInfo = token.getMechanismInfo(mech);
                this.mechanisms.put(mech, mechInfo);
            }
            catch (Exception e) {
                StaticLogger.warn("error getMechanism for {} (0x{}): {}", token.getSlot().getModule().codeToName(PKCS11Constants.Category.CKM, mech), Functions.toFullHex(mech), e.getMessage());
            }
        }
        Session session = this.openSession();
        this.login(session);
        this.sessions.add(new ConcurrentBag.BagEntry<Session>(session));
    }

    public PKCS11Module getModule() {
        return this.token.getSlot().getModule();
    }

    public void setTimeOutWaitNewSession(int timeOutWaitNewSessionMs) {
        if (timeOutWaitNewSessionMs < 1000) {
            throw new IllegalArgumentException("timeOutWaitNewSessionMs is not greater than 999");
        }
        this.timeOutWaitNewSessionMs = timeOutWaitNewSessionMs;
        StaticLogger.info("timeOutWaitNewSession = {} milli-seconds", timeOutWaitNewSessionMs);
    }

    public void setMaxMessageSize(int maxMessageSize) {
        if (maxMessageSize < 256) {
            throw new IllegalArgumentException("maxMessageSize too small, at least 256 is required: " + maxMessageSize);
        }
        this.maxMessageSize = maxMessageSize % 16 * 16;
    }

    public Set<Long> getMechanisms() {
        return Collections.unmodifiableSet(this.mechanisms.keySet());
    }

    public MechanismInfo getMechanismInfo(long mechanism) {
        return this.mechanisms.get(mechanism);
    }

    public boolean supportsMechanism(long mechanism, long flagBit) {
        MechanismInfo info = this.mechanisms.get(mechanism);
        return info != null && info.hasFlagBit(flagBit);
    }

    public void closeAllSessions() {
        if (this.token != null) {
            try {
                StaticLogger.info("close all sessions on token: {}", this.token.getTokenInfo());
                for (ConcurrentBag.BagEntry<Session> session : this.sessions.values()) {
                    session.value().closeSession();
                }
            }
            catch (Throwable th) {
                StaticLogger.error("error closing sessions, {}", th.getMessage());
            }
        }
        this.sessions.close();
        this.countSessions.lazySet(0L);
    }

    public long getTokenId() {
        return this.token.getTokenID();
    }

    public Token getToken() {
        return this.token;
    }

    public String getModuleInfo() throws TokenException {
        return this.token.getSlot().getModule().getInfo().toString();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logInSecurityOfficer(char[] userName, char[] pin) throws TokenException {
        if (userName != null && userName.length != 0) {
            throw new IllegalArgumentException("userName is not null or empty");
        }
        ConcurrentBag.BagEntry<Session> session0 = this.borrowNoLoginSession();
        Session session = session0.value();
        try {
            this.login(session, 0L, pin == null ? null : Collections.singletonList(pin));
            StaticLogger.info("logIn CKU_SO", new Object[0]);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public void logout() throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            session.logout();
            StaticLogger.info("logout", new Object[0]);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createObject(AttributeVector template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().createObject(template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().createPrivateKeyObject(template, publicKey);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().createECPrivateKeyObject(template, ecPoint);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyObject(long sourceObjectHandle, AttributeVector template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().copyObject(sourceObjectHandle, template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            session0.value().setAttributeValues(objectToUpdateHandle, template);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(long objectHandle) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            session0.value().destroyObject(objectHandle);
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public long[] destroyObjects(long ... objectHandles) throws TokenException {
        ArrayList<Long> list = new ArrayList<Long>(objectHandles.length);
        for (long handle : objectHandles) {
            list.add(handle);
        }
        List<Long> destroyedHandles = this.destroyObjects(list);
        long[] ret = new long[destroyedHandles.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = destroyedHandles.get(i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> destroyObjects(List<Long> objectHandles) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            ArrayList<Long> destroyedHandles = new ArrayList<Long>(objectHandles.size());
            Object object = objectHandles.iterator();
            while (object.hasNext()) {
                long objectHandle = object.next();
                try {
                    session.destroyObject(objectHandle);
                    destroyedHandles.add(objectHandle);
                }
                catch (PKCS11Exception e) {
                    StaticLogger.warn("error destroying object {}: {}", objectHandle, e.getMessage());
                }
            }
            object = destroyedHandles;
            return object;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateUniqueId(AttributeVector template, int idLength, Random random) throws TokenException {
        if (template != null && template.id() != null) {
            throw new IllegalArgumentException("template shall not have CKA_ID");
        }
        if (template == null) {
            template = new AttributeVector();
        }
        byte[] keyId = new byte[idLength];
        template.id(keyId);
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            do {
                random.nextBytes(keyId);
            } while (session.findObjectsSingle(template, 1).length != 0);
            byte[] byArray = keyId;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11Key getKey(PKCS11KeyId keyId) throws TokenException {
        if (keyId == null) {
            return null;
        }
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            PKCS11Key pKCS11Key = this.getKey(session, keyId);
            return pKCS11Key;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11Key getKey(AttributeVector criteria) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            PKCS11KeyId keyId = this.getKeyId(session, criteria);
            PKCS11Key pKCS11Key = keyId == null ? null : this.getKey(session, keyId);
            return pKCS11Key;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private PKCS11Key getKey(Session session, PKCS11KeyId keyId) throws TokenException {
        long objClass = keyId.getObjectCLass();
        long keyType = keyId.getKeyType();
        LinkedList<Long> ckaTypes = new LinkedList<Long>();
        if (objClass == 4L || objClass == 3L) {
            PKCS11Token.addCkaTypes(ckaTypes, 354L, 356L, 2L, 261L, 264L, 263L, 528L, 259L, 357L);
            if (objClass == 4L) {
                PKCS11Token.addCkaTypes(ckaTypes, 260L, 134L, 266L, 262L);
                if (keyType != 19L && keyType != 20L && keyType != 21L) {
                    ckaTypes.add(353L);
                }
            } else {
                PKCS11Token.addCkaTypes(ckaTypes, 514L, 265L);
                if (keyType == 0L) {
                    PKCS11Token.addCkaTypes(ckaTypes, 288L, 290L);
                } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                    ckaTypes.add(384L);
                } else if (keyType == 1L) {
                    PKCS11Token.addCkaTypes(ckaTypes, 304L, 305L, 306L);
                }
            }
        } else {
            PKCS11Token.addCkaTypes(ckaTypes, 260L, 134L, 266L, 267L, 262L);
            if (keyType == 0L) {
                PKCS11Token.addCkaTypes(ckaTypes, 288L, 290L);
            } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                PKCS11Token.addCkaTypes(ckaTypes, 384L, 385L);
            } else if (keyType == 1L) {
                PKCS11Token.addCkaTypes(ckaTypes, 304L, 305L, 306L);
            }
        }
        AttributeVector attrs = session.getAttrValues(keyId.getHandle(), ckaTypes);
        return new PKCS11Key(keyId, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11KeyId getKeyId(AttributeVector criteria) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            PKCS11KeyId pKCS11KeyId = this.getKeyId(session, criteria);
            return pKCS11KeyId;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private PKCS11KeyId getKeyId(Session session, AttributeVector criteria) throws TokenException {
        byte[] id = criteria.id();
        String label = criteria.label();
        if (!(id != null && id.length != 0 || label != null && !label.isEmpty())) {
            return null;
        }
        Long oClass = criteria.class_();
        if (oClass != null) {
            if (3L != oClass && 2L != oClass && 4L != oClass) {
                return null;
            }
            long[] handles = session.findObjectsSingle(criteria, 2);
            if (handles.length == 0) {
                return null;
            }
            if (handles.length > 1) {
                throw new TokenException("found more than 1 key for the criteria " + criteria);
            }
            return this.getKeyIdByHandle(session, handles[0]);
        }
        oClass = 3L;
        long[] handles = session.findObjectsSingle(criteria.class_(oClass), 2);
        if (handles.length == 0 && (handles = session.findObjectsSingle(criteria.class_(oClass = Long.valueOf(4L)), 2)).length == 0) {
            oClass = 2L;
            handles = session.findObjectsSingle(criteria.class_(oClass), 2);
        }
        if (handles.length == 0) {
            return null;
        }
        if (handles.length > 1) {
            throw new TokenException("found more than 1 key of " + PKCS11Constants.ckoCodeToName(oClass) + " for the criteria " + criteria.class_(null));
        }
        return this.getKeyIdByHandle(session, handles[0]);
    }

    private PKCS11KeyId getKeyIdByHandle(Session session, long hKey) throws TokenException {
        AttributeVector attrs = session.getAttrValues(hKey, 0L, 256L, 258L, 3L);
        Long oClass = attrs.class_();
        Long keyType = attrs.keyType();
        if (oClass == null || keyType == null) {
            return null;
        }
        byte[] id = attrs.id();
        PKCS11KeyId ret = new PKCS11KeyId(hKey, oClass, keyType, id, attrs.label());
        if (oClass == 3L) {
            long[] pubKeyHandles = session.findObjectsSingle(AttributeVector.newPublicKey(keyType).id(id), 2);
            if (pubKeyHandles.length == 1) {
                ret.setPublicKeyHandle(pubKeyHandles[0]);
            } else if (pubKeyHandles.length > 1) {
                StaticLogger.warn("found more than 1 public key for the private key {}, ignore them.", hKey);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findAllObjects(AttributeVector template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long[] lArray = session0.value().findAllObjectsSingle(template);
            return lArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findObjects(AttributeVector template, int maxObjectCount) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long[] lArray = session0.value().findObjectsSingle(template, maxObjectCount);
            return lArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public int encrypt(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws TokenException {
        return this.encrypt(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encrypt(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            this.opInit(OP.ENCRYPT, session, mechanism, keyHandle);
            if (inLen <= this.maxMessageSize) {
                int n = session.encrypt(in, inOfs, inLen, out, outOfs, outLen);
                return n;
            }
            int origOutOfs = outOfs;
            int endInOfs = inOfs + inLen;
            int endOutOfs = outOfs + outLen;
            try {
                for (int ofs = inOfs; ofs < endInOfs; ofs += this.maxMessageSize) {
                    int ciphertextPartLen = session.encryptUpdate(in, ofs, Math.min(this.maxMessageSize, endInOfs - ofs), out, outOfs, endOutOfs - outOfs);
                    outOfs += ciphertextPartLen;
                }
            }
            finally {
                int ciphertextPartLen = session.encryptFinal(out, outOfs, endOutOfs - outOfs);
                outOfs += ciphertextPartLen;
            }
            int n = outOfs - origOutOfs;
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encrypt(OutputStream out, Mechanism mechanism, long keyHandle, InputStream plaintext) throws TokenException, IOException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            int resLen;
            int estimatedResLen;
            byte[] outBuffer = new byte[this.maxMessageSize + 256];
            byte[] buffer = new byte[this.maxMessageSize];
            int inSum = 0;
            int outSum = 0;
            this.opInit(OP.ENCRYPT, session, mechanism, keyHandle);
            try {
                int read;
                while ((read = plaintext.read(buffer)) != -1) {
                    estimatedResLen = this.maxMessageSize + 32 + (inSum - outSum);
                    if (outBuffer.length < estimatedResLen) {
                        outBuffer = new byte[estimatedResLen];
                    }
                    if (read <= 0) continue;
                    inSum += read;
                    resLen = session.encryptUpdate(buffer, 0, read, outBuffer, 0, outBuffer.length);
                    outSum += resLen;
                    if (resLen <= 0) continue;
                    out.write(outBuffer, 0, resLen);
                }
            }
            finally {
                estimatedResLen = this.maxMessageSize + 32 + (inSum - outSum);
                if (outBuffer.length < estimatedResLen) {
                    outBuffer = new byte[estimatedResLen];
                }
                resLen = session.encryptFinal(outBuffer, 0, outBuffer.length);
                outSum += resLen;
                if (resLen > 0) {
                    out.write(outBuffer, 0, resLen);
                }
            }
            int n = outSum;
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public int decrypt(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws TokenException {
        return this.decrypt(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrypt(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            this.opInit(OP.DECRYPT, session, mechanism, keyHandle);
            int n = session.decrypt(in, inOfs, inLen, out, outOfs, outLen);
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrypt(OutputStream out, Mechanism mechanism, long keyHandle, InputStream ciphertext) throws TokenException, IOException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] ciphertextBytes = PKCS11Token.readAllBytes(ciphertext);
            byte[] plaintextBytes = new byte[ciphertextBytes.length];
            this.opInit(OP.DECRYPT, session, mechanism, keyHandle);
            int plaintextLen = session.decrypt(ciphertextBytes, plaintextBytes);
            out.write(plaintextBytes, 0, plaintextLen);
            int n = plaintextLen;
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public byte[] digest(Mechanism mechanism, byte[] in) throws TokenException {
        return this.digest(mechanism, in, 0, in.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(Mechanism mechanism, byte[] in, int inOfs, int inLen) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            int outLen;
            int digestLen = PKCS11Token.estimateDigestLen(mechanism);
            byte[] digest = new byte[digestLen];
            this.opInit(OP.DIGEST, session, mechanism, 0L);
            if (inLen < this.maxMessageSize) {
                outLen = session.digest(in, inOfs, inLen, digest, 0, digestLen);
            } else {
                try {
                    int endInOfs = inOfs + inLen;
                    for (int ofs = inOfs; ofs < endInOfs; ofs += this.maxMessageSize) {
                        session.signUpdate(in, ofs, Math.min(this.maxMessageSize, endInOfs - ofs));
                    }
                }
                finally {
                    outLen = session.digestFinal(digest, 0, digestLen);
                }
            }
            byte[] byArray = outLen == digestLen ? digest : Arrays.copyOf(digest, outLen);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digestKey(Mechanism mechanism, long keyHandle) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] digest;
            this.opInit(OP.DIGEST, session, mechanism, 0L);
            try {
                session.digestKey(keyHandle);
            }
            finally {
                int digestLen = PKCS11Token.estimateDigestLen(mechanism);
                digest = new byte[digestLen];
                int len = session.digestFinal(digest, 0, digest.length);
                if (len != digestLen) {
                    digest = Arrays.copyOf(digest, len);
                }
            }
            byte[] byArray = digest;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(Mechanism mechanism, InputStream data) throws TokenException, IOException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            int outLen;
            byte[] buffer = new byte[this.maxMessageSize];
            int digestLen = PKCS11Token.estimateDigestLen(mechanism);
            byte[] digest = new byte[digestLen];
            this.opInit(OP.DIGEST, session, mechanism, 0L);
            try {
                int read;
                while ((read = data.read(buffer)) != -1) {
                    if (read <= 0) continue;
                    session.digestUpdate(PKCS11Token.copyOfLen(buffer, read));
                }
            }
            finally {
                outLen = session.digestFinal(digest, 0, digestLen);
            }
            byte[] byArray = outLen == digestLen ? digest : Arrays.copyOf(digest, outLen);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public byte[] sign(Mechanism mechanism, long keyHandle, byte[] in) throws TokenException {
        return this.sign(mechanism, keyHandle, in, 0, in.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] signature;
            this.opInit(OP.SIGN, session, mechanism, keyHandle);
            if (inLen < this.maxMessageSize) {
                byte[] byArray = session.sign(PKCS11Token.copyOfLen(in, inOfs, inLen));
                return byArray;
            }
            int endInOfs = inOfs + inLen;
            try {
                for (int ofs = inOfs; ofs < endInOfs; ofs += this.maxMessageSize) {
                    session.signUpdate(in, ofs, Math.min(this.maxMessageSize, endInOfs - ofs));
                }
            }
            finally {
                signature = session.signFinal();
            }
            byte[] byArray = signature;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(Mechanism mechanism, long keyHandle, InputStream data) throws TokenException, IOException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] signature;
            byte[] buffer;
            block13: {
                buffer = new byte[this.maxMessageSize];
                int firstBlockLen = PKCS11Token.readBytes(data, buffer, this.maxMessageSize);
                byte[] firstBlock = PKCS11Token.copyOfLen(buffer, firstBlockLen);
                this.opInit(OP.SIGN, session, mechanism, keyHandle);
                if (firstBlockLen < this.maxMessageSize) {
                    byte[] byArray = session.sign(firstBlock);
                    return byArray;
                }
                try {
                    session.signUpdate(firstBlock);
                }
                catch (PKCS11Exception e) {
                    int read;
                    if (e.getErrorCode() != 145L) break block13;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream(this.maxMessageSize + data.available());
                    bout.write(firstBlock);
                    while ((read = data.read(buffer)) != -1) {
                        bout.write(buffer, 0, read);
                    }
                    this.opInit(OP.SIGN, session, mechanism, keyHandle);
                    byte[] byArray = session.sign(bout.toByteArray());
                    this.sessions.requite(session0);
                    return byArray;
                }
            }
            try {
                int read;
                while ((read = data.read(buffer)) != -1) {
                    if (read <= 0) continue;
                    session.signUpdate(PKCS11Token.copyOfLen(buffer, read));
                }
            }
            finally {
                signature = session.signFinal();
            }
            byte[] byArray = signature;
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public int signRecover(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws TokenException {
        return this.signRecover(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int signRecover(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            Session session = session0.value();
            this.opInit(OP.SIGN_RECOVER, session, mechanism, keyHandle);
            int n = session.signRecover(in, inOfs, inLen, out, outOfs, outLen);
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean verify(Mechanism mechanism, long keyHandle, byte[] data, byte[] signature) throws TokenException {
        block23: {
            session0 = this.borrowSession();
            session = session0.value();
            len = data.length;
            code = mechanism.getMechanismCode();
            if (!this.supportsMechanism(code, 8192L)) break block23;
            try {
                this.opInit(OP.VERIFY, session, mechanism, keyHandle);
                if (len <= this.maxMessageSize) {
                    session.verify(data, signature);
                } else {
                    try {
                        try {
                            for (ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                                session.verifyUpdate(PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)));
                            }
                        }
                        finally {
                            session.verifyFinal(signature);
                        }
                    }
                    catch (PKCS11Exception e) {
                        if (e.getErrorCode() == 145L) {
                            this.opInit(OP.VERIFY, session, mechanism, keyHandle);
                            session.verify(data, signature);
                        }
                        throw e;
                    }
                }
                e = true;
                return e;
            }
            catch (PKCS11Exception e) {
                block25: {
                    ckr = e.getErrorCode();
                    if (ckr != 192L && ckr != 193L) break block25;
                    var14_17 = false;
                    this.sessions.requite(session0);
                    return var14_17;
                }
                throw e;
            }
        }
        if (!this.supportsMechanism(code, 2048L) || !PKCS11Token.isMacMechanism(code)) ** GOTO lbl-1000
        this.opInit(OP.SIGN, session, mechanism, keyHandle);
        if (len <= this.maxMessageSize) {
            sig2 = session.sign(data);
        } else {
            try {
                for (ofs = 0; ofs < len; ofs += this.maxMessageSize) {
                    session.signUpdate(PKCS11Token.copyOfLen(data, ofs, Math.min(this.maxMessageSize, len - ofs)));
                }
            }
            finally {
                sig2 = session.signFinal();
            }
        }
        var12_16 = Arrays.equals(signature, sig2);
        return var12_16;
lbl-1000:
        // 1 sources

        {
            throw new PKCS11Exception(112L);
            {
                catch (Throwable var16_19) {
                    throw var16_19;
                }
            }
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(Mechanism mechanism, long keyHandle, InputStream data, byte[] signature) throws TokenException, IOException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            byte[] buffer = new byte[this.maxMessageSize];
            int firstBlockLen = PKCS11Token.readBytes(data, buffer, this.maxMessageSize);
            byte[] firstBlock = PKCS11Token.copyOfLen(buffer, firstBlockLen);
            long code = mechanism.getMechanismCode();
            if (this.supportsMechanism(code, 8192L)) {
                boolean read;
                block27: {
                    this.opInit(OP.VERIFY, session, mechanism, keyHandle);
                    if (firstBlockLen < this.maxMessageSize) {
                        session.verify(firstBlock, signature);
                        boolean bl = true;
                        return bl;
                    }
                    try {
                        session.verifyUpdate(firstBlock);
                    }
                    catch (PKCS11Exception e) {
                        int read2;
                        if (e.getErrorCode() != 145L) break block27;
                        ByteArrayOutputStream bout = new ByteArrayOutputStream(this.maxMessageSize + data.available());
                        bout.write(firstBlock);
                        while ((read2 = data.read(buffer)) != -1) {
                            bout.write(buffer, 0, read2);
                        }
                        this.opInit(OP.VERIFY, session, mechanism, keyHandle);
                        session.verify(bout.toByteArray(), signature);
                        boolean bl = true;
                        this.sessions.requite(session0);
                        return bl;
                    }
                }
                try {
                    while (!(read = data.read(buffer))) {
                        if (read <= false) continue;
                        session.verifyUpdate(PKCS11Token.copyOfLen(buffer, read ? 1 : 0));
                    }
                }
                finally {
                    session.verifyFinal(signature);
                }
                read = true;
                return read;
            }
            if (this.supportsMechanism(code, 2048L) && PKCS11Token.isMacMechanism(code)) {
                byte[] sig2;
                this.opInit(OP.SIGN, session, mechanism, keyHandle);
                if (firstBlockLen < this.maxMessageSize) {
                    sig2 = session.sign(firstBlock);
                } else {
                    try {
                        int read;
                        session.signUpdate(firstBlock);
                        while ((read = data.read(buffer)) != -1) {
                            if (read <= 0) continue;
                            session.signUpdate(buffer, 0, read);
                        }
                    }
                    finally {
                        sig2 = session.signFinal();
                    }
                }
                boolean bl = Arrays.equals(signature, sig2);
                return bl;
            }
            try {
                throw new PKCS11Exception(112L);
            }
            catch (PKCS11Exception e) {
                long ckr = e.getErrorCode();
                if (ckr == 192L || ckr == 193L) {
                    boolean bl = false;
                    return bl;
                }
                throw e;
            }
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public int verifyRecover(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws TokenException {
        return this.verifyRecover(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verifyRecover(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            Session session = session0.value();
            this.opInit(OP.VERIFY_RECOVER, session, mechanism, keyHandle);
            int n = session.verifyRecover(in, inOfs, inLen, out, outOfs, outLen);
            return n;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long generateKey(Mechanism mechanism, AttributeVector template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().generateKey(mechanism, template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            PKCS11KeyPair pKCS11KeyPair = session0.value().generateKeyPair(mechanism, template);
            return pKCS11KeyPair;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            byte[] byArray = session0.value().wrapKey(mechanism, wrappingKeyHandle, keyHandle);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().unwrapKey(mechanism, unwrappingKeyHandle, wrappedKey, keyTemplate);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            long l = session0.value().deriveKey(mechanism, baseKeyHandle, template);
            return l;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws TokenException {
        return this.generateRandom(numberOfBytesToGenerate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateRandom(int numberOfBytesToGenerate, byte[] extraSeed) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        Session session = session0.value();
        try {
            if (extraSeed != null && extraSeed.length > 0) {
                session.seedRandom(extraSeed);
            }
            byte[] byArray = session.generateRandom(numberOfBytesToGenerate);
            return byArray;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    public String toString() {
        return "User type: " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, this.userType) + "\nMaximal session count: " + this.maxSessionCount + "\nNew session timeout: " + this.timeOutWaitNewSessionMs + " ms\nRead only: " + this.readOnly + "\nToken: " + this.token;
    }

    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws TokenException {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        return this.getAttrValues(objectHandle, typeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getAttrValues(long objectHandle, List<Long> attributeTypes) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            AttributeVector attributeVector = session0.value().getAttrValues(objectHandle, attributeTypes);
            return attributeVector;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getDefaultAttrValues(long objectHandle) throws TokenException {
        ConcurrentBag.BagEntry<Session> session0 = this.borrowSession();
        try {
            AttributeVector attributeVector = session0.value().getDefaultAttrValues(objectHandle);
            return attributeVector;
        }
        finally {
            this.sessions.requite(session0);
        }
    }

    private Session openSession() throws PKCS11Exception {
        Session session = this.token.openSession(!this.readOnly);
        this.countSessions.incrementAndGet();
        return session;
    }

    private ConcurrentBag.BagEntry<Session> borrowSession() throws TokenException {
        return this.borrowSession(true);
    }

    private ConcurrentBag.BagEntry<Session> borrowNoLoginSession() throws TokenException {
        return this.borrowSession(false);
    }

    private ConcurrentBag.BagEntry<Session> borrowSession(boolean login) throws TokenException {
        long maxTimeMs = clock.millis() + this.timeOutWaitNewSessionMs;
        int maxTries = this.maxSessionCount + 1;
        for (int retries = 0; retries < maxTries; ++retries) {
            ConcurrentBag.BagEntry<Session> sessionBagEntry = this.borrowSession(login, maxTimeMs);
            if (sessionBagEntry == null) continue;
            if (retries != 0) {
                StaticLogger.info("Borrowed session after " + (retries + 1) + " tries.", new Object[0]);
            }
            return sessionBagEntry;
        }
        throw new TokenException("could not borrow session after " + maxTries + " tries.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentBag.BagEntry<Session> borrowSession(boolean login, long maxTimeMs) throws TokenException {
        if (maxTimeMs == 0L) {
            maxTimeMs = clock.millis() + this.timeOutWaitNewSessionMs;
        }
        ConcurrentBag.BagEntry<Session> session = null;
        ConcurrentBag<Session> concurrentBag = this.sessions;
        synchronized (concurrentBag) {
            if (this.countSessions.get() < (long)this.maxSessionCount) {
                try {
                    session = this.sessions.borrow(1L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (session == null) {
                    this.sessions.add(new ConcurrentBag.BagEntry<Session>(this.openSession()));
                }
            }
        }
        if (session == null) {
            long timeOutMs = maxTimeMs - clock.millis();
            try {
                session = this.sessions.borrow(Math.max(1L, timeOutMs), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new TokenException("no idle session");
        }
        boolean requiteSession = true;
        try {
            long deviceError2;
            boolean sessionActive = true;
            SessionInfo sessionInfo = null;
            try {
                sessionInfo = session.value().getSessionInfo();
            }
            catch (PKCS11Exception ex) {
                long ckr = ex.getErrorCode();
                if (ckr == 176L || ckr == 179L) {
                    sessionActive = false;
                }
                StaticLogger.warn("error getSessionInfo: {}", PKCS11Constants.ckrCodeToName(ckr));
            }
            if (sessionActive && sessionInfo != null && (deviceError2 = sessionInfo.getDeviceError()) != 0L) {
                if (this.getModule().hasVendorBehaviour(5)) {
                    StaticLogger.warn("ignore device error {}", deviceError2);
                } else {
                    sessionActive = false;
                    StaticLogger.error("device has error {}", deviceError2);
                }
            }
            if (!sessionActive) {
                requiteSession = false;
                this.sessions.remove(session);
                this.countSessions.decrementAndGet();
                ConcurrentBag.BagEntry<Session> deviceError2 = null;
                return deviceError2;
            }
            if (login) {
                boolean loggedIn = false;
                if (sessionInfo != null) {
                    long state = sessionInfo.getState();
                    boolean bl = loggedIn = state == 4L || state == 3L || state == 1L;
                }
                if (!loggedIn) {
                    Object object = this.loginSync;
                    synchronized (object) {
                        try {
                            sessionInfo = session.value().getSessionInfo();
                            loggedIn = PKCS11Token.isSessionLoggedIn(sessionInfo);
                        }
                        catch (Exception e) {
                            StaticLogger.debug("Error while getSessionInfo()", e);
                        }
                        if (!loggedIn) {
                            this.login(session.value());
                        }
                    }
                }
            }
            requiteSession = false;
            ConcurrentBag.BagEntry<Session> bagEntry = session;
            return bagEntry;
        }
        finally {
            if (requiteSession) {
                this.sessions.requite(session);
            }
        }
    }

    private static boolean isSessionLoggedIn(SessionInfo sessionInfo) {
        long state = sessionInfo.getState();
        return state == 4L || state == 3L || state == 1L;
    }

    private void login(Session session) throws TokenException {
        this.login(session, this.userType, this.pins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(Session session, long userType, List<char[]> pins) throws TokenException {
        Object object = this.loginSync;
        synchronized (object) {
            Object pin;
            StaticLogger.info("verify on PKCS11Module with " + (pins == null || pins.isEmpty() ? "NULL pin" : "pin"), new Object[0]);
            String userText = "user of type " + PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, userType);
            boolean nullPins = pins == null || pins.isEmpty() ? true : (pins.size() == 1 ? (pin = (Object)pins.get(0)) == null || ((Object)pin).length == 0 : false);
            try {
                if (nullPins) {
                    session.login(userType, new char[0]);
                    StaticLogger.info("login successful as " + userText + " with NULL PIN", new Object[0]);
                } else {
                    for (char[] pin2 : pins) {
                        session.login(userType, pin2 == null ? new char[]{} : pin2);
                    }
                    StaticLogger.info("login successful as " + userText + " with PIN", new Object[0]);
                }
            }
            catch (PKCS11Exception ex) {
                long ckr = ex.getErrorCode();
                if (ckr == 256L) {
                    StaticLogger.info("user already logged in", new Object[0]);
                }
                StaticLogger.warn("login failed as {}: {}", userText, PKCS11Constants.ckrCodeToName(ckr));
                throw ex;
            }
        }
    }

    private void opInit(OP op, Session session, Mechanism mechanism, long keyHandle) throws TokenException {
        block2: {
            try {
                this.opInit0(op, session, mechanism, keyHandle);
            }
            catch (PKCS11Exception ex) {
                if (ex.getErrorCode() != 257L) break block2;
                this.login(session);
                this.opInit0(op, session, mechanism, keyHandle);
            }
        }
    }

    private void opInit0(OP op, Session session, Mechanism mechanism, long keyHandle) throws TokenException {
        switch (op) {
            case SIGN: {
                session.signInit(mechanism, keyHandle);
                break;
            }
            case VERIFY: {
                session.verifyInit(mechanism, keyHandle);
                break;
            }
            case DECRYPT: {
                session.decryptInit(mechanism, keyHandle);
                break;
            }
            case ENCRYPT: {
                session.encryptInit(mechanism, keyHandle);
                break;
            }
            case DIGEST: {
                session.digestInit(mechanism);
                break;
            }
            case SIGN_RECOVER: {
                session.signRecoverInit(mechanism, keyHandle);
                break;
            }
            case VERIFY_RECOVER: {
                session.verifyRecoverInit(mechanism, keyHandle);
                break;
            }
            default: {
                throw new IllegalStateException("unknown OP " + (Object)((Object)op));
            }
        }
    }

    private static byte[] copyOfLen(byte[] bytes, int len) {
        return bytes.length == len ? bytes : Arrays.copyOf(bytes, len);
    }

    private static byte[] copyOfLen(byte[] bytes, int offset, int len) {
        return offset == 0 && bytes.length == len ? bytes : Arrays.copyOfRange(bytes, offset, offset + len);
    }

    private static int estimateDigestLen(Mechanism mechanism) {
        long mechCode = mechanism.getMechanismCode();
        int digestLen = mechCode == 544L ? 20 : (mechCode == 597L || mechCode == 693L ? 28 : (mechCode == 592L || mechCode == 688L || mechCode == 0xFFFFF005L ? 32 : (mechCode == 608L || mechCode == 704L ? 48 : (mechCode == 624L || mechCode == 720L ? 64 : 64))));
        return digestLen;
    }

    private static byte[] readAllBytes(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(Math.min(32, stream.available()));
        byte[] buffer = new byte[4096];
        while ((read = stream.read(buffer)) != -1) {
            bout.write(buffer, 0, read);
        }
        return bout.toByteArray();
    }

    private static int readBytes(InputStream stream, byte[] buffer, int numBytes) throws IOException {
        int read;
        int ofs = 0;
        while ((read = stream.read(buffer, ofs, numBytes - ofs)) != -1 && (ofs += read) < numBytes) {
        }
        return ofs;
    }

    private static boolean isMacMechanism(long mechanism) {
        return mechanism == 4234L || mechanism == 4238L || mechanism == 545L || mechanism == 598L || mechanism == 593L || mechanism == 609L || mechanism == 625L || mechanism == 694L || mechanism == 689L || mechanism == 705L || mechanism == 721L || mechanism == 599L || mechanism == 594L || mechanism == 610L || mechanism == 626L || mechanism == 695L || mechanism == 690L || mechanism == 706L || mechanism == 722L;
    }

    private static void addCkaTypes(List<Long> list, long ... types) {
        for (long type : types) {
            list.add(type);
        }
    }

    private static enum OP {
        DIGEST,
        SIGN,
        VERIFY,
        ENCRYPT,
        DECRYPT,
        SIGN_RECOVER,
        VERIFY_RECOVER;

    }
}

