/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.SessionInfo;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.Util;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import org.xipki.pkcs11.wrapper.attrs.BooleanAttribute;
import org.xipki.pkcs11.wrapper.attrs.ByteArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.CharArrayAttribute;
import org.xipki.pkcs11.wrapper.attrs.LongAttribute;
import org.xipki.pkcs11.wrapper.attrs.MechanismArrayAttribute;
import org.xipki.pkcs11.wrapper.params.CkParamsWithExtra;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11;

public class Session {
    private static final byte[] OID_curve25519 = Functions.encodeOid("1.3.101.110");
    private static final byte[] OID_curve448 = Functions.encodeOid("1.3.101.111");
    private static final byte[] OID_edwards25519 = Functions.encodeOid("1.3.101.112");
    private static final byte[] OID_edwards448 = Functions.encodeOid("1.3.101.113");
    private static final byte[] NAME_curve25519 = Functions.decodeHex("130a63757276653235353139");
    private static final byte[] NAME_curve448 = Functions.decodeHex("13086375727665343438");
    private static final byte[] NAME_edwards25519 = Functions.decodeHex("130c656477617264733235353139");
    private static final byte[] NAME_edwards448 = Functions.decodeHex("130a65647761726473343438");
    private static final int SIGN_TYPE_ECDSA = 1;
    private static final int SIGN_TYPE_SM2 = 2;
    private static final Method encrypt0;
    private static final Method encrypt1;
    private static final Method decrypt0;
    private static final Method decrypt1;
    private final PKCS11Module module;
    private final PKCS11 pkcs11;
    private long sessionHandle;
    private final Token token;
    private int signatureType;
    private long signOrVerifyKeyHandle;
    private ExtraParams signVerifyExtraParams;

    protected Session(Token token, long sessionHandle) {
        this.token = Functions.requireNonNull("token", token);
        this.module = token.getSlot().getModule();
        this.pkcs11 = this.module.getPKCS11();
        this.sessionHandle = sessionHandle;
    }

    public void closeSession() throws PKCS11Exception {
        String method = "C_CloseSession";
        try {
            this.debugIn("C_CloseSession");
            this.pkcs11.C_CloseSession(this.sessionHandle);
            this.debugOut("C_CloseSession");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_CloseSession", ex);
            throw this.module.convertException(ex);
        }
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public SessionInfo getSessionInfo() throws PKCS11Exception {
        try {
            return new SessionInfo(this.pkcs11.C_GetSessionInfo(this.sessionHandle));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.module.convertException(ex);
        }
    }

    public PKCS11Module getModule() {
        return this.module;
    }

    public Token getToken() {
        return this.token;
    }

    public byte[] getOperationState() throws PKCS11Exception {
        try {
            return this.pkcs11.C_GetOperationState(this.sessionHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.module.convertException(ex);
        }
    }

    public void setOperationState(byte[] operationState, long encryptionKeyHandle, long authenticationKeyHandle) throws PKCS11Exception {
        try {
            this.pkcs11.C_SetOperationState(this.sessionHandle, operationState, encryptionKeyHandle, authenticationKeyHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.module.convertException(ex);
        }
    }

    public void setSessionHandle(long sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public void login(long userType, char[] pin) throws PKCS11Exception {
        String method = "C_Login";
        if (StaticLogger.isDebugEnabled()) {
            this.debugIn("C_Login", "userType={}", PKCS11Constants.codeToName(PKCS11Constants.Category.CKU, userType));
        }
        try {
            this.pkcs11.C_Login(this.sessionHandle, userType, pin);
            this.debugOut("C_Login");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_Login", ex);
            throw this.module.convertException(ex);
        }
    }

    public void logout() throws PKCS11Exception {
        String method = "C_Logout";
        this.debugIn("C_Logout");
        try {
            this.pkcs11.C_Logout(this.sessionHandle);
            this.debugOut("C_Logout");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_Logout", ex);
            throw this.module.convertException(ex);
        }
    }

    public long createObject(AttributeVector template) throws PKCS11Exception {
        String method = "C_CreateObject";
        if (StaticLogger.isDebugEnabled()) {
            long objClass = template.class_();
            if (objClass == 3L || objClass == 4L) {
                template.attributesAsSensitive(17L, 291L, 292L, 293L, 294L, 295L, 296L);
            }
            this.debugIn("C_CreateObject", "template={}", template);
        }
        try {
            long hObject = this.pkcs11.C_CreateObject(this.sessionHandle, this.toOutCKAttributes(template));
            this.debugOut("C_CreateObject", "hObject={}", hObject);
            this.traceObject("created object", hObject);
            return hObject;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_CreateObject", ex);
            throw this.module.convertException(ex);
        }
    }

    public long createPrivateKeyObject(AttributeVector template, PublicKey publicKey) throws PKCS11Exception {
        if (publicKey instanceof ECPublicKey && this.privateKeyWithEcPoint(template.keyType())) {
            byte[] ecParams = template.ecParams();
            Integer fieldSize = Functions.getECFieldSize(ecParams);
            ECPoint w = ((ECPublicKey)publicKey).getW();
            byte[] wx = Functions.asUnsignedByteArray(w.getAffineX());
            byte[] wy = Functions.asUnsignedByteArray(w.getAffineY());
            if (fieldSize == null) {
                fieldSize = Math.max(wx.length, wy.length);
            } else if (wx.length > fieldSize || wy.length > fieldSize) {
                throw new IllegalStateException("should not happen, public key and ecParams do not match");
            }
            byte[] ecPoint = new byte[1 + 2 * fieldSize];
            ecPoint[0] = 4;
            System.arraycopy(wx, 0, ecPoint, 1 + fieldSize - wx.length, wx.length);
            System.arraycopy(wy, 0, ecPoint, ecPoint.length - wy.length, wy.length);
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    public long createECPrivateKeyObject(AttributeVector template, byte[] ecPoint) throws PKCS11Exception {
        if (ecPoint != null && this.privateKeyWithEcPoint(template.keyType())) {
            template.ecPoint(ecPoint);
        }
        return this.createObject(template);
    }

    private boolean privateKeyWithEcPoint(Long keyType) {
        if (keyType == null) {
            return false;
        }
        if (3L == keyType) {
            return this.module.hasVendorBehaviour(3);
        }
        if (0xFFFFF001L == keyType) {
            return this.module.hasVendorBehaviour(4);
        }
        return false;
    }

    public long copyObject(long sourceObjectHandle, AttributeVector template) throws PKCS11Exception {
        String method = "C_CopyObject";
        this.debugIn("C_CopyObject", "sourceObjectHandle={}, template={}", sourceObjectHandle, template);
        try {
            long hObject = this.pkcs11.C_CopyObject(this.sessionHandle, sourceObjectHandle, this.toOutCKAttributes(template));
            this.debugOut("C_CopyObject", "hObject={}", hObject);
            this.traceObject("copied object", hObject);
            return hObject;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_CopyObject", ex);
            throw this.module.convertException(ex);
        }
    }

    public void setAttributeValues(long objectToUpdateHandle, AttributeVector template) throws PKCS11Exception {
        String method = "C_SetAttributeValue";
        this.debugIn("C_SetAttributeValue", "objectToUpdateHandle={}, template={}", objectToUpdateHandle, template);
        try {
            this.pkcs11.C_SetAttributeValue(this.sessionHandle, objectToUpdateHandle, this.toOutCKAttributes(template));
            this.debugOut("C_SetAttributeValue");
            this.traceObject("object (after settingAttributeValues)", objectToUpdateHandle);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_SetAttributeValue", ex);
            throw this.module.convertException(ex);
        }
    }

    public void destroyObject(long objectHandle) throws PKCS11Exception {
        String method = "C_DestroyObject";
        this.debugIn("C_DestroyObject", "objectHandle={}", objectHandle);
        try {
            this.pkcs11.C_DestroyObject(this.sessionHandle, objectHandle);
            this.debugOut("C_DestroyObject");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DestroyObject", ex);
            throw this.module.convertException(ex);
        }
    }

    public void findObjectsInit(AttributeVector template) throws PKCS11Exception {
        String method = "C_FindObjectsInit";
        this.debugIn("C_FindObjectsInit", "template={}", template);
        try {
            this.pkcs11.C_FindObjectsInit(this.sessionHandle, template == null ? null : this.toOutCKAttributes(template, true));
            this.debugOut("C_FindObjectsInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_FindObjectsInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public long[] findObjects(int maxObjectCount) throws PKCS11Exception {
        int countPerCall = 1000;
        if (maxObjectCount <= 1000) {
            return this.findObjects0(maxObjectCount);
        }
        LinkedList<Long> list = new LinkedList<Long>();
        for (int i = 0; i < maxObjectCount; i += 1000) {
            long[] handles;
            int numObjects = Math.min(1000, maxObjectCount - i);
            for (long handle : handles = this.findObjects0(numObjects)) {
                list.add(handle);
            }
            if (handles.length < numObjects) break;
        }
        long[] ret = new long[list.size()];
        int idx = 0;
        for (Long handle : list) {
            ret[idx++] = handle;
        }
        return ret;
    }

    private long[] findObjects0(int maxObjectCount) throws PKCS11Exception {
        String method = "C_FindObjects";
        this.debugIn("C_FindObjects", "maxObjectCount={}", maxObjectCount);
        try {
            long[] hObjects = this.pkcs11.C_FindObjects(this.sessionHandle, maxObjectCount);
            if (StaticLogger.isDebugEnabled()) {
                this.debugOut("C_FindObjects", "hObjects={}", Arrays.toString(hObjects));
            }
            return hObjects;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_FindObjects", ex);
            throw this.module.convertException(ex);
        }
    }

    public void findObjectsFinal() throws PKCS11Exception {
        String method = "C_FindObjectsFinal";
        this.debugIn("C_FindObjectsFinal");
        try {
            this.pkcs11.C_FindObjectsFinal(this.sessionHandle);
            this.debugOut("C_FindObjectsFinal");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_FindObjectsFinal", ex);
            throw this.module.convertException(ex);
        }
    }

    public long[] findAllObjectsSingle(AttributeVector template) throws PKCS11Exception {
        return this.findObjectsSingle(template, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] findObjectsSingle(AttributeVector template, int maxObjectCount) throws PKCS11Exception {
        this.findObjectsInit(template);
        try {
            long[] lArray = this.findObjects(maxObjectCount);
            return lArray;
        }
        finally {
            this.findObjectsFinal();
        }
    }

    public void encryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_EncryptInit";
        mechanism.setModule(this.module);
        this.debugIn("C_EncryptInit", "keyHandle={}, mechanism={}", keyHandle, mechanism);
        try {
            this.pkcs11.C_EncryptInit(this.sessionHandle, mechanism.toCkMechanism(), keyHandle);
            this.debugOut("C_EncryptInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_EncryptInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public int encrypt(byte[] in, byte[] out) throws PKCS11Exception {
        return this.encrypt(in, 0, in.length, out, 0, out.length);
    }

    public int encryptSingle(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws PKCS11Exception {
        return this.encryptSingle(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    public int encrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        int resLen;
        block6: {
            Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
            String method = "C_Encrypt";
            this.debugIn("C_Encrypt", "inOfs={}, inLen={}, outOfs={}, outLen", inOfs, inLen, outOfs, outLen);
            try {
                if (encrypt0 != null) {
                    resLen = (Integer)encrypt0.invoke((Object)this.pkcs11, this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
                    break block6;
                }
                if (encrypt1 != null) {
                    resLen = (Integer)encrypt1.invoke((Object)this.pkcs11, this.sessionHandle, 0, in, inOfs, inLen, 0, out, outOfs, outLen);
                    break block6;
                }
                throw new IllegalStateException("could not find C_ENCRYPT method");
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof sun.security.pkcs11.wrapper.PKCS11Exception) {
                    this.debugError("C_Encrypt", (sun.security.pkcs11.wrapper.PKCS11Exception)cause);
                    throw this.module.convertException((sun.security.pkcs11.wrapper.PKCS11Exception)cause);
                }
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return this.logOutLen("C_Encrypt", resLen);
    }

    public int encryptSingle(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        this.encryptInit(mechanism, keyHandle);
        return this.encrypt(in, inOfs, inLen, out, outOfs, outLen);
    }

    public int encryptUpdate(byte[] in, byte[] out) throws PKCS11Exception {
        return this.encryptUpdate(in, 0, in.length, out, 0, out.length);
    }

    public int encryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_EncryptUpdate";
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        this.debugIn("C_EncryptUpdate", "inOfs={}, inLen={}, outOfs={}, outLen", inOfs, inLen, outOfs, outLen);
        try {
            return this.logOutLen("C_EncryptUpdate", this.pkcs11.C_EncryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_EncryptUpdate", ex);
            throw this.module.convertException(ex);
        }
    }

    public int encryptFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_EncryptFinal";
        Session.checkOutParams(out, outOfs, outLen);
        this.debugIn("C_EncryptFinal", "outOfs={}, outLen", outOfs, outLen);
        try {
            return this.logOutLen("C_EncryptFinal", this.pkcs11.C_EncryptFinal(this.sessionHandle, 0L, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_EncryptFinal", ex);
            throw this.module.convertException(ex);
        }
    }

    public void decryptInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_DecryptInit";
        mechanism.setModule(this.module);
        this.debugIn("C_DecryptInit", "keyHandle={}, mechanism={}", keyHandle, mechanism);
        try {
            this.pkcs11.C_DecryptInit(this.sessionHandle, mechanism.toCkMechanism(), keyHandle);
            this.debugOut("C_DecryptInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DecryptInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public int decrypt(byte[] in, byte[] out) throws PKCS11Exception {
        return this.decrypt(in, 0, in.length, out, 0, out.length);
    }

    public int decryptSingle(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws PKCS11Exception {
        return this.decryptSingle(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    public int decrypt(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        int resLen;
        block6: {
            Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
            String method = "C_Decrypt";
            this.debugIn("C_Decrypt", "inOfs={}, inLen={}, outOfs={}, outLen", inOfs, inLen, outOfs, outLen);
            try {
                if (decrypt0 != null) {
                    resLen = (Integer)decrypt0.invoke((Object)this.pkcs11, this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen);
                    break block6;
                }
                if (decrypt1 != null) {
                    resLen = (Integer)decrypt1.invoke((Object)this.pkcs11, this.sessionHandle, 0, in, inOfs, inLen, 0, out, outOfs, outLen);
                    break block6;
                }
                throw new IllegalStateException("could not find C_DECRYPT method");
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof sun.security.pkcs11.wrapper.PKCS11Exception) {
                    this.debugError("C_Decrypt", (sun.security.pkcs11.wrapper.PKCS11Exception)cause);
                    throw this.module.convertException((sun.security.pkcs11.wrapper.PKCS11Exception)cause);
                }
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return this.logOutLen("C_Decrypt", resLen);
    }

    public int decryptSingle(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        this.decryptInit(mechanism, keyHandle);
        return this.decrypt(in, inOfs, inLen, out, outOfs, outLen);
    }

    public int decryptUpdate(byte[] in, byte[] out) throws PKCS11Exception {
        return this.decryptUpdate(in, 0, in.length, out, 0, out.length);
    }

    public int decryptUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_DecryptUpdate";
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        this.debugIn("C_DecryptUpdate", "inOfs={}, inLen={}, outOfs={}, outLen", inOfs, inLen, outOfs, outLen);
        try {
            return this.logOutLen("C_DecryptUpdate", this.pkcs11.C_DecryptUpdate(this.sessionHandle, 0L, in, inOfs, inLen, 0L, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DecryptUpdate", ex);
            throw this.module.convertException(ex);
        }
    }

    public int decryptFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_DecryptFinal";
        Session.checkOutParams(out, outOfs, outLen);
        this.debugIn("C_DecryptFinal", "outOfs={}, outLen", outOfs, outLen);
        try {
            return this.logOutLen("C_DecryptFinal", this.pkcs11.C_DecryptFinal(this.sessionHandle, 0L, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DecryptFinal", ex);
            throw this.module.convertException(ex);
        }
    }

    public void digestInit(Mechanism mechanism) throws PKCS11Exception {
        String method = "C_DigestInit";
        mechanism.setModule(this.module);
        this.debugIn("C_DigestInit", "mechanism={}", mechanism);
        try {
            this.pkcs11.C_DigestInit(this.sessionHandle, mechanism.toCkMechanism());
            this.debugOut("C_DigestInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DigestInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public int digestFinal(byte[] in, byte[] out) throws PKCS11Exception {
        return this.digestFinal(in, 0, in.length, out, 0, out.length);
    }

    public int digestFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        this.digestUpdate(in, inOfs, inLen);
        return this.digestFinal(out, outOfs, outLen);
    }

    public int digest(byte[] in, byte[] out) throws PKCS11Exception {
        return this.digest(in, 0, in.length, out, 0, out.length);
    }

    public int digestSingle(Mechanism mechanism, byte[] in, byte[] out) throws PKCS11Exception {
        return this.digestSingle(mechanism, in, 0, in.length, out, 0, out.length);
    }

    public int digest(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        return this.digestFinal(in, inOfs, inLen, out, outOfs, outLen);
    }

    public int digestSingle(Mechanism mechanism, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_DigestSingle";
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        mechanism.setModule(this.module);
        this.debugIn("C_DigestSingle", "mechanism={}, inOfs={}, inLen={}, outOfs={}, outLen", mechanism, inOfs, inLen, outOfs, outLen);
        try {
            return this.logOutLen("C_DigestSingle", this.pkcs11.C_DigestSingle(this.sessionHandle, mechanism.toCkMechanism(), in, inOfs, inLen, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DigestSingle", ex);
            throw this.module.convertException(ex);
        }
    }

    public void digestUpdate(byte[] in) throws PKCS11Exception {
        this.digestUpdate(in, 0, in.length);
    }

    public void digestUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        String method = "C_DigestUpdate";
        Session.checkInParams(in, inOfs, inLen);
        this.debugIn("C_DigestUpdate", "inOfs={}, inLen={}", inOfs, inLen);
        try {
            this.pkcs11.C_DigestUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
            this.debugOut("C_DigestUpdate");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DigestUpdate", ex);
            throw this.module.convertException(ex);
        }
    }

    public void digestKey(long keyHandle) throws PKCS11Exception {
        String method = "C_DigestUpdate";
        this.debugIn("C_DigestUpdate", "keyHandle={}", keyHandle);
        try {
            this.pkcs11.C_DigestKey(this.sessionHandle, keyHandle);
            this.debugOut("C_DigestUpdate");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DigestUpdate", ex);
            throw this.module.convertException(ex);
        }
    }

    public int digestFinal(byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_DigestFinal";
        Session.checkOutParams(out, outOfs, outLen);
        this.debugIn("C_DigestFinal", "outOfs={}, outLen", outOfs, outLen);
        try {
            return this.logOutLen("C_DigestFinal", this.pkcs11.C_DigestFinal(this.sessionHandle, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DigestFinal", ex);
            throw this.module.convertException(ex);
        }
    }

    private void initSignVerify(Mechanism mechanism, long keyHandle) {
        this.signOrVerifyKeyHandle = keyHandle;
        long code = mechanism.getMechanismCode();
        this.signatureType = code == 4161L || code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L ? 1 : (code == 0xFFFFF002L || code == 0xFFFFF003L ? 2 : 0);
        this.signVerifyExtraParams = mechanism.getParameters() instanceof CkParamsWithExtra ? ((CkParamsWithExtra)mechanism.getParameters()).getExtraParams() : null;
    }

    public void signInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_SignInit";
        mechanism.setModule(this.module);
        try {
            this.initSignVerify(mechanism, keyHandle);
            this.debugIn("C_SignInit", "keyHandle={}, mechanism={}", keyHandle, mechanism);
            this.pkcs11.C_SignInit(this.sessionHandle, mechanism.toCkMechanism(), keyHandle);
            this.debugOut("C_SignInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_SignInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public byte[] sign(byte[] data) throws PKCS11Exception {
        Functions.requireNonNull("data", data);
        String method = "C_Sign";
        this.debugIn("C_Sign", "data.length={}", Session.len(data));
        try {
            byte[] sigValue = this.pkcs11.C_Sign(this.sessionHandle, data);
            this.debugOut("C_Sign", "rv.length={}", Session.len(sigValue));
            return this.fixSignOutput(sigValue);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_Sign", ex);
            throw this.module.convertException(ex);
        }
    }

    public byte[] signSingle(Mechanism mechanism, long keyHandle, byte[] data) throws PKCS11Exception {
        this.signInit(mechanism, keyHandle);
        return this.sign(data);
    }

    public void signUpdate(byte[] in) throws PKCS11Exception {
        this.signUpdate(in, 0, in.length);
    }

    public void signUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        String method = "C_SignUpdate";
        Session.checkInParams(in, inOfs, inLen);
        this.debugIn("C_SignUpdate", "inOfs={}, inLen={}", inOfs, inLen);
        try {
            this.pkcs11.C_SignUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
            this.debugOut("C_SignUpdate");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_SignUpdate", ex);
            throw this.module.convertException(ex);
        }
    }

    public byte[] signFinal() throws PKCS11Exception {
        String method = "C_SignFinal";
        this.debugIn("C_SignFinal");
        try {
            byte[] sigValue = this.pkcs11.C_SignFinal(this.sessionHandle, 0);
            this.debugOut("C_SignFinal", "rv.length={}", Session.len(sigValue));
            return this.fixSignOutput(sigValue);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_SignFinal", ex);
            throw this.module.convertException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fixSignOutput(byte[] signatureValue) {
        if (this.signatureType == 0) {
            return signatureValue;
        }
        PKCS11Module pKCS11Module = this.module;
        synchronized (pKCS11Module) {
            if (this.signatureType == 1) {
                Boolean b = this.module.getEcdsaSignatureFixNeeded();
                if (b == null) {
                    StaticLogger.info("EcdsaSignatureFixNeeded: null", new Object[0]);
                } else {
                    StaticLogger.debug("EcdsaSignatureFixNeeded: {}", b);
                }
                if (b == null || b.booleanValue()) {
                    boolean fixed;
                    byte[] fixedSigValue;
                    if (this.signVerifyExtraParams != null) {
                        int rOrSLen = (this.signVerifyExtraParams.ecOrderBitSize() + 7) / 8;
                        fixedSigValue = Functions.fixECDSASignature(signatureValue, rOrSLen);
                    } else {
                        byte[] ecParams;
                        try {
                            ecParams = this.getAttrValues(this.signOrVerifyKeyHandle, 384L).ecParams();
                        }
                        catch (PKCS11Exception e) {
                            StaticLogger.debug("error getting CKA_EC_PARAMS for key {}", this.signOrVerifyKeyHandle);
                            return signatureValue;
                        }
                        if (ecParams == null) {
                            StaticLogger.debug("found no CKA_EC_PARAMS for key {}", this.signOrVerifyKeyHandle);
                            return signatureValue;
                        }
                        fixedSigValue = Functions.fixECDSASignature(signatureValue, ecParams);
                    }
                    boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                    if (b == null) {
                        StaticLogger.info("Set EcdsaSignatureFixNeeded to {}", fixed);
                        this.module.setEcdsaSignatureFixNeeded(fixed);
                    }
                    return fixedSigValue;
                }
            } else if (this.signatureType == 2) {
                Boolean b = this.module.getSm2SignatureFixNeeded();
                if (b == null) {
                    StaticLogger.info("Sm2SignatureFixNeeded: null", new Object[0]);
                } else {
                    StaticLogger.debug("Sm2SignatureFixNeeded: {}", b);
                }
                if (b == null || b.booleanValue()) {
                    boolean fixed;
                    byte[] fixedSigValue = Functions.fixECDSASignature(signatureValue, 32);
                    boolean bl = fixed = !Arrays.equals(fixedSigValue, signatureValue);
                    if (b == null) {
                        StaticLogger.info("Set Sm2SignatureFixNeeded to {}", fixed);
                        this.module.setSm2SignatureFixNeeded(fixed);
                    }
                    return fixedSigValue;
                }
            }
            return signatureValue;
        }
    }

    private byte[] fixSignatureToVerify(byte[] signatureValue) {
        if (this.signatureType == 1 ? this.module.hasVendorBehaviour(1) : this.signatureType == 2 && this.module.hasVendorBehaviour(2)) {
            return Functions.dsaSigPlainToX962(signatureValue);
        }
        return signatureValue;
    }

    public void signRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_SignRecoverInit";
        mechanism.setModule(this.module);
        this.debugIn("C_SignRecoverInit", "keyHandle={}, mechanism={}", keyHandle, mechanism);
        try {
            this.pkcs11.C_SignRecoverInit(this.sessionHandle, mechanism.toCkMechanism(), keyHandle);
            this.debugOut("C_SignRecoverInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_SignRecoverInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public int signRecover(byte[] in, byte[] out) throws PKCS11Exception {
        return this.signRecover(in, 0, in.length, out, 0, out.length);
    }

    public int signRecoverSingle(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws PKCS11Exception {
        this.signRecoverInit(mechanism, keyHandle);
        return this.signRecoverSingle(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    public int signRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        String method = "C_SignRecover";
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        this.debugIn("C_SignRecover", "inOfs={}, inLen={}, outOfs={}, outLen", inOfs, inLen, outOfs, outLen);
        try {
            return this.logOutLen("C_SignRecover", this.pkcs11.C_SignRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_SignRecover", ex);
            throw this.module.convertException(ex);
        }
    }

    public int signRecoverSingle(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        this.signRecoverInit(mechanism, keyHandle);
        return this.signRecover(in, inOfs, inLen, out, outOfs, outLen);
    }

    public void verifyInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_VerifyInit";
        mechanism.setModule(this.module);
        try {
            this.initSignVerify(mechanism, keyHandle);
            this.debugIn("C_VerifyInit", "keyHandle={}, mechanism={}", keyHandle, mechanism);
            this.pkcs11.C_VerifyInit(this.sessionHandle, mechanism.toCkMechanism(), keyHandle);
            this.debugOut("C_VerifyInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_VerifyInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public void verify(byte[] data, byte[] signature) throws PKCS11Exception {
        String method = "C_Verify";
        Functions.requireNonNull("signature", signature);
        this.debugIn("C_Verify", "data.length={}, signature.length={}", Session.len(data), Session.len(signature));
        try {
            this.pkcs11.C_Verify(this.sessionHandle, data, this.fixSignatureToVerify(signature));
            this.debugOut("C_Verify");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_Verify", ex);
            throw this.module.convertException(ex);
        }
    }

    public void verifySingle(Mechanism mechanism, long keyHandle, byte[] data, byte[] signature) throws PKCS11Exception {
        this.verifyInit(mechanism, keyHandle);
        this.verify(data, signature);
    }

    public void verifyUpdate(byte[] in) throws PKCS11Exception {
        this.verifyUpdate(in, 0, in.length);
    }

    public void verifyUpdate(byte[] in, int inOfs, int inLen) throws PKCS11Exception {
        String method = "C_VerifyUpdate";
        Session.checkInParams(in, inOfs, inLen);
        this.debugIn("C_VerifyUpdate", "inOfs={}, inLen={}", inOfs, inLen);
        try {
            this.pkcs11.C_VerifyUpdate(this.sessionHandle, 0L, in, inOfs, inLen);
            this.debugOut("C_VerifyUpdate");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_VerifyUpdate", ex);
            throw this.module.convertException(ex);
        }
    }

    public void verifyFinal(byte[] signature) throws PKCS11Exception {
        String method = "C_VerifyFinal";
        Functions.requireNonNull("signature", signature);
        this.debugIn("C_VerifyFinal", "signature.length={}", Session.len(signature));
        try {
            this.pkcs11.C_VerifyFinal(this.sessionHandle, this.fixSignatureToVerify(signature));
            this.debugOut("C_VerifyFinal");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_VerifyFinal", ex);
            throw this.module.convertException(ex);
        }
    }

    public void verifyRecoverInit(Mechanism mechanism, long keyHandle) throws PKCS11Exception {
        String method = "C_VerifyRecoverInit";
        mechanism.setModule(this.module);
        this.debugIn("C_VerifyRecoverInit", "keyHandle={}, mechanism={}", keyHandle, mechanism);
        try {
            this.pkcs11.C_VerifyRecoverInit(this.sessionHandle, mechanism.toCkMechanism(), keyHandle);
            this.debugOut("C_VerifyRecoverInit");
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_VerifyRecoverInit", ex);
            throw this.module.convertException(ex);
        }
    }

    public int verifyRecover(byte[] in, byte[] out) throws PKCS11Exception {
        return this.verifyRecover(in, 0, in.length, out, 0, out.length);
    }

    public int verifyRecoverSingle(Mechanism mechanism, long keyHandle, byte[] in, byte[] out) throws PKCS11Exception {
        this.verifyRecoverInit(mechanism, keyHandle);
        return this.verifyRecoverSingle(mechanism, keyHandle, in, 0, in.length, out, 0, out.length);
    }

    public int verifyRecover(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        Session.checkParams(in, inOfs, inLen, out, outOfs, outLen);
        String method = "C_VerifyRecover";
        this.debugIn("C_VerifyRecover", "inOfs={}, inLen={}, outOfs={}, outLen", inOfs, inLen, outOfs, outLen);
        try {
            return this.logOutLen("C_VerifyRecover", this.pkcs11.C_VerifyRecover(this.sessionHandle, in, inOfs, inLen, out, outOfs, outLen));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_VerifyRecover", ex);
            throw this.module.convertException(ex);
        }
    }

    public int verifyRecoverSingle(Mechanism mechanism, long keyHandle, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
        this.verifyRecoverInit(mechanism, keyHandle);
        return this.verifyRecover(in, inOfs, inLen, out, outOfs, outLen);
    }

    public long generateKey(Mechanism mechanism, AttributeVector template) throws PKCS11Exception {
        String method = "C_GenerateKey";
        mechanism.setModule(this.module);
        this.debugIn("C_GenerateKey", "mechanism={}, template={}", mechanism, template);
        try {
            long hKey = this.pkcs11.C_GenerateKey(this.sessionHandle, mechanism.toCkMechanism(), this.toOutCKAttributes(template));
            this.debugOut("C_GenerateKey", "hKey={}", hKey);
            this.traceObject("generated key", hKey);
            return hKey;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_GenerateKey", ex);
            throw this.module.convertException(ex);
        }
    }

    public PKCS11KeyPair generateKeyPair(Mechanism mechanism, KeyPairTemplate template) throws PKCS11Exception {
        String method = "C_GenerateKeyPair";
        mechanism.setModule(this.module);
        this.debugIn("C_GenerateKeyPair", "mechanism={}, template={}", mechanism, template);
        try {
            long[] objectHandles = this.pkcs11.C_GenerateKeyPair(this.sessionHandle, mechanism.toCkMechanism(), this.toOutCKAttributes(template.publicKey()), this.toOutCKAttributes(template.privateKey()));
            PKCS11KeyPair rv = new PKCS11KeyPair(objectHandles[0], objectHandles[1]);
            this.debugOut("C_GenerateKeyPair", "hPublicKey={}, hPrivateKey={}", rv.getPublicKey(), rv.getPrivateKey());
            this.traceObject("public  key of the generated keypair", rv.getPublicKey());
            this.traceObject("private key of the generated keypair", rv.getPrivateKey());
            return rv;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_GenerateKeyPair", ex);
            throw this.module.convertException(ex);
        }
    }

    public byte[] wrapKey(Mechanism mechanism, long wrappingKeyHandle, long keyHandle) throws PKCS11Exception {
        String method = "C_WrapKey";
        mechanism.setModule(this.module);
        this.debugIn("C_WrapKey", "wrappingKeyHandle={}, keyHandle={}, mechanism={}", wrappingKeyHandle, keyHandle, mechanism);
        try {
            return this.toNonNull("C_WrapKey", this.pkcs11.C_WrapKey(this.sessionHandle, mechanism.toCkMechanism(), wrappingKeyHandle, keyHandle));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_WrapKey", ex);
            throw this.module.convertException(ex);
        }
    }

    public long unwrapKey(Mechanism mechanism, long unwrappingKeyHandle, byte[] wrappedKey, AttributeVector keyTemplate) throws PKCS11Exception {
        Functions.requireNonNull("wrappedKey", wrappedKey);
        String method = "C_UnwrapKey";
        mechanism.setModule(this.module);
        this.debugIn("C_UnwrapKey", "unwrappingKeyHandle={}, wrappedKey.length={}, mechanism={}, template={}", unwrappingKeyHandle, Session.len(wrappedKey), mechanism, keyTemplate);
        try {
            long hKey = this.pkcs11.C_UnwrapKey(this.sessionHandle, mechanism.toCkMechanism(), unwrappingKeyHandle, wrappedKey, this.toOutCKAttributes(keyTemplate));
            this.debugOut("C_UnwrapKey", "hKey={}", hKey);
            this.traceObject("unwrapped key", hKey);
            return hKey;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_UnwrapKey", ex);
            throw this.module.convertException(ex);
        }
    }

    public long deriveKey(Mechanism mechanism, long baseKeyHandle, AttributeVector template) throws PKCS11Exception {
        String method = "C_DeriveKey";
        mechanism.setModule(this.module);
        this.debugIn("C_DeriveKey", "baseKeyHandle={}, mechanism={},template={}", baseKeyHandle, mechanism, template);
        try {
            long hKey = this.pkcs11.C_DeriveKey(this.sessionHandle, mechanism.toCkMechanism(), baseKeyHandle, this.toOutCKAttributes(template));
            this.debugOut("C_DeriveKey", "hKey={}", hKey);
            this.traceObject("derived key", hKey);
            return hKey;
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_DeriveKey", ex);
            throw this.module.convertException(ex);
        }
    }

    public void seedRandom(byte[] seed) throws PKCS11Exception {
        try {
            this.pkcs11.C_SeedRandom(this.sessionHandle, seed);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            throw this.module.convertException(ex);
        }
    }

    public byte[] generateRandom(int numberOfBytesToGenerate) throws PKCS11Exception {
        String method = "C_GenerateRandom";
        this.debugIn("C_GenerateRandom", "numberOfBytesToGenerate={}", numberOfBytesToGenerate);
        byte[] randomBytesBuffer = new byte[numberOfBytesToGenerate];
        try {
            this.pkcs11.C_GenerateRandom(this.sessionHandle, randomBytesBuffer);
            return this.toNonNull("C_GenerateRandom", randomBytesBuffer);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            this.debugError("C_GenerateRandom", ex);
            throw this.module.convertException(ex);
        }
    }

    public String toString() {
        return "Session Handle: 0x" + Long.toHexString(this.sessionHandle) + "\nToken: " + this.token;
    }

    public String getStringAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        CharArrayAttribute attr = new CharArrayAttribute(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public Object getAttrValue(long objectHandle, long attributeType) throws PKCS11Exception {
        Attribute attr = Attribute.getInstance(attributeType);
        this.doGetAttrValue(objectHandle, attr);
        return attr.getValue();
    }

    public AttributeVector getAttrValues(long objectHandle, long ... attributeTypes) throws PKCS11Exception {
        ArrayList<Long> typeList = new ArrayList<Long>(attributeTypes.length);
        for (long attrType : attributeTypes) {
            typeList.add(attrType);
        }
        return this.getAttrValues(objectHandle, typeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeVector getAttrValues(long objectHandle, List<Long> attributeTypes) throws PKCS11Exception {
        if (attributeTypes.contains(385L) && !attributeTypes.contains(384L)) {
            PKCS11Module pKCS11Module = this.module;
            synchronized (pKCS11Module) {
                Boolean b = this.module.getEcPointFixNeeded();
                if (b == null || b.booleanValue()) {
                    attributeTypes.add(384L);
                }
            }
        }
        Attribute[] attrs = new Attribute[attributeTypes.size()];
        int index = 0;
        long[] firstTypes = new long[]{0L, 256L, 384L, 385L};
        for (long type : firstTypes) {
            if (!attributeTypes.remove(type)) continue;
            attrs[index++] = Attribute.getInstance(type);
        }
        Object object = attributeTypes.iterator();
        while (object.hasNext()) {
            long type = (Long)object.next();
            attrs[index++] = Attribute.getInstance(type);
        }
        this.doGetAttrValues(objectHandle, attrs);
        return new AttributeVector(attrs);
    }

    public AttributeVector getDefaultAttrValues(long objectHandle) throws PKCS11Exception {
        return this.getDefaultAttrValues(objectHandle, false);
    }

    public AttributeVector getDefaultAttrValues(long objectHandle, boolean withSensitiveVAttributes) throws PKCS11Exception {
        long objClass = this.getAttrValues(objectHandle, 0L).class_();
        LinkedList<Long> ckaTypes = new LinkedList<Long>();
        Session.addCkaTypes(ckaTypes, 3L, 258L, 1L);
        if (objClass == 4L || objClass == 3L) {
            Session.addCkaTypes(ckaTypes, 0x40000600L, 261L, 354L, 358L, 356L, 2L, 264L, 263L, 1073742354L, 528L);
            AttributeVector attrs = this.getAttrValues(objectHandle, 256L, 259L, 357L);
            long keyType = attrs.keyType();
            Boolean sensitive = attrs.sensitive();
            Boolean alwaysSensitive = attrs.alwaysSensitive();
            boolean withSensitiveAttrs = withSensitiveVAttributes;
            if (withSensitiveAttrs) {
                boolean isSensitive;
                boolean bl = isSensitive = sensitive == null || sensitive != false;
                if (alwaysSensitive != null) {
                    isSensitive |= alwaysSensitive.booleanValue();
                }
                boolean bl2 = withSensitiveAttrs = !isSensitive;
            }
            if (objClass == 4L) {
                Session.addCkaTypes(ckaTypes, 260L, 134L, 266L, 262L, 1073742353L);
                if (keyType != 19L && keyType != 20L && keyType != 21L) {
                    ckaTypes.add(353L);
                }
                if (withSensitiveAttrs) {
                    ckaTypes.add(17L);
                }
            } else {
                Session.addCkaTypes(ckaTypes, 514L, 265L);
                if (keyType == 0L) {
                    Session.addCkaTypes(ckaTypes, 288L, 290L);
                    if (withSensitiveAttrs) {
                        Session.addCkaTypes(ckaTypes, 291L, 292L, 293L, 294L, 295L, 296L);
                    }
                } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                    ckaTypes.add(384L);
                    if (withSensitiveAttrs) {
                        ckaTypes.add(17L);
                    }
                } else if (keyType == 1L) {
                    Session.addCkaTypes(ckaTypes, 304L, 305L, 306L);
                    if (withSensitiveAttrs) {
                        ckaTypes.add(17L);
                    }
                }
            }
            return this.getAttrValues(objectHandle, ckaTypes).class_(objClass).keyType(keyType).sensitive(sensitive).alwaysSensitive(alwaysSensitive);
        }
        if (objClass == 2L) {
            Session.addCkaTypes(ckaTypes, 0x40000600L, 260L, 358L, 134L, 266L, 267L, 262L, 1073742353L);
            long keyType = this.getAttrValues(objectHandle, 256L).keyType();
            if (keyType == 0L) {
                Session.addCkaTypes(ckaTypes, 288L, 290L);
            } else if (keyType == 3L || keyType == 64L || keyType == 65L || keyType == 0xFFFFF001L) {
                Session.addCkaTypes(ckaTypes, 384L, 385L);
            } else if (keyType == 1L) {
                Session.addCkaTypes(ckaTypes, 304L, 305L, 306L);
            }
            return this.getAttrValues(objectHandle, ckaTypes).class_(objClass).keyType(keyType);
        }
        if (objClass == 1L) {
            Session.addCkaTypes(ckaTypes, 134L, 135L, 272L, 273L);
            long certType = this.getAttrValues(objectHandle, 128L).certificateType();
            if (certType == 0L) {
                Session.addCkaTypes(ckaTypes, 17L, 137L, 129L, 257L, 130L, 139L, 138L);
            }
            return this.getAttrValues(objectHandle, ckaTypes).class_(objClass).certificateType(certType);
        }
        return this.getAttrValues(objectHandle, ckaTypes);
    }

    private static void addCkaTypes(List<Long> list, long ... types) {
        for (long type : types) {
            list.add(type);
        }
    }

    private void doGetAttrValues(long objectHandle, Attribute ... attributes) throws PKCS11Exception {
        Functions.requireNonNull("attributes", attributes);
        if (attributes.length == 1) {
            this.doGetAttrValue(objectHandle, attributes[0]);
            return;
        }
        CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributeTemplateList[i] = new CK_ATTRIBUTE();
            attributeTemplateList[i].type = attributes[i].getType();
        }
        PKCS11Exception delayedEx = null;
        try {
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            delayedEx = this.module.convertException(ex);
        }
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            CK_ATTRIBUTE template = attributeTemplateList[i];
            if (template == null) continue;
            attribute.present(true).sensitive(false).ckAttribute(template);
        }
        if (delayedEx != null) {
            delayedEx = null;
            for (Attribute attr : attributes) {
                if (attr.getCkAttribute() != null && attr.getCkAttribute().pValue != null) continue;
                try {
                    this.doGetAttrValue0(objectHandle, attr, false);
                }
                catch (PKCS11Exception ex) {
                    if (delayedEx != null) continue;
                    delayedEx = ex;
                }
            }
        }
        for (Attribute attr : attributes) {
            this.postProcessGetAttribute(attr, objectHandle, attributes);
        }
        if (delayedEx != null) {
            throw delayedEx;
        }
    }

    private void doGetAttrValue(long objectHandle, Attribute attribute) throws PKCS11Exception {
        if (attribute.getType() == 385L) {
            this.doGetAttrValues(objectHandle, new ByteArrayAttribute(384L), attribute);
        } else {
            this.doGetAttrValue0(objectHandle, attribute, true);
        }
    }

    private void doGetAttrValue0(long objectHandle, Attribute attribute, boolean postProcess) throws PKCS11Exception {
        attribute.present(false);
        try {
            CK_ATTRIBUTE[] attributeTemplateList = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            attributeTemplateList[0].type = attribute.getType();
            this.pkcs11.C_GetAttributeValue(this.sessionHandle, objectHandle, attributeTemplateList);
            attribute.ckAttribute(attributeTemplateList[0]).present(true).sensitive(false);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            long ec = ex.getErrorCode();
            if (ec == 18L) {
                if (attribute.getType() == 384L) {
                    attribute.present((boolean)false).getCkAttribute().pValue = null;
                }
            }
            if (ec == 17L) {
                attribute.getCkAttribute().pValue = null;
                attribute.present((boolean)true).sensitive((boolean)true).getCkAttribute().pValue = null;
            }
            if (ec == 7L || ec == 6L || ec == 512L) {
                attribute.present((boolean)false).sensitive((boolean)false).getCkAttribute().pValue = null;
            }
            throw this.module.convertException(ex);
        }
        if (postProcess) {
            this.postProcessGetAttribute(attribute, objectHandle, new Attribute[0]);
        }
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template) {
        return this.toOutCKAttributes(template, false);
    }

    private CK_ATTRIBUTE[] toOutCKAttributes(AttributeVector template, boolean withoutNullValueAttr) {
        if (template == null) {
            return null;
        }
        CK_ATTRIBUTE[] ckAttrs = template.toCkAttributes();
        ArrayList<CK_ATTRIBUTE> nonNullCkAttrs = null;
        if (withoutNullValueAttr) {
            nonNullCkAttrs = new ArrayList<CK_ATTRIBUTE>(ckAttrs.length);
        }
        for (CK_ATTRIBUTE ckAttr : ckAttrs) {
            if (ckAttr.pValue == null) continue;
            if (withoutNullValueAttr) {
                nonNullCkAttrs.add(ckAttr);
            }
            if (ckAttr.type == 256L) {
                long value = (Long)ckAttr.pValue;
                ckAttr.pValue = this.module.genericToVendorCode(PKCS11Constants.Category.CKK, value);
                continue;
            }
            if (ckAttr.type == 385L) {
                boolean isBitString = false;
                Attribute attr = template.getAttribute(256L);
                if (attr != null) {
                    long keyType = (Long)attr.getValue();
                    isBitString = keyType == 64L || keyType == 65L;
                }
                ckAttr.pValue = Functions.toOctetOrBitString((byte[])ckAttr.pValue, isBitString);
                continue;
            }
            if (ckAttr.type != 384L) continue;
            byte[] pValue = (byte[])ckAttr.pValue;
            byte[] newPValue = null;
            if (this.module.hasVendorBehaviour(6)) {
                newPValue = Arrays.equals(OID_edwards25519, pValue) ? NAME_edwards25519 : (byte[])(Arrays.equals(OID_edwards448, pValue) ? NAME_edwards448 : null);
            } else if (this.module.hasVendorBehaviour(7)) {
                Object object = Arrays.equals(OID_curve25519, pValue) ? NAME_curve25519 : (newPValue = (Object)(Arrays.equals(OID_curve448, pValue) ? NAME_curve448 : null));
            }
            if (newPValue == null) continue;
            ckAttr.pValue = Arrays.copyOf(newPValue, newPValue.length);
        }
        return nonNullCkAttrs != null && nonNullCkAttrs.size() != ckAttrs.length ? nonNullCkAttrs.toArray(new CK_ATTRIBUTE[0]) : ckAttrs;
    }

    private void postProcessGetAttribute(Attribute attr, long objectHandle, Attribute ... otherAttrs) {
        long type = attr.getType();
        CK_ATTRIBUTE ckAttr = attr.getCkAttribute();
        if (type == 384L) {
            if (ckAttr.pValue == null) {
                Long keyType = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.type() != 256L) continue;
                        keyType = ((LongAttribute)otherAttr).getValue();
                    }
                }
                if (keyType == null) {
                    try {
                        keyType = this.getAttrValues(objectHandle, 256L).keyType();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                }
                if (keyType != null && keyType == 0xFFFFF001L) {
                    attr.present((boolean)false).getCkAttribute().pValue = Functions.decodeHex("06082a811ccf5501822d");
                }
            } else {
                byte[] ecParams = (byte[])ckAttr.pValue;
                if (ecParams[0] != 6) {
                    ckAttr.pValue = Functions.fixECParams((byte[])ckAttr.pValue);
                }
            }
            return;
        }
        if (ckAttr == null || ckAttr.pValue == null) {
            return;
        }
        if (type == 256L) {
            long value = (Long)ckAttr.pValue;
            if (!PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.vendorToGenericCode(PKCS11Constants.Category.CKK, value);
            }
        } else if (type == 358L) {
            long value = (Long)ckAttr.pValue;
            if (!PKCS11Constants.isUnavailableInformation(value)) {
                ckAttr.pValue = this.module.vendorToGenericCode(PKCS11Constants.Category.CKM, value);
            }
        } else if (type == 0x40000600L) {
            long[] mechs;
            for (long mech : mechs = ((MechanismArrayAttribute)attr).getValue()) {
                ckAttr.pValue = this.module.vendorToGenericCode(PKCS11Constants.Category.CKM, mech);
            }
        } else if (type == 385L) {
            Boolean b = this.module.getEcPointFixNeeded();
            byte[] pValue = (byte[])ckAttr.pValue;
            if (b == null || b.booleanValue()) {
                byte[] ecParams = null;
                if (otherAttrs != null) {
                    for (Attribute otherAttr : otherAttrs) {
                        if (otherAttr.getType() != 384L) continue;
                        ecParams = ((ByteArrayAttribute)otherAttr).getValue();
                        break;
                    }
                }
                byte[] fixedCoreEcPoint = Functions.getCoreECPoint(pValue, ecParams);
                if (b == null) {
                    byte[] coreEcPoint = Functions.getCoreECPoint(pValue);
                    this.module.setEcPointFixNeeded(!Arrays.equals(coreEcPoint, fixedCoreEcPoint));
                }
                ckAttr.pValue = fixedCoreEcPoint;
            } else {
                ckAttr.pValue = Functions.getCoreECPoint(pValue);
            }
        } else if (attr instanceof BooleanAttribute && ckAttr.pValue instanceof byte[]) {
            byte[] value = (byte[])ckAttr.pValue;
            boolean allZeros = true;
            for (byte b : value) {
                if (b == 0) continue;
                allZeros = false;
                break;
            }
            ckAttr.pValue = !allZeros;
        }
    }

    private static void checkParams(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) {
        Session.checkInParams(in, inOfs, inLen);
        Session.checkOutParams(out, outOfs, outLen);
    }

    private static void checkInParams(byte[] in, int inOfs, int inLen) {
        Functions.requireNonNull("in", in);
        if (inOfs < 0 || inLen <= 0) {
            throw new IllegalArgumentException("inOfs or inLen is invalid");
        }
        if (in.length < inOfs + inLen) {
            throw new IllegalArgumentException("inOfs + inLen > in.length");
        }
    }

    private static void checkOutParams(byte[] out, int outOfs, int outLen) {
        Functions.requireNonNull("out", out);
        if (outOfs < 0 || outLen <= 0) {
            throw new IllegalArgumentException("outOfs or outLen is invalid");
        }
        if (out.length < outOfs + outLen) {
            throw new IllegalArgumentException("outOfs + outLen > out.length");
        }
    }

    private void debugIn(String cMethod) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("IN  " + cMethod + ": hSession=" + this.sessionHandle, new Object[0]);
        }
    }

    private void debugIn(String method, String format, Object ... arguments) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("IN  " + method + ": hSession=" + this.sessionHandle + ", " + format, arguments);
        }
    }

    private void debugError(String method) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug(method + ": hSession=" + this.sessionHandle, new Object[0]);
        }
    }

    private void debugError(String method, sun.security.pkcs11.wrapper.PKCS11Exception e) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("ERR " + method + ": " + this.module.codeToName(PKCS11Constants.Category.CKR, e.getErrorCode()), new Object[0]);
        }
    }

    private void debugOut(String method) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("OUT " + method + ": hSession=" + this.sessionHandle, new Object[0]);
        }
    }

    private void debugOut(String method, String format, Object ... arguments) {
        if (StaticLogger.isDebugEnabled()) {
            StaticLogger.debug("OUT " + method + ": hSession=" + this.sessionHandle + ", " + format, arguments);
        }
    }

    private static int len(byte[] bytes) {
        return bytes == null ? 0 : bytes.length;
    }

    private byte[] toNonNull(String method, byte[] bytes) {
        if (bytes == null) {
            this.debugOut(method, "rv=null", new Object[0]);
        } else {
            this.debugOut(method, "rv.length={}", bytes.length);
        }
        return bytes == null ? new byte[]{} : bytes;
    }

    private int logOutLen(String method, int outLen) {
        this.debugOut(method, "outLen={}", outLen);
        return outLen;
    }

    private byte[] toNonNull(byte[] bytes) {
        return bytes == null ? new byte[]{} : bytes;
    }

    private void traceObject(String prefix, long hObject) {
        if (StaticLogger.isTraceEnabled()) {
            try {
                StaticLogger.trace(prefix + ": handle=" + hObject + ", attributes\n" + this.getDefaultAttrValues(hObject), new Object[0]);
            }
            catch (PKCS11Exception e) {
                StaticLogger.trace(prefix + ": reading object " + hObject + " failed with " + PKCS11Constants.ckrCodeToName(e.getErrorCode()), new Object[0]);
            }
        }
    }

    static {
        Class<PKCS11> clazz = PKCS11.class;
        decrypt0 = Util.getMethod(clazz, "C_Decrypt", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        encrypt0 = Util.getMethod(clazz, "C_Encrypt", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        decrypt1 = decrypt0 != null ? null : Util.getMethod(clazz, "C_Decrypt", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        encrypt1 = encrypt0 != null ? null : Util.getMethod(clazz, "C_Encrypt", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
    }
}

