/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.Session;
import org.xipki.pkcs11.wrapper.Slot;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.TokenInfo;

public class Token {
    private final Slot slot;
    private long[] mechCodes;
    private final Map<Long, MechanismInfo> nativeMechCodeInfoMap = new HashMap<Long, MechanismInfo>();
    private final Map<Long, MechanismInfo> mechCodeInfoMap = new HashMap<Long, MechanismInfo>();

    protected Token(Slot slot) {
        this.slot = Functions.requireNonNull("slot", slot);
    }

    private synchronized void init() {
        long[] mechanisms;
        if (this.mechCodes != null) {
            return;
        }
        PKCS11Module module = this.slot.getModule();
        try {
            mechanisms = module.getPKCS11().C_GetMechanismList(this.slot.getSlotID());
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
            StaticLogger.warn("error calling C_GetMechanismList: {}", ex.getMessage());
            this.mechCodes = new long[0];
            return;
        }
        StaticLogger.info("Mechanisms supported by the HSM natively: {}", this.ckmsToSstring(mechanisms));
        long[] mechCodeArray = new long[mechanisms.length];
        int index = 0;
        for (long code : mechanisms) {
            MechanismInfo mechInfo;
            long code2 = module.vendorToGenericCode(PKCS11Constants.Category.CKM, code);
            try {
                mechInfo = new MechanismInfo(module.getPKCS11().C_GetMechanismInfo(this.slot.getSlotID(), code));
            }
            catch (sun.security.pkcs11.wrapper.PKCS11Exception ex) {
                StaticLogger.warn("error calling C_GetMechanismInfo for mechanism {}: {}", PKCS11Constants.ckmCodeToName(code), ex.getMessage());
                continue;
            }
            this.nativeMechCodeInfoMap.put(code, mechInfo);
            mechCodeArray[index++] = code2;
            this.mechCodeInfoMap.put(code2, mechInfo);
        }
        this.mechCodes = index == mechCodeArray.length ? mechCodeArray : Arrays.copyOf(mechCodeArray, index);
        StaticLogger.info("Mechanisms supported by the HSM: {}", this.ckmsToSstring(this.mechCodes));
    }

    private String ckmsToSstring(long[] mechCodes) {
        ArrayList<Long> list = new ArrayList<Long>(mechCodes.length);
        for (long code : mechCodes) {
            list.add(code);
        }
        Collections.sort(list);
        ArrayList<String> names = new ArrayList<String>(mechCodes.length);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            long code = (Long)iterator.next();
            names.add(this.slot.getModule().codeToName(PKCS11Constants.Category.CKM, code));
        }
        return ((Object)names).toString();
    }

    public Slot getSlot() {
        return this.slot;
    }

    public boolean isUseUtf8Encoding() {
        return this.slot.isUseUtf8Encoding();
    }

    public long getTokenID() {
        return this.slot.getSlotID();
    }

    public TokenInfo getTokenInfo() throws PKCS11Exception {
        try {
            return new TokenInfo(this.slot.getModule().getPKCS11().C_GetTokenInfo(this.slot.getSlotID()));
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception e) {
            throw this.slot.getModule().convertException(e);
        }
    }

    public long[] getMechanismList() {
        this.init();
        return (long[])this.mechCodes.clone();
    }

    public MechanismInfo getMechanismInfo(long mechanism) {
        this.init();
        MechanismInfo info = this.mechCodeInfoMap.get(mechanism);
        if (info == null) {
            info = this.nativeMechCodeInfoMap.get(mechanism);
        }
        return info;
    }

    public Session openSession(boolean rwSession) throws PKCS11Exception {
        return this.openSession(rwSession, null);
    }

    public Session openSession(boolean rwSession, Object application) throws PKCS11Exception {
        long sessionHandle;
        long flags = rwSession ? 6L : 4L;
        PKCS11Module module = this.slot.getModule();
        try {
            sessionHandle = module.getPKCS11().C_OpenSession(this.slot.getSlotID(), flags, application, null);
        }
        catch (sun.security.pkcs11.wrapper.PKCS11Exception e) {
            throw module.convertException(e);
        }
        StaticLogger.info("C_OpenSession: slotID={}, flags=0x{}, sessionHandle={}", this.slot.getSlotID(), Functions.toFullHex(flags), sessionHandle);
        return new Session(this, sessionHandle);
    }

    public String toString() {
        return "Token in Slot: " + this.slot;
    }
}

