/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.StaticLogger;
import org.xipki.pkcs11.wrapper.Version;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;

public class TokenInfo {
    private final String label;
    private final String manufacturerID;
    private final String model;
    private final String serialNumber;
    private final Version hardwareVersion;
    private final Version firmwareVersion;
    private final Instant time;
    private final CK_TOKEN_INFO ckTokenInfo;

    protected TokenInfo(CK_TOKEN_INFO ckTokenInfo) {
        Instant time;
        Functions.requireNonNull("ckTokenInfo", ckTokenInfo);
        this.label = new String(ckTokenInfo.label).trim();
        this.manufacturerID = new String(ckTokenInfo.manufacturerID).trim();
        this.model = new String(ckTokenInfo.model).trim();
        this.serialNumber = new String(ckTokenInfo.serialNumber).trim();
        this.hardwareVersion = new Version(ckTokenInfo.hardwareVersion);
        this.firmwareVersion = new Version(ckTokenInfo.firmwareVersion);
        this.ckTokenInfo = ckTokenInfo;
        char[] utcTime = ckTokenInfo.utcTime;
        try {
            int year = Integer.parseInt(new String(utcTime, 0, 4));
            int month = Integer.parseInt(new String(utcTime, 4, 2));
            int day = Integer.parseInt(new String(utcTime, 6, 2));
            int hour = Integer.parseInt(new String(utcTime, 8, 2));
            int minute = Integer.parseInt(new String(utcTime, 10, 2));
            int second = Integer.parseInt(new String(utcTime, 12, 2));
            time = ZonedDateTime.of(year, month, day, hour, minute, second, 0, ZoneOffset.UTC).toInstant();
        }
        catch (Exception ex) {
            StaticLogger.warn("toke return invalid utcTime: {}, use system time", utcTime == null ? "null" : new String(utcTime));
            time = Instant.now();
        }
        this.time = time;
    }

    public String getLabel() {
        return this.label;
    }

    public String getManufacturerID() {
        return this.manufacturerID;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public long getMaxSessionCount() {
        return this.ckTokenInfo.ulMaxSessionCount;
    }

    public long getSessionCount() {
        return this.ckTokenInfo.ulSessionCount;
    }

    public long getMaxRwSessionCount() {
        return this.ckTokenInfo.ulMaxRwSessionCount;
    }

    public long getRwSessionCount() {
        return this.ckTokenInfo.ulRwSessionCount;
    }

    public long getMaxPinLen() {
        return this.ckTokenInfo.ulMaxPinLen;
    }

    public long getMinPinLen() {
        return this.ckTokenInfo.ulMinPinLen;
    }

    public long getTotalPublicMemory() {
        return this.ckTokenInfo.ulTotalPublicMemory;
    }

    public long getFreePublicMemory() {
        return this.ckTokenInfo.ulFreePublicMemory;
    }

    public long getTotalPrivateMemory() {
        return this.ckTokenInfo.ulTotalPrivateMemory;
    }

    public long getFreePrivateMemory() {
        return this.ckTokenInfo.ulFreePrivateMemory;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public Instant getTime() {
        return this.time;
    }

    public long getFlags() {
        return this.ckTokenInfo.flags;
    }

    public boolean hasFlagBit(long flagMask) {
        return (this.ckTokenInfo.flags & flagMask) != 0L;
    }

    public boolean isProtectedAuthenticationPath() {
        return this.hasFlagBit(256L);
    }

    public boolean isLoginRequired() {
        return this.hasFlagBit(4L);
    }

    public boolean isTokenInitialized() {
        return this.hasFlagBit(1024L);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        String ni = "\n" + indent;
        String text = indent + "Label:           " + this.label + ni + "Manufacturer ID: " + this.manufacturerID + ni + "Model:           " + this.model + ni + "Serial Number:   " + this.serialNumber + ni + "PIN Length:      [" + this.getMinPinLen() + ", " + this.getMaxPinLen() + "]" + ni + "Time:            " + this.time + ni + "Versions         [Hardware: " + this.hardwareVersion + ", Firmware: " + this.firmwareVersion + "]" + ni + "Session Counts   [#: " + TokenInfo.ct(this.getSessionCount()) + ", #Max: " + TokenInfo.mct(this.getMaxSessionCount()) + ", #Max RW: " + TokenInfo.mct(this.getMaxRwSessionCount()) + ", #RW: " + TokenInfo.ct(this.getRwSessionCount()) + "]" + ni + "Memories         [Total Private: " + TokenInfo.ct(this.getTotalPrivateMemory()) + ", Free Private: " + TokenInfo.ct(this.getFreePrivateMemory()) + ", Total Public: " + TokenInfo.ct(this.getTotalPublicMemory()) + ", Free Public: " + TokenInfo.ct(this.getFreePublicMemory()) + "]";
        return text + "\n" + Functions.toStringFlags(PKCS11Constants.Category.CKF_TOKEN, indent + "Flags: ", this.ckTokenInfo.flags, 1L, 2L, 4L, 32L, 64L, 256L, 512L, 1024L, 2048L, 8L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L);
    }

    private static String mct(long count) {
        return PKCS11Constants.isUnavailableInformation(count) ? "N/A" : (count == 0L ? "unlimited" : Long.toString(count));
    }

    private static String ct(long count) {
        return PKCS11Constants.isUnavailableInformation(count) ? "N/A" : Long.toString(count);
    }
}

