/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.attrs;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.xipki.pkcs11.wrapper.attrs.Attribute;
import sun.security.pkcs11.wrapper.CK_DATE;

public class DateAttribute
extends Attribute {
    public DateAttribute(long type) {
        super(type);
    }

    public DateAttribute dateValue(Instant value) {
        if (value == null) {
            this.ckAttribute.pValue = null;
        } else {
            ZonedDateTime utcTime = ZonedDateTime.ofInstant(value, ZoneOffset.UTC);
            int year = utcTime.getYear();
            int month = utcTime.getMonthValue();
            int day = utcTime.getDayOfMonth();
            this.ckAttribute.pValue = new CK_DATE(Integer.toString(year).toCharArray(), (month < 10 ? "0" + month : Integer.toString(month)).toCharArray(), (day < 10 ? "0" + day : Integer.toString(day)).toCharArray());
        }
        this.present = true;
        return this;
    }

    @Override
    public Instant getValue() {
        if (this.isNullValue()) {
            return null;
        }
        CK_DATE ckDate = (CK_DATE)this.ckAttribute.pValue;
        int year = Integer.parseInt(new String(ckDate.year));
        int month = Integer.parseInt(new String(ckDate.month));
        int day = Integer.parseInt(new String(ckDate.day));
        return ZonedDateTime.of(year, month, day, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
    }

    @Override
    protected String getValueString() {
        if (this.isNullValue()) {
            return "<NULL_PTR>";
        }
        CK_DATE ckDate = (CK_DATE)this.ckAttribute.pValue;
        return new String(ckDate.year) + "." + new String(ckDate.month) + "." + new String(ckDate.day);
    }
}

