/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class ECDH1_DERIVE_PARAMS
extends CkParams {
    private final CK_ECDH1_DERIVE_PARAMS params;

    public ECDH1_DERIVE_PARAMS(long kdf, byte[] sharedData, byte[] publicData) {
        ECDH1_DERIVE_PARAMS.requireNonNull("publicData", publicData);
        this.params = new CK_ECDH1_DERIVE_PARAMS(kdf, sharedData, publicData);
    }

    @Override
    public CK_ECDH1_DERIVE_PARAMS getParams() {
        if (this.module == null) {
            return this.params;
        }
        long newKdf = this.module.genericToVendorCode(PKCS11Constants.Category.CKD, this.params.kdf);
        if (newKdf == this.params.kdf) {
            return this.params;
        }
        return new CK_ECDH1_DERIVE_PARAMS(newKdf, this.params.pSharedData, this.params.pPublicData);
    }

    @Override
    public CK_MECHANISM toCkMechanism(long mechanism) {
        return new CK_MECHANISM(mechanism, this.getParams());
    }

    @Override
    protected int getMaxFieldLen() {
        return 11;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_ECDH1_DERIVE_PARAMS:" + this.val2Str(indent, "kdf", this.codeToName(PKCS11Constants.Category.CKD, this.params.kdf)) + this.ptr2str(indent, "pPublicData", this.params.pPublicData) + this.ptr2str(indent, "pSharedData", this.params.pSharedData);
    }
}

