/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.pkcs11.wrapper.params;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.Util;
import org.xipki.pkcs11.wrapper.params.CkParams;
import sun.security.pkcs11.wrapper.CK_MECHANISM;

public class RSA_PKCS_PSS_PARAMS
extends CkParams {
    public static final String CLASS_CK_PARAMS = "sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS";
    private static final Constructor<?> constructor;
    private static final Constructor<?> constructorNoArgs;
    private static final Field hashAlgField;
    private static final Field mgfField;
    private static final Field sLenField;
    private static final Method CK_MECHANISM_method_setParameter;
    private static final Field CK_MECHANISM_field_pParameter;
    private static final Map<Long, Long> mgf2HashAlgMap;
    protected long hashAlg;
    protected long mgf;
    private final int sLen;
    private final Object params;

    public RSA_PKCS_PSS_PARAMS(long hashAlg, long mgf, int sLen) {
        if (constructor == null && constructorNoArgs == null) {
            throw new IllegalStateException("could not find constructor for class sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS");
        }
        this.hashAlg = hashAlg;
        this.mgf = mgf;
        this.sLen = sLen;
        if (constructorNoArgs != null) {
            long realHashAlg = this.module == null || (hashAlg & 0x80000000L) == 0L ? hashAlg : this.module.genericToVendorCode(PKCS11Constants.Category.CKM, hashAlg);
            long realMgf = this.module == null || (mgf & 0x80000000L) == 0L ? mgf : this.module.genericToVendorCode(PKCS11Constants.Category.CKG_MGF, mgf);
            try {
                this.params = constructorNoArgs.newInstance(new Object[0]);
                hashAlgField.set(this.params, realHashAlg);
                mgfField.set(this.params, realMgf);
                sLenField.set(this.params, sLen);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS", ex);
            }
        }
        String hashAlgName = Functions.getHashAlgName(hashAlg);
        String mgfHashAlgName = Functions.getHashAlgName(mgf2HashAlgMap.get(mgf));
        try {
            this.params = constructor.newInstance(hashAlgName, "MGF1", mgfHashAlgName, sLen);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS", ex);
        }
    }

    @Override
    public Object getParams() {
        if (constructorNoArgs == null || this.module == null) {
            return this.params;
        }
        long newHashAlg = this.module.genericToVendorCode(PKCS11Constants.Category.CKM, this.hashAlg);
        long newMgf = this.module.genericToVendorCode(PKCS11Constants.Category.CKG_MGF, this.mgf);
        if (newHashAlg == this.hashAlg && newMgf == this.mgf) {
            return this.params;
        }
        try {
            Object ret = constructorNoArgs.newInstance(new Object[0]);
            hashAlgField.set(ret, newHashAlg);
            mgfField.set(ret, newMgf);
            sLenField.set(ret, this.sLen);
            return ret;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create new instance of sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS", ex);
        }
    }

    @Override
    public CK_MECHANISM toCkMechanism(long mechanism) {
        CK_MECHANISM mech;
        block4: {
            mech = new CK_MECHANISM(mechanism);
            Object params = this.getParams();
            try {
                if (CK_MECHANISM_field_pParameter != null) {
                    CK_MECHANISM_field_pParameter.set(mech, params);
                    break block4;
                }
                if (CK_MECHANISM_method_setParameter != null) {
                    CK_MECHANISM_method_setParameter.invoke((Object)mech, params);
                    break block4;
                }
                throw new IllegalStateException("could not construct CK_MECHANISM for RSA_PKCS_PSS_PARAMS");
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new IllegalStateException("could not construct CK_MECHANISM for RSA_PKCS_PSS_PARAMS", ex);
            }
        }
        return mech;
    }

    @Override
    protected int getMaxFieldLen() {
        return 7;
    }

    @Override
    public String toString(String indent) {
        return indent + "CK_RSA_PKCS_PSS_PARAMS:" + this.val2Str(indent, "hashAlg", this.codeToName(PKCS11Constants.Category.CKM, this.hashAlg)) + this.val2Str(indent, "mgf", this.codeToName(PKCS11Constants.Category.CKG_MGF, this.mgf)) + this.val2Str(indent, "sLen", this.sLen);
    }

    static {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        map.put(1L, 544L);
        map.put(5L, 597L);
        map.put(2L, 592L);
        map.put(3L, 608L);
        map.put(4L, 624L);
        map.put(6L, 693L);
        map.put(7L, 688L);
        map.put(8L, 704L);
        map.put(9L, 720L);
        mgf2HashAlgMap = Collections.unmodifiableMap(map);
        Class<Object> clazz = Util.getClass(CLASS_CK_PARAMS);
        if (clazz != null) {
            constructor = Util.getConstructor(clazz, String.class, String.class, String.class, Integer.TYPE);
            constructorNoArgs = constructor != null ? null : Util.getConstructor(clazz, new Class[0]);
            hashAlgField = constructorNoArgs == null ? null : Util.getField(clazz, "hashAlg");
            mgfField = constructorNoArgs == null ? null : Util.getField(clazz, "mgf");
            sLenField = constructorNoArgs == null ? null : Util.getField(clazz, "sLen");
        } else {
            constructor = null;
            constructorNoArgs = null;
            hashAlgField = null;
            mgfField = null;
            sLenField = null;
        }
        clazz = CK_MECHANISM.class;
        CK_MECHANISM_field_pParameter = Util.getField(clazz, "pParameter");
        Class<?> paramClass = Util.getClass(CLASS_CK_PARAMS);
        CK_MECHANISM_method_setParameter = paramClass == null ? null : Util.getMethod(clazz, "setParameter", paramClass);
    }
}

