/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.xipki.ocsp.client.AbstractOcspRequestor;
import org.xipki.ocsp.client.RequestOptions;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class HttpOcspRequestor
extends AbstractOcspRequestor {
    private static final int MAX_LEN_GET = 190;
    private static final String CT_REQUEST = "application/ocsp-request";
    private static final String CT_RESPONSE = "application/ocsp-response";

    @Override
    protected byte[] send(byte[] request, URL responderUrl, RequestOptions requestOptions) throws IOException {
        HttpURLConnection httpUrlConnection;
        Args.notNull((Object)request, (String)"request");
        Args.notNull((Object)responderUrl, (String)"responderUrl");
        Args.notNull((Object)requestOptions, (String)"requestOptions");
        int size = request.length;
        if (size <= 190 && requestOptions.isUseHttpGetForRequest()) {
            String b64Request = Base64.encodeToString((byte[])request);
            String urlEncodedReq = URLEncoder.encode(b64Request, "UTF-8");
            String baseUrl = responderUrl.toString();
            String url = StringUtil.concat((String)baseUrl, (String[])new String[]{baseUrl.endsWith("/") ? "" : "/", urlEncodedReq});
            URL newUrl = new URL(url);
            httpUrlConnection = IoUtil.openHttpConn((URL)newUrl);
            httpUrlConnection.setRequestMethod("GET");
        } else {
            httpUrlConnection = IoUtil.openHttpConn((URL)responderUrl);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setRequestProperty("Content-Type", CT_REQUEST);
            httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
            OutputStream outputstream = httpUrlConnection.getOutputStream();
            outputstream.write(request);
            outputstream.flush();
        }
        InputStream inputstream = httpUrlConnection.getInputStream();
        if (httpUrlConnection.getResponseCode() != 200) {
            inputstream.close();
            throw new IOException("bad response: " + httpUrlConnection.getResponseCode() + "    " + httpUrlConnection.getResponseMessage());
        }
        String responseContentType = httpUrlConnection.getContentType();
        boolean isValidContentType = false;
        if (responseContentType != null && responseContentType.equalsIgnoreCase(CT_RESPONSE)) {
            isValidContentType = true;
        }
        if (!isValidContentType) {
            inputstream.close();
            throw new IOException("bad response: mime type " + responseContentType + " not supported!");
        }
        return IoUtil.read((InputStream)inputstream);
    }
}

