/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.client;

import java.util.HashMap;
import java.util.Map;
import org.xipki.util.Hex;
import org.xipki.util.StringUtil;

public abstract class OcspResponseException
extends Exception {
    public OcspResponseException() {
    }

    public OcspResponseException(String message) {
        super(message);
    }

    public OcspResponseException(Throwable cause) {
        super(cause);
    }

    public OcspResponseException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class Unsuccessful
    extends OcspResponseException {
        private static final Map<Integer, String> codeStatusMap = new HashMap<Integer, String>();
        private final int status;

        public Unsuccessful(int status) {
            super(Unsuccessful.getStatusText(status));
            this.status = status;
        }

        public int status() {
            return this.status;
        }

        public String statusText() {
            return Unsuccessful.getStatusText(this.status);
        }

        public static String getStatusText(int statusCode) {
            String status = codeStatusMap.get(statusCode);
            return status == null ? Integer.toString(statusCode) : status;
        }

        static {
            codeStatusMap.put(0, "successful");
            codeStatusMap.put(1, "malformedRequest");
            codeStatusMap.put(2, "internalError");
            codeStatusMap.put(3, "tryLater");
            codeStatusMap.put(5, "sigRequired");
            codeStatusMap.put(6, "unauthorized");
        }
    }

    public static class ResponderUnreachable
    extends OcspResponseException {
        public ResponderUnreachable() {
        }

        public ResponderUnreachable(String message, Throwable cause) {
            super(message, cause);
        }

        public ResponderUnreachable(String message) {
            super(message);
        }

        public ResponderUnreachable(Throwable cause) {
            super(cause);
        }
    }

    public static class OcspTargetUnmatched
    extends OcspResponseException {
        public OcspTargetUnmatched() {
        }

        public OcspTargetUnmatched(String message, Throwable cause) {
            super(message, cause);
        }

        public OcspTargetUnmatched(String message) {
            super(message);
        }

        public OcspTargetUnmatched(Throwable cause) {
            super(cause);
        }
    }

    public static class OcspNonceUnmatched
    extends OcspResponseException {
        public OcspNonceUnmatched(byte[] expected, byte[] is) {
            super(OcspNonceUnmatched.buildMessage(expected, is));
        }

        private static String buildMessage(byte[] expected, byte[] is) {
            return StringUtil.concat((String)"nonce unmatch (received ", (String[])new String[]{is == null || is.length == 0 ? "none" : Hex.encode((byte[])is), ", but expected ", expected == null || expected.length == 0 ? "none" : Hex.encode((byte[])expected), ")"});
        }
    }

    public static class InvalidResponse
    extends OcspResponseException {
        public InvalidResponse() {
        }

        public InvalidResponse(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidResponse(String message) {
            super(message);
        }

        public InvalidResponse(Throwable cause) {
            super(cause);
        }
    }
}

