/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.util.Args;

public class RequestOptions {
    private static final Map<String, AlgorithmIdentifier> SIGALGS_MAP;
    private boolean signRequest;
    private boolean useNonce = true;
    private int nonceLen = 8;
    private boolean allowNoNonceInResponse;
    private boolean useHttpGetForRequest;
    private ASN1ObjectIdentifier hashAlgorithmId = NISTObjectIdentifiers.id_sha256;
    private List<AlgorithmIdentifier> preferredSignatureAlgorithms;

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public int getNonceLen() {
        return this.nonceLen;
    }

    public void setNonceLen(int nonceLen) {
        this.nonceLen = Args.positive((int)nonceLen, (String)"nonceLen");
    }

    public ASN1ObjectIdentifier getHashAlgorithmId() {
        return this.hashAlgorithmId;
    }

    public void setHashAlgorithmId(ASN1ObjectIdentifier hashAlgorithmId) {
        this.hashAlgorithmId = hashAlgorithmId;
    }

    public List<AlgorithmIdentifier> getPreferredSignatureAlgorithms() {
        return this.preferredSignatureAlgorithms;
    }

    public void setPreferredSignatureAlgorithms(AlgorithmIdentifier[] preferredSignatureAlgorithms) {
        this.preferredSignatureAlgorithms = Arrays.asList(preferredSignatureAlgorithms);
    }

    public void setPreferredSignatureAlgorithms(String[] preferredSignatureAlgoNames) {
        if (preferredSignatureAlgoNames == null || preferredSignatureAlgoNames.length == 0) {
            this.preferredSignatureAlgorithms = null;
            return;
        }
        for (String algoName : preferredSignatureAlgoNames) {
            AlgorithmIdentifier sigAlgId = SIGALGS_MAP.get(algoName.toUpperCase());
            if (sigAlgId == null) continue;
            if (this.preferredSignatureAlgorithms == null) {
                this.preferredSignatureAlgorithms = new ArrayList<AlgorithmIdentifier>(preferredSignatureAlgoNames.length);
            }
            this.preferredSignatureAlgorithms.add(sigAlgId);
        }
    }

    public boolean isUseHttpGetForRequest() {
        return this.useHttpGetForRequest;
    }

    public void setUseHttpGetForRequest(boolean useHttpGetForRequest) {
        this.useHttpGetForRequest = useHttpGetForRequest;
    }

    public boolean isSignRequest() {
        return this.signRequest;
    }

    public void setSignRequest(boolean signRequest) {
        this.signRequest = signRequest;
    }

    public boolean isAllowNoNonceInResponse() {
        return this.allowNoNonceInResponse;
    }

    public void setAllowNoNonceInResponse(boolean allowNoNonceInResponse) {
        this.allowNoNonceInResponse = allowNoNonceInResponse;
    }

    private static AlgorithmIdentifier createAlgId(String algoName) {
        DERNull params;
        algoName = algoName.toUpperCase();
        ASN1ObjectIdentifier algOid = null;
        if ("SHA1WITHRSA".equals(algoName)) {
            algOid = PKCSObjectIdentifiers.sha1WithRSAEncryption;
        } else if ("SHA256WITHRSA".equals(algoName)) {
            algOid = PKCSObjectIdentifiers.sha256WithRSAEncryption;
        } else if ("SHA384WITHRSA".equals(algoName)) {
            algOid = PKCSObjectIdentifiers.sha384WithRSAEncryption;
        } else if ("SHA512WITHRSA".equals(algoName)) {
            algOid = PKCSObjectIdentifiers.sha512WithRSAEncryption;
        } else if ("SHA1WITHECDSA".equals(algoName)) {
            algOid = X9ObjectIdentifiers.ecdsa_with_SHA1;
        } else if ("SHA256WITHECDSA".equals(algoName)) {
            algOid = X9ObjectIdentifiers.ecdsa_with_SHA256;
        } else if ("SHA384WITHECDSA".equals(algoName)) {
            algOid = X9ObjectIdentifiers.ecdsa_with_SHA384;
        } else if ("SHA512WITHECDSA".equals(algoName)) {
            algOid = X9ObjectIdentifiers.ecdsa_with_SHA512;
        } else if ("SHA1WITHRSAANDMGF1".equals(algoName) || "SHA256WITHRSAANDMGF1".equals(algoName) || "SHA384WITHRSAANDMGF1".equals(algoName) || "SHA512WITHRSAANDMGF1".equals(algoName)) {
            algOid = PKCSObjectIdentifiers.id_RSASSA_PSS;
        } else {
            throw new IllegalStateException("Unsupported algorithm " + algoName);
        }
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)algOid)) {
            ASN1ObjectIdentifier digestAlgOid = null;
            digestAlgOid = "SHA1WITHRSAANDMGF1".equals(algoName) ? X509ObjectIdentifiers.id_SHA1 : ("SHA256WITHRSAANDMGF1".equals(algoName) ? NISTObjectIdentifiers.id_sha256 : ("SHA384WITHRSAANDMGF1".equals(algoName) ? NISTObjectIdentifiers.id_sha384 : NISTObjectIdentifiers.id_sha512));
            params = RequestOptions.createPSSRSAParams(digestAlgOid);
        } else {
            params = DERNull.INSTANCE;
        }
        return new AlgorithmIdentifier(algOid, (ASN1Encodable)params);
    }

    public static RSASSAPSSparams createPSSRSAParams(ASN1ObjectIdentifier digestAlgOid) {
        int saltSize;
        if (X509ObjectIdentifiers.id_SHA1.equals((ASN1Primitive)digestAlgOid)) {
            saltSize = 20;
        } else if (NISTObjectIdentifiers.id_sha224.equals((ASN1Primitive)digestAlgOid)) {
            saltSize = 28;
        } else if (NISTObjectIdentifiers.id_sha256.equals((ASN1Primitive)digestAlgOid)) {
            saltSize = 32;
        } else if (NISTObjectIdentifiers.id_sha384.equals((ASN1Primitive)digestAlgOid)) {
            saltSize = 48;
        } else if (NISTObjectIdentifiers.id_sha512.equals((ASN1Primitive)digestAlgOid)) {
            saltSize = 64;
        } else {
            throw new IllegalStateException("unknown digest algorithm " + digestAlgOid);
        }
        AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(digestAlgOid, (ASN1Encodable)DERNull.INSTANCE);
        return new RSASSAPSSparams(digAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)digAlgId), new ASN1Integer((long)saltSize), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
    }

    static {
        String[] algoNames;
        SIGALGS_MAP = new HashMap<String, AlgorithmIdentifier>();
        for (String algoName : algoNames = new String[]{"SHA1WITHRSA", "SHA256WITHRSA", "SHA384WITHRSA", "SHA512WITHRSA", "SHA1WITHECDSA", "SHA256WITHECDSA", "SHA384WITHECDSA", "SHA512WITHECDSA", "SHA1WITHRSAANDMGF1", "SHA256WITHRSAANDMGF1", "SHA384WITHRSAANDMGF1", "SHA512WITHRSAANDMGF1"}) {
            SIGALGS_MAP.put(algoName.toUpperCase(), RequestOptions.createAlgId(algoName));
        }
    }
}

