/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.client;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.Request;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.ContentSigner;
import org.xipki.ocsp.client.OcspRequestor;
import org.xipki.ocsp.client.OcspRequestorException;
import org.xipki.ocsp.client.OcspResponseException;
import org.xipki.ocsp.client.RequestOptions;
import org.xipki.ocsp.client.XiOCSPReqBuilder;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignAlgo;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.ConcurrentBag;
import org.xipki.util.LogUtil;
import org.xipki.util.ReqRespDebug;
import org.xipki.util.StringUtil;

public abstract class AbstractOcspRequestor
implements OcspRequestor {
    private SecurityFactory securityFactory;
    private final Object signerLock = new Object();
    private ConcurrentContentSigner signer;
    private String signerType;
    private String signerConf;
    private String signerCertFile;
    private final SecureRandom random = new SecureRandom();

    protected AbstractOcspRequestor() {
    }

    protected abstract byte[] send(byte[] var1, URL var2, RequestOptions var3) throws IOException;

    @Override
    public OCSPResp ask(X509Cert issuerCert, X509Cert cert, URL responderUrl, RequestOptions requestOptions, ReqRespDebug debug) throws OcspResponseException, OcspRequestorException {
        if (!X509Util.issues((X509Cert)((X509Cert)Args.notNull((Object)issuerCert, (String)"issuerCert")), (X509Cert)((X509Cert)Args.notNull((Object)cert, (String)"cert")))) {
            throw new IllegalArgumentException("cert and issuerCert do not match");
        }
        return this.ask(issuerCert, new BigInteger[]{cert.getSerialNumber()}, responderUrl, requestOptions, debug);
    }

    @Override
    public OCSPResp ask(X509Cert issuerCert, X509Cert[] certs, URL responderUrl, RequestOptions requestOptions, ReqRespDebug debug) throws OcspResponseException, OcspRequestorException {
        Args.notNull((Object)issuerCert, (String)"issuerCert");
        Args.notNull((Object)certs, (String)"certs");
        Args.positive((int)certs.length, (String)"certs.length");
        BigInteger[] serialNumbers = new BigInteger[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            X509Cert cert = certs[i];
            if (!X509Util.issues((X509Cert)issuerCert, (X509Cert)cert)) {
                throw new IllegalArgumentException("cert at index " + i + " and issuerCert do not match");
            }
            serialNumbers[i] = cert.getSerialNumber();
        }
        return this.ask(issuerCert, serialNumbers, responderUrl, requestOptions, debug);
    }

    @Override
    public OCSPResp ask(X509Cert issuerCert, BigInteger serialNumber, URL responderUrl, RequestOptions requestOptions, ReqRespDebug debug) throws OcspResponseException, OcspRequestorException {
        return this.ask(issuerCert, new BigInteger[]{serialNumber}, responderUrl, requestOptions, debug);
    }

    @Override
    public OCSPResp ask(X509Cert issuerCert, BigInteger[] serialNumbers, URL responderUrl, RequestOptions requestOptions, ReqRespDebug debug) throws OcspResponseException, OcspRequestorException {
        SingleResp[] singleResponses;
        Object respObject;
        OCSPResp ocspResp;
        byte[] encodedResp;
        byte[] encodedReq;
        Args.notNull((Object)issuerCert, (String)"issuerCert");
        Args.notNull((Object)responderUrl, (String)"responderUrl");
        byte[] nonce = null;
        if (((RequestOptions)Args.notNull((Object)requestOptions, (String)"requestOptions")).isUseNonce()) {
            nonce = this.nextNonce(requestOptions.getNonceLen());
        }
        OCSPRequest ocspReq = this.buildRequest(issuerCert, serialNumbers, nonce, requestOptions);
        try {
            encodedReq = ocspReq.getEncoded();
        }
        catch (IOException ex) {
            throw new OcspRequestorException("could not encode OCSP request: " + ex.getMessage(), ex);
        }
        ReqRespDebug.ReqRespPair msgPair = null;
        if (debug != null) {
            msgPair = new ReqRespDebug.ReqRespPair();
            debug.add(msgPair);
            if (debug.saveRequest()) {
                msgPair.setRequest(encodedReq);
            }
        }
        try {
            encodedResp = this.send(encodedReq, responderUrl, requestOptions);
        }
        catch (IOException ex) {
            throw new OcspResponseException.ResponderUnreachable("IOException: " + ex.getMessage(), ex);
        }
        if (msgPair != null && debug.saveResponse()) {
            msgPair.setResponse(encodedResp);
        }
        try {
            ocspResp = new OCSPResp(encodedResp);
        }
        catch (IOException ex) {
            throw new OcspResponseException.InvalidResponse("IOException: " + ex.getMessage(), ex);
        }
        try {
            respObject = ocspResp.getResponseObject();
        }
        catch (OCSPException ex) {
            throw new OcspResponseException.InvalidResponse("responseObject is invalid");
        }
        if (ocspResp.getStatus() != 0) {
            return ocspResp;
        }
        if (!(respObject instanceof BasicOCSPResp)) {
            return ocspResp;
        }
        BasicOCSPResp basicOcspResp = (BasicOCSPResp)respObject;
        if (nonce != null) {
            Extension nonceExtn = basicOcspResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            if (nonceExtn == null) {
                if (!requestOptions.isAllowNoNonceInResponse()) {
                    throw new OcspResponseException.OcspNonceUnmatched(nonce, null);
                }
            } else {
                byte[] receivedNonce = nonceExtn.getExtnValue().getOctets();
                if (!Arrays.equals(nonce, receivedNonce)) {
                    throw new OcspResponseException.OcspNonceUnmatched(nonce, receivedNonce);
                }
            }
        }
        if ((singleResponses = basicOcspResp.getResponses()) == null || singleResponses.length == 0) {
            String msg = StringUtil.concat((String)"response with no singleResponse is returned, expected is ", (String[])new String[]{Integer.toString(serialNumbers.length)});
            throw new OcspResponseException.OcspTargetUnmatched(msg);
        }
        int countSingleResponses = singleResponses.length;
        if (countSingleResponses != serialNumbers.length) {
            String msg = StringUtil.concat((String)"response with ", (String[])new String[]{Integer.toString(countSingleResponses), " singleResponse", countSingleResponses > 1 ? "s" : "", " is returned, expected is ", Integer.toString(serialNumbers.length)});
            throw new OcspResponseException.OcspTargetUnmatched(msg);
        }
        Request reqAt0 = Request.getInstance((Object)ocspReq.getTbsRequest().getRequestList().getObjectAt(0));
        CertID certId = reqAt0.getReqCert();
        ASN1ObjectIdentifier issuerHashAlg = certId.getHashAlgorithm().getAlgorithm();
        byte[] issuerKeyHash = certId.getIssuerKeyHash().getOctets();
        byte[] issuerNameHash = certId.getIssuerNameHash().getOctets();
        if (serialNumbers.length == 1) {
            boolean issuerMatch;
            SingleResp singleResp = singleResponses[0];
            CertificateID cid = singleResp.getCertID();
            boolean bl = issuerMatch = issuerHashAlg.equals((ASN1Primitive)cid.getHashAlgOID()) && Arrays.equals(issuerKeyHash, cid.getIssuerKeyHash()) && Arrays.equals(issuerNameHash, cid.getIssuerNameHash());
            if (!issuerMatch) {
                throw new OcspResponseException.OcspTargetUnmatched("the issuer is not requested");
            }
            BigInteger serialNumber = cid.getSerialNumber();
            if (!serialNumbers[0].equals(serialNumber)) {
                throw new OcspResponseException.OcspTargetUnmatched("the serialNumber is not requested");
            }
        } else {
            List<BigInteger> tmpSerials1 = Arrays.asList(serialNumbers);
            ArrayList<BigInteger> tmpSerials2 = new ArrayList<BigInteger>(tmpSerials1);
            for (int i = 0; i < countSingleResponses; ++i) {
                boolean issuerMatch;
                SingleResp singleResp = singleResponses[i];
                CertificateID cid = singleResp.getCertID();
                boolean bl = issuerMatch = issuerHashAlg.equals((ASN1Primitive)cid.getHashAlgOID()) && Arrays.equals(issuerKeyHash, cid.getIssuerKeyHash()) && Arrays.equals(issuerNameHash, cid.getIssuerNameHash());
                if (!issuerMatch) {
                    throw new OcspResponseException.OcspTargetUnmatched("the issuer specified in singleResponse[" + i + "] is not requested");
                }
                BigInteger serialNumber = cid.getSerialNumber();
                if (tmpSerials2.remove(serialNumber)) continue;
                if (tmpSerials1.contains(serialNumber)) {
                    throw new OcspResponseException.OcspTargetUnmatched("serialNumber " + LogUtil.formatCsn((BigInteger)serialNumber) + "is contained in at least two singleResponses");
                }
                throw new OcspResponseException.OcspTargetUnmatched("serialNumber " + LogUtil.formatCsn((BigInteger)serialNumber) + " specified in singleResponse[" + i + "] is not requested");
            }
        }
        return ocspResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OCSPRequest buildRequest(X509Cert caCert, BigInteger[] serialNumbers, byte[] nonce, RequestOptions requestOptions) throws OcspRequestorException {
        OCSPRequest oCSPRequest;
        ConcurrentBag.BagEntry signer0;
        HashAlgo hashAlgo = requestOptions.getHashAlgorithm();
        List<SignAlgo> prefSigAlgs = requestOptions.getPreferredSignatureAlgorithms();
        XiOCSPReqBuilder reqBuilder = new XiOCSPReqBuilder();
        LinkedList<Extension> extensions = new LinkedList<Extension>();
        if (nonce != null) {
            extensions.add(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce)));
        }
        if (prefSigAlgs != null && !prefSigAlgs.isEmpty()) {
            Extension extn;
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (SignAlgo algId : prefSigAlgs) {
                vec.add((ASN1Encodable)new DERSequence((ASN1Encodable)algId.getAlgorithmIdentifier()));
            }
            DERSequence extnValue = new DERSequence(vec);
            try {
                extn = new Extension(ObjectIdentifiers.Extn.id_pkix_ocsp_prefSigAlgs, false, (ASN1OctetString)new DEROctetString((ASN1Encodable)extnValue));
            }
            catch (IOException iOException) {
                throw new OcspRequestorException(iOException.getMessage(), iOException);
            }
            extensions.add(extn);
        }
        if (CollectionUtil.isNotEmpty(extensions)) {
            reqBuilder.setRequestExtensions(new Extensions(extensions.toArray(new Extension[0])));
        }
        DEROctetString issuerNameHash = new DEROctetString(hashAlgo.hash((byte[][])new byte[][]{caCert.getSubject().getEncoded()}));
        TBSCertificate tbsCert = caCert.toBcCert().toASN1Structure().getTBSCertificate();
        DEROctetString issuerKeyHash = new DEROctetString(hashAlgo.hash((byte[][])new byte[][]{tbsCert.getSubjectPublicKeyInfo().getPublicKeyData().getOctets()}));
        for (BigInteger serialNumber : serialNumbers) {
            CertID certId = new CertID(hashAlgo.getAlgorithmIdentifier(), (ASN1OctetString)issuerNameHash, (ASN1OctetString)issuerKeyHash, new ASN1Integer(serialNumber));
            reqBuilder.addRequest(certId);
        }
        if (!requestOptions.isSignRequest()) return reqBuilder.build();
        Object object = this.signerLock;
        synchronized (object) {
            if (this.signer == null) {
                if (StringUtil.isBlank((String)this.signerType)) {
                    throw new OcspRequestorException("signerType is not configured");
                }
                if (StringUtil.isBlank((String)this.signerConf)) {
                    throw new OcspRequestorException("signerConf is not configured");
                }
                X509Cert cert = null;
                if (StringUtil.isNotBlank((String)this.signerCertFile)) {
                    try {
                        cert = X509Util.parseCert((File)new File(this.signerCertFile));
                    }
                    catch (CertificateException ex) {
                        throw new OcspRequestorException("could not parse certificate " + this.signerCertFile + ": " + ex.getMessage());
                    }
                }
                try {
                    this.signer = this.getSecurityFactory().createSigner(this.signerType, new SignerConf(this.signerConf), cert);
                }
                catch (Exception ex) {
                    throw new OcspRequestorException("could not create signer: " + ex.getMessage());
                }
            }
        }
        reqBuilder.setRequestorName(this.signer.getCertificate().getSubject());
        X509Cert[] x509CertArray = this.signer.getCertificateChain();
        Certificate[] certChain = new Certificate[x509CertArray.length];
        for (int i = 0; i < certChain.length; ++i) {
            certChain[i] = x509CertArray[i].toBcCert().toASN1Structure();
        }
        try {
            signer0 = this.signer.borrowSigner();
        }
        catch (NoIdleSignerException ex) {
            throw new OcspRequestorException("NoIdleSignerException: " + ex.getMessage());
        }
        try {
            oCSPRequest = reqBuilder.build((ContentSigner)signer0.value(), certChain);
        }
        catch (Throwable throwable) {
            try {
                this.signer.requiteSigner(signer0);
                throw throwable;
            }
            catch (IOException | OCSPException ex) {
                throw new OcspRequestorException(ex.getMessage(), ex);
            }
        }
        this.signer.requiteSigner(signer0);
        return oCSPRequest;
    }

    private byte[] nextNonce(int nonceLen) {
        byte[] nonce = new byte[nonceLen];
        this.random.nextBytes(nonce);
        return nonce;
    }

    public String getSignerConf() {
        return this.signerConf;
    }

    public void setSignerConf(String signerConf) {
        this.signer = null;
        this.signerConf = signerConf;
    }

    public String getSignerCertFile() {
        return this.signerCertFile;
    }

    public void setSignerCertFile(String signerCertFile) {
        if (StringUtil.isNotBlank((String)signerCertFile)) {
            this.signer = null;
            this.signerCertFile = signerCertFile;
        }
    }

    public String getSignerType() {
        return this.signerType;
    }

    public void setSignerType(String signerType) {
        this.signer = null;
        this.signerType = signerType;
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }
}

