/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.client;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.Request;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.ocsp.TBSRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.operator.ContentSigner;

public class XiOCSPReqBuilder {
    private final List<RequestObject> list = new ArrayList<RequestObject>();
    private GeneralName requestorName = null;
    private Extensions requestExtensions = null;

    public XiOCSPReqBuilder addRequest(CertID certId) {
        this.list.add(new RequestObject(certId, null));
        return this;
    }

    public XiOCSPReqBuilder addRequest(CertID certId, Extensions singleRequestExtensions) {
        this.list.add(new RequestObject(certId, singleRequestExtensions));
        return this;
    }

    public XiOCSPReqBuilder setRequestorName(X500Name requestorName) {
        this.requestorName = new GeneralName(4, (ASN1Encodable)requestorName);
        return this;
    }

    public XiOCSPReqBuilder setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
        return this;
    }

    public XiOCSPReqBuilder setRequestExtensions(Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
        return this;
    }

    private OCSPRequest generateRequest(ContentSigner contentSigner, Certificate[] chain) throws OCSPException {
        Iterator<RequestObject> it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add((ASN1Encodable)it.next().toRequest());
            }
            catch (Exception ex) {
                throw new OCSPException("exception creating Request", (Throwable)ex);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, (ASN1Sequence)new DERSequence(requests), this.requestExtensions);
        Signature signature = null;
        if (contentSigner != null) {
            if (this.requestorName == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                OutputStream sOut = contentSigner.getOutputStream();
                sOut.write(tbsReq.getEncoded("DER"));
                sOut.close();
            }
            catch (Exception ex) {
                throw new OCSPException("exception processing TBSRequest: " + ex, (Throwable)ex);
            }
            DERBitString bitSig = new DERBitString(contentSigner.getSignature());
            AlgorithmIdentifier sigAlgId = contentSigner.getAlgorithmIdentifier();
            if (chain != null && chain.length > 0) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                for (int i = 0; i != chain.length; ++i) {
                    vec.add((ASN1Encodable)chain[i]);
                }
                signature = new Signature(sigAlgId, bitSig, (ASN1Sequence)new DERSequence(vec));
            } else {
                signature = new Signature(sigAlgId, bitSig);
            }
        }
        return new OCSPRequest(tbsReq, signature);
    }

    public OCSPRequest build() throws OCSPException {
        return this.generateRequest(null, null);
    }

    public OCSPRequest build(ContentSigner signer, Certificate[] chain) throws OCSPException {
        if (signer == null) {
            throw new IllegalArgumentException("no signer specified");
        }
        return this.generateRequest(signer, chain);
    }

    private static class RequestObject {
        private final CertID certId;
        private final Extensions extensions;

        public RequestObject(CertID certId, Extensions extensions) {
            this.certId = certId;
            this.extensions = extensions;
        }

        public Request toRequest() {
            return new Request(this.certId, this.extensions);
        }
    }
}

