/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.mgmt.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.xipki.ocsp.api.mgmt.MgmtMessage;
import org.xipki.ocsp.api.mgmt.MgmtRequest;
import org.xipki.ocsp.api.mgmt.OcspManager;
import org.xipki.ocsp.api.mgmt.OcspMgmtException;
import org.xipki.security.util.JSON;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.exception.ObjectCreationException;
import org.xipki.util.http.SslContextConf;

public class OcspMgmtClient
implements OcspManager {
    private static final String REQUEST_CT = "application/json";
    private static final String RESPONSE_CT = "application/json";
    private final Map<MgmtMessage.MgmtAction, URL> actionUrlMap = new HashMap<MgmtMessage.MgmtAction, URL>(50);
    private final SslContextConf sslContextConf;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private boolean initialized;
    private OcspMgmtException initException;

    public OcspMgmtClient(SslContextConf sslContextConf) {
        this.sslContextConf = sslContextConf;
    }

    public void setServerUrl(String serverUrl) throws MalformedURLException {
        Args.notBlank((String)serverUrl, (String)"serverUrl");
        if (!((String)serverUrl).endsWith("/")) {
            serverUrl = (String)serverUrl + "/";
        }
        for (MgmtMessage.MgmtAction action : MgmtMessage.MgmtAction.values()) {
            this.actionUrlMap.put(action, new URL((String)serverUrl + action));
        }
    }

    public synchronized void initIfNotDone() throws OcspMgmtException {
        if (this.initException != null) {
            throw this.initException;
        }
        if (this.initialized) {
            return;
        }
        if (this.sslContextConf != null && this.sslContextConf.isUseSslConf()) {
            try {
                this.sslSocketFactory = this.sslContextConf.getSslSocketFactory();
                this.hostnameVerifier = this.sslContextConf.buildHostnameVerifier();
            }
            catch (ObjectCreationException ex) {
                this.initException = new OcspMgmtException("could not initialize CaMgmtClient: " + ex.getMessage(), (Throwable)ex);
                throw this.initException;
            }
        }
        this.initialized = true;
    }

    public void restartOcspServer() throws OcspMgmtException {
        this.voidTransmit(MgmtMessage.MgmtAction.restartServer, null);
    }

    private void voidTransmit(MgmtMessage.MgmtAction action, MgmtRequest req) throws OcspMgmtException {
        this.transmit(action, req, true);
    }

    private byte[] transmit(MgmtMessage.MgmtAction action, MgmtRequest req) throws OcspMgmtException {
        return this.transmit(action, req, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] transmit(MgmtMessage.MgmtAction action, MgmtRequest req, boolean voidReturn) throws OcspMgmtException {
        this.initIfNotDone();
        byte[] reqBytes = req == null ? null : JSON.toJSONBytes((Object)req);
        int size = reqBytes == null ? 0 : reqBytes.length;
        URL url = this.actionUrlMap.get(action);
        try {
            HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)url);
            if (httpUrlConnection instanceof HttpsURLConnection) {
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)httpUrlConnection).setSSLSocketFactory(this.sslSocketFactory);
                }
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)httpUrlConnection).setHostnameVerifier(this.hostnameVerifier);
                }
            }
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
            OutputStream outputstream = httpUrlConnection.getOutputStream();
            if (size != 0) {
                outputstream.write(reqBytes);
            }
            outputstream.flush();
            if (httpUrlConnection.getResponseCode() == 200) {
                byte[] byArray;
                block16: {
                    boolean inClosed;
                    InputStream in;
                    block14: {
                        byte[] byArray2;
                        block15: {
                            in = httpUrlConnection.getInputStream();
                            inClosed = false;
                            try {
                                String responseContentType = httpUrlConnection.getContentType();
                                if (!"application/json".equals(responseContentType)) {
                                    throw new OcspMgmtException("bad response: mime type " + responseContentType + " not supported!");
                                }
                                if (!voidReturn) break block14;
                                byArray2 = null;
                                if (!(in != null & !inClosed)) break block15;
                            }
                            catch (Throwable throwable) {
                                if (in != null & !inClosed) {
                                    in.close();
                                }
                                throw throwable;
                            }
                            in.close();
                        }
                        return byArray2;
                    }
                    inClosed = true;
                    byArray = IoUtil.readAllBytesAndClose((InputStream)httpUrlConnection.getInputStream());
                    if (!(in != null & !inClosed)) break block16;
                    in.close();
                }
                return byArray;
            }
            String errorMessage = httpUrlConnection.getHeaderField("x-xipki-error");
            if (errorMessage != null) {
                throw new OcspMgmtException(errorMessage);
            }
            StringBuilder sb = new StringBuilder(100);
            sb.append("server returns ").append(httpUrlConnection.getResponseCode());
            String respMsg = httpUrlConnection.getResponseMessage();
            if (StringUtil.isNotBlank((String)respMsg)) {
                sb.append(" ").append(respMsg);
            }
            throw new OcspMgmtException(sb.toString());
        }
        catch (IOException ex) {
            throw new OcspMgmtException("IOException while sending message to the server: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

