/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.util.LinkedList;
import java.util.List;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.InvalidConfException;
import org.xipki.util.ValidatableConf;

public class OcspServerConf
extends ValidatableConf {
    private ResponseCache responseCache;
    private List<Responder> responders;
    private List<Signer> signers;
    private List<Store> stores;
    private List<Datasource> datasources;
    private List<RequestOption> requestOptions;
    private List<ResponseOption> responseOptions;
    private boolean master = true;

    public ResponseCache getResponseCache() {
        return this.responseCache;
    }

    public void setResponseCache(ResponseCache responseCache) {
        this.responseCache = responseCache;
    }

    public List<Responder> getResponders() {
        if (this.responders == null) {
            this.responders = new LinkedList<Responder>();
        }
        return this.responders;
    }

    public void setResponders(List<Responder> responders) {
        this.responders = responders;
    }

    public List<Signer> getSigners() {
        if (this.signers == null) {
            this.signers = new LinkedList<Signer>();
        }
        return this.signers;
    }

    public void setSigners(List<Signer> signers) {
        this.signers = signers;
    }

    public List<Store> getStores() {
        if (this.stores == null) {
            this.stores = new LinkedList<Store>();
        }
        return this.stores;
    }

    public void setStores(List<Store> stores) {
        this.stores = stores;
    }

    public List<Datasource> getDatasources() {
        if (this.datasources == null) {
            this.datasources = new LinkedList<Datasource>();
        }
        return this.datasources;
    }

    public void setDatasources(List<Datasource> datasources) {
        this.datasources = datasources;
    }

    public List<RequestOption> getRequestOptions() {
        if (this.requestOptions == null) {
            this.requestOptions = new LinkedList<RequestOption>();
        }
        return this.requestOptions;
    }

    public void setRequestOptions(List<RequestOption> requestOptions) {
        this.requestOptions = requestOptions;
    }

    public List<ResponseOption> getResponseOptions() {
        if (this.responseOptions == null) {
            this.responseOptions = new LinkedList<ResponseOption>();
        }
        return this.responseOptions;
    }

    public void setResponseOptions(List<ResponseOption> responseOptions) {
        this.responseOptions = responseOptions;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public void validate() throws InvalidConfException {
        OcspServerConf.notEmpty(this.responders, (String)"responders");
        OcspServerConf.validate(this.responders);
        OcspServerConf.notEmpty(this.signers, (String)"signers");
        OcspServerConf.validate(this.signers);
        OcspServerConf.notEmpty(this.stores, (String)"stores");
        OcspServerConf.validate(this.stores);
        OcspServerConf.validate(this.datasources);
        OcspServerConf.notEmpty(this.requestOptions, (String)"requestOptions");
        OcspServerConf.validate(this.requestOptions);
        OcspServerConf.notEmpty(this.responseOptions, (String)"responseOptions");
        OcspServerConf.validate(this.responseOptions);
    }

    public static class CrlSourceConf
    extends ValidatableConf {
        private String crlFile;
        private String crlUrl;
        private boolean useUpdateDatesFromCrl = true;
        private String caCertFile;
        private String issuerCertFile;
        private String certsDir;

        public String getCrlFile() {
            return this.crlFile;
        }

        public void setCrlFile(String crlFile) {
            this.crlFile = crlFile;
        }

        public String getCrlUrl() {
            return this.crlUrl;
        }

        public void setCrlUrl(String crlUrl) {
            this.crlUrl = crlUrl;
        }

        public boolean isUseUpdateDatesFromCrl() {
            return this.useUpdateDatesFromCrl;
        }

        public void setUseUpdateDatesFromCrl(boolean useUpdateDatesFromCrl) {
            this.useUpdateDatesFromCrl = useUpdateDatesFromCrl;
        }

        public String getCaCertFile() {
            return this.caCertFile;
        }

        public void setCaCertFile(String caCertFile) {
            this.caCertFile = caCertFile;
        }

        public String getIssuerCertFile() {
            return this.issuerCertFile;
        }

        public void setIssuerCertFile(String issuerCertFile) {
            this.issuerCertFile = issuerCertFile;
        }

        public String getCertsDir() {
            return this.certsDir;
        }

        public void setCertsDir(String certsDir) {
            this.certsDir = certsDir;
        }

        public void validate() throws InvalidConfException {
            CrlSourceConf.notEmpty((String)this.crlFile, (String)"crlFile");
            CrlSourceConf.notEmpty((String)this.caCertFile, (String)"caCertFile");
        }
    }

    public static class DbSourceConf
    extends ValidatableConf {
        private CaCerts caCerts;

        public CaCerts getCaCerts() {
            return this.caCerts;
        }

        public void setCaCerts(CaCerts caCerts) {
            this.caCerts = caCerts;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class CaCerts
    extends ValidatableConf {
        private List<String> includes;
        private List<String> excludes;

        public List<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(List<String> includes) {
            this.includes = includes;
        }

        public List<String> getExcludes() {
            return this.excludes;
        }

        public void setExcludes(List<String> excludes) {
            this.excludes = excludes;
        }

        public void validate() throws InvalidConfException {
        }
    }

    public static class SourceConfImpl
    extends ValidatableConf
    implements OcspStore.SourceConf {
        private DbSourceConf dbSource;
        private CrlSourceConf crlSource;
        private Object custom;

        public DbSourceConf getDbSource() {
            return this.dbSource;
        }

        public void setDbSource(DbSourceConf dbSource) {
            this.dbSource = dbSource;
        }

        public CrlSourceConf getCrlSource() {
            return this.crlSource;
        }

        public void setCrlSource(CrlSourceConf crlSource) {
            this.crlSource = crlSource;
        }

        public Object getCustom() {
            return this.custom;
        }

        public void setCustom(Object custom) {
            this.custom = custom;
        }

        public void validate() throws InvalidConfException {
            int occurrences = 0;
            if (this.dbSource != null) {
                ++occurrences;
            }
            if (this.crlSource == null) {
                ++occurrences;
            }
            if (this.custom != null) {
                ++occurrences;
            }
            if (occurrences > 1) {
                throw new InvalidConfException("maximal one of dbSource, crlSource and custom may be set");
            }
        }
    }

    public static class Source
    extends ValidatableConf {
        private String type;
        private String datasource;
        private SourceConfImpl conf;

        public String getType() {
            return this.type;
        }

        public void setType(String value) {
            this.type = value;
        }

        public String getDatasource() {
            return this.datasource;
        }

        public void setDatasource(String value) {
            this.datasource = value;
        }

        public SourceConfImpl getConf() {
            return this.conf;
        }

        public void setConf(SourceConfImpl value) {
            this.conf = value;
        }

        public void validate() throws InvalidConfException {
            Source.notEmpty((String)this.type, (String)"type");
        }
    }

    public static class Store
    extends ValidatableConf {
        private Source source;
        private Boolean ignoreExpiredCert;
        private Boolean ignoreNotYetValidCert;
        private Integer retentionInterval;
        private Boolean unknownSerialAsGood;
        private Boolean includeArchiveCutoff;
        private Boolean includeCrlId;
        private String name;

        public Source getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = source;
        }

        public Boolean getIgnoreExpiredCert() {
            return this.ignoreExpiredCert;
        }

        public void setIgnoreExpiredCert(Boolean ignoreExpiredCert) {
            this.ignoreExpiredCert = ignoreExpiredCert;
        }

        public Boolean getIgnoreNotYetValidCert() {
            return this.ignoreNotYetValidCert;
        }

        public void setIgnoreNotYetValidCert(Boolean ignoreNotYetValidCert) {
            this.ignoreNotYetValidCert = ignoreNotYetValidCert;
        }

        public Integer getRetentionInterval() {
            return this.retentionInterval;
        }

        public void setRetentionInterval(Integer retentionInterval) {
            this.retentionInterval = retentionInterval;
        }

        public Boolean getUnknownSerialAsGood() {
            return this.unknownSerialAsGood;
        }

        public void setUnknownSerialAsGood(Boolean unknownSerialAsGood) {
            this.unknownSerialAsGood = unknownSerialAsGood;
        }

        public Boolean getIncludeArchiveCutoff() {
            return this.includeArchiveCutoff;
        }

        public void setIncludeArchiveCutoff(Boolean includeArchiveCutoff) {
            this.includeArchiveCutoff = includeArchiveCutoff;
        }

        public Boolean getIncludeCrlId() {
            return this.includeCrlId;
        }

        public void setIncludeCrlId(Boolean includeCrlId) {
            this.includeCrlId = includeCrlId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Store.notEmpty((String)this.name, (String)"name");
            Store.notNull((Object)((Object)this.source), (String)"source");
        }
    }

    public static class Signer
    extends ValidatableConf {
        private String name;
        private String type;
        private String key;
        private List<String> algorithms;
        private FileOrBinary cert;
        private List<FileOrBinary> caCerts;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<String> getAlgorithms() {
            if (this.algorithms == null) {
                this.algorithms = new LinkedList<String>();
            }
            return this.algorithms;
        }

        public void setAlgorithms(List<String> algorithms) {
            this.algorithms = algorithms;
        }

        public FileOrBinary getCert() {
            return this.cert;
        }

        public void setCert(FileOrBinary cert) {
            this.cert = cert;
        }

        public List<FileOrBinary> getCaCerts() {
            if (this.caCerts == null) {
                this.caCerts = new LinkedList<FileOrBinary>();
            }
            return this.caCerts;
        }

        public void setCaCerts(List<FileOrBinary> caCerts) {
            this.caCerts = caCerts;
        }

        public void validate() throws InvalidConfException {
            Signer.notEmpty((String)this.name, (String)"name");
            Signer.notEmpty((String)this.type, (String)"type");
            Signer.notEmpty((String)this.key, (String)"key");
            Signer.notEmpty(this.algorithms, (String)"algorithms");
        }
    }

    public static class ResponseOption
    extends ValidatableConf {
        private boolean responderIdByName = true;
        private boolean includeInvalidityDate = false;
        private boolean includeRevReason = false;
        private EmbedCertsMode embedCertsMode = EmbedCertsMode.SIGNER;
        private boolean includeCerthash = false;
        private Long cacheMaxAge;
        private String name;

        public boolean isResponderIdByName() {
            return this.responderIdByName;
        }

        public void setResponderIdByName(boolean responderIdByName) {
            this.responderIdByName = responderIdByName;
        }

        public boolean isIncludeInvalidityDate() {
            return this.includeInvalidityDate;
        }

        public void setIncludeInvalidityDate(boolean includeInvalidityDate) {
            this.includeInvalidityDate = includeInvalidityDate;
        }

        public boolean isIncludeRevReason() {
            return this.includeRevReason;
        }

        public void setIncludeRevReason(boolean includeRevReason) {
            this.includeRevReason = includeRevReason;
        }

        public EmbedCertsMode getEmbedCertsMode() {
            return this.embedCertsMode;
        }

        public void setEmbedCertsMode(EmbedCertsMode embedCertsMode) {
            this.embedCertsMode = embedCertsMode;
        }

        public boolean isIncludeCerthash() {
            return this.includeCerthash;
        }

        public void setIncludeCerthash(boolean includeCerthash) {
            this.includeCerthash = includeCerthash;
        }

        public Long getCacheMaxAge() {
            return this.cacheMaxAge;
        }

        public void setCacheMaxAge(Long cacheMaxAge) {
            this.cacheMaxAge = cacheMaxAge;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            ResponseOption.notEmpty((String)this.name, (String)"name");
        }
    }

    public static class ResponseCache
    extends ValidatableConf {
        private Datasource datasource;
        private int validity = 86400;

        public Datasource getDatasource() {
            return this.datasource;
        }

        public void setDatasource(Datasource datasource) {
            this.datasource = datasource;
        }

        public int getValidity() {
            return this.validity;
        }

        public void setValidity(int validity) {
            this.validity = validity;
        }

        public void validate() throws InvalidConfException {
            ResponseCache.notNull((Object)((Object)this.datasource), (String)"datasource");
        }
    }

    public static class Responder
    extends ValidatableConf {
        private List<String> servletPaths;
        private String mode;
        private boolean inheritCaRevocation;
        private String signer;
        private String request;
        private String response;
        private List<String> stores;
        private String name;

        public List<String> getServletPaths() {
            if (this.servletPaths == null) {
                this.servletPaths = new LinkedList<String>();
            }
            return this.servletPaths;
        }

        public void setServletPaths(List<String> servletPaths) {
            this.servletPaths = servletPaths;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean isInheritCaRevocation() {
            return this.inheritCaRevocation;
        }

        public void setInheritCaRevocation(boolean inheritCaRevocation) {
            this.inheritCaRevocation = inheritCaRevocation;
        }

        public String getSigner() {
            return this.signer;
        }

        public void setSigner(String signer) {
            this.signer = signer;
        }

        public String getRequest() {
            return this.request;
        }

        public void setRequest(String request) {
            this.request = request;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public List<String> getStores() {
            if (this.stores == null) {
                this.stores = new LinkedList<String>();
            }
            return this.stores;
        }

        public void setStores(List<String> stores) {
            this.stores = stores;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            Responder.notEmpty(this.servletPaths, (String)"servletPaths");
            Responder.notEmpty((String)this.signer, (String)"signer");
            Responder.notEmpty((String)this.request, (String)"request");
            Responder.notEmpty((String)this.response, (String)"response");
            Responder.notEmpty(this.stores, (String)"stores");
            Responder.notEmpty((String)this.name, (String)"name");
        }
    }

    public static class RequestOption
    extends ValidatableConf {
        private boolean supportsHttpGet = false;
        private int maxRequestListCount;
        private int maxRequestSize;
        private List<String> versions;
        private Nonce nonce;
        private boolean signatureRequired;
        private boolean validateSignature;
        private List<String> hashAlgorithms;
        private CertpathValidation certpathValidation;
        private String name;

        public boolean isSupportsHttpGet() {
            return this.supportsHttpGet;
        }

        public void setSupportsHttpGet(boolean supportsHttpGet) {
            this.supportsHttpGet = supportsHttpGet;
        }

        public int getMaxRequestListCount() {
            return this.maxRequestListCount;
        }

        public void setMaxRequestListCount(int maxRequestListCount) {
            this.maxRequestListCount = maxRequestListCount;
        }

        public int getMaxRequestSize() {
            return this.maxRequestSize;
        }

        public void setMaxRequestSize(int maxRequestSize) {
            this.maxRequestSize = maxRequestSize;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public void setVersions(List<String> versions) {
            this.versions = versions;
        }

        public Nonce getNonce() {
            return this.nonce;
        }

        public void setNonce(Nonce nonce) {
            this.nonce = nonce;
        }

        public boolean isSignatureRequired() {
            return this.signatureRequired;
        }

        public void setSignatureRequired(boolean signatureRequired) {
            this.signatureRequired = signatureRequired;
        }

        public boolean isValidateSignature() {
            return this.validateSignature;
        }

        public void setValidateSignature(boolean validateSignature) {
            this.validateSignature = validateSignature;
        }

        public List<String> getHashAlgorithms() {
            if (this.hashAlgorithms == null) {
                this.hashAlgorithms = new LinkedList<String>();
            }
            return this.hashAlgorithms;
        }

        public void setHashAlgorithms(List<String> hashAlgorithms) {
            this.hashAlgorithms = hashAlgorithms;
        }

        public CertpathValidation getCertpathValidation() {
            return this.certpathValidation;
        }

        public void setCertpathValidation(CertpathValidation certpathValidation) {
            this.certpathValidation = certpathValidation;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void validate() throws InvalidConfException {
            RequestOption.notEmpty(this.versions, (String)"versions");
            RequestOption.notNull((Object)((Object)this.nonce), (String)"nonce");
            RequestOption.validate((ValidatableConf)this.nonce);
            RequestOption.validate((ValidatableConf)this.certpathValidation);
        }

        public static class CertpathValidation
        extends ValidatableConf {
            private ValidationModel validationModel;
            private CertCollection trustAnchors;
            private CertCollection certs;

            public ValidationModel getValidationModel() {
                return this.validationModel;
            }

            public void setValidationModel(ValidationModel validationModel) {
                this.validationModel = validationModel;
            }

            public CertCollection getTrustAnchors() {
                return this.trustAnchors;
            }

            public void setTrustAnchors(CertCollection trustAnchors) {
                this.trustAnchors = trustAnchors;
            }

            public CertCollection getCerts() {
                return this.certs;
            }

            public void setCerts(CertCollection certs) {
                this.certs = certs;
            }

            public void validate() throws InvalidConfException {
                CertpathValidation.notNull((Object)((Object)this.validationModel), (String)"validationModel");
                CertpathValidation.notNull((Object)((Object)this.trustAnchors), (String)"trustAnchors");
                CertpathValidation.validate((ValidatableConf)this.trustAnchors);
                CertpathValidation.validate((ValidatableConf)this.certs);
            }
        }
    }

    public static class Nonce
    extends ValidatableConf {
        private String occurrence;
        private Integer minLen;
        private Integer maxLen;

        public String getOccurrence() {
            return this.occurrence;
        }

        public void setOccurrence(String occurrence) {
            this.occurrence = occurrence;
        }

        public Integer getMinLen() {
            return this.minLen;
        }

        public void setMinLen(Integer minLen) {
            this.minLen = minLen;
        }

        public Integer getMaxLen() {
            return this.maxLen;
        }

        public void setMaxLen(Integer maxLen) {
            this.maxLen = maxLen;
        }

        public void validate() throws InvalidConfException {
            Nonce.notEmpty((String)this.occurrence, (String)"occurrence");
        }
    }

    public static class Datasource
    extends ValidatableConf {
        private FileOrValue conf;
        private String name;

        public FileOrValue getConf() {
            return this.conf;
        }

        public void setConf(FileOrValue value) {
            this.conf = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) {
            this.name = value;
        }

        public void validate() throws InvalidConfException {
            Datasource.notEmpty((String)this.name, (String)"name");
            Datasource.notNull((Object)this.conf, (String)"conf");
            Datasource.validate((ValidatableConf)this.conf);
        }
    }

    public static class CertCollection
    extends ValidatableConf {
        private String dir;
        private Keystore keystore;

        public String getDir() {
            return this.dir;
        }

        public void setDir(String value) {
            this.dir = value;
        }

        public Keystore getKeystore() {
            return this.keystore;
        }

        public void setKeystore(Keystore value) {
            this.keystore = value;
        }

        public void validate() throws InvalidConfException {
            this.exactOne((Object)this.keystore, "keystore", this.dir, "dir");
            CertCollection.validate((ValidatableConf)this.keystore);
        }

        public static class Keystore
        extends ValidatableConf {
            private String type;
            private FileOrBinary keystore;
            private String password;

            public String getType() {
                return this.type;
            }

            public void setType(String value) {
                this.type = value;
            }

            public FileOrBinary getKeystore() {
                return this.keystore;
            }

            public void setKeystore(FileOrBinary value) {
                this.keystore = value;
            }

            public String getPassword() {
                return this.password;
            }

            public void setPassword(String value) {
                this.password = value;
            }

            public void validate() throws InvalidConfException {
                Keystore.notEmpty((String)this.type, (String)"type");
                Keystore.validate((ValidatableConf)this.keystore);
            }
        }
    }

    public static enum ValidationModel {
        PKIX,
        CHAIN;

    }

    public static enum EmbedCertsMode {
        NONE,
        SIGNER,
        SIGNER_AND_CA;

    }
}

