/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.OCSPRequest;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspRespWithCacheInfo;
import org.xipki.ocsp.api.OcspServer;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.OcspStoreFactoryRegister;
import org.xipki.ocsp.api.Responder;
import org.xipki.ocsp.api.ResponderAndPath;
import org.xipki.ocsp.server.CertWithEncoded;
import org.xipki.ocsp.server.OCSPRespBuilder;
import org.xipki.ocsp.server.OcspResponseStatus;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.RequestOption;
import org.xipki.ocsp.server.ResponderImpl;
import org.xipki.ocsp.server.ResponderOption;
import org.xipki.ocsp.server.ResponderSigner;
import org.xipki.ocsp.server.ResponseCacher;
import org.xipki.ocsp.server.Template;
import org.xipki.ocsp.server.type.CertID;
import org.xipki.ocsp.server.type.EncodingException;
import org.xipki.ocsp.server.type.ExtendedExtension;
import org.xipki.ocsp.server.type.Extension;
import org.xipki.ocsp.server.type.Extensions;
import org.xipki.ocsp.server.type.OID;
import org.xipki.ocsp.server.type.OcspRequest;
import org.xipki.ocsp.server.type.ResponderID;
import org.xipki.ocsp.server.type.TaggedCertSequence;
import org.xipki.ocsp.server.type.WritableOnlyExtension;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.AlgorithmCode;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CertpathValidationModel;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrBinary;
import org.xipki.util.FileOrValue;
import org.xipki.util.HealthCheckResult;
import org.xipki.util.Hex;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.StringUtil;
import org.xipki.util.TripleState;

public class OcspServerImpl
implements OcspServer {
    public static final long DFLT_CACHE_MAX_AGE = 60L;
    private static final byte[] DERNullBytes = new byte[]{5, 0};
    private static final byte[] bytes_certstatus_good = new byte[]{-128, 0};
    private static final byte[] bytes_certstatus_unknown = new byte[]{-126, 0};
    private static final byte[] bytes_certstatus_rfc6960_unknown = Hex.decode((String)"a116180f31393730303130313030303030305aa0030a0106");
    private static final WritableOnlyExtension extension_pkix_ocsp_extendedRevoke;
    private static final Logger LOG;
    private static final Map<OcspResponseStatus, OcspRespWithCacheInfo> unsuccesfulOCSPRespMap;
    private final DataSourceFactory datasourceFactory;
    private SecurityFactory securityFactory;
    private String confFile;
    private boolean master;
    private ResponseCacher responseCacher;
    private OcspStoreFactoryRegister ocspStoreFactoryRegister;
    private Map<String, ResponderImpl> responders = new HashMap<String, ResponderImpl>();
    private Map<String, ResponderSigner> signers = new HashMap<String, ResponderSigner>();
    private Map<String, RequestOption> requestOptions = new HashMap<String, RequestOption>();
    private Map<String, OcspServerConf.ResponseOption> responseOptions = new HashMap<String, OcspServerConf.ResponseOption>();
    private Map<String, OcspStore> stores = new HashMap<String, OcspStore>();
    private List<String> servletPaths = new ArrayList<String>();
    private Map<String, ResponderImpl> path2responderMap = new HashMap<String, ResponderImpl>();
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public OcspServerImpl() {
        this.datasourceFactory = new DataSourceFactory();
    }

    public void setSecurityFactory(SecurityFactory securityFactory) {
        this.securityFactory = securityFactory;
    }

    public void setConfFile(String confFile) {
        this.confFile = confFile;
    }

    public ResponderAndPath getResponderForPath(String path) throws UnsupportedEncodingException {
        for (String servletPath : this.servletPaths) {
            if (!path.startsWith(servletPath)) continue;
            return new ResponderAndPath(servletPath, (Responder)this.path2responderMap.get(servletPath));
        }
        return null;
    }

    public ResponderImpl getResponder(String name) {
        Args.notBlank((String)name, (String)"name");
        return this.responders.get(name);
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void init() throws InvalidConfException, DataAccessException, PasswordResolverException {
        this.init(true);
    }

    public void init(boolean force) throws InvalidConfException, DataAccessException, PasswordResolverException {
        LOG.info("starting OCSPResponder server ...");
        if (this.initialized.get() && !force) {
            LOG.info("already started, skipping ...");
            return;
        }
        try {
            this.init0();
            this.initialized.set(true);
            LOG.info("started OCSPResponder server");
        }
        catch (PasswordResolverException | InvalidConfException ex) {
            LOG.error("could not start OCSP responder", ex);
            throw ex;
        }
        catch (Error ex) {
            LOG.error("could not start OCSP responder", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            LOG.error("could not start OCSP responder", (Throwable)ex);
            throw ex;
        }
        catch (Throwable th) {
            LOG.error("could not start OCSP responder", th);
            throw new IllegalStateException(th);
        }
    }

    private void init0() throws OcspStoreException, InvalidConfException, PasswordResolverException {
        ResponderOption option;
        if (this.confFile == null) {
            throw new IllegalStateException("confFile is not set");
        }
        if (this.datasourceFactory == null) {
            throw new IllegalStateException("datasourceFactory is not set");
        }
        if (this.securityFactory == null) {
            throw new IllegalStateException("securityFactory is not set");
        }
        this.initialized.set(false);
        this.responseCacher = null;
        this.responders.clear();
        this.signers.clear();
        this.requestOptions.clear();
        this.responseOptions.clear();
        for (String name2 : this.stores.keySet()) {
            OcspStore store = this.stores.get(name2);
            try {
                store.close();
            }
            catch (IOException iOException) {
                throw new OcspStoreException("could not close OCSP store " + name2, (Throwable)iOException);
            }
        }
        this.stores.clear();
        this.servletPaths.clear();
        this.path2responderMap.clear();
        OcspServerConf conf = OcspServerImpl.parseConf(this.confFile);
        HashSet<String> set = new HashSet<String>();
        for (OcspServerConf.Responder responder : conf.getResponders()) {
            String string = responder.getName();
            if ("health".equalsIgnoreCase(string) || "mgmt".equalsIgnoreCase(string)) {
                throw new InvalidConfException("responder name '" + string + "' is not permitted");
            }
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of responder named '" + string + "'");
            }
            if (StringUtil.isBlank((String)string)) {
                throw new InvalidConfException("responder name may not be empty");
            }
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                if ((ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '-') && ch != '_' && ch != '.') continue;
                throw new InvalidConfException("invalid OCSP responder name '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (OcspServerConf.Signer signer : conf.getSigners()) {
            String string = signer.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of signer option named '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (OcspServerConf.RequestOption requestOption : conf.getRequestOptions()) {
            String string = requestOption.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of request option named '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (OcspServerConf.ResponseOption responseOption : conf.getResponseOptions()) {
            String string = responseOption.getName();
            if (set.contains(string)) {
                throw new InvalidConfException("duplicated definition of response option named '" + string + "'");
            }
            set.add(string);
        }
        set.clear();
        for (OcspServerConf.Store store : conf.getStores()) {
            String string = store.getName();
            if (!set.contains(string)) continue;
            throw new InvalidConfException("duplicated definition of store named '" + string + "'");
        }
        set.clear();
        if (conf.getDatasources() != null) {
            for (OcspServerConf.Datasource datasource : conf.getDatasources()) {
                String string = datasource.getName();
                if (set.contains(string)) {
                    throw new InvalidConfException("duplicated definition of datasource named '" + string + "'");
                }
                set.add(string);
            }
        }
        this.master = conf.isMaster();
        OcspServerConf.ResponseCache cacheType = conf.getResponseCache();
        if (cacheType != null) {
            DataSourceWrapper dataSourceWrapper;
            OcspServerConf.Datasource datasource = cacheType.getDatasource();
            InputStream dsStream = null;
            try {
                dsStream = OcspServerImpl.getInputStream(datasource.getConf());
                dataSourceWrapper = this.datasourceFactory.createDataSource(datasource.getName(), dsStream, this.securityFactory.getPasswordResolver());
            }
            catch (IOException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                OcspServerImpl.closeStream(dsStream);
            }
            this.responseCacher = new ResponseCacher(dataSourceWrapper, this.master, cacheType.getValidity());
            this.responseCacher.init();
        }
        for (OcspServerConf.Signer signer : conf.getSigners()) {
            ResponderSigner signer2 = this.initSigner(signer);
            this.signers.put(signer.getName(), signer2);
        }
        for (OcspServerConf.RequestOption requestOption : conf.getRequestOptions()) {
            RequestOption option2 = new RequestOption(requestOption);
            this.requestOptions.put(requestOption.getName(), option2);
        }
        for (OcspServerConf.ResponseOption responseOption : conf.getResponseOptions()) {
            this.responseOptions.put(responseOption.getName(), responseOption);
        }
        HashMap<String, DataSourceWrapper> hashMap = new HashMap<String, DataSourceWrapper>();
        if (conf.getDatasources() != null) {
            for (OcspServerConf.Datasource m : conf.getDatasources()) {
                DataSourceWrapper datasource;
                String name3 = m.getName();
                InputStream dsStream = null;
                try {
                    dsStream = OcspServerImpl.getInputStream(m.getConf());
                    datasource = this.datasourceFactory.createDataSource(name3, dsStream, this.securityFactory.getPasswordResolver());
                }
                catch (IOException ex) {
                    throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    OcspServerImpl.closeStream(dsStream);
                }
                hashMap.put(name3, datasource);
            }
        }
        HashMap<String, ResponderOption> hashMap2 = new HashMap<String, ResponderOption>();
        for (OcspServerConf.Responder m : conf.getResponders()) {
            option = new ResponderOption(m);
            String optName = option.getSignerName();
            if (!this.signers.containsKey(optName)) {
                throw new InvalidConfException("no signer named '" + optName + "' is defined");
            }
            String reqOptName = option.getRequestOptionName();
            if (!this.requestOptions.containsKey(reqOptName)) {
                throw new InvalidConfException("no requestOption named '" + (String)reqOptName + "' is defined");
            }
            String respOptName = option.getResponseOptionName();
            if (!this.responseOptions.containsKey(respOptName)) {
                throw new InvalidConfException("no responseOption named '" + respOptName + "' is defined");
            }
            List<OcspServerConf.Store> storeDefs = conf.getStores();
            HashSet<String> storeNames = new HashSet<String>(storeDefs.size());
            for (OcspServerConf.Store storeDef : storeDefs) {
                storeNames.add(storeDef.getName());
            }
            hashMap2.put(m.getName(), option);
        }
        for (OcspServerConf.Store m : conf.getStores()) {
            OcspStore store = this.newStore(m, hashMap);
            this.stores.put(m.getName(), store);
        }
        for (String name4 : hashMap2.keySet()) {
            option = (ResponderOption)hashMap2.get(name4);
            ArrayList<OcspStore> statusStores = new ArrayList<OcspStore>(option.getStoreNames().size());
            for (String storeName : option.getStoreNames()) {
                statusStores.add(this.stores.get(storeName));
            }
            OcspServerConf.ResponseOption responseOption = this.responseOptions.get(option.getResponseOptionName());
            ResponderSigner signer = this.signers.get(option.getSignerName());
            if (signer.isMacSigner()) {
                if (responseOption.isResponderIdByName()) {
                    throw new InvalidConfException("could not use ResponderIdByName for signer " + option.getSignerName());
                }
                if (OcspServerConf.EmbedCertsMode.NONE != responseOption.getEmbedCertsMode()) {
                    throw new InvalidConfException("could not embed certifcate in response for signer " + option.getSignerName());
                }
            }
            ResponderImpl responder = new ResponderImpl(option, this.requestOptions.get(option.getRequestOptionName()), responseOption, signer, statusStores);
            this.responders.put(name4, responder);
        }
        LinkedList<SizeComparableString> tmpList = new LinkedList<SizeComparableString>();
        for (String name5 : hashMap2.keySet()) {
            ResponderImpl responder = this.responders.get(name5);
            ResponderOption option3 = (ResponderOption)hashMap2.get(name5);
            List<String> strs = option3.getServletPaths();
            for (String path : strs) {
                tmpList.add(new SizeComparableString(path));
                this.path2responderMap.put(path, responder);
            }
        }
        Collections.sort(tmpList);
        ArrayList<String> list2 = new ArrayList<String>(tmpList.size());
        for (SizeComparableString m : tmpList) {
            list2.add(m.str);
        }
        this.servletPaths = list2;
    }

    public void close() {
        LOG.info("stopped OCSP Responder");
        if (this.responseCacher != null) {
            this.responseCacher.close();
        }
        for (OcspStore store : this.stores.values()) {
            try {
                store.close();
            }
            catch (Exception ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("shutdown store " + store.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public OcspRespWithCacheInfo answer(Responder responder2, byte[] request, boolean viaGet) {
        int version;
        ResponderImpl responder = (ResponderImpl)responder2;
        RequestOption reqOpt = responder.getRequestOption();
        try {
            version = OcspRequest.readRequestVersion(request);
        }
        catch (EncodingException ex) {
            String message = "could not extract version from request";
            LOG.warn(message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        if (!reqOpt.isVersionAllowed(version)) {
            String message = "invalid request version " + version;
            LOG.warn(message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        ResponderSigner signer = responder.getSigner();
        OcspServerConf.ResponseOption repOpt = responder.getResponseOption();
        try {
            byte[] encodeOcspResponse;
            OcspServerConf.EmbedCertsMode certsMode;
            boolean canCacheDb;
            ExtendedExtension extn;
            Object reqOrRrrorResp = this.checkSignature(request, reqOpt);
            if (reqOrRrrorResp instanceof OcspRespWithCacheInfo) {
                return (OcspRespWithCacheInfo)reqOrRrrorResp;
            }
            OcspRequest req = (OcspRequest)reqOrRrrorResp;
            List<CertID> requestList = req.getRequestList();
            int requestsSize = requestList.size();
            if (requestsSize > reqOpt.getMaxRequestListCount()) {
                String message = requestsSize + " entries in RequestList, but maximal " + reqOpt.getMaxRequestListCount() + " is allowed";
                LOG.warn(message);
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
            OcspRespControl repControl = new OcspRespControl();
            repControl.canCacheInfo = true;
            List<ExtendedExtension> reqExtensions = req.getExtensions();
            LinkedList<Extension> respExtensions = new LinkedList<Extension>();
            ExtendedExtension nonceExtn = OcspServerImpl.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_NONCE);
            if (nonceExtn != null) {
                if (reqOpt.getNonceOccurrence() == TripleState.forbidden) {
                    LOG.warn("nonce forbidden, but is present in the request");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                int len = nonceExtn.getExtnValueLength();
                int min = reqOpt.getNonceMinLen();
                int max = reqOpt.getNonceMaxLen();
                if (len < min || len > max) {
                    LOG.warn("length of nonce {} not within [{},{}]", new Object[]{len, min, max});
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                repControl.canCacheInfo = false;
                respExtensions.add(nonceExtn);
            } else if (reqOpt.getNonceOccurrence() == TripleState.required) {
                LOG.warn("nonce required, but is not present in the request");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
            ConcurrentContentSigner concurrentSigner = null;
            if (responder.getResponderOption().getMode() != ResponderOption.OcspMode.RFC2560 && (extn = OcspServerImpl.removeExtension(reqExtensions, OID.ID_PKIX_OCSP_PREFSIGALGS)) != null) {
                ArrayList<AlgorithmIdentifier> arrayList;
                try (ASN1InputStream asn1Stream = new ASN1InputStream(extn.getExtnValueStream());){
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1Stream.readObject());
                    int size = seq.size();
                    arrayList = new ArrayList<AlgorithmIdentifier>(size);
                    for (int i = 0; i < size; ++i) {
                        arrayList.add(AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(i)));
                    }
                }
                concurrentSigner = signer.getSignerForPreferredSigAlgs(arrayList);
            }
            if (!reqExtensions.isEmpty()) {
                boolean flag = false;
                for (ExtendedExtension extendedExtension : reqExtensions) {
                    if (!extendedExtension.isCritical()) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    if (LOG.isWarnEnabled()) {
                        LinkedList<OID> oids = new LinkedList<OID>();
                        for (ExtendedExtension m : reqExtensions) {
                            if (!m.isCritical()) continue;
                            oids.add(m.getExtnType());
                        }
                        LOG.warn("could not process critial request extensions: {}", oids);
                    }
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
            }
            if (concurrentSigner == null) {
                concurrentSigner = signer.getFirstSigner();
            }
            AlgorithmCode cacheDbSigAlgCode = null;
            BigInteger cacheDbSerialNumber = null;
            Object var20_40 = null;
            boolean bl = canCacheDb = requestsSize == 1 && this.responseCacher != null && nonceExtn == null && this.responseCacher.isOnService();
            if (canCacheDb) {
                void var20_43;
                CertID certId = requestList.get(0);
                HashAlgo reqHashAlgo = certId.getIssuer().hashAlgorithm();
                if (!reqOpt.allows(reqHashAlgo)) {
                    LOG.warn("CertID.hashAlgorithm {} not allowed", reqHashAlgo != null ? reqHashAlgo : certId.getIssuer().hashAlgorithmOID());
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
                }
                cacheDbSigAlgCode = concurrentSigner.getAlgorithmCode();
                Integer n = this.responseCacher.getIssuerId(certId.getIssuer());
                cacheDbSerialNumber = certId.getSerialNumber();
                if (n != null) {
                    OcspRespWithCacheInfo cachedResp = this.responseCacher.getOcspResponse(n, cacheDbSerialNumber, cacheDbSigAlgCode);
                    if (cachedResp != null) {
                        return cachedResp;
                    }
                } else if (this.master) {
                    OcspStore store;
                    X509Certificate issuerCert = null;
                    Iterator<OcspStore> iterator = responder.getStores().iterator();
                    while (iterator.hasNext() && (issuerCert = (store = iterator.next()).getIssuerCert(certId.getIssuer())) == null) {
                    }
                    if (issuerCert != null) {
                        Integer n2 = this.responseCacher.storeIssuer(issuerCert);
                    }
                }
                if (var20_43 == null) {
                    canCacheDb = false;
                }
            }
            ResponderID responderId = signer.getResponderId(repOpt.isResponderIdByName());
            OCSPRespBuilder builder = new OCSPRespBuilder(responderId);
            for (int i = 0; i < requestsSize; ++i) {
                OcspRespWithCacheInfo failureOcspResp = this.processCertReq(requestList.get(i), builder, responder, reqOpt, repOpt, repControl);
                if (failureOcspResp == null) continue;
                return failureOcspResp;
            }
            if (repControl.includeExtendedRevokeExtension) {
                respExtensions.add(extension_pkix_ocsp_extendedRevoke);
            }
            if (!respExtensions.isEmpty()) {
                Extensions extns = new Extensions(respExtensions);
                builder.setResponseExtensions(extns);
            }
            Object certsInResp = (certsMode = repOpt.getEmbedCertsMode()) == OcspServerConf.EmbedCertsMode.SIGNER ? signer.getSequenceOfCert() : (certsMode == OcspServerConf.EmbedCertsMode.NONE ? null : signer.getSequenceOfCertChain());
            try {
                encodeOcspResponse = builder.buildOCSPResponse(concurrentSigner, (TaggedCertSequence)certsInResp, new Date());
            }
            catch (NoIdleSignerException ex) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
            }
            catch (OCSPException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"answer() basicOcspBuilder.build");
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
            }
            if (canCacheDb && repControl.canCacheInfo) {
                void var20_44;
                this.responseCacher.storeOcspResponse(var20_44.intValue(), cacheDbSerialNumber, repControl.cacheThisUpdate, repControl.cacheNextUpdate, cacheDbSigAlgCode, encodeOcspResponse);
            }
            if (viaGet && repControl.canCacheInfo) {
                OcspRespWithCacheInfo.ResponseCacheInfo cacheInfo = new OcspRespWithCacheInfo.ResponseCacheInfo(repControl.cacheThisUpdate);
                if (repControl.cacheNextUpdate != Long.MAX_VALUE) {
                    cacheInfo.setNextUpdate(Long.valueOf(repControl.cacheNextUpdate));
                }
                return new OcspRespWithCacheInfo(encodeOcspResponse, cacheInfo);
            }
            return new OcspRespWithCacheInfo(encodeOcspResponse, null);
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.internalError);
        }
    }

    private OcspRespWithCacheInfo processCertReq(CertID certId, OCSPRespBuilder builder, ResponderImpl responder, RequestOption reqOpt, OcspServerConf.ResponseOption repOpt, OcspRespControl repControl) throws IOException {
        byte[] certHash;
        byte[] certStatus;
        Date thisUpdate;
        HashAlgo reqHashAlgo = certId.getIssuer().hashAlgorithm();
        if (!reqOpt.allows(reqHashAlgo)) {
            LOG.warn("CertID.hashAlgorithm {} not allowed", (Object)reqHashAlgo);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        CertStatusInfo certStatusInfo = null;
        boolean exceptionOccurs = false;
        BigInteger serial = certId.getSerialNumber();
        Date now = new Date();
        for (OcspStore store : responder.getStores()) {
            try {
                certStatusInfo = store.getCertStatus(now, certId.getIssuer(), serial, repOpt.isIncludeCerthash(), repOpt.isIncludeInvalidityDate(), responder.getResponderOption().isInheritCaRevocation());
                if (certStatusInfo == null) continue;
                break;
            }
            catch (OcspStoreException ex) {
                exceptionOccurs = true;
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("getCertStatus() of CertStatusStore " + store.getName()));
            }
        }
        if (certStatusInfo == null) {
            if (exceptionOccurs) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.tryLater);
            }
            certStatusInfo = CertStatusInfo.getIssuerUnknownCertStatusInfo((Date)new Date(), null);
        }
        if ((thisUpdate = certStatusInfo.getThisUpdate()) == null) {
            thisUpdate = new Date();
        }
        Date nextUpdate = certStatusInfo.getNextUpdate();
        LinkedList<Extension> extensions = new LinkedList<Extension>();
        boolean unknownAsRevoked = false;
        switch (certStatusInfo.getCertStatus()) {
            case GOOD: {
                certStatus = bytes_certstatus_good;
                break;
            }
            case ISSUER_UNKNOWN: {
                repControl.canCacheInfo = false;
                certStatus = bytes_certstatus_unknown;
                break;
            }
            case UNKNOWN: 
            case IGNORE: {
                repControl.canCacheInfo = false;
                if (responder.getResponderOption().getMode() == ResponderOption.OcspMode.RFC2560) {
                    certStatus = bytes_certstatus_unknown;
                    break;
                }
                unknownAsRevoked = true;
                certStatus = bytes_certstatus_rfc6960_unknown;
                break;
            }
            case REVOKED: {
                CertRevocationInfo revInfo = certStatusInfo.getRevocationInfo();
                certStatus = Template.getEncodeRevokedInfo(repOpt.isIncludeRevReason() ? revInfo.getReason() : null, revInfo.getRevocationTime());
                Date invalidityDate = revInfo.getInvalidityTime();
                if (!repOpt.isIncludeInvalidityDate() || invalidityDate == null || invalidityDate.equals(revInfo.getRevocationTime())) break;
                extensions.add(Template.getInvalidityDateExtension(invalidityDate));
                break;
            }
            default: {
                throw new IllegalStateException("unknown CertificateStatus:" + certStatusInfo.getCertStatus());
            }
        }
        if (responder.getResponderOption().getMode() != ResponderOption.OcspMode.RFC2560) {
            repControl.includeExtendedRevokeExtension = true;
        }
        if ((certHash = certStatusInfo.getCertHash()) != null) {
            extensions.add(Template.getCertHashExtension(certStatusInfo.getCertHashAlgo(), certHash));
        }
        if (certStatusInfo.getArchiveCutOff() != null) {
            extensions.add(Template.getArchiveOffExtension(certStatusInfo.getArchiveCutOff()));
        }
        if (LOG.isDebugEnabled()) {
            String certStatusText = null;
            certStatusText = Arrays.equals(certStatus, bytes_certstatus_good) ? "good" : (Arrays.equals(certStatus, bytes_certstatus_unknown) ? "unknown" : (Arrays.equals(certStatus, bytes_certstatus_rfc6960_unknown) ? "RFC6969_unknown" : (unknownAsRevoked ? "unknown_as_revoked" : "revoked")));
            String msg = StringUtil.concatObjectsCap((int)250, (Object)"issuer: ", (Object[])new Object[]{certId.getIssuer(), ", serialNumber: ", LogUtil.formatCsn((BigInteger)certId.getSerialNumber()), ", certStatus: ", certStatusText, ", thisUpdate: ", thisUpdate, ", nextUpdate: ", nextUpdate});
            StringBuilder sb = new StringBuilder(msg.length() + 80);
            sb.append(msg);
            if (certHash != null) {
                sb.append(", certHash: ").append(Hex.encode((byte[])certHash));
            }
            LOG.debug(sb.toString());
        }
        if (CollectionUtil.isEmpty(extensions)) {
            builder.addResponse(certId, certStatus, thisUpdate, nextUpdate, null);
        } else {
            builder.addResponse(certId, certStatus, thisUpdate, nextUpdate, new Extensions(extensions));
        }
        repControl.cacheThisUpdate = Math.max(repControl.cacheThisUpdate, thisUpdate.getTime());
        if (nextUpdate != null) {
            repControl.cacheNextUpdate = Math.min(repControl.cacheNextUpdate, nextUpdate.getTime());
        }
        return null;
    }

    public HealthCheckResult healthCheck(Responder responder2) {
        ResponderImpl responder = (ResponderImpl)responder2;
        HealthCheckResult result = new HealthCheckResult();
        result.setName("OCSPResponder");
        boolean healthy = true;
        for (OcspStore store : responder.getStores()) {
            boolean storeHealthy = store.isHealthy();
            healthy &= storeHealthy;
            HealthCheckResult storeHealth = new HealthCheckResult();
            storeHealth.setName("CertStatusStore." + store.getName());
            storeHealth.setHealthy(storeHealthy);
            result.addChildCheck(storeHealth);
        }
        boolean signerHealthy = responder.getSigner().isHealthy();
        HealthCheckResult signerHealth = new HealthCheckResult();
        signerHealth.setName("Signer");
        signerHealth.setHealthy(signerHealthy);
        result.addChildCheck(signerHealth);
        result.setHealthy(healthy &= signerHealthy);
        return result;
    }

    public void setOcspStoreFactoryRegister(OcspStoreFactoryRegister ocspStoreFactoryRegister) {
        this.ocspStoreFactoryRegister = ocspStoreFactoryRegister;
    }

    public void refreshTokenForSignerType(String signerType) throws XiSecurityException {
        this.securityFactory.refreshTokenForSignerType(signerType);
    }

    private ResponderSigner initSigner(OcspServerConf.Signer signerType) throws InvalidConfException {
        X509Certificate[] explicitCertificateChain = null;
        X509Certificate explicitResponderCert = null;
        if (signerType.getCert() != null) {
            explicitResponderCert = OcspServerImpl.parseCert(signerType.getCert());
        }
        if (explicitResponderCert != null) {
            HashSet<X509Certificate> caCerts = null;
            if (signerType.getCaCerts() != null) {
                caCerts = new HashSet<X509Certificate>();
                for (FileOrBinary certConf : signerType.getCaCerts()) {
                    caCerts.add(OcspServerImpl.parseCert(certConf));
                }
            }
            explicitCertificateChain = X509Util.buildCertPath((X509Certificate)explicitResponderCert, caCerts);
        }
        String responderSignerType = signerType.getType();
        String responderKeyConf = signerType.getKey();
        List<String> sigAlgos = signerType.getAlgorithms();
        ArrayList<ConcurrentContentSigner> singleSigners = new ArrayList<ConcurrentContentSigner>(sigAlgos.size());
        for (String sigAlgo : sigAlgos) {
            try {
                ConcurrentContentSigner requestorSigner = this.securityFactory.createSigner(responderSignerType, new SignerConf("algo=" + sigAlgo + "," + responderKeyConf), explicitCertificateChain);
                singleSigners.add(requestorSigner);
            }
            catch (ObjectCreationException ex) {
                throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            return new ResponderSigner(singleSigners);
        }
        catch (IOException | CertificateException ex) {
            throw new InvalidConfException(ex.getMessage(), (Throwable)ex);
        }
    }

    private OcspStore newStore(OcspServerConf.Store conf, Map<String, DataSourceWrapper> datasources) throws InvalidConfException {
        OcspStore store;
        try {
            store = this.ocspStoreFactoryRegister.newOcspStore(conf.getSource().getType());
        }
        catch (ObjectCreationException ex) {
            throw new InvalidConfException("ObjectCreationException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
        }
        store.setName(conf.getName());
        Integer interval = conf.getRetentionInterval();
        int retentionInterva = interval == null ? -1 : interval;
        store.setRetentionInterval(retentionInterva);
        store.setUnknownSerialAsGood(OcspServerImpl.getBoolean(conf.getUnknownSerialAsGood(), false));
        store.setIncludeArchiveCutoff(OcspServerImpl.getBoolean(conf.getIncludeArchiveCutoff(), true));
        store.setIncludeCrlId(OcspServerImpl.getBoolean(conf.getIncludeCrlId(), true));
        store.setIgnoreExpiredCert(OcspServerImpl.getBoolean(conf.getIgnoreExpiredCert(), true));
        store.setIgnoreNotYetValidCert(OcspServerImpl.getBoolean(conf.getIgnoreNotYetValidCert(), true));
        String datasourceName = conf.getSource().getDatasource();
        DataSourceWrapper datasource = null;
        if (datasourceName != null && (datasource = datasources.get(datasourceName)) == null) {
            throw new InvalidConfException("datasource named '" + datasourceName + "' not defined");
        }
        try {
            OcspServerConf.SourceConfImpl sourceConf = conf.getSource().getConf();
            store.init((OcspStore.SourceConf)sourceConf, datasource);
        }
        catch (OcspStoreException ex) {
            throw new InvalidConfException("CertStatusStoreException of store " + conf.getName() + ":" + ex.getMessage(), (Throwable)ex);
        }
        return store;
    }

    private Object checkSignature(byte[] request, RequestOption requestOption) throws OCSPException, CertificateParsingException, InvalidAlgorithmParameterException {
        ContentVerifierProvider cvp;
        OCSPRequest req;
        try {
            if (!requestOption.isValidateSignature()) {
                return OcspRequest.getInstance(request);
            }
            if (!OcspRequest.containsSignature(request)) {
                if (requestOption.isSignatureRequired()) {
                    LOG.warn("signature in request required");
                    return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.sigRequired);
                }
                return OcspRequest.getInstance(request);
            }
            try {
                req = OCSPRequest.getInstance((Object)request);
            }
            catch (IllegalArgumentException ex) {
                throw new EncodingException("could not parse OCSP request", ex);
            }
        }
        catch (EncodingException ex) {
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
        }
        OCSPReq ocspReq = new OCSPReq(req);
        X509CertificateHolder[] certs = ocspReq.getCerts();
        if (certs == null || certs.length < 1) {
            LOG.warn("no certificate found in request to verify the signature");
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        try {
            cvp = this.securityFactory.getContentVerifierProvider(certs[0]);
        }
        catch (InvalidKeyException ex) {
            String message = ex.getMessage();
            LOG.warn("securityFactory.getContentVerifierProvider, InvalidKeyException: {}", (Object)message);
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        boolean sigValid = ocspReq.isSignatureValid(cvp);
        if (!sigValid) {
            LOG.warn("request signature is invalid");
            return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
        }
        Date referenceTime = new Date();
        if (OcspServerImpl.canBuildCertpath(certs, requestOption, referenceTime)) {
            try {
                return OcspRequest.getInstance(req);
            }
            catch (EncodingException ex) {
                return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.malformedRequest);
            }
        }
        LOG.warn("could not build certpath for the request's signer certificate");
        return unsuccesfulOCSPRespMap.get((Object)OcspResponseStatus.unauthorized);
    }

    private static boolean canBuildCertpath(X509CertificateHolder[] certsInReq, RequestOption requestOption, Date referenceTime) {
        Set<X509Certificate> configuredCerts;
        X509Certificate target;
        try {
            target = X509Util.toX509Cert((Certificate)certsInReq[0].toASN1Structure());
        }
        catch (CertificateException ex) {
            return false;
        }
        HashSet<X509Certificate> certstore = new HashSet<X509Certificate>();
        Set<CertWithEncoded> trustAnchors = requestOption.getTrustAnchors();
        for (CertWithEncoded m : trustAnchors) {
            certstore.add(m.getCert());
        }
        int n = certsInReq.length;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                X509Certificate cert;
                try {
                    cert = X509Util.toX509Cert((Certificate)certsInReq[i].toASN1Structure());
                }
                catch (CertificateException ex) {
                    continue;
                }
                certstore.add(cert);
            }
        }
        if (CollectionUtil.isNonEmpty(configuredCerts = requestOption.getCerts())) {
            certstore.addAll(requestOption.getCerts());
        }
        X509Certificate[] certpath = X509Util.buildCertPath((X509Certificate)target, certstore);
        CertpathValidationModel model = requestOption.getCertpathValidationModel();
        Date now = new Date();
        if (model == null || model == CertpathValidationModel.PKIX) {
            for (X509Certificate x509Certificate : certpath) {
                if (!x509Certificate.getNotBefore().after(now) && !x509Certificate.getNotAfter().before(now)) continue;
                return false;
            }
        } else if (model != CertpathValidationModel.CHAIN) {
            throw new IllegalStateException("invalid CertpathValidationModel " + model.name());
        }
        for (int i = certpath.length - 1; i >= 0; --i) {
            X509Certificate targetCert = certpath[i];
            for (CertWithEncoded certWithEncoded : trustAnchors) {
                if (!certWithEncoded.equalsCert(targetCert)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean getBoolean(Boolean bo, boolean defaultValue) {
        return bo == null ? defaultValue : bo;
    }

    private static InputStream getInputStream(FileOrBinary conf) throws IOException {
        return conf.getFile() != null ? Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)conf.getFile()), new String[0]), new OpenOption[0]) : new ByteArrayInputStream(conf.getBinary());
    }

    private static InputStream getInputStream(FileOrValue conf) throws IOException {
        return conf.getFile() != null ? Files.newInputStream(Paths.get(IoUtil.expandFilepath((String)conf.getFile()), new String[0]), new OpenOption[0]) : new ByteArrayInputStream(conf.getValue().getBytes());
    }

    private static void closeStream(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            LOG.warn("could not close stream: {}", (Object)ex.getMessage());
        }
    }

    private static X509Certificate parseCert(FileOrBinary certConf) throws InvalidConfException {
        InputStream is = null;
        try {
            is = OcspServerImpl.getInputStream(certConf);
            X509Certificate x509Certificate = X509Util.parseCert((InputStream)is);
            return x509Certificate;
        }
        catch (IOException | CertificateException ex) {
            String msg = "could not parse certificate";
            if (certConf.getFile() != null) {
                msg = msg + " from file " + certConf.getFile();
            }
            throw new InvalidConfException(msg);
        }
        finally {
            OcspServerImpl.closeStream(is);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OcspServerConf parseConf(String confFilename) throws InvalidConfException {
        try (InputStream is = Files.newInputStream(Paths.get(confFilename, new String[0]), new OpenOption[0]);){
            OcspServerConf root = (OcspServerConf)((Object)JSON.parseObject((InputStream)is, OcspServerConf.class, (Feature[])new Feature[0]));
            root.validate();
            OcspServerConf ocspServerConf = root;
            return ocspServerConf;
        }
        catch (IOException | RuntimeException ex) {
            throw new InvalidConfException("parse profile failed, message: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static ExtendedExtension removeExtension(List<ExtendedExtension> extensions, OID extnType) {
        ExtendedExtension extn = null;
        for (ExtendedExtension m : extensions) {
            if (extnType != m.getExtnType()) continue;
            extn = m;
            break;
        }
        if (extn != null) {
            extensions.remove(extn);
        }
        return extn;
    }

    static {
        LOG = LoggerFactory.getLogger(OcspServer.class);
        unsuccesfulOCSPRespMap = new HashMap<OcspResponseStatus, OcspRespWithCacheInfo>(10);
        for (OcspResponseStatus status : OcspResponseStatus.values()) {
            byte[] encoded;
            if (status == OcspResponseStatus.successful) continue;
            OCSPResponse resp = new OCSPResponse(new OCSPResponseStatus(status.getStatus()), null);
            try {
                encoded = resp.getEncoded();
            }
            catch (IOException ex) {
                throw new ExceptionInInitializerError("could not encode OCSPResp for status " + (Object)((Object)status) + ": " + ex.getMessage());
            }
            unsuccesfulOCSPRespMap.put(status, new OcspRespWithCacheInfo(encoded, null));
        }
        ExtendedExtension ext = new ExtendedExtension(OID.ID_PKIX_OCSP_EXTENDEDREVOKE, true, DERNullBytes);
        byte[] encoded = new byte[ext.getEncodedLength()];
        ext.write(encoded, 0);
        extension_pkix_ocsp_extendedRevoke = new WritableOnlyExtension(encoded);
    }

    private static class OcspRespControl {
        boolean canCacheInfo;
        boolean includeExtendedRevokeExtension = false;
        long cacheThisUpdate = 0L;
        long cacheNextUpdate = Long.MAX_VALUE;
    }

    private static class SizeComparableString
    implements Comparable<SizeComparableString> {
        private String str;

        public SizeComparableString(String str) {
            this.str = (String)Args.notNull((Object)str, (String)"str");
        }

        @Override
        public int compareTo(SizeComparableString obj) {
            if (this.str.length() == obj.str.length()) {
                return 0;
            }
            return this.str.length() > obj.str.length() ? 1 : -1;
        }
    }
}

