/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.ocsp.server.type.ResponderID;
import org.xipki.ocsp.server.type.TaggedCertSequence;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;

class ResponderSigner {
    private final Map<String, ConcurrentContentSigner> algoSignerMap;
    private final List<ConcurrentContentSigner> signers;
    private final TaggedCertSequence sequenceOfCert;
    private final X509Certificate cert;
    private final TaggedCertSequence sequenceOfCertChain;
    private final X509Certificate[] certChain;
    private final ResponderID responderIdByName;
    private final ResponderID responderIdByKey;
    private final boolean macSigner;

    ResponderSigner(List<ConcurrentContentSigner> signers) throws CertificateException, IOException {
        this.signers = Args.notEmpty(signers, (String)"signers");
        ConcurrentContentSigner firstSigner = signers.get(0);
        this.macSigner = firstSigner.isMac();
        if (this.macSigner) {
            this.responderIdByName = null;
            this.cert = null;
            this.certChain = null;
            this.sequenceOfCert = null;
            this.sequenceOfCertChain = null;
            byte[] keySha1 = firstSigner.getSha1OfMacKey();
            this.responderIdByKey = new ResponderID(keySha1);
        } else {
            X509Certificate cert;
            X509Certificate[] tmpCertChain = firstSigner.getCertificateChain();
            if (tmpCertChain == null || tmpCertChain.length == 0) {
                throw new CertificateException("no certificate is bound with the signer");
            }
            int len = tmpCertChain.length;
            if (len > 1 && (cert = tmpCertChain[len - 1]).getIssuerX500Principal().equals(cert.getSubjectX500Principal())) {
                --len;
            }
            this.certChain = new X509Certificate[len];
            System.arraycopy(tmpCertChain, 0, this.certChain, 0, len);
            this.cert = this.certChain[0];
            byte[] encodedCert = this.cert.getEncoded();
            this.sequenceOfCert = new TaggedCertSequence(encodedCert);
            byte[][] encodedCertChain = new byte[this.certChain.length][];
            encodedCertChain[0] = encodedCert;
            for (int i = 1; i < this.certChain.length; ++i) {
                encodedCertChain[i] = this.certChain[i].getEncoded();
            }
            this.sequenceOfCertChain = new TaggedCertSequence(encodedCertChain);
            Certificate bcCertificate = Certificate.getInstance((Object)encodedCert);
            this.responderIdByName = new ResponderID(bcCertificate.getSubject());
            byte[] keySha1 = HashAlgo.SHA1.hash(bcCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes());
            this.responderIdByKey = new ResponderID(keySha1);
        }
        this.algoSignerMap = new HashMap<String, ConcurrentContentSigner>();
        for (ConcurrentContentSigner signer : signers) {
            String algoName = signer.getAlgorithmName();
            this.algoSignerMap.put(algoName, signer);
        }
    }

    public boolean isMacSigner() {
        return this.macSigner;
    }

    public ConcurrentContentSigner getFirstSigner() {
        return this.signers.get(0);
    }

    public ConcurrentContentSigner getSignerForPreferredSigAlgs(List<AlgorithmIdentifier> prefSigAlgs) {
        if (prefSigAlgs == null) {
            return this.signers.get(0);
        }
        for (AlgorithmIdentifier sigAlgId : prefSigAlgs) {
            String algoName = ResponderSigner.getSignatureAlgorithmName(sigAlgId);
            if (!this.algoSignerMap.containsKey(algoName)) continue;
            return this.algoSignerMap.get(algoName);
        }
        return null;
    }

    public ResponderID getResponderId(boolean byName) {
        return byName ? this.responderIdByName : this.responderIdByKey;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public X509Certificate[] getCertChain() {
        return this.certChain;
    }

    public TaggedCertSequence getSequenceOfCert() {
        return this.sequenceOfCert;
    }

    public TaggedCertSequence getSequenceOfCertChain() {
        return this.sequenceOfCertChain;
    }

    public boolean isHealthy() {
        for (ConcurrentContentSigner signer : this.signers) {
            if (signer.isHealthy()) continue;
            return false;
        }
        return true;
    }

    private static String getSignatureAlgorithmName(AlgorithmIdentifier sigAlgId) {
        ASN1ObjectIdentifier algOid = sigAlgId.getAlgorithm();
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algOid)) {
            return algOid.getId();
        }
        ASN1Encodable asn1Encodable = sigAlgId.getParameters();
        RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)asn1Encodable);
        ASN1ObjectIdentifier digestAlgOid = param.getHashAlgorithm().getAlgorithm();
        return digestAlgOid.getId() + "WITHRSAANDMGF1";
    }
}

