/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.ImportCrl;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.DateUtil;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class CrlDbCertStatusStore
extends DbCertStatusStore {
    public static final String KEY_CA_REVOCATION_TIME = "ca.revocation.time";
    public static final String KEY_CA_INVALIDITY_TIME = "ca.invalidity.time";
    private static final Logger LOG = LoggerFactory.getLogger(CrlDbCertStatusStore.class);
    private final AtomicBoolean crlUpdateInProcess = new AtomicBoolean(false);
    private X509Certificate caCert;
    private X509Certificate issuerCert;
    private String crlFilename;
    private String crlUrl;
    private String certsDirName;
    private boolean useUpdateDatesFromCrl;
    private boolean crlUpdated;
    private boolean crlUpdateFailed;

    @Override
    public void init(OcspStore.SourceConf conf, DataSourceWrapper datasource) throws OcspStoreException {
        Args.notNull((Object)conf, (String)"conf");
        if (!(conf instanceof OcspServerConf.SourceConfImpl)) {
            throw new OcspStoreException("unknown conf " + conf.getClass().getName());
        }
        OcspServerConf.CrlSourceConf conf0 = ((OcspServerConf.SourceConfImpl)conf).getCrlSource();
        if (conf0 == null) {
            throw new OcspStoreException("conf.getDbSource() may not be null");
        }
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.crlFilename = IoUtil.expandFilepath((String)conf0.getCrlFile());
        this.crlUrl = conf0.getCrlUrl();
        this.certsDirName = conf0.getCertsDir() == null ? null : IoUtil.expandFilepath((String)conf0.getCertsDir());
        this.caCert = CrlDbCertStatusStore.parseCert(conf0.getCaCertFile());
        this.issuerCert = conf0.getIssuerCertFile() != null ? CrlDbCertStatusStore.parseCert(conf0.getIssuerCertFile()) : null;
        this.useUpdateDatesFromCrl = conf0.isUseUpdateDatesFromCrl();
        this.initializeStore(datasource);
        super.init(conf, datasource);
    }

    @Override
    protected List<Runnable> getScheduledServices() {
        return Arrays.asList(new CrlUpdateService());
    }

    @Override
    protected boolean isInitialized() {
        return this.crlUpdated && super.isInitialized();
    }

    @Override
    protected boolean isInitializationFailed() {
        return this.crlUpdateFailed || super.isInitializationFailed();
    }

    private static X509Certificate parseCert(String certFile) throws OcspStoreException {
        try {
            return X509Util.parseCert((File)new File(certFile));
        }
        catch (IOException | CertificateException ex) {
            throw new OcspStoreException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeStore(DataSourceWrapper datasource) {
        if (this.crlUpdateInProcess.get()) {
            return;
        }
        this.crlUpdateInProcess.set(true);
        Boolean updateCrlSuccessful = null;
        File updateMeFile = new File(this.crlFilename + ".UPDATEME");
        if (!updateMeFile.exists()) {
            LOG.info("The CRL will not be updated. Create new file {} to force the update", (Object)updateMeFile.getAbsolutePath());
            this.crlUpdated = true;
            this.crlUpdateFailed = false;
            return;
        }
        try {
            File fullCrlFile = new File(this.crlFilename);
            if (!fullCrlFile.exists()) {
                LOG.warn("CRL File {} does not exist", (Object)this.crlFilename);
                return;
            }
            LOG.info("UPDATE_CERTSTORE: a newer CRL is available");
            updateCrlSuccessful = false;
            X509CRL crl = X509Util.parseCrl((File)new File(this.crlFilename));
            File revFile = new File(this.crlFilename + ".revocation");
            CertRevocationInfo caRevInfo = null;
            if (revFile.exists()) {
                Properties props = new Properties();
                try (InputStream is = Files.newInputStream(revFile.toPath(), new OpenOption[0]);){
                    props.load(is);
                }
                String str = props.getProperty(KEY_CA_REVOCATION_TIME);
                if (StringUtil.isNotBlank((String)str)) {
                    Date revocationTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    Date invalidityTime = null;
                    str = props.getProperty(KEY_CA_INVALIDITY_TIME);
                    if (StringUtil.isNotBlank((String)str)) {
                        invalidityTime = DateUtil.parseUtcTimeyyyyMMddhhmmss((String)str);
                    }
                    caRevInfo = new CertRevocationInfo(CrlReason.UNSPECIFIED, revocationTime, invalidityTime);
                }
            }
            ImportCrl importCrl = new ImportCrl(datasource, this.useUpdateDatesFromCrl, crl, this.crlUrl, this.caCert, this.issuerCert, caRevInfo, this.certsDirName);
            updateCrlSuccessful = importCrl.importCrlToOcspDb();
            this.crlUpdated = true;
            if (updateCrlSuccessful.booleanValue()) {
                this.crlUpdateFailed = false;
                LOG.info("updated CertStore {} successfully", (Object)this.name);
            } else {
                this.crlUpdateFailed = true;
                LOG.error("updating CertStore {} failed", (Object)this.name);
            }
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not execute initializeStore()");
            this.crlUpdateFailed = true;
            this.crlUpdated = true;
        }
        finally {
            updateMeFile.delete();
            this.crlUpdateInProcess.set(false);
            if (updateCrlSuccessful != null) {
                if (updateCrlSuccessful.booleanValue()) {
                    LOG.info("UPDATE_CRL: successful");
                } else {
                    LOG.warn("UPDATE_CRL: failed");
                }
            }
        }
    }

    private class CrlUpdateService
    implements Runnable {
        private CrlUpdateService() {
        }

        @Override
        public void run() {
            try {
                CrlDbCertStatusStore.this.initializeStore(CrlDbCertStatusStore.this.datasource);
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("error while calling initializeStore() for store " + CrlDbCertStatusStore.this.name));
            }
        }
    }
}

