/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatus;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStore;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.ocsp.server.OcspServerConf;
import org.xipki.ocsp.server.store.CrlInfo;
import org.xipki.ocsp.server.store.IssuerEntry;
import org.xipki.ocsp.server.store.IssuerFilter;
import org.xipki.ocsp.server.store.IssuerStore;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class DbCertStatusStore
extends OcspStore {
    protected DataSourceWrapper datasource;
    private static final Logger LOG = LoggerFactory.getLogger(DbCertStatusStore.class);
    private final AtomicBoolean storeUpdateInProcess = new AtomicBoolean(false);
    private String sqlCsNoRit;
    private String sqlCs;
    private String sqlCsNoRitWithCertHash;
    private String sqlCsWithCertHash;
    private IssuerFilter issuerFilter;
    private IssuerStore issuerStore;
    private HashAlgo certHashAlgo;
    private boolean initialized;
    private boolean initializationFailed;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    protected List<Runnable> getScheduledServices() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initIssuerStore() {
        if (this.storeUpdateInProcess.get()) {
            return;
        }
        this.storeUpdateInProcess.set(true);
        try {
            String sha1Fp;
            ResultSet rs;
            PreparedStatement ps;
            String sql;
            if (this.initialized) {
                sql = "SELECT ID,REV_INFO,S1C FROM ISSUER";
                ps = this.preparedStatement("SELECT ID,REV_INFO,S1C FROM ISSUER");
                rs = null;
                try {
                    boolean issuersUnchanged;
                    HashMap<Integer, SimpleIssuerEntry> newIssuers = new HashMap<Integer, SimpleIssuerEntry>();
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        sha1Fp = rs.getString("S1C");
                        if (!this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp)) continue;
                        int id = rs.getInt("ID");
                        Long revTimeMs = null;
                        String str = rs.getString("REV_INFO");
                        if (str != null) {
                            CertRevocationInfo revInfo = CertRevocationInfo.fromEncoded((String)str);
                            revTimeMs = revInfo.getRevocationTime().getTime();
                        }
                        SimpleIssuerEntry issuerEntry = new SimpleIssuerEntry(id, revTimeMs);
                        newIssuers.put(id, issuerEntry);
                    }
                    Set newIds = newIssuers.keySet();
                    Set ids = this.issuerStore != null ? this.issuerStore.getIds() : Collections.emptySet();
                    boolean bl = issuersUnchanged = ids.size() == newIds.size() && ids.containsAll(newIds) && newIds.containsAll(ids);
                    if (issuersUnchanged) {
                        for (Integer id : newIds) {
                            IssuerEntry entry = this.issuerStore.getIssuerForId(id);
                            SimpleIssuerEntry newEntry = (SimpleIssuerEntry)newIssuers.get(id);
                            if (!newEntry.match(entry)) continue;
                            issuersUnchanged = false;
                            break;
                        }
                    }
                    if (issuersUnchanged) {
                        return;
                    }
                }
                finally {
                    this.releaseDbResources(ps, rs);
                }
            }
            sql = "SELECT ID,NBEFORE,REV_INFO,S1C,CERT,CRL_INFO FROM ISSUER";
            ps = this.preparedStatement("SELECT ID,NBEFORE,REV_INFO,S1C,CERT,CRL_INFO FROM ISSUER");
            rs = null;
            try {
                rs = ps.executeQuery();
                LinkedList<IssuerEntry> caInfos = new LinkedList<IssuerEntry>();
                while (rs.next()) {
                    sha1Fp = rs.getString("S1C");
                    if (!this.issuerFilter.includeIssuerWithSha1Fp(sha1Fp)) continue;
                    X509Certificate cert = X509Util.parseCert((byte[])rs.getString("CERT").getBytes());
                    IssuerEntry caInfoEntry = new IssuerEntry(rs.getInt("ID"), cert);
                    String crlInfoStr = rs.getString("CRL_INFO");
                    if (StringUtil.isNotBlank((String)crlInfoStr)) {
                        CrlInfo crlInfo = new CrlInfo(crlInfoStr);
                        caInfoEntry.setCrlInfo(crlInfo);
                    }
                    RequestIssuer reqIssuer = new RequestIssuer(HashAlgo.SHA1, caInfoEntry.getEncodedHash(HashAlgo.SHA1));
                    for (IssuerEntry existingIssuer : caInfos) {
                        if (!existingIssuer.matchHash(reqIssuer)) continue;
                        throw new Exception("found at least two issuers with the same subject and key");
                    }
                    String str = rs.getString("REV_INFO");
                    if (str != null) {
                        CertRevocationInfo revInfo = CertRevocationInfo.fromEncoded((String)str);
                        caInfoEntry.setRevocationInfo(revInfo.getRevocationTime());
                    }
                    caInfos.add(caInfoEntry);
                }
                this.initialized = false;
                this.issuerStore = new IssuerStore(caInfos);
                LOG.info("Updated issuers: {}", (Object)this.name);
                this.initializationFailed = false;
                this.initialized = true;
            }
            finally {
                this.releaseDbResources(ps, rs);
            }
        }
        catch (Throwable th) {
            this.storeUpdateInProcess.set(false);
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not executing initIssuerStore()");
            this.initializationFailed = true;
            this.initialized = true;
        }
    }

    public CertStatusInfo getCertStatus(Date time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation) throws OcspStoreException {
        if (serialNumber.signum() != 1) {
            return CertStatusInfo.getUnknownCertStatusInfo((Date)new Date(), null);
        }
        if (!this.initialized) {
            throw new OcspStoreException("initialization of CertStore is still in process");
        }
        if (this.initializationFailed) {
            throw new OcspStoreException("initialization of CertStore failed");
        }
        try {
            Date thisUpdate;
            IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
            if (issuer == null) {
                return null;
            }
            String sql = includeCertHash ? (includeRit ? this.sqlCsWithCertHash : this.sqlCsNoRitWithCertHash) : (includeRit ? this.sqlCs : this.sqlCsNoRit);
            CrlInfo crlInfo = issuer.getCrlInfo();
            Date nextUpdate = null;
            if (crlInfo != null && crlInfo.isUseCrlUpdates()) {
                thisUpdate = crlInfo.getThisUpdate();
                if (crlInfo.getNextUpdate().getTime() - System.currentTimeMillis() > 10000L) {
                    nextUpdate = crlInfo.getNextUpdate();
                }
            } else {
                thisUpdate = new Date();
            }
            ResultSet rs = null;
            CertStatusInfo certStatusInfo = null;
            boolean unknown = true;
            boolean ignore = false;
            String certprofile = null;
            String b64CertHash = null;
            boolean revoked = false;
            int reason = 0;
            long revTime = 0L;
            long invalTime = 0L;
            PreparedStatement ps = this.datasource.prepareStatement(sql);
            try {
                ps.setInt(1, issuer.getId());
                ps.setString(2, serialNumber.toString(16));
                rs = ps.executeQuery();
                if (rs.next()) {
                    long notAfterInSec;
                    long notBeforeInSec;
                    unknown = false;
                    long timeInSec = time.getTime() / 1000L;
                    if (!ignore && this.ignoreNotYetValidCert && (notBeforeInSec = rs.getLong("NBEFORE")) != 0L && timeInSec < notBeforeInSec) {
                        ignore = true;
                    }
                    if (!ignore && this.ignoreExpiredCert && (notAfterInSec = rs.getLong("NAFTER")) != 0L && timeInSec > notAfterInSec) {
                        ignore = true;
                    }
                    if (!ignore) {
                        if (includeCertHash) {
                            b64CertHash = rs.getString("HASH");
                        }
                        if (revoked = rs.getBoolean("REV")) {
                            reason = rs.getInt("RR");
                            revTime = rs.getLong("RT");
                            if (includeRit) {
                                invalTime = rs.getLong("RIT");
                            }
                        }
                    }
                }
                this.releaseDbResources(ps, rs);
            }
            catch (SQLException ex) {
                try {
                    throw this.datasource.translate(sql, ex);
                }
                catch (Throwable throwable) {
                    this.releaseDbResources(ps, rs);
                    throw throwable;
                }
            }
            if (unknown) {
                certStatusInfo = this.unknownSerialAsGood ? CertStatusInfo.getGoodCertStatusInfo((HashAlgo)this.certHashAlgo, null, (Date)thisUpdate, (Date)nextUpdate, null) : CertStatusInfo.getUnknownCertStatusInfo((Date)thisUpdate, (Date)nextUpdate);
            } else if (ignore) {
                certStatusInfo = CertStatusInfo.getIgnoreCertStatusInfo((Date)thisUpdate, (Date)nextUpdate);
            } else {
                byte[] certHash;
                byte[] byArray = certHash = b64CertHash == null ? null : Base64.decodeFast(b64CertHash);
                if (revoked) {
                    Date invTime = invalTime == 0L || invalTime == revTime ? null : new Date(invalTime * 1000L);
                    CertRevocationInfo revInfo = new CertRevocationInfo(reason, new Date(revTime * 1000L), invTime);
                    certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)revInfo, (HashAlgo)this.certHashAlgo, (byte[])certHash, (Date)thisUpdate, (Date)nextUpdate, certprofile);
                } else {
                    certStatusInfo = CertStatusInfo.getGoodCertStatusInfo((HashAlgo)this.certHashAlgo, (byte[])certHash, (Date)thisUpdate, (Date)nextUpdate, certprofile);
                }
            }
            if (this.includeCrlId && crlInfo != null) {
                certStatusInfo.setCrlId(crlInfo.getCrlId());
            }
            if (this.includeArchiveCutoff && this.retentionInterval != 0) {
                Date date;
                if (this.retentionInterval < 0) {
                    date = issuer.getNotBefore();
                } else {
                    long nowInMs = System.currentTimeMillis();
                    long dateInMs = Math.max(issuer.getNotBefore().getTime(), nowInMs - 86400000L * (long)this.retentionInterval);
                    date = new Date(dateInMs);
                }
                certStatusInfo.setArchiveCutOff(date);
            }
            if (!inheritCaRevocation || issuer.getRevocationInfo() == null) {
                return certStatusInfo;
            }
            CertRevocationInfo caRevInfo = issuer.getRevocationInfo();
            CertStatus certStatus = certStatusInfo.getCertStatus();
            boolean replaced = false;
            if (certStatus == CertStatus.GOOD || certStatus == CertStatus.UNKNOWN) {
                replaced = true;
            } else if (certStatus == CertStatus.REVOKED && certStatusInfo.getRevocationInfo().getRevocationTime().after(caRevInfo.getRevocationTime())) {
                replaced = true;
            }
            if (replaced) {
                CertRevocationInfo newRevInfo = caRevInfo.getReason() == CrlReason.CA_COMPROMISE ? caRevInfo : new CertRevocationInfo(CrlReason.CA_COMPROMISE, caRevInfo.getRevocationTime(), caRevInfo.getInvalidityTime());
                certStatusInfo = CertStatusInfo.getRevokedCertStatusInfo((CertRevocationInfo)newRevInfo, (HashAlgo)certStatusInfo.getCertHashAlgo(), (byte[])certStatusInfo.getCertHash(), (Date)certStatusInfo.getThisUpdate(), (Date)certStatusInfo.getNextUpdate(), (String)certStatusInfo.getCertprofile());
            }
            return certStatusInfo;
        }
        catch (DataAccessException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
    }

    private PreparedStatement preparedStatement(String sqlQuery) throws DataAccessException {
        return this.datasource.prepareStatement(sqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHealthy() {
        if (!this.isInitialized()) {
            return false;
        }
        if (this.isInitializationFailed()) {
            return false;
        }
        String sql = "SELECT ID FROM ISSUER";
        PreparedStatement ps = this.preparedStatement("SELECT ID FROM ISSUER");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            boolean bl = true;
            this.releaseDbResources(ps, rs);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.releaseDbResources(ps, rs);
                throw throwable;
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                return false;
            }
        }
    }

    private void releaseDbResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs);
    }

    public void init(OcspStore.SourceConf conf, DataSourceWrapper datasource) throws OcspStoreException {
        OcspServerConf.DbSourceConf conf0;
        if (conf != null && !(conf instanceof OcspServerConf.SourceConfImpl)) {
            throw new OcspStoreException("unknown conf " + conf.getClass().getName());
        }
        OcspServerConf.CaCerts caCerts = null;
        if (conf != null && (conf0 = ((OcspServerConf.SourceConfImpl)conf).getDbSource()) != null) {
            caCerts = conf0.getCaCerts();
        }
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.sqlCs = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsNoRit = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsWithCertHash = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,RIT,HASH FROM CERT WHERE IID=? AND SN=?");
        this.sqlCsNoRitWithCertHash = datasource.buildSelectFirstSql(1, "NBEFORE,NAFTER,REV,RR,RT,HASH FROM CERT WHERE IID=? AND SN=?");
        try {
            this.certHashAlgo = DbCertStatusStore.getCertHashAlgo(datasource);
        }
        catch (DataAccessException ex) {
            throw new OcspStoreException("Could not retrieve the certhash's algorithm from the database", (Throwable)ex);
        }
        try {
            Set<X509Certificate> includeIssuers = null;
            Set<X509Certificate> excludeIssuers = null;
            if (caCerts != null) {
                if (CollectionUtil.isNonEmpty(caCerts.getIncludes())) {
                    includeIssuers = DbCertStatusStore.parseCerts(caCerts.getIncludes());
                }
                if (CollectionUtil.isNonEmpty(caCerts.getExcludes())) {
                    excludeIssuers = DbCertStatusStore.parseCerts(caCerts.getExcludes());
                }
            }
            this.issuerFilter = new IssuerFilter(includeIssuers, excludeIssuers);
        }
        catch (CertificateException ex) {
            throw new OcspStoreException(ex.getMessage(), (Throwable)ex);
        }
        this.initIssuerStore();
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
        StoreUpdateService storeUpdateService = new StoreUpdateService();
        List<Runnable> scheduledServices = this.getScheduledServices();
        int size = 1;
        if (scheduledServices != null) {
            size += scheduledServices.size();
        }
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(size);
        Random random = new Random();
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(storeUpdateService, 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
        if (scheduledServices != null) {
            for (Runnable service : scheduledServices) {
                this.scheduledThreadPoolExecutor.scheduleAtFixedRate(service, 60 + random.nextInt(60), 60L, TimeUnit.SECONDS);
            }
        }
    }

    public void close() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
            this.scheduledThreadPoolExecutor = null;
        }
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    public boolean knowsIssuer(RequestIssuer reqIssuer) {
        return null != this.issuerStore.getIssuerForFp(reqIssuer);
    }

    public X509Certificate getIssuerCert(RequestIssuer reqIssuer) {
        IssuerEntry issuer = this.issuerStore.getIssuerForFp(reqIssuer);
        return issuer == null ? null : issuer.getCert();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isInitializationFailed() {
        return this.initializationFailed;
    }

    private static Set<X509Certificate> parseCerts(Collection<String> certFiles) throws OcspStoreException {
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>(certFiles.size());
        for (String certFile : certFiles) {
            try {
                certs.add(X509Util.parseCert((File)new File(certFile)));
            }
            catch (IOException | CertificateException ex) {
                throw new OcspStoreException("could not parse X.509 certificate from file " + certFile + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        return certs;
    }

    public static HashAlgo getCertHashAlgo(DataSourceWrapper datasource) throws DataAccessException {
        String certHashAlgoStr = (String)datasource.getFirstValue(null, "DBSCHEMA", "VALUE2", "NAME='CERTHASH_ALGO'", String.class);
        if (certHashAlgoStr == null) {
            throw new DataAccessException("Column with NAME='CERTHASH_ALGO' is not defined in table DBSCHEMA");
        }
        return HashAlgo.getNonNullInstance((String)certHashAlgoStr);
    }

    private class StoreUpdateService
    implements Runnable {
        private StoreUpdateService() {
        }

        @Override
        public void run() {
            DbCertStatusStore.this.initIssuerStore();
        }
    }

    private static class SimpleIssuerEntry {
        private final int id;
        private final Long revocationTimeMs;

        SimpleIssuerEntry(int id, Long revocationTimeMs) {
            this.id = id;
            this.revocationTimeMs = revocationTimeMs;
        }

        public boolean match(IssuerEntry issuer) {
            if (this.id != issuer.getId()) {
                return false;
            }
            if (this.revocationTimeMs == null) {
                return issuer.getRevocationInfo() == null;
            }
            return issuer.getRevocationInfo() == null ? false : this.revocationTimeMs.longValue() == issuer.getRevocationInfo().getRevocationTime().getTime();
        }
    }
}

