/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.server.store;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.datasource.DataAccessException;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.server.store.CrlInfo;
import org.xipki.ocsp.server.store.DbCertStatusStore;
import org.xipki.ocsp.server.store.ImportCrlException;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class ImportCrl {
    private static final Logger LOG = LoggerFactory.getLogger(ImportCrl.class);
    private static final String SQL_UPDATE_CERT_REV = "UPDATE CERT SET REV=?,RR=?,RT=?,RIT=?,LUPDATE=? WHERE ID=?";
    private static final String SQL_INSERT_CERT_REV = "INSERT INTO CERT (ID,IID,SN,REV,RR,RT,RIT,LUPDATE) VALUES(?,?,?,?,?,?,?,?)";
    private static final String SQL_DELETE_CERT = "DELETE FROM CERT WHERE IID=? AND SN=?";
    private static final String SQL_UPDATE_CERT = "UPDATE CERT SET LUPDATE=?,NBEFORE=?,NAFTER=?,HASH=? WHERE ID=?";
    private static final String SQL_INSERT_CERT = "INSERT INTO CERT (ID,IID,SN,REV,RR,RT,RIT,LUPDATE,NBEFORE,NAFTER,HASH) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
    private static final String CORE_SQL_SELECT_ID_CERT = "ID FROM CERT WHERE IID=? AND SN=?";
    private final String sqlSelectIdCert;
    private final X509CRL crl;
    private final X509Certificate caCert;
    private final BigInteger crlNumber;
    private final DataSourceWrapper datasource;
    private final boolean useCrlUpdates;
    private final BigInteger baseCrlNumber;
    private final boolean isDeltaCrl;
    private final CrlID crlId;
    private final X500Name caSubject;
    private final X500Principal x500PrincipalCaSubject;
    private final byte[] caSpki;
    private final String certsDirName;
    private final CertRevocationInfo caRevInfo;
    private final HashAlgo certhashAlgo;
    private PreparedStatement psDeleteCert;
    private PreparedStatement psInsertCert;
    private PreparedStatement psInsertCertRev;
    private PreparedStatement psSelectIdCert;
    private PreparedStatement psUpdateCert;
    private PreparedStatement psUpdateCertRev;

    public ImportCrl(DataSourceWrapper datasource, boolean useCrlUpdates, X509CRL crl, String crlUrl, X509Certificate caCert, X509Certificate issuerCert, CertRevocationInfo caRevInfo, String certsDirName) throws ImportCrlException, DataAccessException {
        this.datasource = (DataSourceWrapper)Args.notNull((Object)datasource, (String)"datasource");
        this.certhashAlgo = DbCertStatusStore.getCertHashAlgo(datasource);
        this.useCrlUpdates = useCrlUpdates;
        this.crl = (X509CRL)Args.notNull((Object)crl, (String)"crl");
        this.caCert = (X509Certificate)Args.notNull((Object)caCert, (String)"caCert");
        this.x500PrincipalCaSubject = caCert.getSubjectX500Principal();
        this.caSubject = X500Name.getInstance((Object)this.x500PrincipalCaSubject.getEncoded());
        try {
            this.caSpki = X509Util.extractSki((X509Certificate)caCert);
        }
        catch (CertificateEncodingException ex) {
            throw new ImportCrlException("could not extract AKI of CA certificate", ex);
        }
        this.certsDirName = certsDirName;
        this.caRevInfo = caRevInfo;
        X500Principal issuer = crl.getIssuerX500Principal();
        boolean caAsCrlIssuer = true;
        if (!this.x500PrincipalCaSubject.equals(issuer)) {
            caAsCrlIssuer = false;
            if (issuerCert == null) {
                throw new IllegalArgumentException("issuerCert may not be null");
            }
            if (!issuerCert.getSubjectX500Principal().equals(issuer)) {
                throw new IllegalArgumentException("issuerCert and CRL do not match");
            }
        }
        X509Certificate crlSignerCert = caAsCrlIssuer ? caCert : issuerCert;
        try {
            crl.verify(crlSignerCert.getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CRLException ex) {
            throw new ImportCrlException("could not verify signature of CRL", ex);
        }
        byte[] octetString = crl.getExtensionValue(Extension.cRLNumber.getId());
        if (octetString == null) {
            throw new IllegalArgumentException("CRL without CRLNumber is not supported");
        }
        ASN1Integer asn1CrlNumber = ASN1Integer.getInstance((Object)DEROctetString.getInstance((Object)octetString).getOctets());
        this.crlNumber = asn1CrlNumber.getPositiveValue();
        octetString = crl.getExtensionValue(Extension.deltaCRLIndicator.getId());
        boolean bl = this.isDeltaCrl = octetString != null;
        if (this.isDeltaCrl) {
            LOG.info("The CRL is a DeltaCRL");
            byte[] extnValue = DEROctetString.getInstance((Object)octetString).getOctets();
            this.baseCrlNumber = ASN1Integer.getInstance((Object)extnValue).getPositiveValue();
        } else {
            LOG.info("The CRL is a full CRL");
            this.baseCrlNumber = null;
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (StringUtil.isNotBlank((String)crlUrl)) {
            vec.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERIA5String(crlUrl, true)));
        }
        vec.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)asn1CrlNumber));
        vec.add((ASN1Encodable)new DERTaggedObject(true, 2, (ASN1Encodable)new DERGeneralizedTime(crl.getThisUpdate())));
        this.crlId = CrlID.getInstance((Object)new DERSequence(vec));
        this.sqlSelectIdCert = datasource.buildSelectFirstSql(1, CORE_SQL_SELECT_ID_CERT);
    }

    public boolean importCrlToOcspDb() {
        Connection conn = null;
        try {
            conn = this.datasource.getConnection();
            Date startTime = new Date();
            int caId = this.importCa(conn);
            this.psDeleteCert = this.datasource.prepareStatement(conn, SQL_DELETE_CERT);
            this.psInsertCert = this.datasource.prepareStatement(conn, SQL_INSERT_CERT);
            this.psInsertCertRev = this.datasource.prepareStatement(conn, SQL_INSERT_CERT_REV);
            this.psSelectIdCert = this.datasource.prepareStatement(conn, this.sqlSelectIdCert);
            this.psUpdateCert = this.datasource.prepareStatement(conn, SQL_UPDATE_CERT);
            this.psUpdateCertRev = this.datasource.prepareStatement(conn, SQL_UPDATE_CERT_REV);
            this.importEntries(conn, caId);
            this.deleteEntriesNotUpdatedSince(conn, startTime);
            return true;
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not import CRL to OCSP database");
            this.releaseResources(this.psDeleteCert, null);
            this.releaseResources(this.psInsertCert, null);
            this.releaseResources(this.psInsertCertRev, null);
            this.releaseResources(this.psSelectIdCert, null);
            this.releaseResources(this.psUpdateCert, null);
            this.releaseResources(this.psUpdateCertRev, null);
            if (conn != null) {
                this.datasource.returnConnection(conn);
            }
            return false;
        }
    }

    private int importCa(Connection conn) throws DataAccessException, ImportCrlException {
        boolean addNew;
        byte[] encodedCaCert;
        try {
            encodedCaCert = this.caCert.getEncoded();
        }
        catch (CertificateEncodingException ex) {
            throw new ImportCrlException("could not encode CA certificate");
        }
        String fpCaCert = HashAlgo.SHA1.base64Hash(encodedCaCert);
        Integer issuerId = null;
        CrlInfo crlInfo = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = null;
        try {
            sql = "SELECT ID,CRL_INFO FROM ISSUER WHERE S1C=?";
            ps = this.datasource.prepareStatement(conn, sql);
            ps.setString(1, fpCaCert);
            rs = ps.executeQuery();
            if (rs.next()) {
                issuerId = rs.getInt("ID");
                String str = rs.getString("CRL_INFO");
                if (str == null) {
                    throw new ImportCrlException("RequestIssuer for the given CA of CRL exists, but not imported from CRL");
                }
                crlInfo = new CrlInfo(str);
            }
            this.releaseResources(ps, rs);
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(sql, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(ps, rs);
                throw throwable;
            }
        }
        boolean bl = addNew = issuerId == null;
        if (addNew) {
            if (this.isDeltaCrl) {
                throw new ImportCrlException("Given CRL is a deltaCRL for the full CRL with number " + this.baseCrlNumber + ", please import this full CRL first.");
            }
            crlInfo = new CrlInfo(this.crlNumber, null, this.useCrlUpdates, this.crl.getThisUpdate(), this.crl.getNextUpdate(), this.crlId);
        } else {
            if (this.crlNumber.compareTo(crlInfo.getCrlNumber()) < 0) {
                throw new ImportCrlException("Given CRL is not newer than existing CRL.");
            }
            if (this.isDeltaCrl) {
                BigInteger lastFullCrlNumber = crlInfo.getBaseCrlNumber();
                if (lastFullCrlNumber == null) {
                    lastFullCrlNumber = crlInfo.getCrlNumber();
                }
                if (!this.baseCrlNumber.equals(lastFullCrlNumber)) {
                    throw new ImportCrlException("Given CRL is a deltaCRL for the full CRL with number " + this.crlNumber + ", please import this full CRL first.");
                }
            }
            crlInfo.setCrlNumber(this.crlNumber);
            crlInfo.setBaseCrlNumber(this.isDeltaCrl ? this.baseCrlNumber : null);
            crlInfo.setThisUpdate(this.crl.getThisUpdate());
            crlInfo.setNextUpdate(this.crl.getNextUpdate());
        }
        ps = null;
        rs = null;
        sql = null;
        try {
            int offset = 1;
            if (addNew) {
                int maxId = (int)this.datasource.getMax(conn, "ISSUER", "ID");
                issuerId = maxId + 1;
                sql = "INSERT INTO ISSUER (ID,SUBJECT,NBEFORE,NAFTER,S1C,CERT,REV_INFO,CRL_INFO) VALUES(?,?,?,?,?,?,?,?)";
                ps = this.datasource.prepareStatement(conn, sql);
                String subject = X509Util.getRfc4519Name((X500Principal)this.caCert.getSubjectX500Principal());
                ps.setInt(offset++, issuerId);
                ps.setString(offset++, subject);
                ps.setLong(offset++, this.caCert.getNotBefore().getTime() / 1000L);
                ps.setLong(offset++, this.caCert.getNotAfter().getTime() / 1000L);
                ps.setString(offset++, fpCaCert);
                ps.setString(offset++, Base64.encodeToString((byte[])encodedCaCert));
            } else {
                sql = "UPDATE ISSUER SET REV_INFO=?,CRL_INFO=? WHERE ID=?";
                ps = this.datasource.prepareStatement(conn, sql);
            }
            ps.setString(offset++, this.caRevInfo == null ? null : this.caRevInfo.getEncoded());
            try {
                ps.setString(offset++, crlInfo.getEncoded());
            }
            catch (IOException ex) {
                throw new ImportCrlException("could not encode the Crlinfo", ex);
            }
            if (!addNew) {
                ps.setInt(offset++, issuerId);
            }
            ps.executeUpdate();
            int n = issuerId;
            return n;
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.releaseResources(ps, rs);
        }
    }

    private void importEntries(Connection conn, int caId) throws DataAccessException, ImportCrlException {
        Certificate cert;
        byte[] extnValue;
        AtomicLong maxId = new AtomicLong(this.datasource.getMax(conn, "CERT", "ID"));
        Set<? extends X509CRLEntry> revokedCertList = this.crl.getRevokedCertificates();
        if (revokedCertList != null) {
            for (X509CRLEntry x509CRLEntry : revokedCertList) {
                X500Principal issuer = x509CRLEntry.getCertificateIssuer();
                BigInteger serial = x509CRLEntry.getSerialNumber();
                if (issuer != null && !this.x500PrincipalCaSubject.equals(issuer)) {
                    throw new ImportCrlException("invalid CRLEntry for certificate number " + serial);
                }
                Date rt = x509CRLEntry.getRevocationDate();
                Date rit = null;
                byte[] extnValue2 = x509CRLEntry.getExtensionValue(Extension.invalidityDate.getId());
                if (extnValue2 != null) {
                    extnValue2 = ImportCrl.extractCoreValue(extnValue2);
                    ASN1GeneralizedTime genTime = DERGeneralizedTime.getInstance((Object)extnValue2);
                    try {
                        rit = genTime.getDate();
                    }
                    catch (ParseException ex) {
                        throw new ImportCrlException(ex.getMessage(), ex);
                    }
                    if (rt.equals(rit)) {
                        rit = null;
                    }
                }
                CrlReason reason = CrlReason.fromReason((CRLReason)x509CRLEntry.getRevocationReason());
                String sql = null;
                try {
                    PreparedStatement ps;
                    if (reason == CrlReason.REMOVE_FROM_CRL) {
                        if (!this.isDeltaCrl) {
                            LOG.warn("ignore CRL entry with reason removeFromCRL in non-Delta CRL");
                        }
                        sql = SQL_DELETE_CERT;
                        this.psDeleteCert.setInt(1, caId);
                        this.psDeleteCert.setString(2, serial.toString(16));
                        this.psDeleteCert.executeUpdate();
                        continue;
                    }
                    Long id = this.getId(caId, serial);
                    int offset = 1;
                    if (id == null) {
                        sql = SQL_INSERT_CERT_REV;
                        id = maxId.incrementAndGet();
                        ps = this.psInsertCertRev;
                        ps.setLong(offset++, id);
                        ps.setInt(offset++, caId);
                        ps.setString(offset++, serial.toString(16));
                    } else {
                        sql = SQL_UPDATE_CERT_REV;
                        ps = this.psUpdateCertRev;
                    }
                    ps.setInt(offset++, 1);
                    ps.setInt(offset++, reason.getCode());
                    ps.setLong(offset++, rt.getTime() / 1000L);
                    if (rit != null) {
                        ps.setLong(offset++, rit.getTime() / 1000L);
                    } else {
                        ps.setNull(offset++, -5);
                    }
                    ps.setLong(offset++, System.currentTimeMillis() / 1000L);
                    if (ps == this.psUpdateCertRev) {
                        ps.setLong(offset++, id);
                    }
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    throw this.datasource.translate(sql, ex);
                }
            }
        }
        if ((extnValue = this.crl.getExtensionValue(ObjectIdentifiers.id_xipki_ext_crlCertset.getId())) != null) {
            extnValue = ImportCrl.extractCoreValue(extnValue);
            ASN1Set aSN1Set = DERSet.getInstance((Object)extnValue);
            int n = aSN1Set.size();
            for (int i = 0; i < n; ++i) {
                ASN1Encodable asn1 = aSN1Set.getObjectAt(i);
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)asn1);
                BigInteger serialNumber = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
                cert = null;
                String profileName = null;
                int size = seq.size();
                block12: for (int j = 1; j < size; ++j) {
                    ASN1TaggedObject taggedObj = DERTaggedObject.getInstance((Object)seq.getObjectAt(j));
                    int tagNo = taggedObj.getTagNo();
                    switch (tagNo) {
                        case 0: {
                            cert = Certificate.getInstance((Object)taggedObj.getObject());
                            continue block12;
                        }
                        case 1: {
                            profileName = DERUTF8String.getInstance((Object)taggedObj.getObject()).getString();
                            continue block12;
                        }
                    }
                }
                if (cert == null) continue;
                if (!this.caSubject.equals((Object)cert.getIssuer())) {
                    LOG.warn("issuer not match (serial={}) in CRL Extension Xipki-CertSet, ignore it", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
                    continue;
                }
                if (!serialNumber.equals(cert.getSerialNumber().getValue())) {
                    LOG.warn("serialNumber not match (serial={}) in CRL Extension Xipki-CertSet, ignore it", (Object)LogUtil.formatCsn((BigInteger)serialNumber));
                    continue;
                }
                String certLogId = "(issuer='" + cert.getIssuer() + "', serialNumber=" + cert.getSerialNumber() + ")";
                this.addCertificate(maxId, caId, cert, profileName, certLogId);
            }
        } else {
            File file = new File(this.certsDirName);
            if (!file.exists()) {
                LOG.warn("the folder {} does not exist, ignore it", (Object)this.certsDirName);
                return;
            }
            if (!file.isDirectory()) {
                LOG.warn("the path {} does not point to a folder, ignore it", (Object)this.certsDirName);
                return;
            }
            if (!file.canRead()) {
                LOG.warn("the folder {} may not be read, ignore it", (Object)this.certsDirName);
                return;
            }
            File[] certFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".der") || name.endsWith(".crt");
                }
            });
            if (certFiles == null || certFiles.length == 0) {
                return;
            }
            for (File certFile : certFiles) {
                try {
                    byte[] encoded = IoUtil.read((File)certFile);
                    cert = Certificate.getInstance((Object)encoded);
                }
                catch (IOException | IllegalArgumentException ex) {
                    LOG.warn("could not parse certificate {}, ignore it", (Object)certFile.getPath());
                    continue;
                }
                String certLogId = "(file " + certFile.getName() + ")";
                this.addCertificate(maxId, caId, cert, null, certLogId);
            }
        }
    }

    private static byte[] extractCoreValue(byte[] encodedExtensionValue) {
        return ASN1OctetString.getInstance((Object)encodedExtensionValue).getOctets();
    }

    private Long getId(int caId, BigInteger serialNumber) throws DataAccessException {
        ResultSet rs;
        block5: {
            rs = null;
            this.psSelectIdCert.setInt(1, caId);
            this.psSelectIdCert.setString(2, serialNumber.toString(16));
            rs = this.psSelectIdCert.executeQuery();
            if (rs.next()) break block5;
            Long l = null;
            this.releaseResources(null, rs);
            return l;
        }
        try {
            Long l = rs.getLong("ID");
            this.releaseResources(null, rs);
            return l;
        }
        catch (SQLException ex) {
            try {
                throw this.datasource.translate(this.sqlSelectIdCert, ex);
            }
            catch (Throwable throwable) {
                this.releaseResources(null, rs);
                throw throwable;
            }
        }
    }

    private void addCertificate(AtomicLong maxId, int caId, Certificate cert, String profileName, String certLogId) throws DataAccessException, ImportCrlException {
        PreparedStatement ps;
        String sql;
        boolean tblCertIdExists;
        byte[] encodedCert;
        if (!this.caSubject.equals((Object)cert.getIssuer())) {
            LOG.warn("certificate {} is not issued by the given CA, ignore it", (Object)certLogId);
            return;
        }
        try {
            encodedCert = cert.getEncoded();
        }
        catch (IOException ex) {
            throw new ImportCrlException("could not encode certificate {}" + certLogId, ex);
        }
        String b64CertHash = this.certhashAlgo.base64Hash(encodedCert);
        if (this.caSpki != null) {
            byte[] aki = null;
            try {
                aki = X509Util.extractAki((Certificate)cert);
            }
            catch (CertificateEncodingException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)("invalid AuthorityKeyIdentifier of certificate {}" + certLogId + ", ignore it"));
                return;
            }
            if (aki == null || !Arrays.equals(this.caSpki, aki)) {
                LOG.warn("certificate {} is not issued by the given CA, ignore it", (Object)certLogId);
                return;
            }
        }
        LOG.info("Importing certificate {}", (Object)certLogId);
        Long id = this.getId(caId, cert.getSerialNumber().getPositiveValue());
        boolean bl = tblCertIdExists = id != null;
        if (tblCertIdExists) {
            sql = SQL_UPDATE_CERT;
            ps = this.psUpdateCert;
        } else {
            sql = SQL_INSERT_CERT;
            ps = this.psInsertCert;
            id = maxId.incrementAndGet();
        }
        try {
            int offset = 1;
            if (sql == SQL_INSERT_CERT) {
                ps.setLong(offset++, id);
                ps.setInt(offset++, caId);
                ps.setString(offset++, cert.getSerialNumber().getPositiveValue().toString(16));
                ps.setInt(offset++, 0);
                ps.setNull(offset++, 5);
                ps.setNull(offset++, -5);
                ps.setNull(offset++, -5);
            }
            ps.setLong(offset++, System.currentTimeMillis() / 1000L);
            TBSCertificate tbsCert = cert.getTBSCertificate();
            ps.setLong(offset++, tbsCert.getStartDate().getDate().getTime() / 1000L);
            ps.setLong(offset++, tbsCert.getEndDate().getDate().getTime() / 1000L);
            ps.setString(offset++, b64CertHash);
            if (sql == SQL_UPDATE_CERT) {
                ps.setLong(offset++, id);
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        LOG.info("Imported  certificate {}", (Object)certLogId);
    }

    private void deleteEntriesNotUpdatedSince(Connection conn, Date time) throws DataAccessException {
        String sql = "DELETE FROM CERT WHERE LUPDATE<" + time.getTime() / 1000L;
        Statement stmt = this.datasource.createStatement(conn);
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw this.datasource.translate(sql, ex);
        }
        finally {
            this.releaseResources(stmt, null);
        }
    }

    private void releaseResources(Statement ps, ResultSet rs) {
        this.datasource.releaseResources(ps, rs, false);
    }
}

